/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.ekoapp.ekosdk.internal.data.converter.EkoFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoLocalFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoCommentFlagEntity;
import io.reactivex.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoCommentFlagDao_Impl
extends EkoCommentFlagDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoCommentFlagEntity> __insertionAdapterOfEkoCommentFlagEntity;
    private final EkoFlagTypeConverter __ekoFlagTypeConverter = new EkoFlagTypeConverter();
    private final EkoLocalFlagTypeConverter __ekoLocalFlagTypeConverter = new EkoLocalFlagTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<EkoCommentFlagEntity> __deletionAdapterOfEkoCommentFlagEntity;
    private final EntityDeletionOrUpdateAdapter<EkoCommentFlagEntity> __updateAdapterOfEkoCommentFlagEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoCommentFlagDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoCommentFlagEntity = new EntityInsertionAdapter<EkoCommentFlagEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `comment_flag` (`commentId`,`flag`,`localFlag`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoCommentFlagEntity value) {
                if (value.getCommentId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommentId());
                }
                String _tmp = EkoCommentFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(value.getFlag());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = EkoCommentFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(value.getLocalFlag());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
                String _tmp_4 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_4);
                }
            }
        };
        this.__deletionAdapterOfEkoCommentFlagEntity = new EntityDeletionOrUpdateAdapter<EkoCommentFlagEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `comment_flag` WHERE `commentId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoCommentFlagEntity value) {
                if (value.getCommentId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommentId());
                }
            }
        };
        this.__updateAdapterOfEkoCommentFlagEntity = new EntityDeletionOrUpdateAdapter<EkoCommentFlagEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `comment_flag` SET `commentId` = ?,`flag` = ?,`localFlag` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `commentId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoCommentFlagEntity value) {
                if (value.getCommentId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommentId());
                }
                String _tmp = EkoCommentFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(value.getFlag());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = EkoCommentFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(value.getLocalFlag());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
                String _tmp_4 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_4);
                }
                if (value.getCommentId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getCommentId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from comment_flag";
                return "DELETE from comment_flag";
            }
        };
    }

    @Override
    public void insertImpl(EkoCommentFlagEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoCommentFlagEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends EkoCommentFlagEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoCommentFlagEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoCommentFlagEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoCommentFlagEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends EkoCommentFlagEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoCommentFlagEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(EkoCommentFlagEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoCommentFlagEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoCommentFlagEntity object) {
        this.__db.beginTransaction();
        try {
            EkoCommentFlagDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends EkoCommentFlagEntity> objects) {
        this.__db.beginTransaction();
        try {
            EkoCommentFlagDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoCommentFlagEntity object) {
        this.__db.beginTransaction();
        try {
            EkoCommentFlagDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EkoCommentFlagEntity getByIdNowImpl(String commentId) {
        String _sql = "SELECT * from comment_flag where commentId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from comment_flag where commentId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (commentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, commentId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoCommentFlagEntity _result;
            int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentId");
            int _cursorIndexOfFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flag");
            int _cursorIndexOfLocalFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localFlag");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new EkoCommentFlagEntity();
                String _tmpCommentId = _cursor.isNull(_cursorIndexOfCommentId) ? null : _cursor.getString(_cursorIndexOfCommentId);
                _result.setCommentId(_tmpCommentId);
                String _tmp = _cursor.isNull(_cursorIndexOfFlag) ? null : _cursor.getString(_cursorIndexOfFlag);
                EkoFlag _tmpFlag = this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                _result.setFlag(_tmpFlag);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfLocalFlag) ? null : _cursor.getString(_cursorIndexOfLocalFlag);
                EkoLocalFlag _tmpLocalFlag = this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                _result.setLocalFlag(_tmpLocalFlag);
                String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            EkoCommentFlagEntity ekoCommentFlagEntity = _result;
            return ekoCommentFlagEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<EkoCommentFlagEntity> getByCommentIdImpl(String commentId) {
        String _sql = "SELECT * from comment_flag where comment_flag.commentId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from comment_flag where comment_flag.commentId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (commentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, commentId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"comment_flag"}, (Callable)new Callable<EkoCommentFlagEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoCommentFlagEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoCommentFlagDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoCommentFlagEntity _result;
                    int _cursorIndexOfCommentId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"commentId");
                    int _cursorIndexOfFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"flag");
                    int _cursorIndexOfLocalFlag = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"localFlag");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoCommentFlagEntity();
                        String _tmpCommentId = _cursor.isNull(_cursorIndexOfCommentId) ? null : _cursor.getString(_cursorIndexOfCommentId);
                        _result.setCommentId(_tmpCommentId);
                        String _tmp = _cursor.isNull(_cursorIndexOfFlag) ? null : _cursor.getString(_cursorIndexOfFlag);
                        EkoFlag _tmpFlag = EkoCommentFlagDao_Impl.this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                        _result.setFlag(_tmpFlag);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfLocalFlag) ? null : _cursor.getString(_cursorIndexOfLocalFlag);
                        EkoLocalFlag _tmpLocalFlag = EkoCommentFlagDao_Impl.this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                        _result.setLocalFlag(_tmpLocalFlag);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    EkoCommentFlagEntity ekoCommentFlagEntity = _result;
                    return ekoCommentFlagEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

