/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.boundarycallback;

import androidx.arch.core.util.Function;
import androidx.core.util.Pair;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.social.comment.AmityComment;
import com.amity.socialcloud.sdk.social.comment.AmityCommentSortOption;
import com.amity.socialcloud.sdk.social.data.comment.CommentLocalDataStore;
import com.amity.socialcloud.sdk.social.data.comment.CommentQueryPersister;
import com.amity.socialcloud.sdk.social.data.comment.CommentRemoteDataStore;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentAndUserListDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentDto;
import com.ekoapp.ekosdk.internal.api.socket.request.CommentQueryRequest;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoBoundaryCallback;
import com.github.davidmoten.rx2.RetryWhen;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.Subject;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0003:\u0001*BO\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001dH\u0003J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0002J\b\u0010$\u001a\u00020\"H\u0016J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0002H\u0016J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u0002H\u0016J\b\u0010)\u001a\u00020\"H\u0016R&\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0015\u001a&\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00050\u0005 \u0017*\u0012\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00180\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/ekoapp/ekosdk/internal/data/boundarycallback/EkoCommentBoundaryCallback;", "Lcom/ekoapp/ekosdk/internal/data/boundarycallback/EkoBoundaryCallback;", "Lcom/amity/socialcloud/sdk/social/comment/AmityComment;", "Landroidx/arch/core/util/Function;", "referenceId", "", "referenceType", "isFilterByParentId", "", "parentId", "isDeleted", "sortBy", "Lcom/amity/socialcloud/sdk/social/comment/AmityCommentSortOption;", "pageSize", "", "delaySubject", "Lio/reactivex/subjects/Subject;", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/social/comment/AmityCommentSortOption;ILio/reactivex/subjects/Subject;)V", "commentIdAndTokenMap", "", "Landroidx/core/util/Pair;", "commentIdSet", "", "kotlin.jvm.PlatformType", "", "Ljava/lang/Boolean;", "apply", "input", "call", "Lio/reactivex/Completable;", "options", "Lcom/ekoapp/ekosdk/internal/api/socket/request/CommentQueryRequest$CommentQueryRequestOptions;", "clearComments", "mapByComment", "", "commentId", "onFirstLoaded", "onItemAtEndLoaded", "itemAtEnd", "onItemAtFrontLoaded", "itemAtFront", "onZeroItemsLoaded", "Companion", "amity-sdk_release"})
public final class EkoCommentBoundaryCallback
extends EkoBoundaryCallback<AmityComment>
implements Function<AmityComment, AmityComment> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String referenceId;
    @NotNull
    private final String referenceType;
    private final boolean isFilterByParentId;
    @Nullable
    private final String parentId;
    @Nullable
    private final Boolean isDeleted;
    @NotNull
    private final AmityCommentSortOption sortBy;
    @NotNull
    private final Subject<Boolean> delaySubject;
    @NotNull
    private final Map<String, Pair<String, Boolean>> commentIdAndTokenMap;
    private final Set<String> commentIdSet;
    @NotNull
    private static final Executor SINGLE_THREAD_EXECUTOR;

    public EkoCommentBoundaryCallback(@NotNull String referenceId, @NotNull String referenceType, boolean isFilterByParentId, @Nullable String parentId, @Nullable Boolean isDeleted, @NotNull AmityCommentSortOption sortBy, int pageSize, @NotNull Subject<Boolean> delaySubject) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        Intrinsics.checkNotNullParameter(delaySubject, (String)"delaySubject");
        super(pageSize);
        this.referenceId = referenceId;
        this.referenceType = referenceType;
        this.isFilterByParentId = isFilterByParentId;
        this.parentId = parentId;
        this.isDeleted = isDeleted;
        this.sortBy = sortBy;
        this.delaySubject = delaySubject;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"newConcurrentMap()");
        this.commentIdAndTokenMap = concurrentMap;
        this.commentIdSet = Sets.newConcurrentHashSet();
        this.onFirstLoaded();
    }

    public void onItemAtFrontLoaded(@NotNull AmityComment itemAtFront) {
        Intrinsics.checkNotNullParameter((Object)itemAtFront, (String)"itemAtFront");
    }

    public void onItemAtEndLoaded(@NotNull AmityComment itemAtEnd) {
        Intrinsics.checkNotNullParameter((Object)itemAtEnd, (String)"itemAtEnd");
    }

    public void onZeroItemsLoaded() {
    }

    @Override
    public void onFirstLoaded() {
        CommentQueryRequest.CommentQueryRequestOptions options = new CommentQueryRequest.CommentQueryRequestOptions(null, null, null, null, null, null, null, null, 255, null);
        options.setLimit(this.getPageSize());
        options.setType("pagination");
        String string = EkoCommentBoundaryCallback.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EkoCommentBoundaryCallback::class.java.name");
        AmityLog.INSTANCE.tag(string).i("onFirstLoaded", new Object[0]);
        this.call(options).doOnComplete(() -> EkoCommentBoundaryCallback.onFirstLoaded$lambda-0(this)).doOnError(arg_0 -> EkoCommentBoundaryCallback.onFirstLoaded$lambda-1(this, arg_0)).subscribeOn(Schedulers.from((Executor)SINGLE_THREAD_EXECUTOR)).subscribe((CompletableObserver)this);
    }

    @NotNull
    public AmityComment apply(@NotNull AmityComment input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.commentIdSet.add(input.getCommentId());
        this.mapByComment(input.getCommentId());
        return input;
    }

    private final void mapByComment(String commentId) {
        block1: {
            Pair<String, Boolean> pair = this.commentIdAndTokenMap.get(commentId);
            if (pair == null) break block1;
            Pair<String, Boolean> tokenAndStatusNonNull = pair;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)tokenAndStatusNonNull.first;
            if (charSequence == null || charSequence.length() == 0 || Intrinsics.areEqual((Object)tokenAndStatusNonNull.second, (Object)true)) {
                return;
            }
            CommentQueryRequest.CommentQueryRequestOptions options = new CommentQueryRequest.CommentQueryRequestOptions(null, null, null, null, null, null, null, (String)tokenAndStatusNonNull.first, 127, null);
            options.setType("pagination");
            this.call(options).doOnSubscribe(arg_0 -> EkoCommentBoundaryCallback.mapByComment$lambda-4$lambda-2(this, commentId, tokenAndStatusNonNull, arg_0)).doOnError(arg_0 -> EkoCommentBoundaryCallback.mapByComment$lambda-4$lambda-3(this, commentId, tokenAndStatusNonNull, arg_0)).subscribeOn(Schedulers.from((Executor)SINGLE_THREAD_EXECUTOR)).subscribe((CompletableObserver)this);
        }
    }

    @Deprecated(message="hack before moving to paging data")
    private final Completable clearComments() {
        CommentLocalDataStore commentLocalDataStore = new CommentLocalDataStore();
        Completable completable = RxJava3BridgeExtensionsKt.toV2(commentLocalDataStore.deleteByReferenceId(this.referenceId)).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"commentLocalDataStore.de\u2026scribeOn(Schedulers.io())");
        return completable;
    }

    private final Completable call(CommentQueryRequest.CommentQueryRequestOptions options) {
        CommentQueryRequest commentQueryRequest = new CommentQueryRequest(this.referenceId, this.referenceType, this.isFilterByParentId, this.parentId, null, this.sortBy.getApiKey(), options, 16, null);
        Completable completable = RxJava3BridgeExtensionsKt.toV2(new CommentRemoteDataStore().queryComments(commentQueryRequest)).flatMap(arg_0 -> EkoCommentBoundaryCallback.call$lambda-6(options, this, arg_0)).flatMap(EkoCommentBoundaryCallback::call$lambda-8).doOnSuccess(arg_0 -> EkoCommentBoundaryCallback.call$lambda-10(this, arg_0)).retryWhen(RetryWhen.maxRetries((int)3).exponentialBackoff(1L, 10L, TimeUnit.SECONDS, 1.5).action(EkoCommentBoundaryCallback::call$lambda-11).build()).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"CommentRemoteDataStore()\u2026         .ignoreElement()");
        return completable;
    }

    private static final void onFirstLoaded$lambda-0(EkoCommentBoundaryCallback this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.delaySubject.onComplete();
    }

    private static final void onFirstLoaded$lambda-1(EkoCommentBoundaryCallback this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.delaySubject.onComplete();
    }

    private static final void mapByComment$lambda-4$lambda-2(EkoCommentBoundaryCallback this$0, String $commentId, Pair $tokenAndStatusNonNull, Disposable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$commentId, (String)"$commentId");
        Intrinsics.checkNotNullParameter((Object)$tokenAndStatusNonNull, (String)"$tokenAndStatusNonNull");
        this$0.commentIdAndTokenMap.put($commentId, (Pair<String, Boolean>)new Pair($tokenAndStatusNonNull.first, (Object)true));
    }

    private static final void mapByComment$lambda-4$lambda-3(EkoCommentBoundaryCallback this$0, String $commentId, Pair $tokenAndStatusNonNull, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$commentId, (String)"$commentId");
        Intrinsics.checkNotNullParameter((Object)$tokenAndStatusNonNull, (String)"$tokenAndStatusNonNull");
        this$0.commentIdAndTokenMap.put($commentId, (Pair<String, Boolean>)new Pair($tokenAndStatusNonNull.first, (Object)false));
    }

    private static final SingleSource call$lambda-6$lambda-5(EkoCommentAndUserListDto $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return (SingleSource)Single.just((Object)$it);
    }

    private static final SingleSource call$lambda-6(CommentQueryRequest.CommentQueryRequestOptions $options, EkoCommentBoundaryCallback this$0, EkoCommentAndUserListDto it) {
        Intrinsics.checkNotNullParameter((Object)$options, (String)"$options");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CharSequence charSequence = $options.getToken();
        if (charSequence == null || charSequence.length() == 0) {
            return (SingleSource)this$0.clearComments().andThen((SingleSource)Single.defer(() -> EkoCommentBoundaryCallback.call$lambda-6$lambda-5(it)));
        }
        return (SingleSource)Single.just((Object)it);
    }

    private static final SingleSource call$lambda-8$lambda-7(EkoCommentAndUserListDto $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return (SingleSource)RxJava3BridgeExtensionsKt.toV2(new CommentQueryPersister().persist($it)).andThen((SingleSource)Single.just((Object)$it));
    }

    private static final SingleSource call$lambda-8(EkoCommentAndUserListDto it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (SingleSource)Single.defer(() -> EkoCommentBoundaryCallback.call$lambda-8$lambda-7(it));
    }

    private static final void call$lambda-10(EkoCommentBoundaryCallback this$0, EkoCommentAndUserListDto dto) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        List<EkoCommentDto> comments = dto.getComments();
        Collection collection = comments;
        if (!(collection == null || collection.isEmpty())) {
            EkoCommentDto ekoCommentDto;
            Object $this$lastOrNull$iv;
            block6: {
                Intrinsics.checkNotNullExpressionValue(comments, (String)"comments");
                $this$lastOrNull$iv = comments;
                boolean $i$f$lastOrNull = false;
                ListIterator<EkoCommentDto> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    EkoCommentDto element$iv;
                    EkoCommentDto it = element$iv = iterator$iv.previous();
                    boolean bl = false;
                    if (!(this$0.isDeleted == null ? true : Intrinsics.areEqual((Object)this$0.isDeleted, (Object)it.getDeleted()))) continue;
                    ekoCommentDto = element$iv;
                    break block6;
                }
                ekoCommentDto = null;
            }
            EkoCommentDto ekoCommentDto2 = ekoCommentDto;
            String commentId = ekoCommentDto2 != null ? ekoCommentDto2.getCommentId() : null;
            String nextPage = dto.getToken().getNext();
            $this$lastOrNull$iv = nextPage;
            if (!($this$lastOrNull$iv == null || $this$lastOrNull$iv.length() == 0)) {
                $this$lastOrNull$iv = commentId;
                if (!($this$lastOrNull$iv == null || $this$lastOrNull$iv.length() == 0)) {
                    $this$lastOrNull$iv = this$0.commentIdAndTokenMap;
                    Pair pair = Pair.create((Object)nextPage, (Object)false);
                    Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(nextPage, false)");
                    Pair pair2 = pair;
                    $this$lastOrNull$iv.put((String)commentId, (Pair<String, Boolean>)pair2);
                    if (this$0.commentIdSet.contains(commentId)) {
                        this$0.mapByComment(commentId);
                    }
                } else {
                    CommentQueryRequest.CommentQueryRequestOptions options = new CommentQueryRequest.CommentQueryRequestOptions(null, null, null, null, null, null, "pagination", nextPage, 63, null);
                    this$0.call(options).subscribeOn(Schedulers.from((Executor)SINGLE_THREAD_EXECUTOR)).subscribe((CompletableObserver)this$0);
                }
            }
        }
    }

    private static final void call$lambda-11(RetryWhen.ErrorAndDuration errorAndDuration) {
        Intrinsics.checkNotNullParameter((Object)errorAndDuration, (String)"errorAndDuration");
        String string = EkoCommentBoundaryCallback.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"EkoCommentBoundaryCallback::class.java.name");
        Object[] objectArray = new Object[]{errorAndDuration.durationMs()};
        AmityLog.INSTANCE.tag(string).e(errorAndDuration.throwable(), "an error occurred, back-off for durationMs:%s", objectArray);
    }

    static {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        SINGLE_THREAD_EXECUTOR = executorService;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ekoapp/ekosdk/internal/data/boundarycallback/EkoCommentBoundaryCallback$Companion;", "", "()V", "SINGLE_THREAD_EXECUTOR", "Ljava/util/concurrent/Executor;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

