/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.UserFeedQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.model.UserFeedQueryTokenEntity;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class UserFeedQueryTokenDao_Impl
extends UserFeedQueryTokenDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<UserFeedQueryTokenEntity> __insertionAdapterOfUserFeedQueryTokenEntity;
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();

    public UserFeedQueryTokenDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUserFeedQueryTokenEntity = new EntityInsertionAdapter<UserFeedQueryTokenEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `user_feed_query_token` (`userId`,`sortBy`,`isDeleted`,`postTypes`,`previous`,`next`,`pageNumber`,`ids`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, UserFeedQueryTokenEntity value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                if (value.getSortBy() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSortBy());
                }
                if (value.isDeleted() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.isDeleted());
                }
                if (value.getPostTypes() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getPostTypes());
                }
                if (value.getPrevious() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getPrevious());
                }
                if (value.getNext() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getNext());
                }
                stmt.bindLong(7, (long)value.getPageNumber());
                String _tmp = UserFeedQueryTokenDao_Impl.this.__stringListConverter.stringListToString(value.getIds());
                if (_tmp == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp);
                }
                String _tmp_1 = UserFeedQueryTokenDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_1);
                }
            }
        };
    }

    @Override
    public Completable insertToken(final UserFeedQueryTokenEntity token) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                UserFeedQueryTokenDao_Impl.this.__db.beginTransaction();
                try {
                    UserFeedQueryTokenDao_Impl.this.__insertionAdapterOfUserFeedQueryTokenEntity.insert((Object)token);
                    UserFeedQueryTokenDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    UserFeedQueryTokenDao_Impl.this.__db.endTransaction();
                }
            }
        });
    }

    @Override
    public Maybe<UserFeedQueryTokenEntity> queryToken(SimpleSQLiteQuery query) {
        SimpleSQLiteQuery _internalQuery = query;
        return Maybe.fromCallable((Callable)new Callable<UserFeedQueryTokenEntity>((SupportSQLiteQuery)_internalQuery){
            final /* synthetic */ SupportSQLiteQuery val$_internalQuery;
            {
                this.val$_internalQuery = supportSQLiteQuery;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UserFeedQueryTokenEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserFeedQueryTokenDao_Impl.this.__db, (SupportSQLiteQuery)this.val$_internalQuery, (boolean)false, null);){
                    UserFeedQueryTokenEntity _result = _cursor.moveToFirst() ? UserFeedQueryTokenDao_Impl.this.__entityCursorConverter_comEkoappEkosdkInternalDataModelUserFeedQueryTokenEntity(_cursor) : null;
                    UserFeedQueryTokenEntity userFeedQueryTokenEntity = _result;
                    return userFeedQueryTokenEntity;
                }
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private UserFeedQueryTokenEntity __entityCursorConverter_comEkoappEkosdkInternalDataModelUserFeedQueryTokenEntity(Cursor cursor) {
        int _cursorIndexOfUserId = CursorUtil.getColumnIndex((Cursor)cursor, (String)"userId");
        int _cursorIndexOfSortBy = CursorUtil.getColumnIndex((Cursor)cursor, (String)"sortBy");
        int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndex((Cursor)cursor, (String)"isDeleted");
        int _cursorIndexOfPostTypes = CursorUtil.getColumnIndex((Cursor)cursor, (String)"postTypes");
        int _cursorIndexOfPrevious = CursorUtil.getColumnIndex((Cursor)cursor, (String)"previous");
        int _cursorIndexOfNext = CursorUtil.getColumnIndex((Cursor)cursor, (String)"next");
        int _cursorIndexOfPageNumber = CursorUtil.getColumnIndex((Cursor)cursor, (String)"pageNumber");
        int _cursorIndexOfIds = CursorUtil.getColumnIndex((Cursor)cursor, (String)"ids");
        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndex((Cursor)cursor, (String)"updatedAt");
        String _tmpUserId = _cursorIndexOfUserId == -1 ? null : (cursor.isNull(_cursorIndexOfUserId) ? null : cursor.getString(_cursorIndexOfUserId));
        String _tmpSortBy = _cursorIndexOfSortBy == -1 ? null : (cursor.isNull(_cursorIndexOfSortBy) ? null : cursor.getString(_cursorIndexOfSortBy));
        String _tmpIsDeleted = _cursorIndexOfIsDeleted == -1 ? null : (cursor.isNull(_cursorIndexOfIsDeleted) ? null : cursor.getString(_cursorIndexOfIsDeleted));
        String _tmpPostTypes = _cursorIndexOfPostTypes == -1 ? null : (cursor.isNull(_cursorIndexOfPostTypes) ? null : cursor.getString(_cursorIndexOfPostTypes));
        UserFeedQueryTokenEntity _entity = new UserFeedQueryTokenEntity(_tmpUserId, _tmpSortBy, _tmpIsDeleted, _tmpPostTypes);
        if (_cursorIndexOfPrevious != -1) {
            String _tmpPrevious = cursor.isNull(_cursorIndexOfPrevious) ? null : cursor.getString(_cursorIndexOfPrevious);
            _entity.setPrevious(_tmpPrevious);
        }
        if (_cursorIndexOfNext != -1) {
            String _tmpNext = cursor.isNull(_cursorIndexOfNext) ? null : cursor.getString(_cursorIndexOfNext);
            _entity.setNext(_tmpNext);
        }
        if (_cursorIndexOfPageNumber != -1) {
            int _tmpPageNumber = cursor.getInt(_cursorIndexOfPageNumber);
            _entity.setPageNumber(_tmpPageNumber);
        }
        if (_cursorIndexOfIds != -1) {
            String _tmp = cursor.isNull(_cursorIndexOfIds) ? null : cursor.getString(_cursorIndexOfIds);
            List<String> _tmpIds = this.__stringListConverter.stringToStringList(_tmp);
            _entity.setIds(_tmpIds);
        }
        if (_cursorIndexOfUpdatedAt != -1) {
            String _tmp_1 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
            DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
            _entity.setUpdatedAt(_tmpUpdatedAt);
        }
        return _entity;
    }
}

