/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.channel;

import androidx.paging.PagingData;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMember;
import com.amity.socialcloud.sdk.chat.channel.AmityChannelMembership;
import com.amity.socialcloud.sdk.core.permission.AmityRoles;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.internal.usecase.channel.SearchChannelMembershipPagingSourceUseCase;
import io.reactivex.Flowable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB-\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMemberSearch;", "", "channelId", "", "roles", "Lcom/amity/socialcloud/sdk/core/permission/AmityRoles;", "memberships", "", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMembership;", "keyword", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/core/permission/AmityRoles;Ljava/util/List;Ljava/lang/String;)V", "getPagingData", "Lio/reactivex/Flowable;", "Landroidx/paging/PagingData;", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMember;", "Builder", "amity-sdk_release"})
public final class AmityChannelMemberSearch {
    @NotNull
    private final String channelId;
    @NotNull
    private final AmityRoles roles;
    @NotNull
    private final List<AmityChannelMembership> memberships;
    @NotNull
    private final String keyword;

    public AmityChannelMemberSearch(@NotNull String channelId, @NotNull AmityRoles roles, @NotNull List<? extends AmityChannelMembership> memberships, @NotNull String keyword) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter(memberships, (String)"memberships");
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        this.channelId = channelId;
        this.roles = roles;
        this.memberships = memberships;
        this.keyword = keyword;
    }

    @NotNull
    public final Flowable<PagingData<AmityChannelMember>> getPagingData() {
        return RxJava3BridgeExtensionsKt.toV2(new SearchChannelMembershipPagingSourceUseCase().execute(this.channelId, this.memberships, this.roles, this.keyword));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010\u000e\u001a\u00020\u00002\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0014\u0010\n\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMemberSearch$Builder;", "", "channelId", "", "keyword", "(Ljava/lang/String;Ljava/lang/String;)V", "()V", "memberships", "", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMembership;", "roles", "Lcom/amity/socialcloud/sdk/core/permission/AmityRoles;", "build", "Lcom/amity/socialcloud/sdk/chat/channel/AmityChannelMemberSearch;", "membershipFilter", "channelMembership", "amity-sdk_release"})
    public static final class Builder {
        private String channelId;
        private String keyword;
        @NotNull
        private AmityRoles roles;
        @NotNull
        private List<? extends AmityChannelMembership> memberships;

        private Builder() {
            this.roles = new AmityRoles();
            this.memberships = CollectionsKt.listOf((Object)((Object)AmityChannelMembership.MEMBER));
        }

        public Builder(@NotNull String channelId, @NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            this();
            this.channelId = channelId;
            this.keyword = keyword;
        }

        @NotNull
        public final Builder membershipFilter(@NotNull List<? extends AmityChannelMembership> channelMembership) {
            Builder builder;
            Intrinsics.checkNotNullParameter(channelMembership, (String)"channelMembership");
            Builder $this$membershipFilter_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            if (!((Collection)channelMembership).isEmpty()) {
                $this$membershipFilter_u24lambda_u2d0.memberships = channelMembership;
            }
            return builder;
        }

        @NotNull
        public final Builder roles(@NotNull List<String> roles) {
            Builder builder;
            Intrinsics.checkNotNullParameter(roles, (String)"roles");
            Builder $this$roles_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$roles_u24lambda_u2d1.roles = new AmityRoles(roles);
            return builder;
        }

        @NotNull
        public final AmityChannelMemberSearch build() {
            String string;
            String string2 = this.channelId;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"channelId");
                string2 = null;
            }
            if ((string = this.keyword) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"keyword");
                string = null;
            }
            return new AmityChannelMemberSearch(string2, this.roles, this.memberships, string);
        }
    }
}

