/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.usecase.stream;

import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.AmityNetworkUtils;
import com.ekoapp.ekosdk.internal.api.EkoApi;
import com.ekoapp.ekosdk.internal.api.http.request.StreamSessionRequest;
import com.ekoapp.ekosdk.internal.api.http.request.StreamSessionRequestCreator;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoApiKeyDao;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.repository.stream.StreamSessionRepository;
import com.ekoapp.ekosdk.stream.entity.EkoStreamSessionEntity;
import io.reactivex.Maybe;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u001c\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0016\u0010\u0011\u001a\u00020\u00102\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001e\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\b\u0010\u0015\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/ekoapp/ekosdk/internal/usecase/stream/SendStreamSessionUseCase;", "", "()V", "retryCount", "", "execute", "Lio/reactivex/rxjava3/core/Completable;", "streamSessions", "", "Lcom/ekoapp/ekosdk/stream/entity/EkoStreamSessionEntity;", "requireNetwork", "", "getApiKey", "Lio/reactivex/rxjava3/core/Maybe;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoApiKey;", "markAsFailed", "", "markAsSynced", "sendToServer", "apiKey", "", "shouldSend", "amity-sdk_release"})
public final class SendStreamSessionUseCase {
    private int retryCount;

    @NotNull
    public final Completable execute(@NotNull List<EkoStreamSessionEntity> streamSessions) {
        Intrinsics.checkNotNullParameter(streamSessions, (String)"streamSessions");
        Completable completable = this.getApiKey().flatMapCompletable((Function)new Function<EkoApiKey, CompletableSource>(this, streamSessions){
            final /* synthetic */ SendStreamSessionUseCase this$0;
            final /* synthetic */ List $streamSessions;

            public final CompletableSource apply(EkoApiKey it) {
                EkoApiKey ekoApiKey = it;
                Intrinsics.checkNotNullExpressionValue((Object)ekoApiKey, (String)"it");
                String string = ekoApiKey.getApiKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.apiKey");
                return (CompletableSource)SendStreamSessionUseCase.access$sendToServer(this.this$0, string, this.$streamSessions);
            }
            {
                this.this$0 = sendStreamSessionUseCase;
                this.$streamSessions = list;
            }
        }).doOnComplete(new Action(this, streamSessions){
            final /* synthetic */ SendStreamSessionUseCase this$0;
            final /* synthetic */ List $streamSessions;

            public final void run() {
                SendStreamSessionUseCase.access$markAsSynced(this.this$0, this.$streamSessions);
            }
            {
                this.this$0 = sendStreamSessionUseCase;
                this.$streamSessions = list;
            }
        }).doOnError((Consumer)new Consumer<Throwable>(this, streamSessions){
            final /* synthetic */ SendStreamSessionUseCase this$0;
            final /* synthetic */ List $streamSessions;

            public final void accept(Throwable it) {
                SendStreamSessionUseCase.access$markAsFailed(this.this$0, this.$streamSessions);
            }
            {
                this.this$0 = sendStreamSessionUseCase;
                this.$streamSessions = list;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"getApiKey()\n            \u2026sFailed(streamSessions) }");
        return completable;
    }

    @NotNull
    public final Completable execute(@NotNull List<EkoStreamSessionEntity> streamSessions, boolean requireNetwork) {
        Completable completable;
        Intrinsics.checkNotNullParameter(streamSessions, (String)"streamSessions");
        if (streamSessions.isEmpty()) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"Completable.complete()");
        } else if (requireNetwork) {
            Completable completable3 = Flowable.interval((long)1L, (TimeUnit)TimeUnit.SECONDS).filter((Predicate)new Predicate<Long>(this){
                final /* synthetic */ SendStreamSessionUseCase this$0;

                public final boolean test(Long it) {
                    return SendStreamSessionUseCase.access$shouldSend(this.this$0);
                }
                {
                    this.this$0 = sendStreamSessionUseCase;
                }
            }).takeUntil((Predicate)new Predicate<Long>(this){
                final /* synthetic */ SendStreamSessionUseCase this$0;

                public final boolean test(Long it) {
                    return SendStreamSessionUseCase.access$getRetryCount$p(this.this$0) >= 60;
                }
                {
                    this.this$0 = sendStreamSessionUseCase;
                }
            }).firstOrError().flatMapCompletable((Function)new Function<Long, CompletableSource>(this, streamSessions){
                final /* synthetic */ SendStreamSessionUseCase this$0;
                final /* synthetic */ List $streamSessions;

                public final CompletableSource apply(Long it) {
                    return (CompletableSource)this.this$0.execute(this.$streamSessions);
                }
                {
                    this.this$0 = sendStreamSessionUseCase;
                    this.$streamSessions = list;
                }
            });
            completable = completable3;
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"Flowable.interval(1, Tim\u2026execute(streamSessions) }");
        } else {
            completable = this.execute(streamSessions);
        }
        return completable;
    }

    private final boolean shouldSend() {
        boolean bl;
        if (AmityNetworkUtils.Companion.isNetworkAvailable()) {
            bl = true;
        } else {
            int n = this.retryCount;
            this.retryCount = n + 1;
            bl = false;
        }
        return bl;
    }

    private final io.reactivex.rxjava3.core.Maybe<EkoApiKey> getApiKey() {
        EkoApiKeyDao ekoApiKeyDao = EkoDatabase.get().apiKeyDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoApiKeyDao, (String)"EkoDatabase.get().apiKeyDao()");
        Maybe<EkoApiKey> maybe = ekoApiKeyDao.getCurrentApiKey();
        Intrinsics.checkNotNullExpressionValue(maybe, (String)"EkoDatabase.get().apiKeyDao().currentApiKey");
        return RxJava3BridgeExtensionsKt.toV3(maybe);
    }

    private final Completable sendToServer(String apiKey, List<EkoStreamSessionEntity> streamSessions) {
        new StreamSessionRepository().markAsSyncing(streamSessions);
        StreamSessionRequest request = new StreamSessionRequestCreator(streamSessions).create();
        io.reactivex.Completable completable = EkoApi.Companion.stream().sendStreamSession(apiKey, request);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoApi.stream().sendStreamSession(apiKey, request)");
        return RxJava3BridgeExtensionsKt.toV3(completable);
    }

    private final void markAsSynced(List<EkoStreamSessionEntity> streamSessions) {
        new StreamSessionRepository().markAsSynced(streamSessions);
    }

    private final void markAsFailed(List<EkoStreamSessionEntity> streamSessions) {
        new StreamSessionRepository().markAsFailed(streamSessions);
    }

    public static final /* synthetic */ Completable access$sendToServer(SendStreamSessionUseCase $this, String apiKey, List streamSessions) {
        return $this.sendToServer(apiKey, streamSessions);
    }

    public static final /* synthetic */ void access$markAsSynced(SendStreamSessionUseCase $this, List streamSessions) {
        $this.markAsSynced(streamSessions);
    }

    public static final /* synthetic */ void access$markAsFailed(SendStreamSessionUseCase $this, List streamSessions) {
        $this.markAsFailed(streamSessions);
    }

    public static final /* synthetic */ boolean access$shouldSend(SendStreamSessionUseCase $this) {
        return $this.shouldSend();
    }

    public static final /* synthetic */ int access$getRetryCount$p(SendStreamSessionUseCase $this) {
        return $this.retryCount;
    }

    public static final /* synthetic */ void access$setRetryCount$p(SendStreamSessionUseCase $this, int n) {
        $this.retryCount = n;
    }
}

