/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.infra.mqtt;

import android.util.Log;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.amity.socialcloud.sdk.core.error.AmityException;
import com.amity.socialcloud.sdk.core.events.AmityTopic;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.infra.mqtt.AmityMqttClient;
import com.amity.socialcloud.sdk.infra.mqtt.listener.MqttEventListener;
import com.amity.socialcloud.sdk.infra.mqtt.listener.MqttEventListeners;
import com.amity.socialcloud.sdk.infra.mqtt.payload.MqttPayload;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.UserEntity;
import com.ekoapp.ekosdk.internal.api.EkoEndpoint;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.UserDao;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.google.gson.JsonObject;
import com.hivemq.client.mqtt.MqttClient;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedListener;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedListener;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.hivemq.client.mqtt.mqtt3.Mqtt3RxClient;
import com.hivemq.client.mqtt.mqtt3.exceptions.Mqtt3ConnAckException;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3ConnectBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAckReturnCode;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import io.reactivex.Completable;
import io.reactivex.Single;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u0011\u001a\u00020\bH\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\b\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a8\u0006\""}, d2={"Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "addClientListeners", "", "authClient", "Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$AuthenticatedMqttClient;", "autoSubscribe", "connect", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "createEventSubscription", "Lio/reactivex/disposables/Disposable;", "destroy", "disconnect", "Lio/reactivex/Completable;", "establish", "generateClientId", "", "newAccount", "handleTokenExpire", "initMqttClient", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "clientId", "obsoleteClient", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "AuthenticatedMqttClient", "Companion", "amity-sdk_release"})
public final class AmityMqttClient
extends SessionComponent {
    private static final CompositeDisposable subscriptions;
    private static AuthenticatedMqttClient activeClient;
    @NotNull
    private static final String TAG;
    @NotNull
    public static final Companion Companion;

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        Log.e((String)"SSM3", (String)("mqtt session change: " + sessionState));
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        Log.e((String)"SSM3", (String)("mqtt session establish: " + this.hashCode()));
        AuthenticatedMqttClient authenticatedMqttClient = activeClient;
        if (authenticatedMqttClient != null) {
            AuthenticatedMqttClient authenticatedMqttClient2 = authenticatedMqttClient;
            boolean bl = false;
            boolean bl2 = false;
            AuthenticatedMqttClient it = authenticatedMqttClient2;
            boolean bl3 = false;
            this.obsoleteClient(it);
        }
        io.reactivex.rxjava3.core.Completable.fromAction((Action)new Action(this, account){
            final /* synthetic */ AmityMqttClient this$0;
            final /* synthetic */ EkoAccount $account;

            public final void run() {
                AmityMqttClient.access$connect(this.this$0, this.$account);
            }
            {
                this.this$0 = amityMqttClient;
                this.$account = ekoAccount;
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    @Override
    public void destroy() {
        block0: {
            AuthenticatedMqttClient authenticatedMqttClient = activeClient;
            if (authenticatedMqttClient == null) break block0;
            AuthenticatedMqttClient authenticatedMqttClient2 = authenticatedMqttClient;
            boolean bl = false;
            boolean bl2 = false;
            AuthenticatedMqttClient it = authenticatedMqttClient2;
            boolean bl3 = false;
            this.obsoleteClient(it);
        }
    }

    @Override
    public void handleTokenExpire() {
        block0: {
            AuthenticatedMqttClient authenticatedMqttClient = activeClient;
            if (authenticatedMqttClient == null) break block0;
            AuthenticatedMqttClient authenticatedMqttClient2 = authenticatedMqttClient;
            boolean bl = false;
            boolean bl2 = false;
            AuthenticatedMqttClient it = authenticatedMqttClient2;
            boolean bl3 = false;
            this.obsoleteClient(it);
        }
    }

    @NotNull
    public final Completable disconnect() {
        Completable completable;
        if (activeClient != null) {
            Completable completable2 = Completable.fromAction((io.reactivex.functions.Action)new io.reactivex.functions.Action(this){
                final /* synthetic */ AmityMqttClient this$0;

                public final void run() {
                    AuthenticatedMqttClient authenticatedMqttClient = AmityMqttClient.access$getActiveClient$cp();
                    Intrinsics.checkNotNull((Object)authenticatedMqttClient);
                    AmityMqttClient.access$obsoleteClient(this.this$0, authenticatedMqttClient);
                }
                {
                    this.this$0 = amityMqttClient;
                }
            });
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"Completable.fromAction {\u2026eClient(activeClient!!) }");
        } else {
            Completable completable3 = Completable.complete();
            completable = completable3;
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"Completable.complete()");
        }
        return completable;
    }

    private final void connect(EkoAccount account) {
        block4: {
            Mqtt3RxClient mqtt3RxClient;
            String clientId = this.generateClientId(account);
            try {
                mqtt3RxClient = this.initMqttClient(clientId);
            }
            catch (Exception e) {
                mqtt3RxClient = null;
            }
            Mqtt3RxClient mqttClient = mqtt3RxClient;
            UserDao userDao = UserDatabase.get().userDao();
            UserEntity user = userDao.getByIdNow(account.getUserId());
            Object object = user;
            if (object == null || (object = ((UserEntity)object).getMid()) == null) {
                object = "";
            }
            Object userName = object;
            Log.e((String)TAG, (String)("Connecting client: " + clientId + " userId: " + account.getUserId()));
            Mqtt3RxClient mqtt3RxClient2 = mqttClient;
            if (mqtt3RxClient2 == null) break block4;
            Mqtt3RxClient mqtt3RxClient3 = mqtt3RxClient2;
            boolean bl = false;
            boolean bl2 = false;
            Mqtt3RxClient it = mqtt3RxClient3;
            boolean bl3 = false;
            Mqtt3SimpleAuthBuilder.Nested.Complete complete = (Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3ConnectBuilder.Nested)mqttClient.connectWith().cleanSession(false)).simpleAuth().username((String)userName);
            String string = account.getAccessToken();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"account.accessToken");
            String string2 = string;
            Charset charset = Charsets.UTF_8;
            boolean bl4 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            ((Single)((Mqtt3ConnectBuilder.Nested)((Mqtt3ConnectBuilder.Nested)((Mqtt3SimpleAuthBuilder.Nested.Complete)complete.password(byArray)).applySimpleAuth()).keepAlive(60)).applyConnect()).ignoreElement().doOnComplete(new io.reactivex.functions.Action(this, mqttClient, (String)userName, account, clientId){
                final /* synthetic */ AmityMqttClient this$0;
                final /* synthetic */ Mqtt3RxClient $mqttClient$inlined;
                final /* synthetic */ String $userName$inlined;
                final /* synthetic */ EkoAccount $account$inlined;
                final /* synthetic */ String $clientId$inlined;
                {
                    this.this$0 = amityMqttClient;
                    this.$mqttClient$inlined = mqtt3RxClient;
                    this.$userName$inlined = string;
                    this.$account$inlined = ekoAccount;
                    this.$clientId$inlined = string2;
                }

                public final void run() {
                    AuthenticatedMqttClient authClient = new AuthenticatedMqttClient(this.$clientId$inlined, this.$account$inlined, this.$mqttClient$inlined);
                    AmityMqttClient.access$setActiveClient$cp(authClient);
                    AmityMqttClient.access$addClientListeners(this.this$0, authClient);
                    AmityMqttClient.access$autoSubscribe(this.this$0);
                }
            }).doOnError((Consumer)connect.1.2.INSTANCE).subscribe();
        }
    }

    private final String generateClientId(EkoAccount newAccount) {
        String string = newAccount.getDeviceId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"newAccount.deviceId");
        return string;
    }

    private final Mqtt3RxClient initMqttClient(String clientId) {
        Mqtt3RxClient mqtt3RxClient = ((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)MqttClient.builder().useMqttVersion3().identifier(clientId)).serverHost(EkoEndpoint.INSTANCE.getMqttUrl())).serverPort(443)).sslWithDefaultConfig()).automaticReconnectWithDefaultConfig()).addConnectedListener((MqttClientConnectedListener)initMqttClient.1.INSTANCE)).addDisconnectedListener(new MqttClientDisconnectedListener(clientId){
            final /* synthetic */ String $clientId;

            /*
             * Unable to fully structure code
             */
            public final void onDisconnected(@NotNull MqttClientDisconnectedContext it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                v0 = it.getCause();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it.cause");
                exception = v0;
                v1 = AmityMqttClient.access$getActiveClient$cp();
                isNotActive = Intrinsics.areEqual((Object)(v1 != null ? v1.getClientId() : null), (Object)this.$clientId) ^ true;
                if (!(exception instanceof Mqtt3ConnAckException)) ** GOTO lbl-1000
                v2 = ((Mqtt3ConnAckException)exception).getMqttMessage();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"exception.mqttMessage");
                if (v2.getReturnCode() == Mqtt3ConnAckReturnCode.IDENTIFIER_REJECTED) ** GOTO lbl-1000
                v3 = ((Mqtt3ConnAckException)exception).getMqttMessage();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"exception.mqttMessage");
                if (v3.getReturnCode() == Mqtt3ConnAckReturnCode.UNSUPPORTED_PROTOCOL_VERSION) ** GOTO lbl-1000
                v4 = ((Mqtt3ConnAckException)exception).getMqttMessage();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"exception.mqttMessage");
                if (v4.getReturnCode() == Mqtt3ConnAckReturnCode.BAD_USER_NAME_OR_PASSWORD) ** GOTO lbl-1000
                v5 = ((Mqtt3ConnAckException)exception).getMqttMessage();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"exception.mqttMessage");
                if (v5.getReturnCode() == Mqtt3ConnAckReturnCode.NOT_AUTHORIZED) lbl-1000:
                // 4 sources

                {
                    v6 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v6 = false;
                }
                hasValidDisconnectReason = v6;
                v7 = shouldNotReconnect = isNotActive != false || hasValidDisconnectReason != false;
                if (shouldNotReconnect) {
                    it.getReconnector().reconnect(false);
                }
                Log.e((String)AmityMqttClient.Companion.getTAG(), (String)("mqtt disconnected || isNotActive: " + isNotActive + " || hasValidDisconnectReason: " + hasValidDisconnectReason + ' '));
                Log.e((String)AmityMqttClient.Companion.getTAG(), (String)("mqtt disconnected || cause: " + exception));
            }
            {
                this.$clientId = string;
            }
        })).buildRx();
        Intrinsics.checkNotNullExpressionValue((Object)mqtt3RxClient, (String)"MqttClient.builder()\n   \u2026 }\n            .buildRx()");
        return mqtt3RxClient;
    }

    private final void obsoleteClient(AuthenticatedMqttClient authClient) {
        subscriptions.clear();
        Log.e((String)TAG, (String)("Disconnecting client: \" + " + authClient.getClientId() + " + \" userId : \" + " + authClient.getAccount().getUserId()));
        Mqtt3RxClient mqttClient = authClient.getMqttClient();
        mqttClient.disconnect().subscribeOn(io.reactivex.schedulers.Schedulers.io()).doOnError((Consumer)obsoleteClient.1.INSTANCE).subscribe();
        activeClient = null;
    }

    private final Disposable createEventSubscription(AuthenticatedMqttClient authClient) {
        Mqtt3RxClient mqttClient = authClient.getMqttClient();
        Disposable disposable = mqttClient.publishes(MqttGlobalPublishFilter.ALL).subscribeOn(io.reactivex.schedulers.Schedulers.io()).doOnNext((Consumer)new Consumer<Mqtt3Publish>(this, authClient){
            final /* synthetic */ AmityMqttClient this$0;
            final /* synthetic */ AuthenticatedMqttClient $authClient;

            public final void accept(Mqtt3Publish it) {
                AuthenticatedMqttClient authenticatedMqttClient = AmityMqttClient.access$getActiveClient$cp();
                boolean isNotActiveClient = Intrinsics.areEqual((Object)this.$authClient.getClientId(), (Object)(authenticatedMqttClient != null ? authenticatedMqttClient.getClientId() : null)) ^ true;
                if (isNotActiveClient) {
                    AmityMqttClient.access$obsoleteClient(this.this$0, this.$authClient);
                    return;
                }
                try {
                    Mqtt3Publish mqtt3Publish = it;
                    Intrinsics.checkNotNullExpressionValue((Object)mqtt3Publish, (String)"it");
                    byte[] byArray = mqtt3Publish.getPayloadAsBytes();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"it.payloadAsBytes");
                    byte[] byArray2 = byArray;
                    boolean bl = false;
                    String payload = new String(byArray2, Charsets.UTF_8);
                    Timber.tag((String)AmityMqttClient.Companion.getTAG()).d("received event: " + payload, new Object[0]);
                    MqttPayload event = (MqttPayload)EkoGson.get().fromJson(payload, MqttPayload.class);
                    JsonObject jsonObject = MqttEventListeners.INSTANCE.getMap();
                    String string = event.getEventType();
                    boolean bl2 = false;
                    MqttEventListener<Object> listener = jsonObject.get(string);
                    if (listener != null) {
                        JsonObject jsonObject2 = event.getData();
                        if (jsonObject2 != null) {
                            jsonObject = jsonObject2;
                            boolean bl3 = false;
                            bl2 = false;
                            JsonObject data = jsonObject;
                            boolean bl4 = false;
                            listener.onEvent$amity_sdk_release(data);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            {
                this.this$0 = amityMqttClient;
                this.$authClient = authenticatedMqttClient;
            }
        }).doOnError((Consumer)createEventSubscription.2.INSTANCE).subscribe();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"mqttClient\n            .\u2026\n            .subscribe()");
        return disposable;
    }

    private final void addClientListeners(AuthenticatedMqttClient authClient) {
        Disposable eventSubscription = this.createEventSubscription(authClient);
        subscriptions.add(eventSubscription);
    }

    private final void autoSubscribe() {
        Disposable networkSubscription2 = Companion.subscribe(new AmityTopic.NETWORK()).subscribeOn(io.reactivex.schedulers.Schedulers.io()).doOnError((Consumer)autoSubscribe.networkSubscription.1.INSTANCE).subscribe();
        subscriptions.add(networkSubscription2);
    }

    public AmityMqttClient(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
    }

    static {
        Companion = new Companion(null);
        subscriptions = new CompositeDisposable();
        TAG = "AmityMqtt";
    }

    public static final /* synthetic */ void access$connect(AmityMqttClient $this, EkoAccount account) {
        $this.connect(account);
    }

    public static final /* synthetic */ void access$obsoleteClient(AmityMqttClient $this, AuthenticatedMqttClient authClient) {
        $this.obsoleteClient(authClient);
    }

    public static final /* synthetic */ void access$setActiveClient$cp(AuthenticatedMqttClient authenticatedMqttClient) {
        activeClient = authenticatedMqttClient;
    }

    public static final /* synthetic */ void access$addClientListeners(AmityMqttClient $this, AuthenticatedMqttClient authClient) {
        $this.addClientListeners(authClient);
    }

    public static final /* synthetic */ void access$autoSubscribe(AmityMqttClient $this) {
        $this.autoSubscribe();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$AuthenticatedMqttClient;", "", "clientId", "", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "mqttClient", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "(Ljava/lang/String;Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;)V", "getAccount", "()Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "getClientId", "()Ljava/lang/String;", "getMqttClient", "()Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "amity-sdk_release"})
    public static final class AuthenticatedMqttClient {
        @NotNull
        private final String clientId;
        @NotNull
        private final EkoAccount account;
        @NotNull
        private final Mqtt3RxClient mqttClient;

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final EkoAccount getAccount() {
            return this.account;
        }

        @NotNull
        public final Mqtt3RxClient getMqttClient() {
            return this.mqttClient;
        }

        public AuthenticatedMqttClient(@NotNull String clientId, @NotNull EkoAccount account, @NotNull Mqtt3RxClient mqttClient) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)mqttClient, (String)"mqttClient");
            this.clientId = clientId;
            this.account = account;
            this.mqttClient = mqttClient;
        }

        @NotNull
        public final String component1() {
            return this.clientId;
        }

        @NotNull
        public final EkoAccount component2() {
            return this.account;
        }

        @NotNull
        public final Mqtt3RxClient component3() {
            return this.mqttClient;
        }

        @NotNull
        public final AuthenticatedMqttClient copy(@NotNull String clientId, @NotNull EkoAccount account, @NotNull Mqtt3RxClient mqttClient) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)mqttClient, (String)"mqttClient");
            return new AuthenticatedMqttClient(clientId, account, mqttClient);
        }

        public static /* synthetic */ AuthenticatedMqttClient copy$default(AuthenticatedMqttClient authenticatedMqttClient, String string, EkoAccount ekoAccount, Mqtt3RxClient mqtt3RxClient, int n, Object object) {
            if ((n & 1) != 0) {
                string = authenticatedMqttClient.clientId;
            }
            if ((n & 2) != 0) {
                ekoAccount = authenticatedMqttClient.account;
            }
            if ((n & 4) != 0) {
                mqtt3RxClient = authenticatedMqttClient.mqttClient;
            }
            return authenticatedMqttClient.copy(string, ekoAccount, mqtt3RxClient);
        }

        @NotNull
        public String toString() {
            return "AuthenticatedMqttClient(clientId=" + this.clientId + ", account=" + this.account + ", mqttClient=" + this.mqttClient + ")";
        }

        public int hashCode() {
            String string = this.clientId;
            EkoAccount ekoAccount = this.account;
            Mqtt3RxClient mqtt3RxClient = this.mqttClient;
            return ((string != null ? string.hashCode() : 0) * 31 + (ekoAccount != null ? ekoAccount.hashCode() : 0)) * 31 + (mqtt3RxClient != null ? mqtt3RxClient.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AuthenticatedMqttClient)) break block3;
                    AuthenticatedMqttClient authenticatedMqttClient = (AuthenticatedMqttClient)object;
                    if (!Intrinsics.areEqual((Object)this.clientId, (Object)authenticatedMqttClient.clientId) || !Intrinsics.areEqual((Object)this.account, (Object)authenticatedMqttClient.account) || !Intrinsics.areEqual((Object)this.mqttClient, (Object)authenticatedMqttClient.mqttClient)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "activeClient", "Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$AuthenticatedMqttClient;", "subscriptions", "Lio/reactivex/disposables/CompositeDisposable;", "getCurrentClient", "Lio/reactivex/Single;", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "subscribe", "Lio/reactivex/Completable;", "mqttTopic", "Lcom/amity/socialcloud/sdk/core/events/AmityTopic;", "unsubscribe", "amity-sdk_release"})
    public static final class Companion {
        @NotNull
        public final String getTAG() {
            return TAG;
        }

        @NotNull
        public final Completable subscribe(@NotNull AmityTopic mqttTopic) {
            Intrinsics.checkNotNullParameter((Object)mqttTopic, (String)"mqttTopic");
            Completable completable = mqttTopic.generateTopic$amity_sdk_release().flatMapCompletable((Function)subscribe.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"mqttTopic.generateTopic(\u2026      }\n                }");
            return completable;
        }

        @NotNull
        public final Completable unsubscribe(@NotNull AmityTopic mqttTopic) {
            Intrinsics.checkNotNullParameter((Object)mqttTopic, (String)"mqttTopic");
            Completable completable = mqttTopic.generateTopic$amity_sdk_release().flatMapCompletable((Function)unsubscribe.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"mqttTopic.generateTopic(\u2026      }\n                }");
            return completable;
        }

        private final Single<Mqtt3RxClient> getCurrentClient() {
            Single single;
            Mqtt3RxClient client;
            AuthenticatedMqttClient authenticatedMqttClient = activeClient;
            Object object = client = authenticatedMqttClient != null ? authenticatedMqttClient.getMqttClient() : null;
            if (client == null) {
                AmityException exception = AmityException.Companion.create("Failed to subscribe", null, AmityError.UNKNOWN);
                Single single2 = Single.error((Throwable)exception);
                single = single2;
                Intrinsics.checkNotNullExpressionValue((Object)single2, (String)"Single.error(exception)");
            } else {
                Single single3 = Single.just((Object)client);
                single = single3;
                Intrinsics.checkNotNullExpressionValue((Object)single3, (String)"Single.just(client)");
            }
            return single;
        }

        private Companion() {
        }

        public static final /* synthetic */ Single access$getCurrentClient(Companion $this) {
            return $this.getCurrentClient();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

