/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.session.component;

import android.util.Log;
import com.amity.socialcloud.sdk.core.domain.session.GetCurrentAccountUseCase;
import com.amity.socialcloud.sdk.core.session.TokenVerifier;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenWatcherSessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0002J\b\u0010\u0018\u001a\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/amity/socialcloud/sdk/core/session/component/TokenWatcherSessionComponent;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "compositeDisposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "getCompositeDisposable", "()Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "setCompositeDisposable", "(Lio/reactivex/rxjava3/disposables/CompositeDisposable;)V", "checkAccessTokenExpiration", "", "destroy", "disposeSubscription", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "handleTokenExpire", "observeAppEvent", "observeSessionState", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "startTokenWatcherInterval", "amity-sdk_release"})
public final class TokenWatcherSessionComponent
extends SessionComponent {
    @NotNull
    private CompositeDisposable compositeDisposable;
    private final AppEventBus appEventBus;

    @NotNull
    public final CompositeDisposable getCompositeDisposable() {
        return this.compositeDisposable;
    }

    public final void setCompositeDisposable(@NotNull CompositeDisposable compositeDisposable) {
        Intrinsics.checkNotNullParameter((Object)compositeDisposable, (String)"<set-?>");
        this.compositeDisposable = compositeDisposable;
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.disposeSubscription();
        this.compositeDisposable = new CompositeDisposable();
        this.observeSessionState();
        this.observeAppEvent();
        this.startTokenWatcherInterval();
    }

    @Override
    public void destroy() {
        this.disposeSubscription();
    }

    @Override
    public void handleTokenExpire() {
        this.disposeSubscription();
    }

    private final void checkAccessTokenExpiration() {
        new GetCurrentAccountUseCase().execute().doOnSuccess((Consumer)new Consumer<EkoAccount>(this){
            final /* synthetic */ TokenWatcherSessionComponent this$0;

            public final void accept(EkoAccount it) {
                EkoAccount ekoAccount = it;
                Intrinsics.checkNotNullExpressionValue((Object)ekoAccount, (String)"it");
                TokenVerifier.Result tokenResult = TokenVerifier.Companion.checkExpiration(ekoAccount);
                Log.e((String)"SSM3", (String)("token verification result: " + (Object)((Object)tokenResult)));
                if (tokenResult == TokenVerifier.Result.ABOUT_TO_EXPIRE) {
                    TokenWatcherSessionComponent.access$getAppEventBus$p(this.this$0).publish(AppEvent.TokenAboutToExpire.INSTANCE);
                } else if (tokenResult == TokenVerifier.Result.EXPIRED) {
                    TokenWatcherSessionComponent.access$getAppEventBus$p(this.this$0).publish(AppEvent.TokenExpire.INSTANCE);
                }
            }
            {
                this.this$0 = tokenWatcherSessionComponent;
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    private final void observeSessionState() {
        Disposable sessionStateDisposable2 = this.getSessionStateEventBus().observe().doOnNext((Consumer)new Consumer<SessionState>(this){
            final /* synthetic */ TokenWatcherSessionComponent this$0;

            public final void accept(SessionState sessionState) {
                if (Intrinsics.areEqual((Object)sessionState, (Object)SessionState.Established.INSTANCE)) {
                    TokenWatcherSessionComponent.access$checkAccessTokenExpiration(this.this$0);
                }
            }
            {
                this.this$0 = tokenWatcherSessionComponent;
            }
        }).subscribeOn(Schedulers.io()).subscribe();
        this.compositeDisposable.add(sessionStateDisposable2);
    }

    private final void observeAppEvent() {
        Disposable appEventDisposable2 = this.appEventBus.observe().filter((Predicate)observeAppEvent.appEventDisposable.1.INSTANCE).doOnNext((Consumer)new Consumer<AppEvent>(this){
            final /* synthetic */ TokenWatcherSessionComponent this$0;

            public final void accept(AppEvent it) {
                TokenWatcherSessionComponent.access$checkAccessTokenExpiration(this.this$0);
            }
            {
                this.this$0 = tokenWatcherSessionComponent;
            }
        }).subscribeOn(Schedulers.io()).subscribe();
        this.compositeDisposable.add(appEventDisposable2);
    }

    private final void startTokenWatcherInterval() {
        Disposable tokenIntervalDisposable2 = Flowable.interval((long)1L, (TimeUnit)TimeUnit.MINUTES, (Scheduler)Schedulers.io()).doOnNext((Consumer)new Consumer<Long>(this){
            final /* synthetic */ TokenWatcherSessionComponent this$0;

            public final void accept(Long it) {
                TokenWatcherSessionComponent.access$checkAccessTokenExpiration(this.this$0);
            }
            {
                this.this$0 = tokenWatcherSessionComponent;
            }
        }).subscribe();
        this.compositeDisposable.add(tokenIntervalDisposable2);
    }

    private final void disposeSubscription() {
        this.compositeDisposable.dispose();
        this.compositeDisposable.clear();
    }

    public TokenWatcherSessionComponent(@NotNull AppEventBus appEventBus, @NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)appEventBus, (String)"appEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.appEventBus = appEventBus;
        this.compositeDisposable = new CompositeDisposable();
    }

    public static final /* synthetic */ AppEventBus access$getAppEventBus$p(TokenWatcherSessionComponent $this) {
        return $this.appEventBus;
    }

    public static final /* synthetic */ void access$checkAccessTokenExpiration(TokenWatcherSessionComponent $this) {
        $this.checkAccessTokenExpiration();
    }
}

