/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.social.feed.AmityFeedType;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityCategoryDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityMembershipDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoFeedDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoPollDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoCommentListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoCommunityCategoryListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoCommunityListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoCommunityMembershipListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoFeedListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoFileListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectMapper;
import com.ekoapp.ekosdk.internal.api.mapper.EkoPollPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoPostListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoStreamListPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoUserListPersister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\bf\u0018\u0000 \u00042\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0004\u00a8\u0006\u0005"}, d2={"Lcom/ekoapp/ekosdk/internal/api/mapper/EkoPostAndUserMapper;", "Lcom/ekoapp/ekosdk/internal/api/mapper/EkoObjectMapper;", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoPostQueryDto;", "", "Companion", "amity-sdk_release"})
public interface EkoPostAndUserMapper
extends EkoObjectMapper<EkoPostQueryDto, Object> {
    @NotNull
    public static final Companion Companion = com.ekoapp.ekosdk.internal.api.mapper.EkoPostAndUserMapper$Companion.$$INSTANCE;

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/ekoapp/ekosdk/internal/api/mapper/EkoPostAndUserMapper$Companion;", "", "()V", "MAPPER", "Lcom/ekoapp/ekosdk/internal/api/mapper/EkoPostAndUserMapper;", "getMAPPER", "()Lcom/ekoapp/ekosdk/internal/api/mapper/EkoPostAndUserMapper;", "mapPostDtoList", "", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoPostDto;", "postDtoList", "feedDtoList", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoFeedDto;", "amity-sdk_release"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final EkoPostAndUserMapper MAPPER;

        private Companion() {
        }

        @NotNull
        public final List<EkoPostDto> mapPostDtoList(@NotNull List<? extends EkoPostDto> postDtoList, @NotNull List<EkoFeedDto> feedDtoList) {
            Intrinsics.checkNotNullParameter(postDtoList, (String)"postDtoList");
            Intrinsics.checkNotNullParameter(feedDtoList, (String)"feedDtoList");
            List newItems = new ArrayList(postDtoList);
            Map feedDtoMap = new HashMap();
            for (EkoFeedDto feedDto : feedDtoList) {
                String string = feedDto.getFeedId();
                Intrinsics.checkNotNull((Object)string);
                feedDtoMap.put(string, feedDto);
            }
            for (EkoPostDto postDto : newItems) {
                String feedId = postDto.getFeedId();
                if (feedId != null && feedDtoMap.get(feedId) != null) {
                    Object v = feedDtoMap.get(feedId);
                    Intrinsics.checkNotNull(v);
                    postDto.setFeedType(((EkoFeedDto)v).getFeedType());
                    continue;
                }
                postDto.setFeedType(AmityFeedType.PUBLISHED.getApiKey());
            }
            return newItems;
        }

        @NotNull
        public final EkoPostAndUserMapper getMAPPER() {
            return MAPPER;
        }

        static {
            $$INSTANCE = new Companion();
            MAPPER = new EkoPostAndUserMapper(){

                public void map(@NotNull EkoPostQueryDto dto) {
                    Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                    EkoFileListPersister.persist(dto.getFiles());
                    List<EkoUserDto> list = dto.getUsers();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"dto.users");
                    EkoUserListPersister.persist(list);
                    List<EkoCommunityCategoryDto> list2 = dto.getCategories();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"dto.categories");
                    EkoCommunityCategoryListPersister.persist(list2);
                    List<EkoCommunityMembershipDto> list3 = dto.getCommunityUsers();
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"dto.communityUsers");
                    EkoCommunityMembershipListPersister.persist(list3);
                    List<EkoCommunityDto> list4 = dto.getCommunities();
                    Intrinsics.checkNotNullExpressionValue(list4, (String)"dto.communities");
                    EkoCommunityListPersister.persist(list4);
                    List<EkoCommentDto> list5 = dto.getComments();
                    Intrinsics.checkNotNullExpressionValue(list5, (String)"dto.comments");
                    EkoCommentListPersister.persist(list5);
                    List<EkoPostDto> list6 = dto.getChildren();
                    Intrinsics.checkNotNullExpressionValue(list6, (String)"dto.children");
                    List<EkoFeedDto> list7 = dto.getFeeds();
                    Intrinsics.checkNotNullExpressionValue(list7, (String)"dto.feeds");
                    List<EkoPostDto> postChildrenDto = com.ekoapp.ekosdk.internal.api.mapper.EkoPostAndUserMapper$Companion.$$INSTANCE.mapPostDtoList(list6, list7);
                    EkoPostListPersister.persist(postChildrenDto);
                    List<EkoPostDto> list8 = dto.getPosts();
                    Intrinsics.checkNotNullExpressionValue(list8, (String)"dto.posts");
                    List<EkoFeedDto> list9 = dto.getFeeds();
                    Intrinsics.checkNotNullExpressionValue(list9, (String)"dto.feeds");
                    List<EkoPostDto> postsDto = com.ekoapp.ekosdk.internal.api.mapper.EkoPostAndUserMapper$Companion.$$INSTANCE.mapPostDtoList(list8, list9);
                    EkoPostListPersister.persist(postsDto);
                    List<EkoFeedDto> list10 = dto.getFeeds();
                    Intrinsics.checkNotNullExpressionValue(list10, (String)"dto.feeds");
                    EkoFeedListPersister.persist(list10);
                    EkoStreamListPersister.INSTANCE.persist(dto.getStreams());
                    List<EkoPollDto> list11 = dto.getPolls();
                    Intrinsics.checkNotNullExpressionValue(list11, (String)"dto.polls");
                    EkoPollPersister.Companion.persist(list11);
                }
            };
        }
    }
}

