/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.comment.helper;

import androidx.arch.core.util.Function;
import androidx.paging.DataSource;
import com.amity.socialcloud.sdk.social.comment.AmityComment;
import com.amity.socialcloud.sdk.social.comment.AmityCommentSortOption;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentDao;
import com.ekoapp.ekosdk.internal.entity.CommentEntity;
import com.ekoapp.ekosdk.internal.repository.comment.helper.CommentComposerFunction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JM\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010JK\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010JM\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/comment/helper/EkoCommentFactory;", "", "()V", "getCommentsFactory", "Landroidx/paging/DataSource$Factory;", "", "Lcom/ekoapp/ekosdk/internal/entity/CommentEntity;", "referenceId", "", "referenceType", "isFilterByParentId", "", "parentId", "isDeleted", "sortOption", "Lcom/amity/socialcloud/sdk/social/comment/AmityCommentSortOption;", "(Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/social/comment/AmityCommentSortOption;)Landroidx/paging/DataSource$Factory;", "getFactory", "Lcom/amity/socialcloud/sdk/social/comment/AmityComment;", "getFactoryEntity", "amity-sdk_release"})
public final class EkoCommentFactory {
    @NotNull
    public final DataSource.Factory<Integer, AmityComment> getFactory(@NotNull String referenceId, @NotNull String referenceType, boolean isFilterByParentId, @Nullable String parentId, @Nullable Boolean isDeleted, @NotNull AmityCommentSortOption sortOption) {
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)referenceType, (String)"referenceType");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        return this.getFactoryEntity(referenceId, referenceType, isFilterByParentId, parentId, isDeleted, sortOption).map((Function)new CommentComposerFunction());
    }

    private final DataSource.Factory<Integer, CommentEntity> getFactoryEntity(String referenceId, String referenceType, boolean isFilterByParentId, String parentId, Boolean isDeleted, AmityCommentSortOption sortOption) {
        return this.getCommentsFactory(referenceId, referenceType, isFilterByParentId, parentId, isDeleted, sortOption);
    }

    private final DataSource.Factory<Integer, CommentEntity> getCommentsFactory(String referenceId, String referenceType, boolean isFilterByParentId, String parentId, Boolean isDeleted, AmityCommentSortOption sortOption) {
        DataSource.Factory<Integer, CommentEntity> factory2;
        EkoCommentDao commentDao = UserDatabase.get().commentDao();
        if (isFilterByParentId) {
            DataSource.Factory<Integer, CommentEntity> factory3 = commentDao.getAllByParentId(referenceType, referenceId, parentId, isDeleted, sortOption);
            factory2 = factory3;
            Intrinsics.checkNotNullExpressionValue(factory3, (String)"{\n            commentDao\u2026ed, sortOption)\n        }");
        } else {
            DataSource.Factory<Integer, CommentEntity> factory4 = commentDao.getAll(referenceType, referenceId, isDeleted, sortOption);
            factory2 = factory4;
            Intrinsics.checkNotNullExpressionValue(factory4, (String)"{\n            commentDao\u2026ed, sortOption)\n        }");
        }
        return factory2;
    }
}

