/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.Entity;
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.ekoapp.ekosdk.EkoObject;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.joda.time.DateTime;

@Entity(tableName="reaction", primaryKeys={"userId", "reactionName", "referenceType", "referenceId"})
public class EkoReactionEntity
extends EkoObject {
    public static final String REACTION_PREFIX = "!";
    private String reactionId;
    @NonNull
    private String reactionName;
    @NonNull
    private String userId;
    private String userDisplayName;
    @NonNull
    private String referenceId;
    @NonNull
    private String referenceType;

    public EkoReactionEntity() {
    }

    public EkoReactionEntity(String reactionId, @NonNull String referenceType, @NonNull String referenceId, @NonNull String reactionName, @NonNull String userId, String userDisplayName, DateTime createdTime, DateTime updatedTime) {
        this.reactionId = reactionId;
        this.referenceType = referenceType;
        this.referenceId = referenceId;
        this.reactionName = reactionName;
        this.userId = userId;
        this.userDisplayName = userDisplayName;
        this.setCreatedAt(createdTime);
        this.setUpdatedAt(updatedTime);
    }

    @Override
    public String getId() {
        return this.referenceType + this.referenceId + this.reactionName + this.userId;
    }

    @NonNull
    public String getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(@NonNull ReactionReferenceType referenceType) {
        this.referenceType = referenceType.getValue();
    }

    public void setReferenceType(@NonNull String referenceType) {
        this.referenceType = referenceType;
    }

    @NonNull
    public String getReactionId() {
        return this.reactionId;
    }

    public void setReactionId(String reactionId) {
        this.reactionId = reactionId;
    }

    @NonNull
    public String getReactionName() {
        return this.reactionName;
    }

    public void setReactionName(@NonNull String reactionName) {
        this.reactionName = reactionName;
    }

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = userId;
    }

    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    @NonNull
    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(@NonNull String referenceId) {
        this.referenceId = referenceId;
    }

    public static EkoReactionEntity createReaction(@NonNull String reactionId, @NonNull ReactionReferenceType referenceType, @NonNull String referenceId, @NonNull String reactionName, @NonNull String userId, @Nullable String userDisplayName, @Nullable DateTime createdAt, @Nullable DateTime updatedAt) {
        return EkoReactionEntity.create(reactionId, referenceType, referenceId, reactionName, userId, userDisplayName, createdAt, updatedAt);
    }

    public static EkoReactionEntity create(@NonNull String reactionId, @NonNull ReactionReferenceType referenceType, @NonNull String referenceId, @NonNull String reactionName, @NonNull String userId, String userDisplayName, DateTime createdAt, DateTime updatedAt) {
        return new EkoReactionEntity(reactionId, referenceType.getValue(), referenceId, reactionName, userId, userDisplayName, createdAt, updatedAt);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        EkoReactionEntity other = (EkoReactionEntity)obj;
        return Objects.equal((Object)this.referenceType, (Object)other.referenceType) && Objects.equal((Object)this.referenceId, (Object)other.referenceId) && Objects.equal((Object)this.reactionName, (Object)other.reactionName) && Objects.equal((Object)this.userId, (Object)other.userId) && Objects.equal((Object)this.userDisplayName, (Object)other.userDisplayName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.referenceType, this.referenceId, this.reactionName, this.userId, this.userDisplayName});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("referenceType", (Object)this.referenceType).add("referenceId", (Object)this.referenceId).add("reactionName", (Object)this.reactionName).add("userId", (Object)this.userId).add("userDisplayName", (Object)this.userDisplayName).toString();
    }
}

