/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.boundarycallback;

import androidx.arch.core.util.Function;
import androidx.core.util.Pair;
import androidx.paging.PagedList;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.video.stream.AmityStream;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.dto.EkoStreamDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoStreamQueryDto;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.StreamQueryConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.StreamQueryRequest;
import com.github.davidmoten.rx2.RetryWhen;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.Subject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 .2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0004:\u0001.B1\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0007H\u0002J\b\u0010&\u001a\u00020$H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)H\u0016J\u0006\u0010*\u001a\u00020$J\u0010\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020-H\u0016R\u0016\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0011R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015R(\u0010\u0017\u001a\u001c\u0012\u0004\u0012\u00020\u0007\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0004\u0012\u00020\t0\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u001a\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00070\u0007 \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/ekoapp/ekosdk/internal/data/boundarycallback/EkoStreamBoundaryCallback;", "Landroidx/paging/PagedList$BoundaryCallback;", "Lcom/amity/socialcloud/sdk/video/stream/AmityStream;", "Lio/reactivex/CompletableObserver;", "Landroidx/arch/core/util/Function;", "statuses", "", "", "isReconnecting", "", "pageSize", "", "delaySubject", "Lio/reactivex/subjects/Subject;", "([Ljava/lang/String;ZILio/reactivex/subjects/Subject;)V", "TAG", "kotlin.jvm.PlatformType", "()Z", "getPageSize", "()I", "getStatuses", "()[Ljava/lang/String;", "[Ljava/lang/String;", "streamIdAndTokenMap", "", "Landroidx/core/util/Pair;", "streamIdSet", "", "", "apply", "input", "call", "Lio/reactivex/Completable;", "options", "Lcom/ekoapp/ekosdk/internal/api/socket/request/StreamQueryRequest$StreamQueryOptions;", "mapByStream", "", "userId", "onComplete", "onError", "e", "", "onFirstLoaded", "onSubscribe", "d", "Lio/reactivex/disposables/Disposable;", "Companion", "amity-sdk_release"})
public final class EkoStreamBoundaryCallback
extends PagedList.BoundaryCallback<AmityStream>
implements CompletableObserver,
Function<AmityStream, AmityStream> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] statuses;
    private final boolean isReconnecting;
    private final int pageSize;
    @NotNull
    private final Subject<Boolean> delaySubject;
    private final String TAG;
    @NotNull
    private final Map<String, Pair<String, Boolean>> streamIdAndTokenMap;
    private final Set<String> streamIdSet;
    @NotNull
    private static final Executor SINGLE_THREAD_EXECUTOR;

    public EkoStreamBoundaryCallback(@NotNull String[] statuses, boolean isReconnecting, int pageSize, @NotNull Subject<Boolean> delaySubject) {
        Intrinsics.checkNotNullParameter((Object)statuses, (String)"statuses");
        Intrinsics.checkNotNullParameter(delaySubject, (String)"delaySubject");
        this.statuses = statuses;
        this.isReconnecting = isReconnecting;
        this.pageSize = pageSize;
        this.delaySubject = delaySubject;
        this.TAG = ((Object)((Object)this)).getClass().getName();
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"newConcurrentMap()");
        this.streamIdAndTokenMap = concurrentMap;
        this.streamIdSet = Sets.newConcurrentHashSet();
        this.onFirstLoaded();
    }

    @NotNull
    public final String[] getStatuses() {
        return this.statuses;
    }

    public final boolean isReconnecting() {
        return this.isReconnecting;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public void onSubscribe(@NotNull Disposable d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
    }

    public void onComplete() {
    }

    public void onError(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public final void onFirstLoaded() {
        StreamQueryRequest.StreamQueryOptions options = new StreamQueryRequest.StreamQueryOptions(this.pageSize, null, 2, null);
        this.call(options).doOnComplete(() -> EkoStreamBoundaryCallback.onFirstLoaded$lambda-0(this)).doOnError(arg_0 -> EkoStreamBoundaryCallback.onFirstLoaded$lambda-1(this, arg_0)).subscribeOn(Schedulers.from((Executor)SINGLE_THREAD_EXECUTOR)).subscribe((CompletableObserver)this);
    }

    @NotNull
    public AmityStream apply(@NotNull AmityStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.streamIdSet.add(input.getStreamId());
        this.mapByStream(input.getStreamId());
        return input;
    }

    private final void mapByStream(String userId) {
        block1: {
            Pair<String, Boolean> pair = this.streamIdAndTokenMap.get(userId);
            if (pair == null) break block1;
            Pair<String, Boolean> tokenAndStatusNonNull = pair;
            boolean bl = false;
            CharSequence charSequence = (CharSequence)tokenAndStatusNonNull.first;
            if (charSequence == null || charSequence.length() == 0 || Intrinsics.areEqual((Object)tokenAndStatusNonNull.second, (Object)true)) {
                return;
            }
            StreamQueryRequest.StreamQueryOptions options = new StreamQueryRequest.StreamQueryOptions(null, null, 3, null);
            options.setToken((String)tokenAndStatusNonNull.first);
            String string = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            AmityLog.INSTANCE.tag(string).i("map userId:" + userId, new Object[0]);
            this.call(options).doOnSubscribe(arg_0 -> EkoStreamBoundaryCallback.mapByStream$lambda-4$lambda-2(this, userId, tokenAndStatusNonNull, arg_0)).doOnError(arg_0 -> EkoStreamBoundaryCallback.mapByStream$lambda-4$lambda-3(this, userId, tokenAndStatusNonNull, arg_0)).subscribeOn(Schedulers.from((Executor)SINGLE_THREAD_EXECUTOR)).subscribe((CompletableObserver)this);
        }
    }

    private final Completable call(StreamQueryRequest.StreamQueryOptions options) {
        StreamQueryRequest request = new StreamQueryRequest(ArraysKt.toList((Object[])this.statuses), false, options);
        Call call = Call.create(request, new StreamQueryConverter());
        Intrinsics.checkNotNullExpressionValue(call, (String)"create(request, StreamQueryConverter())");
        Completable completable = EkoSocket.Companion.call(call).doOnSuccess(arg_0 -> EkoStreamBoundaryCallback.call$lambda-5(this, arg_0)).retryWhen(RetryWhen.maxRetries((int)3).exponentialBackoff(1L, 10L, TimeUnit.SECONDS, 1.5).action(arg_0 -> EkoStreamBoundaryCallback.call$lambda-6(this, arg_0)).build()).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    private static final void onFirstLoaded$lambda-0(EkoStreamBoundaryCallback this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.delaySubject.onComplete();
    }

    private static final void onFirstLoaded$lambda-1(EkoStreamBoundaryCallback this$0, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.delaySubject.onComplete();
    }

    private static final void mapByStream$lambda-4$lambda-2(EkoStreamBoundaryCallback this$0, String $userId, Pair $tokenAndStatusNonNull, Disposable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        Intrinsics.checkNotNullParameter((Object)$tokenAndStatusNonNull, (String)"$tokenAndStatusNonNull");
        this$0.streamIdAndTokenMap.put($userId, (Pair<String, Boolean>)new Pair($tokenAndStatusNonNull.first, (Object)true));
    }

    private static final void mapByStream$lambda-4$lambda-3(EkoStreamBoundaryCallback this$0, String $userId, Pair $tokenAndStatusNonNull, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$userId, (String)"$userId");
        Intrinsics.checkNotNullParameter((Object)$tokenAndStatusNonNull, (String)"$tokenAndStatusNonNull");
        this$0.streamIdAndTokenMap.put($userId, (Pair<String, Boolean>)new Pair($tokenAndStatusNonNull.first, (Object)false));
    }

    private static final void call$lambda-5(EkoStreamBoundaryCallback this$0, EkoStreamQueryDto dto) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
        List<EkoStreamDto> streams = dto.getResult().getStreams();
        Collection collection = streams;
        if (!(collection == null || collection.isEmpty())) {
            EkoStreamDto stream = streams.get(streams.size() - 1);
            Map<String, Pair<String, Boolean>> map = this$0.streamIdAndTokenMap;
            String string = stream.getStreamId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stream.streamId");
            String string2 = string;
            String string3 = dto.getToken().getNext();
            if (string3 == null) {
                string3 = "";
            }
            Pair pair = Pair.create((Object)string3, (Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(dto.token.next ?: \"\", false)");
            Pair pair2 = pair;
            map.put(string2, (Pair<String, Boolean>)pair2);
            if (this$0.streamIdSet.contains(stream.getStreamId())) {
                String string4 = stream.getStreamId();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"stream.streamId");
                this$0.mapByStream(string4);
            }
        }
    }

    private static final void call$lambda-6(EkoStreamBoundaryCallback this$0, RetryWhen.ErrorAndDuration errorAndDuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)errorAndDuration, (String)"errorAndDuration");
        String string = this$0.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        Object[] objectArray = new Object[]{errorAndDuration.durationMs()};
        AmityLog.INSTANCE.tag(string).e(errorAndDuration.throwable(), "an error occurred, back-off for durationMs:%s", objectArray);
    }

    static {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        SINGLE_THREAD_EXECUTOR = executorService;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ekoapp/ekosdk/internal/data/boundarycallback/EkoStreamBoundaryCallback$Companion;", "", "()V", "SINGLE_THREAD_EXECUTOR", "Ljava/util/concurrent/Executor;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

