/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.post;

import com.amity.socialcloud.sdk.core.reaction.AmityPostReactionQuery;
import com.amity.socialcloud.sdk.social.AmitySocialClient;
import com.amity.socialcloud.sdk.social.comment.AmityCommentQuery;
import com.amity.socialcloud.sdk.social.domain.post.getbyids.PostGetByIdsUseCase;
import com.amity.socialcloud.sdk.social.feed.AmityPost;
import com.amity.socialcloud.sdk.social.feed.AmityPostCreateTargetSelector;
import com.amity.socialcloud.sdk.social.post.AmityPostQueryTargetSelector;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.feed.review.AmityPostReviewer;
import com.ekoapp.ekosdk.internal.usecase.post.PostDeleteUseCase;
import com.ekoapp.ekosdk.internal.usecase.post.PostLiveObjectUseCase;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\bJ \u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00110\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u001a"}, d2={"Lcom/amity/socialcloud/sdk/social/post/AmityPostRepository;", "", "()V", "createPost", "Lcom/amity/socialcloud/sdk/social/feed/AmityPostCreateTargetSelector;", "deletePost", "Lio/reactivex/Completable;", "postId", "", "hardDelete", "", "getComments", "Lcom/amity/socialcloud/sdk/social/comment/AmityCommentQuery$Builder;", "getPost", "Lio/reactivex/Flowable;", "Lcom/amity/socialcloud/sdk/social/feed/AmityPost;", "getPostByIds", "", "postIds", "", "getPosts", "Lcom/amity/socialcloud/sdk/social/post/AmityPostQueryTargetSelector;", "getReactions", "Lcom/amity/socialcloud/sdk/core/reaction/AmityPostReactionQuery$Builder;", "reviewPost", "Lcom/ekoapp/ekosdk/feed/review/AmityPostReviewer;", "amity-sdk_release"})
public final class AmityPostRepository {
    @NotNull
    public final Flowable<AmityPost> getPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return RxJava3BridgeExtensionsKt.toV2(new PostLiveObjectUseCase().execute(postId));
    }

    @NotNull
    public final AmityPostQueryTargetSelector getPosts() {
        return new AmityPostQueryTargetSelector();
    }

    @NotNull
    public final AmityPostCreateTargetSelector createPost() {
        return new AmityPostCreateTargetSelector();
    }

    @NotNull
    public final Completable deletePost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return this.deletePost(postId, false);
    }

    @NotNull
    public final Completable deletePost(@NotNull String postId, boolean hardDelete) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return RxJava3BridgeExtensionsKt.toV2(new PostDeleteUseCase().execute(postId, hardDelete));
    }

    @NotNull
    public final AmityPostReviewer reviewPost(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new AmityPostReviewer(postId);
    }

    @NotNull
    public final AmityPostReactionQuery.Builder getReactions(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return new AmityPostReactionQuery.Builder(postId);
    }

    @NotNull
    public final AmityCommentQuery.Builder getComments(@NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        return AmitySocialClient.INSTANCE.newCommentRepository().getComments().post(postId);
    }

    @NotNull
    public final Flowable<List<AmityPost>> getPostByIds(@NotNull Set<String> postIds) {
        Intrinsics.checkNotNullParameter(postIds, (String)"postIds");
        return RxJava3BridgeExtensionsKt.toV2(new PostGetByIdsUseCase().execute(postIds));
    }
}

