/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.AmityEndpoint;
import com.amity.socialcloud.sdk.core.AmityConnectionState;
import com.amity.socialcloud.sdk.core.AmityGlobalBanEvent;
import com.amity.socialcloud.sdk.core.authen.UserRegistration;
import com.amity.socialcloud.sdk.core.domain.notification.RegisterDeviceForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.notification.UnregisterAllUsersForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.notification.UnregisterDeviceForNotificationUseCase;
import com.amity.socialcloud.sdk.core.domain.session.ActiveUserIdGetUseCase;
import com.amity.socialcloud.sdk.core.domain.session.LogoutUseCase;
import com.amity.socialcloud.sdk.core.events.AmityTopic;
import com.amity.socialcloud.sdk.core.events.AmityTopicSubscription;
import com.amity.socialcloud.sdk.core.file.AmityFileRepository;
import com.amity.socialcloud.sdk.core.permission.AmityPermission;
import com.amity.socialcloud.sdk.core.permission.AmityPermissionValidator;
import com.amity.socialcloud.sdk.core.session.SessionError;
import com.amity.socialcloud.sdk.core.session.SessionHandler;
import com.amity.socialcloud.sdk.core.session.SessionStateManager;
import com.amity.socialcloud.sdk.core.session.component.DatabaseSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenRenewalSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.TokenWatcherSessionComponent;
import com.amity.socialcloud.sdk.core.session.component.UserSettingSessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.AppEvent;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.core.user.AmityUser;
import com.amity.socialcloud.sdk.core.user.AmityUserNotification;
import com.amity.socialcloud.sdk.core.user.AmityUserRepository;
import com.amity.socialcloud.sdk.core.user.AmityUserUpdate;
import com.amity.socialcloud.sdk.infra.mqtt.AmityMqttClient;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.streamapi.AmityClientConfiguration;
import com.amity.socialcloud.sdk.streamapi.StreamFunctionInterface;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.AmityContentCheck;
import com.ekoapp.ekosdk.StreamFunction;
import com.ekoapp.ekosdk.internal.api.EkoApi;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoApiKeyDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoHttpUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMqttUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoSocketUrlDao;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoMqttUrl;
import com.ekoapp.ekosdk.internal.data.model.EkoSocketUrl;
import com.ekoapp.ekosdk.internal.init.AmityCoreSDKInitializer;
import com.ekoapp.ekosdk.internal.init.EkoSdkInitProvider;
import com.ekoapp.ekosdk.internal.usecase.content.GetContentCheckUseCase;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.Objects;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Single;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Function4;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.CompletableSubject;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0004J\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0007J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0$J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0$J\r\u0010-\u001a\u00020.H\u0000\u00a2\u0006\u0002\b/J\u0006\u00100\u001a\u00020\u0004J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0004H\u0007J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00042\b\u00108\u001a\u0004\u0018\u000109J\u0006\u0010:\u001a\u00020\u001fJ\u0006\u0010;\u001a\u00020<J\u0006\u0010=\u001a\u00020>J\u0006\u0010?\u001a\u00020@J\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\t0$J\u0006\u0010B\u001a\u00020\u001fJ\u000e\u0010C\u001a\u00020\u001f2\u0006\u0010D\u001a\u00020\u0004J\u0016\u0010C\u001a\u00020\u001f2\u0006\u0010D\u001a\u00020\u00042\u0006\u0010E\u001a\u00020FJ \u0010C\u001a\u00020\u001f2\u0006\u0010D\u001a\u00020\u00042\u0006\u0010G\u001a\u00020\u00042\u0006\u0010H\u001a\u00020\u0004H\u0007J\b\u0010I\u001a\u00020JH\u0002J\u000e\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NJ\u0006\u0010O\u001a\u00020\u001fJ\u000e\u0010O\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u0004J\u0006\u0010P\u001a\u00020QR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lcom/amity/socialcloud/sdk/AmityCoreClient;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "appEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/AppEventBus;", "currentSessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "getCurrentSessionState", "()Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "millisTimeDiff", "", "getMillisTimeDiff$amity_sdk_release", "()I", "setMillisTimeDiff$amity_sdk_release", "(I)V", "mqttClient", "Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient;", "renewalManager", "Lcom/amity/socialcloud/sdk/core/session/component/TokenRenewalSessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "sessionStateManager", "Lcom/amity/socialcloud/sdk/core/session/SessionStateManager;", "socketClient", "Lcom/ekoapp/ekosdk/internal/api/EkoSocket;", "disconnect", "Lio/reactivex/Completable;", "getAmityCoreSdkVersion", "getConfiguration", "Lcom/amity/socialcloud/sdk/streamapi/AmityClientConfiguration;", "getConnectionState", "Lio/reactivex/Flowable;", "Lcom/amity/socialcloud/sdk/core/AmityConnectionState;", "getContentCheck", "Lio/reactivex/Single;", "Lcom/ekoapp/ekosdk/AmityContentCheck;", "getCurrentUser", "Lcom/amity/socialcloud/sdk/core/user/AmityUser;", "getGlobalBanEvents", "Lcom/amity/socialcloud/sdk/core/AmityGlobalBanEvent;", "getServerTime", "Lorg/joda/time/DateTime;", "getServerTime$amity_sdk_release", "getUserId", "hasPermission", "Lcom/amity/socialcloud/sdk/core/permission/AmityPermissionValidator;", "permission", "Lcom/amity/socialcloud/sdk/core/permission/AmityPermission;", "login", "Lcom/amity/socialcloud/sdk/core/authen/UserRegistration$Builder;", "userId", "sessionHandler", "Lcom/amity/socialcloud/sdk/core/session/SessionHandler;", "logout", "newFileRepository", "Lcom/amity/socialcloud/sdk/core/file/AmityFileRepository;", "newUserRepository", "Lcom/amity/socialcloud/sdk/core/user/AmityUserRepository;", "notification", "Lcom/amity/socialcloud/sdk/core/user/AmityUserNotification;", "observeSessionState", "registerDeviceForPushNotification", "setup", "apiKey", "endpoint", "Lcom/amity/socialcloud/sdk/AmityEndpoint;", "httpEndpoint", "socketEndpoint", "setupSessionComponents", "", "subscription", "Lcom/amity/socialcloud/sdk/core/events/AmityTopicSubscription;", "topic", "Lcom/amity/socialcloud/sdk/core/events/AmityTopic;", "unregisterDeviceForPushNotification", "updateUser", "Lcom/amity/socialcloud/sdk/core/user/AmityUserUpdate$Builder;", "amity-sdk_release"})
public final class AmityCoreClient {
    private static final String TAG;
    private static int millisTimeDiff;
    private static AmityMqttClient mqttClient;
    private static EkoSocket socketClient;
    private static TokenRenewalSessionComponent renewalManager;
    private static final SessionLifeCycleEventBus sessionLifeCycleEventBus;
    private static final AppEventBus appEventBus;
    private static final SessionStateEventBus sessionStateEventBus;
    private static final SessionStateManager sessionStateManager;
    @NotNull
    public static final AmityCoreClient INSTANCE;

    public final int getMillisTimeDiff$amity_sdk_release() {
        return millisTimeDiff;
    }

    public final void setMillisTimeDiff$amity_sdk_release(int n) {
        millisTimeDiff = n;
    }

    @NotNull
    public final DateTime getServerTime$amity_sdk_release() {
        DateTime dateTime = DateTime.now().plusMillis(millisTimeDiff);
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"DateTime.now().plusMillis(millisTimeDiff)");
        return dateTime;
    }

    @NotNull
    public final SessionState getCurrentSessionState() {
        return sessionStateManager.getSessionState();
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey, @NotNull AmityEndpoint endpoint) {
        EkoApiKeyDao apiKeyDao;
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        if (!EkoSdkInitProvider.Companion.isInitialized()) {
            Completable completable = Completable.never();
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"Completable.never()");
            return completable;
        }
        EkoPreconditions.checkValidId(apiKey, "apiKey");
        CompletableSubject completableSubject = CompletableSubject.create();
        Intrinsics.checkNotNullExpressionValue((Object)completableSubject, (String)"CompletableSubject.create()");
        CompletableSubject result = completableSubject;
        EkoDatabase database = EkoDatabase.get();
        EkoHttpUrlDao httpUrlDao = database.httpUrlDao();
        EkoSocketUrlDao socketUrlDao = database.socketUrlDao();
        EkoMqttUrlDao mqttUrlDao = database.mqttUrlDao();
        String newHttpUrl = endpoint.getHttpEndpoint();
        String newSocketUrl = endpoint.getSocketEndpoint();
        String newMqttUrl = endpoint.getMqttEndpoint();
        EkoApiKeyDao ekoApiKeyDao = apiKeyDao = EkoDatabase.get().apiKeyDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoApiKeyDao, (String)"apiKeyDao");
        MaybeSource maybeSource = (MaybeSource)ekoApiKeyDao.getCurrentApiKey();
        EkoHttpUrlDao ekoHttpUrlDao = httpUrlDao;
        Intrinsics.checkNotNullExpressionValue((Object)ekoHttpUrlDao, (String)"httpUrlDao");
        MaybeSource maybeSource2 = (MaybeSource)ekoHttpUrlDao.getCurrentHttpUrl();
        EkoSocketUrlDao ekoSocketUrlDao = socketUrlDao;
        Intrinsics.checkNotNullExpressionValue((Object)ekoSocketUrlDao, (String)"socketUrlDao");
        MaybeSource maybeSource3 = (MaybeSource)ekoSocketUrlDao.getCurrentSocketUrl();
        EkoMqttUrlDao ekoMqttUrlDao = mqttUrlDao;
        Intrinsics.checkNotNullExpressionValue((Object)ekoMqttUrlDao, (String)"mqttUrlDao");
        Maybe.zip((MaybeSource)maybeSource, (MaybeSource)maybeSource2, (MaybeSource)maybeSource3, (MaybeSource)((MaybeSource)ekoMqttUrlDao.getCurrentMqttUrl()), (Function4)setup.1.INSTANCE).subscribeOn(Schedulers.io()).doOnSuccess((Consumer)new Consumer<Pair<? extends EkoApiKey, ? extends AmityEndpoint.CUSTOM>>(newHttpUrl, newSocketUrl, newMqttUrl, apiKey, httpUrlDao, socketUrlDao, mqttUrlDao, apiKeyDao){
            final /* synthetic */ String $newHttpUrl;
            final /* synthetic */ String $newSocketUrl;
            final /* synthetic */ String $newMqttUrl;
            final /* synthetic */ String $apiKey;
            final /* synthetic */ EkoHttpUrlDao $httpUrlDao;
            final /* synthetic */ EkoSocketUrlDao $socketUrlDao;
            final /* synthetic */ EkoMqttUrlDao $mqttUrlDao;
            final /* synthetic */ EkoApiKeyDao $apiKeyDao;

            public final void accept(@NotNull Pair<? extends EkoApiKey, ? extends AmityEndpoint> setupPair) {
                Intrinsics.checkNotNullParameter(setupPair, (String)"setupPair");
                String string = ((EkoApiKey)setupPair.getFirst()).getApiKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"setupPair.first.apiKey");
                String storedApiKey = string;
                String storedHttpUrl = ((AmityEndpoint)setupPair.getSecond()).getHttpEndpoint();
                String storedSocketUrl = ((AmityEndpoint)setupPair.getSecond()).getSocketEndpoint();
                String storedMqttUrl = ((AmityEndpoint)setupPair.getSecond()).getMqttEndpoint();
                if (!(Objects.equal((Object)storedHttpUrl, (Object)this.$newHttpUrl) && Objects.equal((Object)storedSocketUrl, (Object)this.$newSocketUrl) && Objects.equal((Object)storedMqttUrl, (Object)this.$newMqttUrl) && Objects.equal((Object)storedApiKey, (Object)this.$apiKey))) {
                    String string2 = AmityCoreClient.access$getTAG$p(AmityCoreClient.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
                    AmityLog.INSTANCE.tag(string2).e("Setup value changed. new api key: %s new http url: %s new socket url: %s new mqtt url: %s", new Object[]{this.$apiKey, this.$newHttpUrl, this.$newSocketUrl, this.$newMqttUrl});
                    String string3 = AmityCoreClient.access$getTAG$p(AmityCoreClient.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
                    AmityLog.INSTANCE.tag(string3).e("deleting user database", new Object[0]);
                    AmityCoreClient.INSTANCE.logout();
                    this.$httpUrlDao.insert(EkoHttpUrl.create(this.$newHttpUrl));
                    this.$socketUrlDao.insert(EkoSocketUrl.create(this.$newSocketUrl));
                    this.$mqttUrlDao.insert(EkoMqttUrl.create(this.$newMqttUrl));
                    this.$apiKeyDao.insert(EkoApiKey.create(this.$apiKey));
                }
                AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
            }
            {
                this.$newHttpUrl = string;
                this.$newSocketUrl = string2;
                this.$newMqttUrl = string3;
                this.$apiKey = string4;
                this.$httpUrlDao = ekoHttpUrlDao;
                this.$socketUrlDao = ekoSocketUrlDao;
                this.$mqttUrlDao = ekoMqttUrlDao;
                this.$apiKeyDao = ekoApiKeyDao;
            }
        }).doOnComplete(new Action(httpUrlDao, newHttpUrl, socketUrlDao, newSocketUrl, mqttUrlDao, newMqttUrl, apiKeyDao, apiKey){
            final /* synthetic */ EkoHttpUrlDao $httpUrlDao;
            final /* synthetic */ String $newHttpUrl;
            final /* synthetic */ EkoSocketUrlDao $socketUrlDao;
            final /* synthetic */ String $newSocketUrl;
            final /* synthetic */ EkoMqttUrlDao $mqttUrlDao;
            final /* synthetic */ String $newMqttUrl;
            final /* synthetic */ EkoApiKeyDao $apiKeyDao;
            final /* synthetic */ String $apiKey;

            public final void run() {
                this.$httpUrlDao.insert(EkoHttpUrl.create(this.$newHttpUrl));
                this.$socketUrlDao.insert(EkoSocketUrl.create(this.$newSocketUrl));
                this.$mqttUrlDao.insert(EkoMqttUrl.create(this.$newMqttUrl));
                this.$apiKeyDao.insert(EkoApiKey.create(this.$apiKey));
                AmityCoreSDKInitializer.INSTANCE.initApiService$amity_sdk_release();
            }
            {
                this.$httpUrlDao = ekoHttpUrlDao;
                this.$newHttpUrl = string;
                this.$socketUrlDao = ekoSocketUrlDao;
                this.$newSocketUrl = string2;
                this.$mqttUrlDao = ekoMqttUrlDao;
                this.$newMqttUrl = string3;
                this.$apiKeyDao = ekoApiKeyDao;
                this.$apiKey = string4;
            }
        }).flatMapCompletable((Function)setup.4.INSTANCE).subscribe((CompletableObserver)result);
        this.setupSessionComponents();
        Completable completable = result.hide();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"result.hide()");
        return completable;
    }

    /*
     * Unable to fully structure code
     */
    @Deprecated(message="please use setup(apiKey: String, endpoint: AmityEndpoint) instead")
    @NotNull
    public final Completable setup(@NotNull String apiKey, @NotNull String httpEndpoint, @NotNull String socketEndpoint) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Intrinsics.checkNotNullParameter((Object)httpEndpoint, (String)"httpEndpoint");
            Intrinsics.checkNotNullParameter((Object)socketEndpoint, (String)"socketEndpoint");
            var5_4 = httpEndpoint;
            switch (var5_4.hashCode()) {
                case 2126050090: {
                    if (!var5_4.equals("https://api.us.amity.co/")) ** break;
                    break;
                }
                case 761791164: {
                    if (!var5_4.equals("https://api.eu.amity.co/")) ** break;
                    v0 = "ssq.eu.amity.co";
                    break block4;
                }
            }
            v0 = "ssq.us.amity.co";
            break block4;
            v0 = "ssq.sg.amity.co";
        }
        mqttEndpoint = v0;
        return this.setup(apiKey, new AmityEndpoint.CUSTOM(httpEndpoint, socketEndpoint, mqttEndpoint));
    }

    @NotNull
    public final Completable setup(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        return this.setup(apiKey, AmityEndpoint.SG.INSTANCE);
    }

    @NotNull
    public final Completable registerDeviceForPushNotification() {
        return RxJava3BridgeExtensionsKt.toV2(new RegisterDeviceForNotificationUseCase().execute());
    }

    @NotNull
    public final Completable unregisterDeviceForPushNotification() {
        return RxJava3BridgeExtensionsKt.toV2(new UnregisterAllUsersForNotificationUseCase().execute());
    }

    @NotNull
    public final Completable unregisterDeviceForPushNotification(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return RxJava3BridgeExtensionsKt.toV2(new UnregisterDeviceForNotificationUseCase().execute(userId));
    }

    @NotNull
    public final Completable disconnect() {
        Completable completable;
        if (mqttClient == null || socketClient == null) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"Completable.complete()");
        } else {
            EkoSocket ekoSocket = socketClient;
            if (ekoSocket != null) {
                ekoSocket.disconnect();
            }
            AmityMqttClient amityMqttClient = mqttClient;
            Intrinsics.checkNotNull((Object)amityMqttClient);
            completable = amityMqttClient.disconnect();
        }
        return completable;
    }

    @Deprecated(message="Please use login function with sessionHandler instead", replaceWith=@ReplaceWith(imports={"com.amity.socialcloud.sdk.AmityCoreClient.login"}, expression="login(userId = userId, sessionHandler = sessionHandler)"))
    @NotNull
    public final UserRegistration.Builder login(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.login(userId, null);
    }

    @NotNull
    public final UserRegistration.Builder login(@NotNull String userId, @Nullable SessionHandler sessionHandler) {
        boolean isLegacyVersion;
        block2: {
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            boolean bl = isLegacyVersion = sessionHandler == null;
            if (this.getCurrentSessionState() instanceof SessionState.Establishing) {
                throw (Throwable)SessionError.INSTANCE.fromState(this.getCurrentSessionState());
            }
            SessionHandler sessionHandler2 = sessionHandler;
            if (sessionHandler2 == null) break block2;
            SessionHandler sessionHandler3 = sessionHandler2;
            boolean bl2 = false;
            boolean bl3 = false;
            SessionHandler it = sessionHandler3;
            boolean bl4 = false;
            TokenRenewalSessionComponent tokenRenewalSessionComponent = renewalManager;
            if (tokenRenewalSessionComponent != null) {
                tokenRenewalSessionComponent.setSessionHandler(it);
            }
        }
        return new UserRegistration.Builder(appEventBus, sessionLifeCycleEventBus, userId, isLegacyVersion);
    }

    @NotNull
    public final Completable logout() {
        appEventBus.publish(AppEvent.ManualLogout.INSTANCE);
        return RxJava3BridgeExtensionsKt.toV2(new LogoutUseCase().execute());
    }

    @NotNull
    public final String getUserId() {
        return new ActiveUserIdGetUseCase().execute();
    }

    @NotNull
    public final AmityUserUpdate.Builder updateUser() {
        return new AmityUserUpdate.Builder(this.getUserId());
    }

    @NotNull
    public final AmityPermissionValidator hasPermission(@NotNull AmityPermission permission) {
        Intrinsics.checkNotNullParameter((Object)((Object)permission), (String)"permission");
        return new AmityPermissionValidator(permission);
    }

    @NotNull
    public final Flowable<AmityUser> getCurrentUser() {
        return this.newUserRepository().getCurrentUser();
    }

    @NotNull
    public final AmityUserRepository newUserRepository() {
        return new AmityUserRepository();
    }

    @NotNull
    public final AmityFileRepository newFileRepository() {
        return new AmityFileRepository();
    }

    @NotNull
    public final String getAmityCoreSdkVersion() {
        return "5.33.0";
    }

    @NotNull
    public final Flowable<AmityGlobalBanEvent> getGlobalBanEvents() {
        return EkoSocket.Companion.getGlobalBanEvents();
    }

    @NotNull
    public final AmityUserNotification notification() {
        return new AmityUserNotification();
    }

    @NotNull
    public final AmityClientConfiguration getConfiguration() {
        return new AmityClientConfiguration((StreamFunctionInterface)new StreamFunction());
    }

    @Deprecated(message="Please use  observeSessionState instead")
    @NotNull
    public final Flowable<AmityConnectionState> getConnectionState() {
        return EkoSocket.Companion.getConnectionState();
    }

    @NotNull
    public final AmityTopicSubscription subscription(@NotNull AmityTopic topic) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        return new AmityTopicSubscription(topic);
    }

    @NotNull
    public final Single<AmityContentCheck> getContentCheck() {
        return new GetContentCheckUseCase().execute();
    }

    @NotNull
    public final Flowable<SessionState> observeSessionState() {
        return RxJava3BridgeExtensionsKt.toV2(sessionStateEventBus.observe());
    }

    private final void setupSessionComponents() {
        if (mqttClient == null || socketClient == null || renewalManager == null) {
            mqttClient = new AmityMqttClient(sessionLifeCycleEventBus, sessionStateEventBus);
            socketClient = new EkoSocket(sessionLifeCycleEventBus, sessionStateEventBus);
            renewalManager = new TokenRenewalSessionComponent(appEventBus, sessionLifeCycleEventBus, sessionStateEventBus);
            new EkoApi(sessionLifeCycleEventBus, sessionStateEventBus);
            new DatabaseSessionComponent(sessionLifeCycleEventBus, sessionStateEventBus);
            new UserSettingSessionComponent(sessionLifeCycleEventBus, sessionStateEventBus);
            new TokenWatcherSessionComponent(appEventBus, sessionLifeCycleEventBus, sessionStateEventBus);
        }
    }

    private AmityCoreClient() {
    }

    static {
        AmityCoreClient amityCoreClient;
        INSTANCE = amityCoreClient = new AmityCoreClient();
        TAG = AmityCoreClient.class.getName();
        sessionLifeCycleEventBus = new SessionLifeCycleEventBus();
        appEventBus = new AppEventBus();
        sessionStateEventBus = new SessionStateEventBus();
        SessionLifeCycleEventBus sessionLifeCycleEventBus = AmityCoreClient.sessionLifeCycleEventBus;
        SessionStateEventBus sessionStateEventBus = AmityCoreClient.sessionStateEventBus;
        sessionStateManager = new SessionStateManager(appEventBus, sessionLifeCycleEventBus, sessionStateEventBus);
    }

    public static final /* synthetic */ String access$getTAG$p(AmityCoreClient $this) {
        AmityCoreClient amityCoreClient = $this;
        return TAG;
    }
}

