/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.GlobalFeedQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.model.GlobalFeedQueryTokenEntity;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class GlobalFeedQueryTokenDao_Impl
extends GlobalFeedQueryTokenDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<GlobalFeedQueryTokenEntity> __insertionAdapterOfGlobalFeedQueryTokenEntity;
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();

    public GlobalFeedQueryTokenDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfGlobalFeedQueryTokenEntity = new EntityInsertionAdapter<GlobalFeedQueryTokenEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `global_feed_query_token` (`isDeleted`,`previous`,`next`,`pageNumber`,`ids`,`updatedAt`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, GlobalFeedQueryTokenEntity value) {
                int _tmp = value.isDeleted() ? 1 : 0;
                stmt.bindLong(1, (long)_tmp);
                if (value.getPrevious() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getPrevious());
                }
                if (value.getNext() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getNext());
                }
                stmt.bindLong(4, (long)value.getPageNumber());
                String _tmp_1 = GlobalFeedQueryTokenDao_Impl.this.__stringListConverter.stringListToString(value.getIds());
                if (_tmp_1 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_1);
                }
                String _tmp_2 = GlobalFeedQueryTokenDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
            }
        };
    }

    @Override
    public Completable insertToken(final GlobalFeedQueryTokenEntity token) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                GlobalFeedQueryTokenDao_Impl.this.__db.beginTransaction();
                try {
                    GlobalFeedQueryTokenDao_Impl.this.__insertionAdapterOfGlobalFeedQueryTokenEntity.insert((Object)token);
                    GlobalFeedQueryTokenDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    GlobalFeedQueryTokenDao_Impl.this.__db.endTransaction();
                }
            }
        });
    }

    @Override
    public Maybe<GlobalFeedQueryTokenEntity> queryToken(SimpleSQLiteQuery query) {
        SimpleSQLiteQuery _internalQuery = query;
        return Maybe.fromCallable((Callable)new Callable<GlobalFeedQueryTokenEntity>((SupportSQLiteQuery)_internalQuery){
            final /* synthetic */ SupportSQLiteQuery val$_internalQuery;
            {
                this.val$_internalQuery = supportSQLiteQuery;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public GlobalFeedQueryTokenEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)GlobalFeedQueryTokenDao_Impl.this.__db, (SupportSQLiteQuery)this.val$_internalQuery, (boolean)false, null);){
                    GlobalFeedQueryTokenEntity _result = _cursor.moveToFirst() ? GlobalFeedQueryTokenDao_Impl.this.__entityCursorConverter_comEkoappEkosdkInternalDataModelGlobalFeedQueryTokenEntity(_cursor) : null;
                    GlobalFeedQueryTokenEntity globalFeedQueryTokenEntity = _result;
                    return globalFeedQueryTokenEntity;
                }
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private GlobalFeedQueryTokenEntity __entityCursorConverter_comEkoappEkosdkInternalDataModelGlobalFeedQueryTokenEntity(Cursor cursor) {
        int _tmp;
        int _cursorIndexOfIsDeleted = cursor.getColumnIndex("isDeleted");
        int _cursorIndexOfPrevious = cursor.getColumnIndex("previous");
        int _cursorIndexOfNext = cursor.getColumnIndex("next");
        int _cursorIndexOfPageNumber = cursor.getColumnIndex("pageNumber");
        int _cursorIndexOfIds = cursor.getColumnIndex("ids");
        int _cursorIndexOfUpdatedAt = cursor.getColumnIndex("updatedAt");
        boolean _tmpIsDeleted = _cursorIndexOfIsDeleted == -1 ? false : (_tmp = cursor.getInt(_cursorIndexOfIsDeleted)) != 0;
        GlobalFeedQueryTokenEntity _entity = new GlobalFeedQueryTokenEntity(_tmpIsDeleted);
        if (_cursorIndexOfPrevious != -1) {
            String _tmpPrevious = cursor.isNull(_cursorIndexOfPrevious) ? null : cursor.getString(_cursorIndexOfPrevious);
            _entity.setPrevious(_tmpPrevious);
        }
        if (_cursorIndexOfNext != -1) {
            String _tmpNext = cursor.isNull(_cursorIndexOfNext) ? null : cursor.getString(_cursorIndexOfNext);
            _entity.setNext(_tmpNext);
        }
        if (_cursorIndexOfPageNumber != -1) {
            int _tmpPageNumber = cursor.getInt(_cursorIndexOfPageNumber);
            _entity.setPageNumber(_tmpPageNumber);
        }
        if (_cursorIndexOfIds != -1) {
            String _tmp_1 = cursor.isNull(_cursorIndexOfIds) ? null : cursor.getString(_cursorIndexOfIds);
            List<String> _tmpIds = this.__stringListConverter.stringToStringList(_tmp_1);
            _entity.setIds(_tmpIds);
        }
        if (_cursorIndexOfUpdatedAt != -1) {
            String _tmp_2 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
            DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
            _entity.setUpdatedAt(_tmpUpdatedAt);
        }
        return _entity;
    }
}

