/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import com.amity.socialcloud.sdk.core.data.user.UserRepository;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.UserEntity;
import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.schedulers.Schedulers;

@Entity(tableName="user_flag", primaryKeys={"userId"}, foreignKeys={@ForeignKey(entity=UserEntity.class, parentColumns={"userId"}, childColumns={"userId"}, onDelete=5)})
public class EkoUserFlag
extends EkoObject {
    @NonNull
    private String userId;
    @SerializedName(value="hashFlag")
    private EkoFlag flag;
    private EkoLocalFlag localFlag;

    @Override
    public String getId() {
        return null;
    }

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = userId;
    }

    public EkoFlag getFlag() {
        return this.flag;
    }

    public void setFlag(EkoFlag flag) {
        this.flag = flag;
    }

    public EkoLocalFlag getLocalFlag() {
        return this.localFlag;
    }

    public void setLocalFlag(EkoLocalFlag localFlag) {
        this.localFlag = localFlag;
    }

    public boolean isFlaggedByMe() {
        if (this.flag != null) {
            boolean mightFlaggedByMe = this.flag.mightFlaggedByMe();
            if (this.localFlag == null) {
                this.localFlag = new EkoLocalFlag();
            }
            if (mightFlaggedByMe && !Objects.equal((Object)this.flag.getHash(), (Object)this.localFlag.getSyncedUpHash())) {
                Single.just((Object)this.getUserId()).filter(this.flag::expired).flatMapSingle(new UserRepository()::isFlaggedByMe).doOnSuccess(isFlaggedByMe2 -> {
                    this.localFlag.setFlaggedByMe((boolean)isFlaggedByMe2);
                    this.localFlag.setSyncedUpHash(this.flag.getHash());
                    UserDatabase.get().userFlagDao().update(this);
                }).subscribe();
                return true;
            }
            return mightFlaggedByMe && this.localFlag.isFlaggedByMe();
        }
        if (this.localFlag != null) {
            Completable.fromAction(() -> {
                this.localFlag = null;
                UserDatabase.get().userFlagDao().update(this);
            }).subscribeOn(Schedulers.io()).subscribe();
        }
        return false;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equal((Object)this.flag, (Object)((EkoUserFlag)obj).flag) && Objects.equal((Object)this.localFlag, (Object)((EkoUserFlag)obj).localFlag);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.flag, this.localFlag});
    }
}

