/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ekoapp.ekosdk.internal.data.dao.EkoAccountDao;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class EkoAccountDao_Impl
extends EkoAccountDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoAccount> __insertionAdapterOfEkoAccount;
    private final EntityDeletionOrUpdateAdapter<EkoAccount> __deletionAdapterOfEkoAccount;
    private final EntityDeletionOrUpdateAdapter<EkoAccount> __updateAdapterOfEkoAccount;
    private final SharedSQLiteStatement __preparedStmtOfSetAllIsActive;

    public EkoAccountDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoAccount = new EntityInsertionAdapter<EkoAccount>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `account` (`userId`,`deviceId`,`isActive`,`refreshToken`,`accessToken`,`activationId`) VALUES (?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoAccount value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                if (value.getDeviceId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getDeviceId());
                }
                int _tmp = value.isActive() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                if (value.getRefreshToken() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getRefreshToken());
                }
                if (value.getAccessToken() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getAccessToken());
                }
                if (value.getActivationId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getActivationId());
                }
            }
        };
        this.__deletionAdapterOfEkoAccount = new EntityDeletionOrUpdateAdapter<EkoAccount>(__db){

            public String createQuery() {
                return "DELETE FROM `account` WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoAccount value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
            }
        };
        this.__updateAdapterOfEkoAccount = new EntityDeletionOrUpdateAdapter<EkoAccount>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `account` SET `userId` = ?,`deviceId` = ?,`isActive` = ?,`refreshToken` = ?,`accessToken` = ?,`activationId` = ? WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoAccount value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                if (value.getDeviceId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getDeviceId());
                }
                int _tmp = value.isActive() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                if (value.getRefreshToken() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getRefreshToken());
                }
                if (value.getAccessToken() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getAccessToken());
                }
                if (value.getActivationId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getActivationId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getUserId());
                }
            }
        };
        this.__preparedStmtOfSetAllIsActive = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE account SET isActive = ?";
                return "UPDATE account SET isActive = ?";
            }
        };
    }

    @Override
    void insert(EkoAccount ekoAccount) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoAccount.insert((Object)ekoAccount);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoAccount account) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoAccount.handle((Object)account);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoAccount ekoAccount) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoAccount.handle((Object)ekoAccount);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoAccount activateAccount(String userId) {
        this.__db.beginTransaction();
        try {
            EkoAccount _result = EkoAccountDao_Impl.super.activateAccount(userId);
            this.__db.setTransactionSuccessful();
            EkoAccount ekoAccount = _result;
            return ekoAccount;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoAccount deactivateAccount(String userId) {
        this.__db.beginTransaction();
        try {
            EkoAccount _result = EkoAccountDao_Impl.super.deactivateAccount(userId);
            this.__db.setTransactionSuccessful();
            EkoAccount ekoAccount = _result;
            return ekoAccount;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoAccount logoutAccount(String userId) {
        this.__db.beginTransaction();
        try {
            EkoAccount _result = EkoAccountDao_Impl.super.logoutAccount(userId);
            this.__db.setTransactionSuccessful();
            EkoAccount ekoAccount = _result;
            return ekoAccount;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void pauseAllAccount() {
        this.__db.beginTransaction();
        try {
            EkoAccountDao_Impl.super.pauseAllAccount();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clearAllUserData(String userId) {
        this.__db.beginTransaction();
        try {
            EkoAccountDao_Impl.super.clearAllUserData(userId);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setAllIsActive(boolean isActive) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetAllIsActive.acquire();
        int _argIndex = 1;
        int _tmp = isActive ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetAllIsActive.release(_stmt);
        }
    }

    @Override
    public Flowable<List<EkoAccount>> getAll() {
        String _sql = "SELECT * from account";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from account", (int)0);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"account"}, (Callable)new Callable<List<EkoAccount>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<EkoAccount> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoAccountDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceId");
                    int _cursorIndexOfIsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isActive");
                    int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refreshToken");
                    int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessToken");
                    int _cursorIndexOfActivationId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activationId");
                    ArrayList<EkoAccount> _result = new ArrayList<EkoAccount>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        EkoAccount _item = new EkoAccount();
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _item.setUserId(_tmpUserId);
                        String _tmpDeviceId = _cursor.isNull(_cursorIndexOfDeviceId) ? null : _cursor.getString(_cursorIndexOfDeviceId);
                        _item.setDeviceId(_tmpDeviceId);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsActive);
                        boolean _tmpIsActive = _tmp != 0;
                        _item.setActive(_tmpIsActive);
                        String _tmpRefreshToken = _cursor.isNull(_cursorIndexOfRefreshToken) ? null : _cursor.getString(_cursorIndexOfRefreshToken);
                        _item.setRefreshToken(_tmpRefreshToken);
                        String _tmpAccessToken = _cursor.isNull(_cursorIndexOfAccessToken) ? null : _cursor.getString(_cursorIndexOfAccessToken);
                        _item.setAccessToken(_tmpAccessToken);
                        String _tmpActivationId = _cursor.isNull(_cursorIndexOfActivationId) ? null : _cursor.getString(_cursorIndexOfActivationId);
                        _item.setActivationId(_tmpActivationId);
                        _result.add(_item);
                    }
                    ArrayList<EkoAccount> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<EkoAccount> getByIdFlowable(String userId) {
        String _sql = "SELECT * from account where userId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from account where userId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"account"}, (Callable)new Callable<EkoAccount>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoAccount call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoAccountDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoAccount _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceId");
                    int _cursorIndexOfIsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isActive");
                    int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refreshToken");
                    int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessToken");
                    int _cursorIndexOfActivationId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activationId");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoAccount();
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpDeviceId = _cursor.isNull(_cursorIndexOfDeviceId) ? null : _cursor.getString(_cursorIndexOfDeviceId);
                        _result.setDeviceId(_tmpDeviceId);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsActive);
                        boolean _tmpIsActive = _tmp != 0;
                        _result.setActive(_tmpIsActive);
                        String _tmpRefreshToken = _cursor.isNull(_cursorIndexOfRefreshToken) ? null : _cursor.getString(_cursorIndexOfRefreshToken);
                        _result.setRefreshToken(_tmpRefreshToken);
                        String _tmpAccessToken = _cursor.isNull(_cursorIndexOfAccessToken) ? null : _cursor.getString(_cursorIndexOfAccessToken);
                        _result.setAccessToken(_tmpAccessToken);
                        String _tmpActivationId = _cursor.isNull(_cursorIndexOfActivationId) ? null : _cursor.getString(_cursorIndexOfActivationId);
                        _result.setActivationId(_tmpActivationId);
                    } else {
                        _result = null;
                    }
                    EkoAccount ekoAccount = _result;
                    return ekoAccount;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Maybe<EkoAccount> getByIdMaybe(String userId) {
        String _sql = "SELECT * from account where userId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from account where userId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return Maybe.fromCallable((Callable)new Callable<EkoAccount>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoAccount call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoAccountDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoAccount _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceId");
                    int _cursorIndexOfIsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isActive");
                    int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refreshToken");
                    int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessToken");
                    int _cursorIndexOfActivationId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activationId");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoAccount();
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpDeviceId = _cursor.isNull(_cursorIndexOfDeviceId) ? null : _cursor.getString(_cursorIndexOfDeviceId);
                        _result.setDeviceId(_tmpDeviceId);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsActive);
                        boolean _tmpIsActive = _tmp != 0;
                        _result.setActive(_tmpIsActive);
                        String _tmpRefreshToken = _cursor.isNull(_cursorIndexOfRefreshToken) ? null : _cursor.getString(_cursorIndexOfRefreshToken);
                        _result.setRefreshToken(_tmpRefreshToken);
                        String _tmpAccessToken = _cursor.isNull(_cursorIndexOfAccessToken) ? null : _cursor.getString(_cursorIndexOfAccessToken);
                        _result.setAccessToken(_tmpAccessToken);
                        String _tmpActivationId = _cursor.isNull(_cursorIndexOfActivationId) ? null : _cursor.getString(_cursorIndexOfActivationId);
                        _result.setActivationId(_tmpActivationId);
                    } else {
                        _result = null;
                    }
                    EkoAccount ekoAccount = _result;
                    return ekoAccount;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    Flowable<EkoAccount> getByIsActiveFlowable(boolean isActive) {
        String _sql = "SELECT * from account where isActive = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from account where isActive = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        int _tmp = isActive ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"account"}, (Callable)new Callable<EkoAccount>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoAccount call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoAccountDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoAccount _result;
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceId");
                    int _cursorIndexOfIsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isActive");
                    int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refreshToken");
                    int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessToken");
                    int _cursorIndexOfActivationId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activationId");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoAccount();
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpDeviceId = _cursor.isNull(_cursorIndexOfDeviceId) ? null : _cursor.getString(_cursorIndexOfDeviceId);
                        _result.setDeviceId(_tmpDeviceId);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsActive);
                        boolean _tmpIsActive = _tmp_1 != 0;
                        _result.setActive(_tmpIsActive);
                        String _tmpRefreshToken = _cursor.isNull(_cursorIndexOfRefreshToken) ? null : _cursor.getString(_cursorIndexOfRefreshToken);
                        _result.setRefreshToken(_tmpRefreshToken);
                        String _tmpAccessToken = _cursor.isNull(_cursorIndexOfAccessToken) ? null : _cursor.getString(_cursorIndexOfAccessToken);
                        _result.setAccessToken(_tmpAccessToken);
                        String _tmpActivationId = _cursor.isNull(_cursorIndexOfActivationId) ? null : _cursor.getString(_cursorIndexOfActivationId);
                        _result.setActivationId(_tmpActivationId);
                    } else {
                        _result = null;
                    }
                    EkoAccount ekoAccount = _result;
                    return ekoAccount;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EkoAccount getByIsActiveNow(boolean isActive) {
        String _sql = "SELECT * from account where isActive = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from account where isActive = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        int _tmp = isActive ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoAccount _result;
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceId");
            int _cursorIndexOfIsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isActive");
            int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refreshToken");
            int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessToken");
            int _cursorIndexOfActivationId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activationId");
            if (_cursor.moveToFirst()) {
                _result = new EkoAccount();
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpDeviceId = _cursor.isNull(_cursorIndexOfDeviceId) ? null : _cursor.getString(_cursorIndexOfDeviceId);
                _result.setDeviceId(_tmpDeviceId);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsActive);
                boolean _tmpIsActive = _tmp_1 != 0;
                _result.setActive(_tmpIsActive);
                String _tmpRefreshToken = _cursor.isNull(_cursorIndexOfRefreshToken) ? null : _cursor.getString(_cursorIndexOfRefreshToken);
                _result.setRefreshToken(_tmpRefreshToken);
                String _tmpAccessToken = _cursor.isNull(_cursorIndexOfAccessToken) ? null : _cursor.getString(_cursorIndexOfAccessToken);
                _result.setAccessToken(_tmpAccessToken);
                String _tmpActivationId = _cursor.isNull(_cursorIndexOfActivationId) ? null : _cursor.getString(_cursorIndexOfActivationId);
                _result.setActivationId(_tmpActivationId);
            } else {
                _result = null;
            }
            EkoAccount ekoAccount = _result;
            return ekoAccount;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EkoAccount getByIdNow(String userId) {
        String _sql = "SELECT * from account where userId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from account where userId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoAccount _result;
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfDeviceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceId");
            int _cursorIndexOfIsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isActive");
            int _cursorIndexOfRefreshToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"refreshToken");
            int _cursorIndexOfAccessToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"accessToken");
            int _cursorIndexOfActivationId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activationId");
            if (_cursor.moveToFirst()) {
                _result = new EkoAccount();
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpDeviceId = _cursor.isNull(_cursorIndexOfDeviceId) ? null : _cursor.getString(_cursorIndexOfDeviceId);
                _result.setDeviceId(_tmpDeviceId);
                int _tmp = _cursor.getInt(_cursorIndexOfIsActive);
                boolean _tmpIsActive = _tmp != 0;
                _result.setActive(_tmpIsActive);
                String _tmpRefreshToken = _cursor.isNull(_cursorIndexOfRefreshToken) ? null : _cursor.getString(_cursorIndexOfRefreshToken);
                _result.setRefreshToken(_tmpRefreshToken);
                String _tmpAccessToken = _cursor.isNull(_cursorIndexOfAccessToken) ? null : _cursor.getString(_cursorIndexOfAccessToken);
                _result.setAccessToken(_tmpAccessToken);
                String _tmpActivationId = _cursor.isNull(_cursorIndexOfActivationId) ? null : _cursor.getString(_cursorIndexOfActivationId);
                _result.setActivationId(_tmpActivationId);
            } else {
                _result = null;
            }
            EkoAccount ekoAccount = _result;
            return ekoAccount;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

