/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api;

import com.amity.socialcloud.sdk.AmityOkHttp;
import com.amity.socialcloud.sdk.core.data.session.SessionApi;
import com.amity.socialcloud.sdk.infra.retrofit.conveter.Rx3ErrorHandlingCallAdapterFactory;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.internal.api.EkoApi;
import com.ekoapp.ekosdk.internal.api.EkoEndpoint;
import com.ekoapp.ekosdk.internal.api.EkoNotificationApi;
import com.ekoapp.ekosdk.internal.api.EkoStreamApi;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoAccountDao;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.google.gson.Gson;
import io.reactivex.Flowable;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Predicate;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J%\u0010\u0012\u001a\u0002H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\nH\u0002J#\u0010\u001a\u001a\u0002H\u0013\"\b\b\u0000\u0010\u0013*\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u001b\u001a\u00020\nH\u0002J\b\u0010\u001c\u001a\u00020\fH\u0002J\b\u0010\u001d\u001a\u00020\nH\u0002J\b\u0010\u001e\u001a\u00020\fH\u0002J\u0006\u0010\u001f\u001a\u00020\u0010J\b\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020\u0010H\u0002J\b\u0010#\u001a\u00020\u0010H\u0002J \u0010$\u001a\u00020%\"\b\b\u0000\u0010\u0013*\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015H\u0002J\b\u0010&\u001a\u00020'H\u0007R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/ekoapp/ekosdk/internal/api/EkoApi;", "", "()V", "apiKeyRequiredApis", "", "", "kotlin.jvm.PlatformType", "apiMap", "", "authOkHttpClient", "Lokhttp3/OkHttpClient;", "authRetrofit", "Lretrofit2/Retrofit;", "okHttpClient", "retrofit", "autoCancelRequestOnAccountDeactivation", "", "userId", "createApi", "T", "clazz", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Ljava/lang/Object;", "createRetrofit", "url", "httpClient", "get", "getAuthOkHttpClient", "getAuthRetrofit", "getOkHttpClient", "getRetrofit", "init", "notification", "Lcom/ekoapp/ekosdk/internal/api/EkoNotificationApi;", "observeAccountChanges", "observeEndpointChanges", "requiresAuthentication", "", "stream", "Lcom/ekoapp/ekosdk/internal/api/EkoStreamApi;", "amity-sdk_release"})
public final class EkoApi {
    private static Retrofit retrofit;
    private static Retrofit authRetrofit;
    private static OkHttpClient okHttpClient;
    private static OkHttpClient authOkHttpClient;
    private static final Map<String, Object> apiMap;
    private static final Set<String> apiKeyRequiredApis;
    @NotNull
    public static final EkoApi INSTANCE;

    public final void init() {
        this.observeAccountChanges();
        this.observeEndpointChanges();
    }

    private final void observeAccountChanges() {
        EkoAccountDao ekoAccountDao = EkoDatabase.get().accountDao();
        Intrinsics.checkNotNullExpressionValue((Object)ekoAccountDao, (String)"EkoDatabase.get()\n            .accountDao()");
        Flowable<EkoAccount> flowable = ekoAccountDao.getCurrentAccountFlowable();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"EkoDatabase.get()\n      \u2026  .currentAccountFlowable");
        RxJava3BridgeExtensionsKt.toV3(flowable).doOnNext((Consumer)observeAccountChanges.1.INSTANCE).subscribeOn(Schedulers.io()).subscribe();
    }

    private final void autoCancelRequestOnAccountDeactivation(String userId) {
        CompositeDisposable subscriptions = new CompositeDisposable();
        Disposable subscription2 = EkoDatabase.get().accountDao().getByIdFlowable(userId).filter((Predicate)autoCancelRequestOnAccountDeactivation.subscription.1.INSTANCE).doOnNext((io.reactivex.functions.Consumer)new io.reactivex.functions.Consumer<EkoAccount>(subscriptions){
            final /* synthetic */ CompositeDisposable $subscriptions;

            public final void accept(@NotNull EkoAccount account) {
                Intrinsics.checkNotNullParameter((Object)account, (String)"account");
                OkHttpClient okHttpClient = EkoApi.access$getAuthOkHttpClient$p(EkoApi.INSTANCE);
                if (okHttpClient != null && (okHttpClient = okHttpClient.dispatcher()) != null) {
                    okHttpClient.cancelAll();
                }
                this.$subscriptions.clear();
            }
            {
                this.$subscriptions = compositeDisposable;
            }
        }).subscribe();
        subscriptions.add(subscription2);
    }

    private final void observeEndpointChanges() {
        RxJava3BridgeExtensionsKt.toV3(EkoEndpoint.INSTANCE.observeHttpUrl()).doOnNext((Consumer)observeEndpointChanges.1.INSTANCE).subscribeOn(Schedulers.io()).subscribe();
    }

    @Deprecated(message="Use get() instead")
    @NotNull
    public final EkoStreamApi stream() {
        return (EkoStreamApi)this.get(Reflection.getOrCreateKotlinClass(EkoStreamApi.class));
    }

    @Deprecated(message="Use get() instead")
    @NotNull
    public final EkoNotificationApi notification() {
        return (EkoNotificationApi)this.get(Reflection.getOrCreateKotlinClass(EkoNotificationApi.class));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> T get(@NotNull KClass<T> clazz) {
        Object object;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Object existingInstance = apiMap.get(JvmClassMappingKt.getJavaClass(clazz).getName());
        if (existingInstance != null) {
            object = existingInstance;
        } else {
            void var3_3;
            T newInstance = this.createApi(clazz);
            String string = JvmClassMappingKt.getJavaClass(clazz).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.java.name");
            apiMap.put(string, newInstance);
            object = var3_3;
        }
        return (T)object;
    }

    private final <T> T createApi(KClass<T> clazz) {
        Object object;
        if (this.requiresAuthentication(clazz)) {
            Object object2 = this.getAuthRetrofit().create(JvmClassMappingKt.getJavaClass(clazz));
            object = object2;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getAuthRetrofit().create(clazz.java)");
        } else {
            Object object3 = this.getRetrofit().create(JvmClassMappingKt.getJavaClass(clazz));
            object = object3;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"getRetrofit().create(clazz.java)");
        }
        return (T)object;
    }

    private final Retrofit getRetrofit() {
        if (retrofit == null) {
            retrofit = this.createRetrofit(EkoEndpoint.INSTANCE.getHttpUrl(), this.getOkHttpClient());
        }
        Retrofit retrofit = EkoApi.retrofit;
        Intrinsics.checkNotNull((Object)retrofit);
        return retrofit;
    }

    private final Retrofit getAuthRetrofit() {
        if (authRetrofit == null) {
            authRetrofit = this.createRetrofit(EkoEndpoint.INSTANCE.getHttpUrl(), this.getAuthOkHttpClient());
        }
        Retrofit retrofit = authRetrofit;
        Intrinsics.checkNotNull((Object)retrofit);
        return retrofit;
    }

    private final OkHttpClient getOkHttpClient() {
        if (okHttpClient == null) {
            okHttpClient = AmityOkHttp.Companion.newBuilder$amity_sdk_release().build();
        }
        OkHttpClient okHttpClient = EkoApi.okHttpClient;
        Intrinsics.checkNotNull((Object)okHttpClient);
        return okHttpClient;
    }

    private final OkHttpClient getAuthOkHttpClient() {
        if (authOkHttpClient == null) {
            authOkHttpClient = AmityOkHttp.Companion.newBuilder$amity_sdk_release().build();
        }
        OkHttpClient okHttpClient = authOkHttpClient;
        Intrinsics.checkNotNull((Object)okHttpClient);
        return okHttpClient;
    }

    private final Retrofit createRetrofit(String url, OkHttpClient httpClient) {
        Retrofit retrofit = new Retrofit.Builder().baseUrl(url).client(httpClient).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.createAsync()).addCallAdapterFactory(Rx3ErrorHandlingCallAdapterFactory.Companion.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)EkoGson.get())).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"Retrofit.Builder()\n     \u2026()))\n            .build()");
        return retrofit;
    }

    private final <T> boolean requiresAuthentication(KClass<T> clazz) {
        return !apiKeyRequiredApis.contains(JvmClassMappingKt.getJavaClass(clazz).getName());
    }

    private EkoApi() {
    }

    static {
        EkoApi ekoApi;
        INSTANCE = ekoApi = new EkoApi();
        boolean bl = false;
        apiMap = new LinkedHashMap();
        apiKeyRequiredApis = SetsKt.setOf((Object[])new String[]{SessionApi.class.getName(), EkoNotificationApi.class.getName()});
    }

    public static final /* synthetic */ void access$autoCancelRequestOnAccountDeactivation(EkoApi $this, String userId) {
        $this.autoCancelRequestOnAccountDeactivation(userId);
    }

    public static final /* synthetic */ OkHttpClient access$getAuthOkHttpClient$p(EkoApi $this) {
        EkoApi ekoApi = $this;
        return authOkHttpClient;
    }

    public static final /* synthetic */ void access$setAuthOkHttpClient$p(EkoApi $this, OkHttpClient okHttpClient) {
        EkoApi ekoApi = $this;
        authOkHttpClient = okHttpClient;
    }

    public static final /* synthetic */ Retrofit access$getRetrofit$p(EkoApi $this) {
        EkoApi ekoApi = $this;
        return retrofit;
    }

    public static final /* synthetic */ void access$setRetrofit$p(EkoApi $this, Retrofit retrofit) {
        EkoApi ekoApi = $this;
        EkoApi.retrofit = retrofit;
    }

    public static final /* synthetic */ Retrofit access$getAuthRetrofit$p(EkoApi $this) {
        EkoApi ekoApi = $this;
        return authRetrofit;
    }

    public static final /* synthetic */ void access$setAuthRetrofit$p(EkoApi $this, Retrofit retrofit) {
        EkoApi ekoApi = $this;
        authRetrofit = retrofit;
    }

    public static final /* synthetic */ OkHttpClient access$getOkHttpClient$p(EkoApi $this) {
        EkoApi ekoApi = $this;
        return okHttpClient;
    }

    public static final /* synthetic */ void access$setOkHttpClient$p(EkoApi $this, OkHttpClient okHttpClient) {
        EkoApi ekoApi = $this;
        EkoApi.okHttpClient = okHttpClient;
    }

    public static final /* synthetic */ Map access$getApiMap$p(EkoApi $this) {
        EkoApi ekoApi = $this;
        return apiMap;
    }
}

