/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import com.google.common.base.Objects;

@Entity(tableName="push_config", primaryKeys={"userId", "deviceId"})
public class EkoPushConfig {
    @NonNull
    private String userId;
    @NonNull
    private String deviceId;
    @NonNull
    private State state;

    public EkoPushConfig(@NonNull String userId, @NonNull String deviceId, @NonNull State state) {
        this.userId = userId;
        this.deviceId = deviceId;
        this.state = state;
    }

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = userId;
    }

    @NonNull
    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(@NonNull String deviceId) {
        this.deviceId = deviceId;
    }

    @NonNull
    public State getState() {
        return this.state;
    }

    public void setState(@NonNull State state) {
        this.state = state;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        EkoPushConfig other = (EkoPushConfig)obj;
        return Objects.equal((Object)this.userId, (Object)other.userId) && Objects.equal((Object)this.deviceId, (Object)other.deviceId) && Objects.equal((Object)((Object)this.state), (Object)((Object)other.state));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.userId, this.deviceId, this.state});
    }

    public static enum State {
        REGISTERED("registered"),
        UNREGISTERED("unregistered");

        private final String apiKey;

        private State(String apiKey) {
            this.apiKey = apiKey;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public static State fromApiKey(String apiKey) {
            for (State state : State.values()) {
                if (!Objects.equal((Object)apiKey, (Object)state.apiKey)) continue;
                return state;
            }
            return null;
        }
    }
}

