/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.room.Insert;
import com.ekoapp.ekosdk.TaggedEkoObject;
import com.ekoapp.ekosdk.internal.data.model.EkoTagObject;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;

public abstract class EkoTagDao<EntityType extends EkoTagObject> {
    static <TaggedObject extends TaggedEkoObject, TagObject extends EkoTagObject> void update(List<TaggedObject> ekoObjects, EkoTagDao<TagObject> dao, EkoTagObject.EkoTagFactory<TagObject> factory2) {
        for (TaggedEkoObject ekoObject : ekoObjects) {
            EkoTagDao.update(ekoObject, dao, factory2);
        }
    }

    static <TagObject extends EkoTagObject> void update(TaggedEkoObject ekoObject, EkoTagDao<TagObject> dao, EkoTagObject.EkoTagFactory<TagObject> factory2) {
        Object[] tags = ekoObject.getTags().toArray(new String[0]);
        ImmutableList list = FluentIterable.from((Object[])tags).transform(tag -> factory2.create(ekoObject.getId(), (String)tag)).toList();
        dao.insert((List<TagObject>)list);
        dao.retainAll(ekoObject.getId(), (String[])tags);
    }

    @Insert(onConflict=1)
    abstract void insert(List<EntityType> var1);

    abstract void retainAll(String var1, String[] var2);
}

