/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.ekoapp.ekosdk.internal.EkoFileEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoFileDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectMapper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public interface EkoFileMapper
extends EkoObjectMapper<EkoFileDto, EkoFileEntity> {
    public static final EkoFileMapper MAPPER = dto -> {
        EkoFileEntity file = new EkoFileEntity();
        file.setFileId(dto.getFileId());
        file.setFileUrl(dto.getFileUrl());
        file.setType(dto.getType());
        file.setCreatedAt(dto.getCreatedAt());
        file.setUpdatedAt(dto.getUpdatedAt());
        JsonObject attributes = new AttributesComposer().compose(dto.getAttributes(), dto.getStatus(), dto.getVideoUrl());
        file.setAttributes(attributes);
        return file;
    };

    @Override
    default public EkoFileEntity update(EkoFileEntity objectOnDisk, EkoFileEntity objectToSave) {
        objectOnDisk.setFileUrl(objectToSave.getFileUrl());
        objectOnDisk.setType(objectToSave.getType());
        objectOnDisk.setAttributes(objectToSave.getAttributes());
        objectOnDisk.setCreatedAt(objectToSave.getCreatedAt());
        objectOnDisk.setUpdatedAt(objectToSave.getUpdatedAt());
        return objectOnDisk;
    }

    public static class AttributesComposer {
        public JsonObject compose(JsonObject dtoAttributes, String status, JsonElement videoUrl) {
            JsonObject attributes = dtoAttributes;
            if (attributes == null) {
                attributes = new JsonObject();
            }
            if (status != null) {
                attributes.addProperty("status", status);
            }
            if (videoUrl != null && videoUrl.getClass() == JsonObject.class) {
                attributes.add("videoUrl", videoUrl);
            }
            return attributes;
        }
    }
}

