/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.model;

import androidx.annotation.NonNull;
import androidx.room.Entity;
import androidx.room.ForeignKey;
import com.ekoapp.ekosdk.internal.data.model.EkoRoleObject;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import com.ekoapp.ekosdk.internal.util.EkoPreconditions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

@Entity(tableName="channel_role", primaryKeys={"channelId", "userId", "roleName"}, foreignKeys={@ForeignKey(entity=ChannelMembershipEntity.class, parentColumns={"channelId", "userId"}, childColumns={"channelId", "userId"}, onDelete=5)})
public class ChannelMembershipRoleEntity
extends EkoRoleObject {
    @NonNull
    private String channelId;
    @NonNull
    private String userId;
    @NonNull
    private String roleName;

    @NonNull
    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(@NonNull String channelId) {
        this.channelId = EkoPreconditions.checkValidId(channelId, "channelId");
    }

    @NonNull
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(@NonNull String userId) {
        this.userId = EkoPreconditions.checkValidId(userId, "userId");
    }

    @NonNull
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(@NonNull String roleName) {
        this.roleName = EkoPreconditions.checkValidId(roleName, "roleName");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ChannelMembershipRoleEntity other = (ChannelMembershipRoleEntity)obj;
        return Objects.equal((Object)this.channelId, (Object)other.channelId) && Objects.equal((Object)this.userId, (Object)other.userId) && Objects.equal((Object)this.roleName, (Object)other.roleName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.channelId, this.userId, this.roleName});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("channelId", (Object)this.channelId).add("userId", (Object)this.userId).add("roleName", (Object)this.roleName).toString();
    }

    public static ChannelMembershipRoleEntity create(@NonNull String channelId, @NonNull String userId, @NonNull String roleName) {
        ChannelMembershipRoleEntity channelRole = new ChannelMembershipRoleEntity();
        channelRole.setChannelId(channelId);
        channelRole.setUserId(userId);
        channelRole.setRoleName(roleName);
        return channelRole;
    }
}

