/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoAccountDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoAccountDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoApiKeyDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoApiKeyDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoBaiduTokenDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoBaiduTokenDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoFcmTokenDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoFcmTokenDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoHttpUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoHttpUrlDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoMqttUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMqttUrlDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoPushConfigDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoPushConfigDao_Impl;
import com.ekoapp.ekosdk.internal.data.dao.EkoSocketUrlDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoSocketUrlDao_Impl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class EkoDatabase_Impl
extends EkoDatabase {
    private volatile EkoHttpUrlDao _ekoHttpUrlDao;
    private volatile EkoSocketUrlDao _ekoSocketUrlDao;
    private volatile EkoMqttUrlDao _ekoMqttUrlDao;
    private volatile EkoApiKeyDao _ekoApiKeyDao;
    private volatile EkoAccountDao _ekoAccountDao;
    private volatile EkoFcmTokenDao _ekoFcmTokenDao;
    private volatile EkoBaiduTokenDao _ekoBaiduTokenDao;
    private volatile EkoPushConfigDao _ekoPushConfigDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(7){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `account` (`userId` TEXT NOT NULL, `deviceId` TEXT, `isActive` INTEGER NOT NULL, `refreshToken` TEXT, `accessToken` TEXT, `activationId` TEXT, PRIMARY KEY(`userId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `api_key` (`id` TEXT NOT NULL, `apiKey` TEXT, `updateAt` INTEGER NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `fcm_token` (`id` TEXT NOT NULL, `token` TEXT NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `baidu_token` (`id` TEXT NOT NULL, `token` TEXT, `userId` TEXT, `channelId` TEXT, `apiKey` TEXT NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `push_config` (`userId` TEXT NOT NULL, `deviceId` TEXT NOT NULL, `state` TEXT NOT NULL, PRIMARY KEY(`userId`, `deviceId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `http_url` (`id` TEXT NOT NULL, `httpUrl` TEXT, `updateAt` INTEGER NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `socket_url` (`id` TEXT NOT NULL, `socketUrl` TEXT, `updateAt` INTEGER NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `mqtt_url` (`id` TEXT NOT NULL, `mqttUrl` TEXT, `updateAt` INTEGER NOT NULL, PRIMARY KEY(`id`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '2f97b87fc810783aec13c55198587e55')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `account`");
                _db.execSQL("DROP TABLE IF EXISTS `api_key`");
                _db.execSQL("DROP TABLE IF EXISTS `fcm_token`");
                _db.execSQL("DROP TABLE IF EXISTS `baidu_token`");
                _db.execSQL("DROP TABLE IF EXISTS `push_config`");
                _db.execSQL("DROP TABLE IF EXISTS `http_url`");
                _db.execSQL("DROP TABLE IF EXISTS `socket_url`");
                _db.execSQL("DROP TABLE IF EXISTS `mqtt_url`");
                if (EkoDatabase_Impl.this.mCallbacks != null) {
                    int _size = EkoDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)EkoDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (EkoDatabase_Impl.this.mCallbacks != null) {
                    int _size = EkoDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)EkoDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                EkoDatabase_Impl.this.mDatabase = _db;
                EkoDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (EkoDatabase_Impl.this.mCallbacks != null) {
                    int _size = EkoDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)EkoDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsAccount = new HashMap<String, TableInfo.Column>(6);
                _columnsAccount.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, 1));
                _columnsAccount.put("deviceId", new TableInfo.Column("deviceId", "TEXT", false, 0, null, 1));
                _columnsAccount.put("isActive", new TableInfo.Column("isActive", "INTEGER", true, 0, null, 1));
                _columnsAccount.put("refreshToken", new TableInfo.Column("refreshToken", "TEXT", false, 0, null, 1));
                _columnsAccount.put("accessToken", new TableInfo.Column("accessToken", "TEXT", false, 0, null, 1));
                _columnsAccount.put("activationId", new TableInfo.Column("activationId", "TEXT", false, 0, null, 1));
                HashSet _foreignKeysAccount = new HashSet(0);
                HashSet _indicesAccount = new HashSet(0);
                TableInfo _infoAccount = new TableInfo("account", _columnsAccount, _foreignKeysAccount, _indicesAccount);
                TableInfo _existingAccount = TableInfo.read((SupportSQLiteDatabase)_db, (String)"account");
                if (!_infoAccount.equals((Object)_existingAccount)) {
                    return new RoomOpenHelper.ValidationResult(false, "account(com.ekoapp.ekosdk.internal.data.model.EkoAccount).\n Expected:\n" + _infoAccount + "\n Found:\n" + _existingAccount);
                }
                HashMap<String, TableInfo.Column> _columnsApiKey = new HashMap<String, TableInfo.Column>(3);
                _columnsApiKey.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                _columnsApiKey.put("apiKey", new TableInfo.Column("apiKey", "TEXT", false, 0, null, 1));
                _columnsApiKey.put("updateAt", new TableInfo.Column("updateAt", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysApiKey = new HashSet(0);
                HashSet _indicesApiKey = new HashSet(0);
                TableInfo _infoApiKey = new TableInfo("api_key", _columnsApiKey, _foreignKeysApiKey, _indicesApiKey);
                TableInfo _existingApiKey = TableInfo.read((SupportSQLiteDatabase)_db, (String)"api_key");
                if (!_infoApiKey.equals((Object)_existingApiKey)) {
                    return new RoomOpenHelper.ValidationResult(false, "api_key(com.ekoapp.ekosdk.internal.data.model.EkoApiKey).\n Expected:\n" + _infoApiKey + "\n Found:\n" + _existingApiKey);
                }
                HashMap<String, TableInfo.Column> _columnsFcmToken = new HashMap<String, TableInfo.Column>(2);
                _columnsFcmToken.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                _columnsFcmToken.put("token", new TableInfo.Column("token", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysFcmToken = new HashSet(0);
                HashSet _indicesFcmToken = new HashSet(0);
                TableInfo _infoFcmToken = new TableInfo("fcm_token", _columnsFcmToken, _foreignKeysFcmToken, _indicesFcmToken);
                TableInfo _existingFcmToken = TableInfo.read((SupportSQLiteDatabase)_db, (String)"fcm_token");
                if (!_infoFcmToken.equals((Object)_existingFcmToken)) {
                    return new RoomOpenHelper.ValidationResult(false, "fcm_token(com.ekoapp.ekosdk.internal.data.model.EkoFcmToken).\n Expected:\n" + _infoFcmToken + "\n Found:\n" + _existingFcmToken);
                }
                HashMap<String, TableInfo.Column> _columnsBaiduToken = new HashMap<String, TableInfo.Column>(5);
                _columnsBaiduToken.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                _columnsBaiduToken.put("token", new TableInfo.Column("token", "TEXT", false, 0, null, 1));
                _columnsBaiduToken.put("userId", new TableInfo.Column("userId", "TEXT", false, 0, null, 1));
                _columnsBaiduToken.put("channelId", new TableInfo.Column("channelId", "TEXT", false, 0, null, 1));
                _columnsBaiduToken.put("apiKey", new TableInfo.Column("apiKey", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysBaiduToken = new HashSet(0);
                HashSet _indicesBaiduToken = new HashSet(0);
                TableInfo _infoBaiduToken = new TableInfo("baidu_token", _columnsBaiduToken, _foreignKeysBaiduToken, _indicesBaiduToken);
                TableInfo _existingBaiduToken = TableInfo.read((SupportSQLiteDatabase)_db, (String)"baidu_token");
                if (!_infoBaiduToken.equals((Object)_existingBaiduToken)) {
                    return new RoomOpenHelper.ValidationResult(false, "baidu_token(com.ekoapp.ekosdk.internal.data.model.EkoBaiduToken).\n Expected:\n" + _infoBaiduToken + "\n Found:\n" + _existingBaiduToken);
                }
                HashMap<String, TableInfo.Column> _columnsPushConfig = new HashMap<String, TableInfo.Column>(3);
                _columnsPushConfig.put("userId", new TableInfo.Column("userId", "TEXT", true, 1, null, 1));
                _columnsPushConfig.put("deviceId", new TableInfo.Column("deviceId", "TEXT", true, 2, null, 1));
                _columnsPushConfig.put("state", new TableInfo.Column("state", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysPushConfig = new HashSet(0);
                HashSet _indicesPushConfig = new HashSet(0);
                TableInfo _infoPushConfig = new TableInfo("push_config", _columnsPushConfig, _foreignKeysPushConfig, _indicesPushConfig);
                TableInfo _existingPushConfig = TableInfo.read((SupportSQLiteDatabase)_db, (String)"push_config");
                if (!_infoPushConfig.equals((Object)_existingPushConfig)) {
                    return new RoomOpenHelper.ValidationResult(false, "push_config(com.ekoapp.ekosdk.internal.data.model.EkoPushConfig).\n Expected:\n" + _infoPushConfig + "\n Found:\n" + _existingPushConfig);
                }
                HashMap<String, TableInfo.Column> _columnsHttpUrl = new HashMap<String, TableInfo.Column>(3);
                _columnsHttpUrl.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                _columnsHttpUrl.put("httpUrl", new TableInfo.Column("httpUrl", "TEXT", false, 0, null, 1));
                _columnsHttpUrl.put("updateAt", new TableInfo.Column("updateAt", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysHttpUrl = new HashSet(0);
                HashSet _indicesHttpUrl = new HashSet(0);
                TableInfo _infoHttpUrl = new TableInfo("http_url", _columnsHttpUrl, _foreignKeysHttpUrl, _indicesHttpUrl);
                TableInfo _existingHttpUrl = TableInfo.read((SupportSQLiteDatabase)_db, (String)"http_url");
                if (!_infoHttpUrl.equals((Object)_existingHttpUrl)) {
                    return new RoomOpenHelper.ValidationResult(false, "http_url(com.ekoapp.ekosdk.internal.data.model.EkoHttpUrl).\n Expected:\n" + _infoHttpUrl + "\n Found:\n" + _existingHttpUrl);
                }
                HashMap<String, TableInfo.Column> _columnsSocketUrl = new HashMap<String, TableInfo.Column>(3);
                _columnsSocketUrl.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                _columnsSocketUrl.put("socketUrl", new TableInfo.Column("socketUrl", "TEXT", false, 0, null, 1));
                _columnsSocketUrl.put("updateAt", new TableInfo.Column("updateAt", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysSocketUrl = new HashSet(0);
                HashSet _indicesSocketUrl = new HashSet(0);
                TableInfo _infoSocketUrl = new TableInfo("socket_url", _columnsSocketUrl, _foreignKeysSocketUrl, _indicesSocketUrl);
                TableInfo _existingSocketUrl = TableInfo.read((SupportSQLiteDatabase)_db, (String)"socket_url");
                if (!_infoSocketUrl.equals((Object)_existingSocketUrl)) {
                    return new RoomOpenHelper.ValidationResult(false, "socket_url(com.ekoapp.ekosdk.internal.data.model.EkoSocketUrl).\n Expected:\n" + _infoSocketUrl + "\n Found:\n" + _existingSocketUrl);
                }
                HashMap<String, TableInfo.Column> _columnsMqttUrl = new HashMap<String, TableInfo.Column>(3);
                _columnsMqttUrl.put("id", new TableInfo.Column("id", "TEXT", true, 1, null, 1));
                _columnsMqttUrl.put("mqttUrl", new TableInfo.Column("mqttUrl", "TEXT", false, 0, null, 1));
                _columnsMqttUrl.put("updateAt", new TableInfo.Column("updateAt", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysMqttUrl = new HashSet(0);
                HashSet _indicesMqttUrl = new HashSet(0);
                TableInfo _infoMqttUrl = new TableInfo("mqtt_url", _columnsMqttUrl, _foreignKeysMqttUrl, _indicesMqttUrl);
                TableInfo _existingMqttUrl = TableInfo.read((SupportSQLiteDatabase)_db, (String)"mqtt_url");
                if (!_infoMqttUrl.equals((Object)_existingMqttUrl)) {
                    return new RoomOpenHelper.ValidationResult(false, "mqtt_url(com.ekoapp.ekosdk.internal.data.model.EkoMqttUrl).\n Expected:\n" + _infoMqttUrl + "\n Found:\n" + _existingMqttUrl);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "2f97b87fc810783aec13c55198587e55", "55edfea2d175e6e51ce1ae2ebcecac23");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"account", "api_key", "fcm_token", "baidu_token", "push_config", "http_url", "socket_url", "mqtt_url"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `account`");
            _db.execSQL("DELETE FROM `api_key`");
            _db.execSQL("DELETE FROM `fcm_token`");
            _db.execSQL("DELETE FROM `baidu_token`");
            _db.execSQL("DELETE FROM `push_config`");
            _db.execSQL("DELETE FROM `http_url`");
            _db.execSQL("DELETE FROM `socket_url`");
            _db.execSQL("DELETE FROM `mqtt_url`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(EkoHttpUrlDao.class, EkoHttpUrlDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(EkoSocketUrlDao.class, EkoSocketUrlDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(EkoMqttUrlDao.class, EkoMqttUrlDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(EkoApiKeyDao.class, EkoApiKeyDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(EkoAccountDao.class, EkoAccountDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(EkoFcmTokenDao.class, EkoFcmTokenDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(EkoBaiduTokenDao.class, EkoBaiduTokenDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(EkoPushConfigDao.class, EkoPushConfigDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
        return Arrays.asList(new Migration[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoHttpUrlDao httpUrlDao() {
        if (this._ekoHttpUrlDao != null) {
            return this._ekoHttpUrlDao;
        }
        EkoDatabase_Impl ekoDatabase_Impl = this;
        synchronized (ekoDatabase_Impl) {
            if (this._ekoHttpUrlDao == null) {
                this._ekoHttpUrlDao = new EkoHttpUrlDao_Impl(this);
            }
            return this._ekoHttpUrlDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoSocketUrlDao socketUrlDao() {
        if (this._ekoSocketUrlDao != null) {
            return this._ekoSocketUrlDao;
        }
        EkoDatabase_Impl ekoDatabase_Impl = this;
        synchronized (ekoDatabase_Impl) {
            if (this._ekoSocketUrlDao == null) {
                this._ekoSocketUrlDao = new EkoSocketUrlDao_Impl(this);
            }
            return this._ekoSocketUrlDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoMqttUrlDao mqttUrlDao() {
        if (this._ekoMqttUrlDao != null) {
            return this._ekoMqttUrlDao;
        }
        EkoDatabase_Impl ekoDatabase_Impl = this;
        synchronized (ekoDatabase_Impl) {
            if (this._ekoMqttUrlDao == null) {
                this._ekoMqttUrlDao = new EkoMqttUrlDao_Impl(this);
            }
            return this._ekoMqttUrlDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoApiKeyDao apiKeyDao() {
        if (this._ekoApiKeyDao != null) {
            return this._ekoApiKeyDao;
        }
        EkoDatabase_Impl ekoDatabase_Impl = this;
        synchronized (ekoDatabase_Impl) {
            if (this._ekoApiKeyDao == null) {
                this._ekoApiKeyDao = new EkoApiKeyDao_Impl(this);
            }
            return this._ekoApiKeyDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoAccountDao accountDao() {
        if (this._ekoAccountDao != null) {
            return this._ekoAccountDao;
        }
        EkoDatabase_Impl ekoDatabase_Impl = this;
        synchronized (ekoDatabase_Impl) {
            if (this._ekoAccountDao == null) {
                this._ekoAccountDao = new EkoAccountDao_Impl(this);
            }
            return this._ekoAccountDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoFcmTokenDao fcmTokenDao() {
        if (this._ekoFcmTokenDao != null) {
            return this._ekoFcmTokenDao;
        }
        EkoDatabase_Impl ekoDatabase_Impl = this;
        synchronized (ekoDatabase_Impl) {
            if (this._ekoFcmTokenDao == null) {
                this._ekoFcmTokenDao = new EkoFcmTokenDao_Impl(this);
            }
            return this._ekoFcmTokenDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoBaiduTokenDao baiduTokenDao() {
        if (this._ekoBaiduTokenDao != null) {
            return this._ekoBaiduTokenDao;
        }
        EkoDatabase_Impl ekoDatabase_Impl = this;
        synchronized (ekoDatabase_Impl) {
            if (this._ekoBaiduTokenDao == null) {
                this._ekoBaiduTokenDao = new EkoBaiduTokenDao_Impl(this);
            }
            return this._ekoBaiduTokenDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EkoPushConfigDao pushConfigDao() {
        if (this._ekoPushConfigDao != null) {
            return this._ekoPushConfigDao;
        }
        EkoDatabase_Impl ekoDatabase_Impl = this;
        synchronized (ekoDatabase_Impl) {
            if (this._ekoPushConfigDao == null) {
                this._ekoPushConfigDao = new EkoPushConfigDao_Impl(this);
            }
            return this._ekoPushConfigDao;
        }
    }
}

