/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionAndUserListDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoReactorDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectMapper;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public interface EkoReactionMapper
extends EkoObjectMapper<EkoReactionAndUserListDto, List<EkoReactionEntity>> {
    public static final EkoReactionMapper MAPPER = dto -> {
        List<EkoUserDto> userDtoList = dto.getUsers();
        HashMap userMap = Maps.newHashMap();
        for (EkoUserDto userDto : userDtoList) {
            userMap.put(userDto.getUserId(), userDto.getDisplayName());
        }
        ArrayList<EkoReactionEntity> reactionList = new ArrayList<EkoReactionEntity>();
        for (EkoReactionDto reactionDto : dto.getReactions()) {
            for (EkoReactorDto reactorDto : reactionDto.getReactors()) {
                EkoReactionEntity reaction = EkoReactionEntity.create(reactorDto.getReactionId(), ReactionReferenceType.Companion.enumOf(reactionDto.getReferenceType()), reactionDto.getReferenceId(), reactorDto.getReactionName(), reactorDto.getUserId(), (String)userMap.get(reactorDto.getUserId()), reactorDto.getCreatedAt(), reactorDto.getUpdatedAt());
                reactionList.add(reaction);
            }
        }
        return reactionList;
    };
}

