/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api;

import androidx.annotation.NonNull;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.ekoapp.ekosdk.internal.api.EkoEndpoint;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.jakewharton.rxrelay2.BehaviorRelay;
import com.jakewharton.rxrelay2.Relay;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.socket.client.IO;
import io.socket.client.Socket;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;

public class RxSocket
implements Disposable {
    private static final String TAG = RxSocket.class.getName();
    private static final ImmutableSet<String> CONNECTION_EVENTS = ImmutableSet.builder().add((Object)"connect").add((Object)"connect_error").add((Object)"connect_timeout").add((Object)"connecting").add((Object)"disconnect").add((Object)"error").add((Object)"reconnect").add((Object)"reconnect_attempt").add((Object)"reconnect_failed").add((Object)"reconnecting").add((Object)"ping").add((Object)"pong").add((Object)"message").build();
    private final String userId;
    private final AtomicReference<Disposable> disposable = new AtomicReference();
    private final AtomicReference<Socket> socket = new AtomicReference<Socket>(PROXY);
    private BehaviorRelay<ConnectionEvent> connectionEventRelay = BehaviorRelay.create();
    private static final Socket PROXY = new Socket(null, null, null){

        public String id() {
            return "proxy";
        }

        public Socket connect() {
            return this;
        }

        public boolean connected() {
            return false;
        }

        public Socket close() {
            return this;
        }
    };

    public RxSocket(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void init() {
        Disposable disposable = EkoDatabase.get().accountDao().getByIdFlowable(this.userId).takeUntil(account -> !account.isActive()).distinctUntilChanged((previous, next) -> {
            String prevToken = previous.getAccessToken();
            String nextToken = next.getAccessToken();
            boolean sameToken = Objects.equal((Object)prevToken, (Object)nextToken);
            AmityLog.INSTANCE.tag(TAG).i("distinctUntilChanged: sameToken: %s %s -> %s", new Object[]{sameToken, StringUtils.right((String)prevToken, (int)10), StringUtils.right((String)nextToken, (int)10)});
            return sameToken;
        }).doOnNext(account -> {
            Socket newSocket = RxSocket.createSocket(account, this.connectionEventRelay);
            Socket oldSocket = this.socket.getAndSet(newSocket);
            oldSocket.disconnect();
            AmityLog.INSTANCE.tag(TAG).w("disconnect oldSocket: %s", new Object[]{oldSocket.id()});
            newSocket.connect();
            AmityLog.INSTANCE.tag(TAG).w("connect newSocket: %s", new Object[]{newSocket.id()});
        }).doOnTerminate(() -> {
            Socket current = this.socket.get();
            AmityLog.INSTANCE.tag(TAG).i("onTerminate: socketId: %s userId: %s", new Object[]{current.id(), this.userId});
            current.disconnect();
        }).subscribe();
        DisposableHelper.set(this.disposable, (Disposable)disposable);
    }

    @NonNull
    private static Socket createSocket(EkoAccount account, Relay<ConnectionEvent> connectionEvent) throws URISyntaxException {
        String userId = account.getUserId();
        AmityLog.INSTANCE.tag(TAG).i("create new socket for: %s", new Object[]{userId});
        IO.Options options = new IO.Options();
        options.transports = new String[]{"websocket"};
        options.query = String.format("token=%s", account.getAccessToken());
        Socket socket = IO.socket((String)EkoEndpoint.INSTANCE.getSocketUrl(), (IO.Options)options);
        for (String event : CONNECTION_EVENTS) {
            socket.on(event, args -> {
                ConnectionEvent ce = new ConnectionEvent(userId, socket, event, args);
                connectionEvent.accept((Object)ce);
            });
        }
        return socket;
    }

    public Flowable<ConnectionEvent> getConnectionEvent() {
        return this.connectionEventRelay.toFlowable(BackpressureStrategy.LATEST);
    }

    public void dispose() {
        DisposableHelper.dispose(this.disposable);
    }

    public boolean isDisposed() {
        return DisposableHelper.isDisposed((Disposable)this.disposable.get());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hashCode", this.hashCode()).add("userId", (Object)this.userId).toString();
    }

    public static class ConnectionEvent {
        final String userId;
        final Socket socket;
        final String event;
        final Object[] args;

        private ConnectionEvent(@NonNull String userId, @NonNull Socket socket, @NonNull String event, @NonNull Object[] args) {
            this.userId = userId;
            this.socket = socket;
            this.event = event;
            this.args = args;
        }

        @NonNull
        public Socket getSocket() {
            return this.socket;
        }

        public boolean isConnected() {
            return this.socket.connected();
        }

        @NonNull
        public String getEvent() {
            return this.event;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("userId", (Object)this.userId).add("socket", (Object)this.socket.id()).add("event", (Object)this.event).add("args", (Object)Arrays.deepToString(this.args)).toString();
        }
    }
}

