/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.message;

import androidx.paging.DataSource;
import androidx.paging.ExperimentalPagingApi;
import androidx.paging.PagedList;
import androidx.paging.Pager;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import androidx.paging.RemoteMediator;
import androidx.paging.rxjava2.PagingRx;
import com.amity.socialcloud.sdk.chat.message.AmityMessage;
import com.amity.socialcloud.sdk.core.AmityTags;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.MessageQueryConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.GetMessageRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.MessageDeleteRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.MessageFlagRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.MessageUnflagRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.MessageUpdateDataRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoMessageBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageFlagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.model.EkoMessageFlag;
import com.ekoapp.ekosdk.internal.repository.message.MessageRepository;
import com.ekoapp.ekosdk.internal.repository.message.MessageRepository$sam$io_reactivex_functions_Function$0;
import com.ekoapp.ekosdk.internal.repository.message.MessageRxRemoteMediator;
import com.ekoapp.ekosdk.internal.repository.message.helper.AttachDataToMessageHelper;
import com.ekoapp.ekosdk.internal.repository.message.helper.MapToExternalModelHelper;
import com.ekoapp.ekosdk.internal.repository.message.helper.MessageRepositoryHelper;
import com.google.gson.JsonObject;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\b\u001a\u00020\tH\u0002J#\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b2\u0006\u0010\u0005\u001a\u00020\u0006JS\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00150\u000b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001cJU\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u001e0\u000b2\u0006\u0010\r\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\"\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010\u001a\u00a8\u0006%"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/message/MessageRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "deleteMessage", "Lio/reactivex/Completable;", "messageId", "", "flagMessage", "getDefaultPageSize", "", "getLatestMessage", "Lio/reactivex/Flowable;", "Lcom/amity/socialcloud/sdk/chat/message/AmityMessage;", "channelId", "isDeleted", "", "(Ljava/lang/String;Ljava/lang/Boolean;)Lio/reactivex/Flowable;", "getMessage", "getMessageFlag", "Lcom/ekoapp/ekosdk/internal/data/model/EkoMessageFlag;", "getMessagePagedList", "Landroidx/paging/PagedList;", "stackFromEnd", "parentId", "isFilterByParentId", "includingTags", "Lcom/amity/socialcloud/sdk/core/AmityTags;", "excludingTags", "(Ljava/lang/String;ZLjava/lang/String;ZLjava/lang/Boolean;Lcom/amity/socialcloud/sdk/core/AmityTags;Lcom/amity/socialcloud/sdk/core/AmityTags;)Lio/reactivex/Flowable;", "getMessagePagingData", "Landroidx/paging/PagingData;", "(Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/core/AmityTags;Lcom/amity/socialcloud/sdk/core/AmityTags;ZLjava/lang/Boolean;Z)Lio/reactivex/Flowable;", "unflagMessage", "updateMessage", "data", "Lcom/google/gson/JsonObject;", "tags", "amity-sdk_release"})
public final class MessageRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<PagedList<AmityMessage>> getMessagePagedList(@NotNull String channelId, boolean stackFromEnd, @Nullable String parentId, boolean isFilterByParentId, @Nullable Boolean isDeleted, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags) {
        Intrinsics.checkParameterIsNotNull((Object)channelId, (String)"channelId");
        Intrinsics.checkParameterIsNotNull((Object)includingTags, (String)"includingTags");
        Intrinsics.checkParameterIsNotNull((Object)excludingTags, (String)"excludingTags");
        UserDatabase userDatabase = UserDatabase.get();
        EkoMessageDao ekoMessageDao = userDatabase.messageDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoMessageDao, (String)"userDatabase.messageDao()");
        EkoMessageDao messageDao = ekoMessageDao;
        DataSource.Factory<Integer, EkoMessageEntity> localFactory = messageDao.getDataSource(channelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted);
        DataSource.Factory factory2 = localFactory.map((androidx.arch.core.util.Function)new AttachDataToMessageHelper()).map((androidx.arch.core.util.Function)new MapToExternalModelHelper());
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        EkoMessageBoundaryCallback boundaryCallback = new EkoMessageBoundaryCallback(channelId, parentId, isFilterByParentId, isDeleted, includingTags, excludingTags, stackFromEnd, this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        return this.createRxCollectionWithBoundaryCallback(factory2.map((androidx.arch.core.util.Function)boundaryCallback), boundaryCallback, stackFromEnd ? Integer.MAX_VALUE : 0);
    }

    @ExperimentalPagingApi
    @NotNull
    public final Flowable<PagingData<AmityMessage>> getMessagePagingData(@NotNull String channelId, @Nullable String parentId, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, boolean isFilterByParentId, @Nullable Boolean isDeleted, boolean stackFromEnd) {
        Intrinsics.checkParameterIsNotNull((Object)channelId, (String)"channelId");
        Intrinsics.checkParameterIsNotNull((Object)includingTags, (String)"includingTags");
        Intrinsics.checkParameterIsNotNull((Object)excludingTags, (String)"excludingTags");
        PagingConfig pagingConfig = new PagingConfig(this.getDefaultPageSize(), 0, false, 0, 0, 0, 58, null);
        EkoMessageQueryTokenDao ekoMessageQueryTokenDao = UserDatabase.get().messageQueryTokenDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoMessageQueryTokenDao, (String)"UserDatabase.get().messageQueryTokenDao()");
        Pager pager2 = new Pager(pagingConfig, null, (RemoteMediator)new MessageRxRemoteMediator(channelId, parentId, includingTags, excludingTags, isFilterByParentId, isDeleted, stackFromEnd, ekoMessageQueryTokenDao), (Function0)new Function0<PagingSource<Integer, EkoMessageEntity>>(channelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted){
            final /* synthetic */ String $channelId;
            final /* synthetic */ boolean $isFilterByParentId;
            final /* synthetic */ String $parentId;
            final /* synthetic */ AmityTags $includingTags;
            final /* synthetic */ AmityTags $excludingTags;
            final /* synthetic */ Boolean $isDeleted;

            public final PagingSource<Integer, EkoMessageEntity> invoke() {
                UserDatabase userDatabase = UserDatabase.get();
                EkoMessageDao ekoMessageDao = userDatabase.messageDao();
                Intrinsics.checkExpressionValueIsNotNull((Object)ekoMessageDao, (String)"userDatabase.messageDao()");
                EkoMessageDao messageDao = ekoMessageDao;
                PagingSource<Integer, EkoMessageEntity> pagingSource = messageDao.getPagingSource(this.$channelId, this.$isFilterByParentId, this.$parentId, this.$includingTags, this.$excludingTags, this.$isDeleted);
                Intrinsics.checkExpressionValueIsNotNull(pagingSource, (String)"messageDao.getPagingSour\u2026  isDeleted\n            )");
                return pagingSource;
            }
            {
                this.$channelId = string;
                this.$isFilterByParentId = bl;
                this.$parentId = string2;
                this.$includingTags = amityTags;
                this.$excludingTags = amityTags2;
                this.$isDeleted = bl2;
                super(0);
            }
        });
        Flowable flowable = PagingRx.getFlowable((Pager)pager2).map((Function)getMessagePagingData.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"pager.flowable\n         \u2026          }\n            }");
        return flowable;
    }

    @NotNull
    public final Flowable<AmityMessage> getMessage(@NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        GetMessageRequest request = new GetMessageRequest(messageId);
        EkoMessageDao messageDao = UserDatabase.get().messageDao();
        EkoSocket.call(Call.create(request, new MessageQueryConverter()));
        Function1 function1 = (Function1)new Function1<EkoMessageEntity, EkoMessageEntity>(new MessageRepositoryHelper()){

            @NotNull
            public final EkoMessageEntity invoke(@NotNull EkoMessageEntity p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((MessageRepositoryHelper)this.receiver).attachDataToEkoMessage(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MessageRepositoryHelper.class);
            }

            public final String getName() {
                return "attachDataToEkoMessage";
            }

            public final String getSignature() {
                return "attachDataToEkoMessage(Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;)Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;";
            }
        };
        MessageRepository$sam$io_reactivex_functions_Function$0 messageRepository$sam$io_reactivex_functions_Function$0 = new MessageRepository$sam$io_reactivex_functions_Function$0(function1);
        function1 = (Function1)new Function1<EkoMessageEntity, AmityMessage>(new MessageRepositoryHelper()){

            @NotNull
            public final AmityMessage invoke(@NotNull EkoMessageEntity p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((MessageRepositoryHelper)this.receiver).mapToExternalModel(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MessageRepositoryHelper.class);
            }

            public final String getName() {
                return "mapToExternalModel";
            }

            public final String getSignature() {
                return "mapToExternalModel(Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;)Lcom/amity/socialcloud/sdk/chat/message/AmityMessage;";
            }
        };
        Flowable flowable = messageDao.getById(messageId).map((Function)messageRepository$sam$io_reactivex_functions_Function$0).map((Function)new MessageRepository$sam$io_reactivex_functions_Function$0(function1));
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"messageDao.getById(messa\u2026er()::mapToExternalModel)");
        return flowable;
    }

    @NotNull
    public final Completable updateMessage(@NotNull String messageId, @Nullable JsonObject data, @Nullable AmityTags tags) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        MessageUpdateDataRequest request = new MessageUpdateDataRequest(messageId, data, tags);
        Completable completable = EkoSocket.rpc(request).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.rpc(request).ignoreElement()");
        return completable;
    }

    @NotNull
    public final Flowable<EkoMessageFlag> getMessageFlag(@NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        EkoMessageFlagDao flagDao = UserDatabase.get().messageFlagDao();
        Flowable<EkoMessageFlag> flowable = flagDao.getByMessageId(messageId);
        Intrinsics.checkExpressionValueIsNotNull(flowable, (String)"flagDao.getByMessageId(messageId)");
        return flowable;
    }

    @NotNull
    public final Completable flagMessage(@NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        MessageFlagRequest request = new MessageFlagRequest(messageId);
        Completable completable = EkoSocket.call(Call.create(request, new MessageQueryConverter())).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable unflagMessage(@NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        MessageUnflagRequest request = new MessageUnflagRequest(messageId);
        Completable completable = EkoSocket.call(Call.create(request, new MessageQueryConverter())).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable deleteMessage(@NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        UserDatabase userDatabase = UserDatabase.get();
        EkoMessageDao ekoMessageDao = userDatabase.messageDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoMessageDao, (String)"userDatabase.messageDao()");
        EkoMessageDao messageDao = ekoMessageDao;
        Completable completable = messageDao.getById(messageId).firstOrError().subscribeOn(Schedulers.io()).flatMapCompletable((Function)new Function<EkoMessageEntity, CompletableSource>(messageDao, messageId){
            final /* synthetic */ EkoMessageDao $messageDao;
            final /* synthetic */ String $messageId;

            public final CompletableSource apply(@NotNull EkoMessageEntity localMessage) {
                CompletableSource completableSource;
                Intrinsics.checkParameterIsNotNull((Object)localMessage, (String)"localMessage");
                if (Intrinsics.areEqual((Object)localMessage.getSyncState(), (Object)AmityMessage.State.FAILED.getStateName())) {
                    this.$messageDao.delete((EkoObject)localMessage);
                    completableSource = (CompletableSource)Completable.complete();
                } else {
                    MessageDeleteRequest request = new MessageDeleteRequest(this.$messageId);
                    completableSource = (CompletableSource)EkoSocket.rpc(request).ignoreElement();
                }
                return completableSource;
            }
            {
                this.$messageDao = ekoMessageDao;
                this.$messageId = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"messageDao.getById(messa\u2026          }\n            }");
        return completable;
    }

    @NotNull
    public final Flowable<AmityMessage> getLatestMessage(@NotNull String channelId, @Nullable Boolean isDeleted) {
        Intrinsics.checkParameterIsNotNull((Object)channelId, (String)"channelId");
        UserDatabase userDatabase = UserDatabase.get();
        EkoMessageDao ekoMessageDao = userDatabase.messageDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoMessageDao, (String)"userDatabase.messageDao()");
        EkoMessageDao messageDao = ekoMessageDao;
        Function1 function1 = (Function1)new Function1<EkoMessageEntity, EkoMessageEntity>(new MessageRepositoryHelper()){

            @NotNull
            public final EkoMessageEntity invoke(@NotNull EkoMessageEntity p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((MessageRepositoryHelper)this.receiver).attachDataToEkoMessage(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MessageRepositoryHelper.class);
            }

            public final String getName() {
                return "attachDataToEkoMessage";
            }

            public final String getSignature() {
                return "attachDataToEkoMessage(Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;)Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;";
            }
        };
        MessageRepository$sam$io_reactivex_functions_Function$0 messageRepository$sam$io_reactivex_functions_Function$0 = new MessageRepository$sam$io_reactivex_functions_Function$0(function1);
        function1 = (Function1)new Function1<EkoMessageEntity, AmityMessage>(new MessageRepositoryHelper()){

            @NotNull
            public final AmityMessage invoke(@NotNull EkoMessageEntity p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((MessageRepositoryHelper)this.receiver).mapToExternalModel(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MessageRepositoryHelper.class);
            }

            public final String getName() {
                return "mapToExternalModel";
            }

            public final String getSignature() {
                return "mapToExternalModel(Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;)Lcom/amity/socialcloud/sdk/chat/message/AmityMessage;";
            }
        };
        Flowable flowable = messageDao.getLatestMessage(channelId, isDeleted).map((Function)messageRepository$sam$io_reactivex_functions_Function$0).map((Function)new MessageRepository$sam$io_reactivex_functions_Function$0(function1));
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"messageDao.getLatestMess\u2026er()::mapToExternalModel)");
        return flowable;
    }
}

