/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonArrayTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoStreamDao;
import com.ekoapp.ekosdk.internal.entity.EkoStreamEntity;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoStreamDao_Impl
extends EkoStreamDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoStreamEntity> __insertionAdapterOfEkoStreamEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final JsonArrayTypeConverter __jsonArrayTypeConverter = new JsonArrayTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<EkoStreamEntity> __deletionAdapterOfEkoStreamEntity;
    private final EntityDeletionOrUpdateAdapter<EkoStreamEntity> __updateAdapterOfEkoStreamEntity;
    private final SharedSQLiteStatement __preparedStmtOfSoftDeleteImpl;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoStreamDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoStreamEntity = new EntityInsertionAdapter<EkoStreamEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `stream` (`streamId`,`title`,`description`,`metadata`,`isDeleted`,`thumbnailFileId`,`userId`,`watcherData`,`broadcasterData`,`recordings`,`status`,`isReconnecting`,`resolution`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoStreamEntity value) {
                if (value.getStreamId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getStreamId());
                }
                if (value.getTitle() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getTitle());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getDescription());
                }
                String _tmp = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                int _tmp_1 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                if (value.getThumbnailFileId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getThumbnailFileId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getUserId());
                }
                String _tmp_2 = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getWatcherData());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_2);
                }
                String _tmp_3 = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getBroadcasterData());
                if (_tmp_3 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_3);
                }
                String _tmp_4 = EkoStreamDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(value.getRecordings());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
                if (value.getStatus() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getStatus());
                }
                int _tmp_5 = value.isReconnecting() ? 1 : 0;
                stmt.bindLong(12, (long)_tmp_5);
                if (value.getResolution() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getResolution());
                }
                String _tmp_6 = EkoStreamDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_6);
                }
                String _tmp_7 = EkoStreamDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_7);
                }
            }
        };
        this.__deletionAdapterOfEkoStreamEntity = new EntityDeletionOrUpdateAdapter<EkoStreamEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `stream` WHERE `streamId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoStreamEntity value) {
                if (value.getStreamId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getStreamId());
                }
            }
        };
        this.__updateAdapterOfEkoStreamEntity = new EntityDeletionOrUpdateAdapter<EkoStreamEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `stream` SET `streamId` = ?,`title` = ?,`description` = ?,`metadata` = ?,`isDeleted` = ?,`thumbnailFileId` = ?,`userId` = ?,`watcherData` = ?,`broadcasterData` = ?,`recordings` = ?,`status` = ?,`isReconnecting` = ?,`resolution` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `streamId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoStreamEntity value) {
                if (value.getStreamId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getStreamId());
                }
                if (value.getTitle() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getTitle());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getDescription());
                }
                String _tmp = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                int _tmp_1 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                if (value.getThumbnailFileId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getThumbnailFileId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getUserId());
                }
                String _tmp_2 = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getWatcherData());
                if (_tmp_2 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_2);
                }
                String _tmp_3 = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getBroadcasterData());
                if (_tmp_3 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_3);
                }
                String _tmp_4 = EkoStreamDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(value.getRecordings());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
                if (value.getStatus() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getStatus());
                }
                int _tmp_5 = value.isReconnecting() ? 1 : 0;
                stmt.bindLong(12, (long)_tmp_5);
                if (value.getResolution() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getResolution());
                }
                String _tmp_6 = EkoStreamDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_6);
                }
                String _tmp_7 = EkoStreamDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, _tmp_7);
                }
                if (value.getStreamId() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getStreamId());
                }
            }
        };
        this.__preparedStmtOfSoftDeleteImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE stream set isDeleted = 1 where isDeleted = 0";
                return "UPDATE stream set isDeleted = 1 where isDeleted = 0";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from stream";
                return "DELETE from stream";
            }
        };
    }

    @Override
    void insertImpl(EkoStreamEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoStreamEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<EkoStreamEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoStreamEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoStreamEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoStreamEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<EkoStreamEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoStreamEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(EkoStreamEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoStreamEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void softDelete() {
        this.__db.beginTransaction();
        try {
            EkoStreamDao_Impl.super.softDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoStreamEntity object) {
        this.__db.beginTransaction();
        try {
            EkoStreamDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<EkoStreamEntity> objects) {
        this.__db.beginTransaction();
        try {
            EkoStreamDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoStreamEntity object) {
        this.__db.beginTransaction();
        try {
            EkoStreamDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void softDeleteImpl() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSoftDeleteImpl.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSoftDeleteImpl.release(_stmt);
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    DataSource.Factory<Integer, EkoStreamEntity> getAllImpl(String[] statuses) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from stream where status in (");
        int _inputSize = statuses.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and isDeleted = 0 order by createdAt DESC");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : statuses) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        return new DataSource.Factory<Integer, EkoStreamEntity>(){

            public LimitOffsetDataSource<EkoStreamEntity> create() {
                return new LimitOffsetDataSource<EkoStreamEntity>(EkoStreamDao_Impl.this.__db, _statement, false, true, new String[]{"stream"}){

                    protected List<EkoStreamEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfStreamId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"streamId");
                        int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"title");
                        int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"description");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfThumbnailFileId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"thumbnailFileId");
                        int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"userId");
                        int _cursorIndexOfWatcherData = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"watcherData");
                        int _cursorIndexOfBroadcasterData = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"broadcasterData");
                        int _cursorIndexOfRecordings = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"recordings");
                        int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"status");
                        int _cursorIndexOfIsReconnecting = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isReconnecting");
                        int _cursorIndexOfResolution = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"resolution");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        ArrayList<EkoStreamEntity> _res = new ArrayList<EkoStreamEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoStreamEntity _item_1 = new EkoStreamEntity();
                            String _tmpStreamId = cursor.isNull(_cursorIndexOfStreamId) ? null : cursor.getString(_cursorIndexOfStreamId);
                            _item_1.setStreamId(_tmpStreamId);
                            String _tmpTitle = cursor.isNull(_cursorIndexOfTitle) ? null : cursor.getString(_cursorIndexOfTitle);
                            _item_1.setTitle(_tmpTitle);
                            String _tmpDescription = cursor.isNull(_cursorIndexOfDescription) ? null : cursor.getString(_cursorIndexOfDescription);
                            _item_1.setDescription(_tmpDescription);
                            String _tmp = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                            _item_1.setMetadata(_tmpMetadata);
                            int _tmp_1 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_1 != 0;
                            _item_1.setDeleted(_tmpIsDeleted);
                            String _tmpThumbnailFileId = cursor.isNull(_cursorIndexOfThumbnailFileId) ? null : cursor.getString(_cursorIndexOfThumbnailFileId);
                            _item_1.setThumbnailFileId(_tmpThumbnailFileId);
                            String _tmpUserId = cursor.isNull(_cursorIndexOfUserId) ? null : cursor.getString(_cursorIndexOfUserId);
                            _item_1.setUserId(_tmpUserId);
                            String _tmp_2 = cursor.isNull(_cursorIndexOfWatcherData) ? null : cursor.getString(_cursorIndexOfWatcherData);
                            JsonObject _tmpWatcherData = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                            _item_1.setWatcherData(_tmpWatcherData);
                            String _tmp_3 = cursor.isNull(_cursorIndexOfBroadcasterData) ? null : cursor.getString(_cursorIndexOfBroadcasterData);
                            JsonObject _tmpBroadcasterData = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                            _item_1.setBroadcasterData(_tmpBroadcasterData);
                            String _tmp_4 = cursor.isNull(_cursorIndexOfRecordings) ? null : cursor.getString(_cursorIndexOfRecordings);
                            JsonArray _tmpRecordings = EkoStreamDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_4);
                            _item_1.setRecordings(_tmpRecordings);
                            String _tmpStatus = cursor.isNull(_cursorIndexOfStatus) ? null : cursor.getString(_cursorIndexOfStatus);
                            _item_1.setStatus(_tmpStatus);
                            int _tmp_5 = cursor.getInt(_cursorIndexOfIsReconnecting);
                            boolean _tmpIsReconnecting = _tmp_5 != 0;
                            _item_1.setReconnecting(_tmpIsReconnecting);
                            String _tmpResolution = cursor.isNull(_cursorIndexOfResolution) ? null : cursor.getString(_cursorIndexOfResolution);
                            _item_1.setResolution(_tmpResolution);
                            String _tmp_6 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoStreamDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                            _item_1.setCreatedAt(_tmpCreatedAt);
                            String _tmp_7 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoStreamDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                            _item_1.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item_1);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    Flowable<EkoStreamEntity> getByIdImpl(String streamId) {
        String _sql = "SELECT * from stream where streamId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from stream where streamId = ?", (int)1);
        int _argIndex = 1;
        if (streamId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, streamId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"stream"}, (Callable)new Callable<EkoStreamEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoStreamEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoStreamDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoStreamEntity _result;
                    int _cursorIndexOfStreamId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"streamId");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfDescription = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"description");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfThumbnailFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thumbnailFileId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfWatcherData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"watcherData");
                    int _cursorIndexOfBroadcasterData = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"broadcasterData");
                    int _cursorIndexOfRecordings = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"recordings");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfIsReconnecting = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isReconnecting");
                    int _cursorIndexOfResolution = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"resolution");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoStreamEntity();
                        String _tmpStreamId = _cursor.isNull(_cursorIndexOfStreamId) ? null : _cursor.getString(_cursorIndexOfStreamId);
                        _result.setStreamId(_tmpStreamId);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        _result.setTitle(_tmpTitle);
                        String _tmpDescription = _cursor.isNull(_cursorIndexOfDescription) ? null : _cursor.getString(_cursorIndexOfDescription);
                        _result.setDescription(_tmpDescription);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                        _result.setMetadata(_tmpMetadata);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_1 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmpThumbnailFileId = _cursor.isNull(_cursorIndexOfThumbnailFileId) ? null : _cursor.getString(_cursorIndexOfThumbnailFileId);
                        _result.setThumbnailFileId(_tmpThumbnailFileId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmp_2 = _cursor.isNull(_cursorIndexOfWatcherData) ? null : _cursor.getString(_cursorIndexOfWatcherData);
                        JsonObject _tmpWatcherData = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                        _result.setWatcherData(_tmpWatcherData);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfBroadcasterData) ? null : _cursor.getString(_cursorIndexOfBroadcasterData);
                        JsonObject _tmpBroadcasterData = EkoStreamDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                        _result.setBroadcasterData(_tmpBroadcasterData);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfRecordings) ? null : _cursor.getString(_cursorIndexOfRecordings);
                        JsonArray _tmpRecordings = EkoStreamDao_Impl.this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_4);
                        _result.setRecordings(_tmpRecordings);
                        String _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : _cursor.getString(_cursorIndexOfStatus);
                        _result.setStatus(_tmpStatus);
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfIsReconnecting);
                        boolean _tmpIsReconnecting = _tmp_5 != 0;
                        _result.setReconnecting(_tmpIsReconnecting);
                        String _tmpResolution = _cursor.isNull(_cursorIndexOfResolution) ? null : _cursor.getString(_cursorIndexOfResolution);
                        _result.setResolution(_tmpResolution);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoStreamDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoStreamDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    EkoStreamEntity ekoStreamEntity = _result;
                    return ekoStreamEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

