/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.paging.PagingSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.core.AmityTags;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.EkoChannelExtra;
import com.ekoapp.ekosdk.EkoChannelWithMembershipAndExtra;
import com.ekoapp.ekosdk.internal.EkoChannelEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelMembershipDto;
import com.ekoapp.ekosdk.internal.api.dto.OldEkoChannelAndChannelMembershipDto;
import com.ekoapp.ekosdk.internal.data.converter.EkoTagsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelDao;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import com.google.gson.JsonObject;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoChannelDao_Impl
extends EkoChannelDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EkoChannelEntity> __insertionAdapterOfEkoChannelEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EkoTagsTypeConverter __ekoTagsTypeConverter = new EkoTagsTypeConverter();
    private final EntityDeletionOrUpdateAdapter<EkoChannelEntity> __deletionAdapterOfEkoChannelEntity;
    private final EntityDeletionOrUpdateAdapter<EkoChannelEntity> __updateAdapterOfEkoChannelEntity;
    private final SharedSQLiteStatement __preparedStmtOfUpdateLastActivity;
    private final SharedSQLiteStatement __preparedStmtOfUpdateMemberCount;
    private final SharedSQLiteStatement __preparedStmtOfUpdateMessageCount;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByIdImpl;

    public EkoChannelDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoChannelEntity = new EntityInsertionAdapter<EkoChannelEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `channel` (`channelId`,`displayName`,`metadata`,`messageCount`,`isRateLimited`,`isMuted`,`lastActivity`,`memberCount`,`tags`,`channelType`,`avatarFileId`,`isDeleted`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoChannelEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getDisplayName());
                }
                String _tmp = EkoChannelDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                stmt.bindLong(4, (long)value.getMessageCount());
                int _tmp_1 = value.isRateLimited() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                int _tmp_2 = value.isMuted() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_2);
                String _tmp_3 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastActivity());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                stmt.bindLong(8, (long)value.getMemberCount());
                String _tmp_4 = EkoChannelDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.getTags());
                if (_tmp_4 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_4);
                }
                if (value.getChannelType() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getChannelType());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getAvatarFileId());
                }
                int _tmp_5 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(12, (long)_tmp_5);
                String _tmp_6 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_6);
                }
                String _tmp_7 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_7);
                }
            }
        };
        this.__deletionAdapterOfEkoChannelEntity = new EntityDeletionOrUpdateAdapter<EkoChannelEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `channel` WHERE `channelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoChannelEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
            }
        };
        this.__updateAdapterOfEkoChannelEntity = new EntityDeletionOrUpdateAdapter<EkoChannelEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `channel` SET `channelId` = ?,`displayName` = ?,`metadata` = ?,`messageCount` = ?,`isRateLimited` = ?,`isMuted` = ?,`lastActivity` = ?,`memberCount` = ?,`tags` = ?,`channelType` = ?,`avatarFileId` = ?,`isDeleted` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `channelId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoChannelEntity value) {
                if (value.getChannelId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getChannelId());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getDisplayName());
                }
                String _tmp = EkoChannelDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                stmt.bindLong(4, (long)value.getMessageCount());
                int _tmp_1 = value.isRateLimited() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                int _tmp_2 = value.isMuted() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_2);
                String _tmp_3 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getLastActivity());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                stmt.bindLong(8, (long)value.getMemberCount());
                String _tmp_4 = EkoChannelDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.getTags());
                if (_tmp_4 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_4);
                }
                if (value.getChannelType() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getChannelType());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getAvatarFileId());
                }
                int _tmp_5 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(12, (long)_tmp_5);
                String _tmp_6 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_6);
                }
                String _tmp_7 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_7);
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getChannelId());
                }
            }
        };
        this.__preparedStmtOfUpdateLastActivity = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel set lastActivity = ? where channelId = ?";
                return "UPDATE channel set lastActivity = ? where channelId = ?";
            }
        };
        this.__preparedStmtOfUpdateMemberCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel set memberCount = ? where channelId = ?";
                return "UPDATE channel set memberCount = ? where channelId = ?";
            }
        };
        this.__preparedStmtOfUpdateMessageCount = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE channel set messageCount = ? where channelId = ? and messageCount < ?";
                return "UPDATE channel set messageCount = ? where channelId = ? and messageCount < ?";
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel";
                return "DELETE from channel";
            }
        };
        this.__preparedStmtOfDeleteByIdImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from channel where channelId = ?";
                return "DELETE from channel where channelId = ?";
            }
        };
    }

    @Override
    void insertImpl(EkoChannelEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoChannelEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<EkoChannelEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoChannelEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoChannelEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoChannelEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<EkoChannelEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoChannelEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(EkoChannelEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoChannelEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertDto(List<EkoChannelDto> channelDtoList, List<EkoChannelMembershipDto> channelMembershipDtoList) {
        this.__db.beginTransaction();
        try {
            EkoChannelDao_Impl.super.insertDto(channelDtoList, channelMembershipDtoList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertDto(List<OldEkoChannelAndChannelMembershipDto> list) {
        this.__db.beginTransaction();
        try {
            EkoChannelDao_Impl.super.insertDto(list);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteById(String channelId) {
        this.__db.beginTransaction();
        try {
            EkoChannelDao_Impl.super.deleteById(channelId);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAllLocallyInactiveChannelsAndUpdateAllActiveChannelsToNotReading() {
        this.__db.beginTransaction();
        try {
            EkoChannelDao_Impl.super.deleteAllLocallyInactiveChannelsAndUpdateAllActiveChannelsToNotReading();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoChannelEntity channel) {
        this.__db.beginTransaction();
        try {
            EkoChannelDao_Impl.super.insert(channel);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<EkoChannelEntity> channels) {
        this.__db.beginTransaction();
        try {
            EkoChannelDao_Impl.super.insert(channels);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoChannelEntity channel) {
        this.__db.beginTransaction();
        try {
            EkoChannelDao_Impl.super.update(channel);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLastActivity(String channelId, DateTime lastActivity) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateLastActivity.acquire();
        int _argIndex = 1;
        String _tmp = this.__dateTimeTypeConverter.dateTimeToString(lastActivity);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateLastActivity.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMemberCount(String channelId, int memberCount) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateMemberCount.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)memberCount);
        _argIndex = 2;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateMemberCount.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMessageCount(String channelId, int messageCount) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateMessageCount.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)messageCount);
        _argIndex = 2;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        _argIndex = 3;
        _stmt.bindLong(_argIndex, (long)messageCount);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateMessageCount.release(_stmt);
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deleteByIdImpl(String channelId) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByIdImpl.acquire();
        int _argIndex = 1;
        if (channelId == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, channelId);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByIdImpl.release(_stmt);
        }
    }

    @Override
    Flowable<List<EkoChannelWithMembershipAndExtra>> getTotalUnreadCountImpl(String userId, String membership) {
        String _sql = "SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId in (SELECT channelId from channel_membership where membership = ?) and channel_membership.userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId in (SELECT channelId from channel_membership where membership = ?) and channel_membership.userId = ?", (int)2);
        int _argIndex = 1;
        if (membership == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, membership);
        }
        _argIndex = 2;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel", "channel_membership", "channel_extra"}, (Callable)new Callable<List<EkoChannelWithMembershipAndExtra>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<EkoChannelWithMembershipAndExtra> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageCount");
                    int _cursorIndexOfIsRateLimited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRateLimited");
                    int _cursorIndexOfIsMuted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isMuted");
                    int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActivity");
                    int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberCount");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelType");
                    int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membership_readToSegment");
                    int _cursorIndexOfLocalReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extra_localReadToSegment");
                    ArrayList<EkoChannelWithMembershipAndExtra> _result = new ArrayList<EkoChannelWithMembershipAndExtra>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        EkoChannelExtra _tmpChannelExtra;
                        ChannelMembershipEntity _tmpChannelMembership;
                        if (!_cursor.isNull(_cursorIndexOfReadToSegment)) {
                            _tmpChannelMembership = new ChannelMembershipEntity();
                            int _tmpReadToSegment = _cursor.getInt(_cursorIndexOfReadToSegment);
                            _tmpChannelMembership.setReadToSegment(_tmpReadToSegment);
                        } else {
                            _tmpChannelMembership = null;
                        }
                        if (!_cursor.isNull(_cursorIndexOfLocalReadToSegment)) {
                            _tmpChannelExtra = new EkoChannelExtra(null);
                            int _tmpLocalReadToSegment = _cursor.getInt(_cursorIndexOfLocalReadToSegment);
                            _tmpChannelExtra.setLocalReadToSegment(_tmpLocalReadToSegment);
                        } else {
                            _tmpChannelExtra = null;
                        }
                        EkoChannelWithMembershipAndExtra _item = new EkoChannelWithMembershipAndExtra();
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _item.setChannelId(_tmpChannelId);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        _item.setDisplayName(_tmpDisplayName);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoChannelDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                        _item.setMetadata(_tmpMetadata);
                        int _tmpMessageCount = _cursor.getInt(_cursorIndexOfMessageCount);
                        _item.setMessageCount(_tmpMessageCount);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsRateLimited);
                        boolean _tmpIsRateLimited = _tmp_1 != 0;
                        _item.setRateLimited(_tmpIsRateLimited);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfIsMuted);
                        boolean _tmpIsMuted = _tmp_2 != 0;
                        _item.setMuted(_tmpIsMuted);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfLastActivity) ? null : _cursor.getString(_cursorIndexOfLastActivity);
                        DateTime _tmpLastActivity = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _item.setLastActivity(_tmpLastActivity);
                        int _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                        _item.setMemberCount(_tmpMemberCount);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoChannelDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_4);
                        _item.setTags(_tmpTags);
                        String _tmpChannelType = _cursor.isNull(_cursorIndexOfChannelType) ? null : _cursor.getString(_cursorIndexOfChannelType);
                        _item.setChannelType(_tmpChannelType);
                        String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                        _item.setAvatarFileId(_tmpAvatarFileId);
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_5 != 0;
                        _item.setDeleted(_tmpIsDeleted);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        _item.setChannelMembership(_tmpChannelMembership);
                        _item.setChannelExtra(_tmpChannelExtra);
                        _result.add(_item);
                    }
                    ArrayList<EkoChannelWithMembershipAndExtra> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    DataSource.Factory<Integer, EkoChannelWithMembershipAndExtra> getDataSourceImpl(String userId, String[] channelTypes, boolean isFilterByTags, String[] includingTags, String[] excludingTags, boolean isFilterByMemberships, String[] memberships, Boolean isDeleted) {
        Integer _tmp_3;
        Integer _tmp_2;
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel_membership.userId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and channel.channelType in (");
        int _inputSize = channelTypes.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then channel.channelId in (SELECT channelId from channel_tag where tagName in (");
        int _inputSize_1 = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) else channel.channelId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then channel.channelId in (SELECT channelId from channel_membership where membership in (");
        int _inputSize_2 = memberships.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_2);
        _stringBuilder.append(") and userId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(") else channel.channelId is not null end and channel.channelId not in (SELECT channelId from channel_tag where tagName in (");
        int _inputSize_3 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_3);
        _stringBuilder.append(")) and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then channel.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else channel.channelId is not null end order by channel.lastActivity DESC");
        String _sql = _stringBuilder.toString();
        int _argCount = 6 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 2;
        for (String _item : channelTypes) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize;
        int _tmp = isFilterByTags ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 3 + _inputSize;
        for (String _item_1 : includingTags) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        _argIndex = 3 + _inputSize + _inputSize_1;
        int _tmp_1 = isFilterByMemberships ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        _argIndex = 4 + _inputSize + _inputSize_1;
        for (String _item_2 : memberships) {
            if (_item_2 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_2);
            }
            ++_argIndex;
        }
        _argIndex = 4 + _inputSize + _inputSize_1 + _inputSize_2;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 5 + _inputSize + _inputSize_1 + _inputSize_2;
        for (String _item_3 : excludingTags) {
            if (_item_3 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_3);
            }
            ++_argIndex;
        }
        _argIndex = 5 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
        Integer n = isDeleted == null ? null : (_tmp_2 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 6 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
        Integer n2 = isDeleted == null ? null : (_tmp_3 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        return new DataSource.Factory<Integer, EkoChannelWithMembershipAndExtra>(){

            public LimitOffsetDataSource<EkoChannelWithMembershipAndExtra> create() {
                return new LimitOffsetDataSource<EkoChannelWithMembershipAndExtra>(EkoChannelDao_Impl.this.__db, _statement, false, true, new String[]{"channel", "channel_membership", "channel_extra", "channel_tag"}){

                    protected List<EkoChannelWithMembershipAndExtra> convertRows(Cursor cursor) {
                        int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"channelId");
                        int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"displayName");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"messageCount");
                        int _cursorIndexOfIsRateLimited = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isRateLimited");
                        int _cursorIndexOfIsMuted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isMuted");
                        int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastActivity");
                        int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"memberCount");
                        int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"tags");
                        int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"channelType");
                        int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"avatarFileId");
                        int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"membership_readToSegment");
                        int _cursorIndexOfLocalReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"extra_localReadToSegment");
                        ArrayList<EkoChannelWithMembershipAndExtra> _res = new ArrayList<EkoChannelWithMembershipAndExtra>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoChannelExtra _tmpChannelExtra;
                            ChannelMembershipEntity _tmpChannelMembership;
                            if (!cursor.isNull(_cursorIndexOfReadToSegment)) {
                                _tmpChannelMembership = new ChannelMembershipEntity();
                                int _tmpReadToSegment = cursor.getInt(_cursorIndexOfReadToSegment);
                                _tmpChannelMembership.setReadToSegment(_tmpReadToSegment);
                            } else {
                                _tmpChannelMembership = null;
                            }
                            if (!cursor.isNull(_cursorIndexOfLocalReadToSegment)) {
                                _tmpChannelExtra = new EkoChannelExtra(null);
                                int _tmpLocalReadToSegment = cursor.getInt(_cursorIndexOfLocalReadToSegment);
                                _tmpChannelExtra.setLocalReadToSegment(_tmpLocalReadToSegment);
                            } else {
                                _tmpChannelExtra = null;
                            }
                            EkoChannelWithMembershipAndExtra _item_4 = new EkoChannelWithMembershipAndExtra();
                            String _tmpChannelId = cursor.isNull(_cursorIndexOfChannelId) ? null : cursor.getString(_cursorIndexOfChannelId);
                            _item_4.setChannelId(_tmpChannelId);
                            String _tmpDisplayName = cursor.isNull(_cursorIndexOfDisplayName) ? null : cursor.getString(_cursorIndexOfDisplayName);
                            _item_4.setDisplayName(_tmpDisplayName);
                            String _tmp_4 = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoChannelDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item_4.setMetadata(_tmpMetadata);
                            int _tmpMessageCount = cursor.getInt(_cursorIndexOfMessageCount);
                            _item_4.setMessageCount(_tmpMessageCount);
                            int _tmp_5 = cursor.getInt(_cursorIndexOfIsRateLimited);
                            boolean _tmpIsRateLimited = _tmp_5 != 0;
                            _item_4.setRateLimited(_tmpIsRateLimited);
                            int _tmp_6 = cursor.getInt(_cursorIndexOfIsMuted);
                            boolean _tmpIsMuted = _tmp_6 != 0;
                            _item_4.setMuted(_tmpIsMuted);
                            String _tmp_7 = cursor.isNull(_cursorIndexOfLastActivity) ? null : cursor.getString(_cursorIndexOfLastActivity);
                            DateTime _tmpLastActivity = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                            _item_4.setLastActivity(_tmpLastActivity);
                            int _tmpMemberCount = cursor.getInt(_cursorIndexOfMemberCount);
                            _item_4.setMemberCount(_tmpMemberCount);
                            String _tmp_8 = cursor.isNull(_cursorIndexOfTags) ? null : cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoChannelDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_8);
                            _item_4.setTags(_tmpTags);
                            String _tmpChannelType = cursor.isNull(_cursorIndexOfChannelType) ? null : cursor.getString(_cursorIndexOfChannelType);
                            _item_4.setChannelType(_tmpChannelType);
                            String _tmpAvatarFileId = cursor.isNull(_cursorIndexOfAvatarFileId) ? null : cursor.getString(_cursorIndexOfAvatarFileId);
                            _item_4.setAvatarFileId(_tmpAvatarFileId);
                            int _tmp_9 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_9 != 0;
                            _item_4.setDeleted(_tmpIsDeleted);
                            String _tmp_10 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item_4.setCreatedAt(_tmpCreatedAt);
                            String _tmp_11 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                            _item_4.setUpdatedAt(_tmpUpdatedAt);
                            _item_4.setChannelMembership(_tmpChannelMembership);
                            _item_4.setChannelExtra(_tmpChannelExtra);
                            _res.add(_item_4);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    PagingSource<Integer, EkoChannelWithMembershipAndExtra> getPagingSourceImpl(String userId, String[] channelTypes, boolean isFilterByTags, String[] includingTags, String[] excludingTags, boolean isFilterByMemberships, String[] memberships, Boolean isDeleted) {
        Integer _tmp_3;
        Integer _tmp_2;
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel_membership.userId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and channel.channelType in (");
        int _inputSize = channelTypes.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then channel.channelId in (SELECT channelId from channel_tag where tagName in (");
        int _inputSize_1 = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) else channel.channelId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then channel.channelId in (SELECT channelId from channel_membership where membership in (");
        int _inputSize_2 = memberships.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_2);
        _stringBuilder.append(") and userId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(") else channel.channelId is not null end and channel.channelId not in (SELECT channelId from channel_tag where tagName in (");
        int _inputSize_3 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_3);
        _stringBuilder.append(")) and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then channel.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else channel.channelId is not null end order by channel.lastActivity DESC");
        String _sql = _stringBuilder.toString();
        int _argCount = 6 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 2;
        for (String _item : channelTypes) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        _argIndex = 2 + _inputSize;
        int _tmp = isFilterByTags ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp);
        _argIndex = 3 + _inputSize;
        for (String _item_1 : includingTags) {
            if (_item_1 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_1);
            }
            ++_argIndex;
        }
        _argIndex = 3 + _inputSize + _inputSize_1;
        int _tmp_1 = isFilterByMemberships ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_1);
        _argIndex = 4 + _inputSize + _inputSize_1;
        for (String _item_2 : memberships) {
            if (_item_2 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_2);
            }
            ++_argIndex;
        }
        _argIndex = 4 + _inputSize + _inputSize_1 + _inputSize_2;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 5 + _inputSize + _inputSize_1 + _inputSize_2;
        for (String _item_3 : excludingTags) {
            if (_item_3 == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item_3);
            }
            ++_argIndex;
        }
        _argIndex = 5 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
        Integer n = isDeleted == null ? null : (_tmp_2 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_2 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_2.intValue());
        }
        _argIndex = 6 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
        Integer n2 = isDeleted == null ? null : (_tmp_3 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_3 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_3.intValue());
        }
        return (PagingSource)new DataSource.Factory<Integer, EkoChannelWithMembershipAndExtra>(){

            public LimitOffsetDataSource<EkoChannelWithMembershipAndExtra> create() {
                return new LimitOffsetDataSource<EkoChannelWithMembershipAndExtra>(EkoChannelDao_Impl.this.__db, _statement, false, false, new String[]{"channel", "channel_membership", "channel_extra", "channel_tag"}){

                    protected List<EkoChannelWithMembershipAndExtra> convertRows(Cursor cursor) {
                        int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"channelId");
                        int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"displayName");
                        int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"metadata");
                        int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"messageCount");
                        int _cursorIndexOfIsRateLimited = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isRateLimited");
                        int _cursorIndexOfIsMuted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isMuted");
                        int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"lastActivity");
                        int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"memberCount");
                        int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"tags");
                        int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"channelType");
                        int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"avatarFileId");
                        int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"isDeleted");
                        int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"createdAt");
                        int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"updatedAt");
                        int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"membership_readToSegment");
                        int _cursorIndexOfLocalReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)cursor, (String)"extra_localReadToSegment");
                        ArrayList<EkoChannelWithMembershipAndExtra> _res = new ArrayList<EkoChannelWithMembershipAndExtra>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoChannelExtra _tmpChannelExtra;
                            ChannelMembershipEntity _tmpChannelMembership;
                            if (!cursor.isNull(_cursorIndexOfReadToSegment)) {
                                _tmpChannelMembership = new ChannelMembershipEntity();
                                int _tmpReadToSegment = cursor.getInt(_cursorIndexOfReadToSegment);
                                _tmpChannelMembership.setReadToSegment(_tmpReadToSegment);
                            } else {
                                _tmpChannelMembership = null;
                            }
                            if (!cursor.isNull(_cursorIndexOfLocalReadToSegment)) {
                                _tmpChannelExtra = new EkoChannelExtra(null);
                                int _tmpLocalReadToSegment = cursor.getInt(_cursorIndexOfLocalReadToSegment);
                                _tmpChannelExtra.setLocalReadToSegment(_tmpLocalReadToSegment);
                            } else {
                                _tmpChannelExtra = null;
                            }
                            EkoChannelWithMembershipAndExtra _item_4 = new EkoChannelWithMembershipAndExtra();
                            String _tmpChannelId = cursor.isNull(_cursorIndexOfChannelId) ? null : cursor.getString(_cursorIndexOfChannelId);
                            _item_4.setChannelId(_tmpChannelId);
                            String _tmpDisplayName = cursor.isNull(_cursorIndexOfDisplayName) ? null : cursor.getString(_cursorIndexOfDisplayName);
                            _item_4.setDisplayName(_tmpDisplayName);
                            String _tmp_4 = cursor.isNull(_cursorIndexOfMetadata) ? null : cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoChannelDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item_4.setMetadata(_tmpMetadata);
                            int _tmpMessageCount = cursor.getInt(_cursorIndexOfMessageCount);
                            _item_4.setMessageCount(_tmpMessageCount);
                            int _tmp_5 = cursor.getInt(_cursorIndexOfIsRateLimited);
                            boolean _tmpIsRateLimited = _tmp_5 != 0;
                            _item_4.setRateLimited(_tmpIsRateLimited);
                            int _tmp_6 = cursor.getInt(_cursorIndexOfIsMuted);
                            boolean _tmpIsMuted = _tmp_6 != 0;
                            _item_4.setMuted(_tmpIsMuted);
                            String _tmp_7 = cursor.isNull(_cursorIndexOfLastActivity) ? null : cursor.getString(_cursorIndexOfLastActivity);
                            DateTime _tmpLastActivity = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                            _item_4.setLastActivity(_tmpLastActivity);
                            int _tmpMemberCount = cursor.getInt(_cursorIndexOfMemberCount);
                            _item_4.setMemberCount(_tmpMemberCount);
                            String _tmp_8 = cursor.isNull(_cursorIndexOfTags) ? null : cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoChannelDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_8);
                            _item_4.setTags(_tmpTags);
                            String _tmpChannelType = cursor.isNull(_cursorIndexOfChannelType) ? null : cursor.getString(_cursorIndexOfChannelType);
                            _item_4.setChannelType(_tmpChannelType);
                            String _tmpAvatarFileId = cursor.isNull(_cursorIndexOfAvatarFileId) ? null : cursor.getString(_cursorIndexOfAvatarFileId);
                            _item_4.setAvatarFileId(_tmpAvatarFileId);
                            int _tmp_9 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_9 != 0;
                            _item_4.setDeleted(_tmpIsDeleted);
                            String _tmp_10 = cursor.isNull(_cursorIndexOfCreatedAt) ? null : cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item_4.setCreatedAt(_tmpCreatedAt);
                            String _tmp_11 = cursor.isNull(_cursorIndexOfUpdatedAt) ? null : cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                            _item_4.setUpdatedAt(_tmpUpdatedAt);
                            _item_4.setChannelMembership(_tmpChannelMembership);
                            _item_4.setChannelExtra(_tmpChannelExtra);
                            _res.add(_item_4);
                        }
                        return _res;
                    }
                };
            }
        }.asPagingSourceFactory().invoke();
    }

    @Override
    Flowable<EkoChannelWithMembershipAndExtra> getChannelImpl(String channelId) {
        String _sql = "SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel", "channel_membership", "channel_extra"}, (Callable)new Callable<EkoChannelWithMembershipAndExtra>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoChannelWithMembershipAndExtra call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    EkoChannelWithMembershipAndExtra _result;
                    int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
                    int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
                    int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
                    int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageCount");
                    int _cursorIndexOfIsRateLimited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRateLimited");
                    int _cursorIndexOfIsMuted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isMuted");
                    int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActivity");
                    int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberCount");
                    int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
                    int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelType");
                    int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membership_readToSegment");
                    int _cursorIndexOfLocalReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extra_localReadToSegment");
                    if (_cursor.moveToFirst()) {
                        EkoChannelExtra _tmpChannelExtra;
                        ChannelMembershipEntity _tmpChannelMembership;
                        if (!_cursor.isNull(_cursorIndexOfReadToSegment)) {
                            _tmpChannelMembership = new ChannelMembershipEntity();
                            int _tmpReadToSegment = _cursor.getInt(_cursorIndexOfReadToSegment);
                            _tmpChannelMembership.setReadToSegment(_tmpReadToSegment);
                        } else {
                            _tmpChannelMembership = null;
                        }
                        if (!_cursor.isNull(_cursorIndexOfLocalReadToSegment)) {
                            _tmpChannelExtra = new EkoChannelExtra(null);
                            int _tmpLocalReadToSegment = _cursor.getInt(_cursorIndexOfLocalReadToSegment);
                            _tmpChannelExtra.setLocalReadToSegment(_tmpLocalReadToSegment);
                        } else {
                            _tmpChannelExtra = null;
                        }
                        _result = new EkoChannelWithMembershipAndExtra();
                        String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                        _result.setDisplayName(_tmpDisplayName);
                        String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoChannelDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                        _result.setMetadata(_tmpMetadata);
                        int _tmpMessageCount = _cursor.getInt(_cursorIndexOfMessageCount);
                        _result.setMessageCount(_tmpMessageCount);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsRateLimited);
                        boolean _tmpIsRateLimited = _tmp_1 != 0;
                        _result.setRateLimited(_tmpIsRateLimited);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfIsMuted);
                        boolean _tmpIsMuted = _tmp_2 != 0;
                        _result.setMuted(_tmpIsMuted);
                        String _tmp_3 = _cursor.isNull(_cursorIndexOfLastActivity) ? null : _cursor.getString(_cursorIndexOfLastActivity);
                        DateTime _tmpLastActivity = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setLastActivity(_tmpLastActivity);
                        int _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                        _result.setMemberCount(_tmpMemberCount);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoChannelDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_4);
                        _result.setTags(_tmpTags);
                        String _tmpChannelType = _cursor.isNull(_cursorIndexOfChannelType) ? null : _cursor.getString(_cursorIndexOfChannelType);
                        _result.setChannelType(_tmpChannelType);
                        String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                        _result.setAvatarFileId(_tmpAvatarFileId);
                        int _tmp_5 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_5 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoChannelDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        _result.setChannelMembership(_tmpChannelMembership);
                        _result.setChannelExtra(_tmpChannelExtra);
                    } else {
                        _result = null;
                    }
                    EkoChannelWithMembershipAndExtra ekoChannelWithMembershipAndExtra = _result;
                    return ekoChannelWithMembershipAndExtra;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EkoChannelWithMembershipAndExtra getByIdNowImpl(String channelId) {
        String _sql = "SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (channelId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, channelId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            EkoChannelWithMembershipAndExtra _result;
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageCount");
            int _cursorIndexOfIsRateLimited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRateLimited");
            int _cursorIndexOfIsMuted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isMuted");
            int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActivity");
            int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberCount");
            int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
            int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelType");
            int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membership_readToSegment");
            int _cursorIndexOfLocalReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extra_localReadToSegment");
            if (_cursor.moveToFirst()) {
                EkoChannelExtra _tmpChannelExtra;
                ChannelMembershipEntity _tmpChannelMembership;
                if (!_cursor.isNull(_cursorIndexOfReadToSegment)) {
                    _tmpChannelMembership = new ChannelMembershipEntity();
                    int _tmpReadToSegment = _cursor.getInt(_cursorIndexOfReadToSegment);
                    _tmpChannelMembership.setReadToSegment(_tmpReadToSegment);
                } else {
                    _tmpChannelMembership = null;
                }
                if (!_cursor.isNull(_cursorIndexOfLocalReadToSegment)) {
                    _tmpChannelExtra = new EkoChannelExtra(null);
                    int _tmpLocalReadToSegment = _cursor.getInt(_cursorIndexOfLocalReadToSegment);
                    _tmpChannelExtra.setLocalReadToSegment(_tmpLocalReadToSegment);
                } else {
                    _tmpChannelExtra = null;
                }
                _result = new EkoChannelWithMembershipAndExtra();
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                _result.setDisplayName(_tmpDisplayName);
                String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _result.setMetadata(_tmpMetadata);
                int _tmpMessageCount = _cursor.getInt(_cursorIndexOfMessageCount);
                _result.setMessageCount(_tmpMessageCount);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsRateLimited);
                boolean _tmpIsRateLimited = _tmp_1 != 0;
                _result.setRateLimited(_tmpIsRateLimited);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsMuted);
                boolean _tmpIsMuted = _tmp_2 != 0;
                _result.setMuted(_tmpIsMuted);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfLastActivity) ? null : _cursor.getString(_cursorIndexOfLastActivity);
                DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setLastActivity(_tmpLastActivity);
                int _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                _result.setMemberCount(_tmpMemberCount);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_4);
                _result.setTags(_tmpTags);
                String _tmpChannelType = _cursor.isNull(_cursorIndexOfChannelType) ? null : _cursor.getString(_cursorIndexOfChannelType);
                _result.setChannelType(_tmpChannelType);
                String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                _result.setAvatarFileId(_tmpAvatarFileId);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_5 != 0;
                _result.setDeleted(_tmpIsDeleted);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setUpdatedAt(_tmpUpdatedAt);
                _result.setChannelMembership(_tmpChannelMembership);
                _result.setChannelExtra(_tmpChannelExtra);
            } else {
                _result = null;
            }
            EkoChannelWithMembershipAndExtra ekoChannelWithMembershipAndExtra = _result;
            return ekoChannelWithMembershipAndExtra;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<EkoChannelWithMembershipAndExtra> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId  IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfChannelId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelId");
            int _cursorIndexOfDisplayName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"displayName");
            int _cursorIndexOfMetadata = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"metadata");
            int _cursorIndexOfMessageCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageCount");
            int _cursorIndexOfIsRateLimited = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRateLimited");
            int _cursorIndexOfIsMuted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isMuted");
            int _cursorIndexOfLastActivity = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastActivity");
            int _cursorIndexOfMemberCount = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"memberCount");
            int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
            int _cursorIndexOfChannelType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"channelType");
            int _cursorIndexOfAvatarFileId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"avatarFileId");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"membership_readToSegment");
            int _cursorIndexOfLocalReadToSegment = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extra_localReadToSegment");
            ArrayList<EkoChannelWithMembershipAndExtra> _result = new ArrayList<EkoChannelWithMembershipAndExtra>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoChannelExtra _tmpChannelExtra;
                ChannelMembershipEntity _tmpChannelMembership;
                if (!_cursor.isNull(_cursorIndexOfReadToSegment)) {
                    _tmpChannelMembership = new ChannelMembershipEntity();
                    int _tmpReadToSegment = _cursor.getInt(_cursorIndexOfReadToSegment);
                    _tmpChannelMembership.setReadToSegment(_tmpReadToSegment);
                } else {
                    _tmpChannelMembership = null;
                }
                if (!_cursor.isNull(_cursorIndexOfLocalReadToSegment)) {
                    _tmpChannelExtra = new EkoChannelExtra(null);
                    int _tmpLocalReadToSegment = _cursor.getInt(_cursorIndexOfLocalReadToSegment);
                    _tmpChannelExtra.setLocalReadToSegment(_tmpLocalReadToSegment);
                } else {
                    _tmpChannelExtra = null;
                }
                EkoChannelWithMembershipAndExtra _item_1 = new EkoChannelWithMembershipAndExtra();
                String _tmpChannelId = _cursor.isNull(_cursorIndexOfChannelId) ? null : _cursor.getString(_cursorIndexOfChannelId);
                _item_1.setChannelId(_tmpChannelId);
                String _tmpDisplayName = _cursor.isNull(_cursorIndexOfDisplayName) ? null : _cursor.getString(_cursorIndexOfDisplayName);
                _item_1.setDisplayName(_tmpDisplayName);
                String _tmp = _cursor.isNull(_cursorIndexOfMetadata) ? null : _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _item_1.setMetadata(_tmpMetadata);
                int _tmpMessageCount = _cursor.getInt(_cursorIndexOfMessageCount);
                _item_1.setMessageCount(_tmpMessageCount);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsRateLimited);
                boolean _tmpIsRateLimited = _tmp_1 != 0;
                _item_1.setRateLimited(_tmpIsRateLimited);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsMuted);
                boolean _tmpIsMuted = _tmp_2 != 0;
                _item_1.setMuted(_tmpIsMuted);
                String _tmp_3 = _cursor.isNull(_cursorIndexOfLastActivity) ? null : _cursor.getString(_cursorIndexOfLastActivity);
                DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _item_1.setLastActivity(_tmpLastActivity);
                int _tmpMemberCount = _cursor.getInt(_cursorIndexOfMemberCount);
                _item_1.setMemberCount(_tmpMemberCount);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_4);
                _item_1.setTags(_tmpTags);
                String _tmpChannelType = _cursor.isNull(_cursorIndexOfChannelType) ? null : _cursor.getString(_cursorIndexOfChannelType);
                _item_1.setChannelType(_tmpChannelType);
                String _tmpAvatarFileId = _cursor.isNull(_cursorIndexOfAvatarFileId) ? null : _cursor.getString(_cursorIndexOfAvatarFileId);
                _item_1.setAvatarFileId(_tmpAvatarFileId);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_5 != 0;
                _item_1.setDeleted(_tmpIsDeleted);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_7 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                _item_1.setChannelMembership(_tmpChannelMembership);
                _item_1.setChannelExtra(_tmpChannelExtra);
                _result.add(_item_1);
            }
            ArrayList<EkoChannelWithMembershipAndExtra> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public Flowable<List<String>> getActiveIds(String userId) {
        String _sql = "SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where membership = 'member' and userId = ?)";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where membership = 'member' and userId = ?)", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel", "channel_membership"}, (Callable)new Callable<List<String>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EkoChannelDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _item = _cursor.isNull(0) ? null : _cursor.getString(0);
                        _result.add(_item);
                    }
                    ArrayList<String> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<String> getInactiveIds(String userId) {
        String _sql = "SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where (membership = 'none' or membership = 'banned') and userId = ?)";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where (membership = 'none' or membership = 'banned') and userId = ?)", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            ArrayList<String> _result = new ArrayList<String>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _item = _cursor.isNull(0) ? null : _cursor.getString(0);
                _result.add(_item);
            }
            ArrayList<String> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

