/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.event;

import androidx.annotation.NonNull;
import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.socket.util.EkoGson;
import com.ekoapp.ekosdk.internal.api.dto.ChannelEvent;
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelMembershipDto;
import com.ekoapp.ekosdk.internal.api.event.SocketEventListener;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;
import com.google.gson.Gson;

public class ChannelDidMarkSeenListener
extends SocketEventListener {
    private final Gson gson = EkoGson.get();

    @Override
    @NonNull
    public String getEvent() {
        return "v3.channel.didMarkSeen";
    }

    @Override
    protected void onEvent(@NonNull String event, Object ... args) {
        super.onEvent(event, args);
        String json = args[0].toString();
        ChannelEvent eventData = (ChannelEvent)this.gson.fromJson(json, ChannelEvent.class);
        if (eventData.getChannelDtoList() != null && !eventData.getChannelDtoList().isEmpty() && eventData.getChannelMembershipDtoList() != null && !eventData.getChannelMembershipDtoList().isEmpty()) {
            EkoChannelDto channelEvent = eventData.getChannelDtoList().get(0);
            EkoChannelMembershipDto membershipEvent = eventData.getChannelMembershipDtoList().get(0);
            EkoChannelMembershipDao membershipDao = UserDatabase.get().channelMembershipDao();
            int readToSegment = membershipEvent.getReadToSegment();
            membershipDao.updateReadToSegment(channelEvent.getChannelId(), AmityCoreClient.INSTANCE.getUserId(), readToSegment);
        }
    }
}

