/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.event;

import androidx.annotation.NonNull;
import com.amity.socialcloud.sdk.AmityCoreClient;
import com.ekoapp.ekosdk.internal.api.dto.ChannelEventDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelDto;
import com.ekoapp.ekosdk.internal.api.event.ChannelListener;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;

public class ChannelDidCreateListener
extends ChannelListener {
    @Override
    @NonNull
    public String getEvent() {
        return "v3.channel.didCreate";
    }

    @Override
    void onChannelEvent(@NonNull String eventName, ChannelEventDto eventData) {
        super.onChannelEvent(eventName, eventData);
        if (eventData.getChannelDtoList() != null && !eventData.getChannelDtoList().isEmpty()) {
            EkoChannelDto channelEvent = eventData.getChannelDtoList().get(0);
            EkoChannelMembershipDao membershipDao = UserDatabase.get().channelMembershipDao();
            int readToSegment = channelEvent.getMessageCount();
            int lastMentionedSegment = channelEvent.getMessageCount();
            membershipDao.updateReadToSegment(channelEvent.getChannelId(), AmityCoreClient.INSTANCE.getUserId(), readToSegment);
            membershipDao.updateLastMentionedSegment(channelEvent.getChannelId(), AmityCoreClient.INSTANCE.getUserId(), lastMentionedSegment);
        }
    }
}

