/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.session;

import com.amity.socialcloud.sdk.core.data.notification.device.DeviceNotificationRepository;
import com.amity.socialcloud.sdk.core.data.session.SessionLocalDataStore;
import com.amity.socialcloud.sdk.core.data.session.SessionRemoteDataStore;
import com.amity.socialcloud.sdk.core.data.session.SessionRepository;
import com.amity.socialcloud.sdk.core.data.user.UserQueryPersister;
import com.amity.socialcloud.sdk.core.data.user.UserRepository;
import com.amity.socialcloud.sdk.core.error.AmityError;
import com.amity.socialcloud.sdk.core.error.AmityException;
import com.amity.socialcloud.sdk.core.user.AmityUser;
import com.ekoapp.core.utils.RxJava3BridgeExtensionsKt;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceDto;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.repository.user.UserUpdateOption;
import com.github.davidmoten.rx2.RetryWhen;
import io.reactivex.functions.Predicate;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0007J\"\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\u000e\u001a\u00020\tJ$\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0002J$\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/amity/socialcloud/sdk/core/data/session/SessionRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "activateAccount", "Lio/reactivex/rxjava3/core/Single;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "userId", "", "disconnect", "Lio/reactivex/rxjava3/core/Completable;", "getActiveUserId", "login", "displayName", "authToken", "logout", "refreshToken", "account", "registerDevice", "updateDisplayNameIfNeeded", "", "verifyCurrentAccessToken", "amity-sdk_release"})
public final class SessionRepository
extends EkoObjectRepository {
    @NotNull
    public final String getActiveUserId() {
        return new SessionLocalDataStore().getActiveUserId();
    }

    @NotNull
    public final Completable login(@NotNull String userId, @Nullable String displayName, @Nullable String authToken) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Completable completable = this.activateAccount(userId).flatMapCompletable((Function)new Function<EkoAccount, CompletableSource>(this, displayName, authToken){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authToken;

            public final CompletableSource apply(EkoAccount it) {
                EkoAccount ekoAccount = it;
                Intrinsics.checkNotNullExpressionValue((Object)ekoAccount, (String)"it");
                return (CompletableSource)SessionRepository.access$refreshToken(this.this$0, ekoAccount, this.$displayName, this.$authToken);
            }
            {
                this.this$0 = sessionRepository;
                this.$displayName = string;
                this.$authToken = string2;
            }
        }).doOnComplete(new Action(this, userId, displayName){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ String $userId;
            final /* synthetic */ String $displayName;

            public final void run() {
                SessionRepository.access$updateDisplayNameIfNeeded(this.this$0, this.$userId, this.$displayName);
            }
            {
                this.this$0 = sessionRepository;
                this.$userId = string;
                this.$displayName = string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"activateAccount(userId)\n\u2026isplayName)\n            }");
        return completable;
    }

    @NotNull
    public final Completable logout() {
        Completable completable = new DeviceNotificationRepository().unregisterAll().andThen((CompletableSource)Completable.fromAction((Action)logout.1.INSTANCE).subscribeOn(Schedulers.io()));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"DeviceNotificationReposi\u2026ulers.io())\n            )");
        return completable;
    }

    @NotNull
    public final Completable disconnect() {
        return new SessionLocalDataStore().disconnectAccount();
    }

    private final Single<EkoAccount> activateAccount(String userId) {
        Single single = Single.fromCallable((Callable)new Callable<EkoAccount>(userId){
            final /* synthetic */ String $userId;

            public final EkoAccount call() {
                String lastUser = new SessionLocalDataStore().getActiveUserId();
                boolean isTheSameUser = Intrinsics.areEqual((Object)lastUser, (Object)this.$userId);
                if (isTheSameUser) {
                    new SessionLocalDataStore().deactivateAccount(this.$userId);
                } else {
                    new SessionLocalDataStore().logoutAccount(this.$userId);
                }
                return new SessionLocalDataStore().activateAccount(this.$userId);
            }
            {
                this.$userId = string;
            }
        }).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"Single.fromCallable {\n  \u2026scribeOn(Schedulers.io())");
        return single;
    }

    private final Completable refreshToken(EkoAccount account, String displayName, String authToken) {
        Completable completable = this.verifyCurrentAccessToken(account).onErrorResumeNext((Function)new Function<Throwable, CompletableSource>(this, account, displayName, authToken){
            final /* synthetic */ SessionRepository this$0;
            final /* synthetic */ EkoAccount $account;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authToken;

            public final CompletableSource apply(Throwable it) {
                return AmityError.Companion.from(it) == AmityError.USER_IS_GLOBAL_BANNED ? (CompletableSource)Completable.error((Throwable)it) : (CompletableSource)SessionRepository.access$registerDevice(this.this$0, this.$account, this.$displayName, this.$authToken);
            }
            {
                this.this$0 = sessionRepository;
                this.$account = ekoAccount;
                this.$displayName = string;
                this.$authToken = string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"verifyCurrentAccessToken\u2026          }\n            }");
        return completable;
    }

    private final Completable verifyCurrentAccessToken(EkoAccount account) {
        Completable completable = new SessionLocalDataStore().getApiKey().flatMapCompletable((Function)new Function<EkoApiKey, CompletableSource>(account){
            final /* synthetic */ EkoAccount $account;

            public final CompletableSource apply(EkoApiKey it) {
                CompletableSource completableSource;
                if (this.$account.getAccessToken() == null) {
                    completableSource = (CompletableSource)Completable.error((Throwable)AmityException.Companion.create("accessToken not found", null, AmityError.UNAUTHORIZED_ERROR));
                } else {
                    SessionRemoteDataStore sessionRemoteDataStore = new SessionRemoteDataStore();
                    EkoApiKey ekoApiKey = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ekoApiKey, (String)"it");
                    String string = ekoApiKey.getApiKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.apiKey");
                    completableSource = (CompletableSource)sessionRemoteDataStore.verifyAccessToken(string);
                }
                return completableSource;
            }
            {
                this.$account = ekoAccount;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"SessionLocalDataStore().\u2026          }\n            }");
        return completable;
    }

    private final Completable registerDevice(EkoAccount account, String displayName, String authToken) {
        Completable completable = new SessionLocalDataStore().getApiKey().flatMapCompletable((Function)new Function<EkoApiKey, CompletableSource>(account, displayName, authToken){
            final /* synthetic */ EkoAccount $account;
            final /* synthetic */ String $displayName;
            final /* synthetic */ String $authToken;

            public final CompletableSource apply(EkoApiKey it) {
                SessionRemoteDataStore sessionRemoteDataStore = new SessionRemoteDataStore();
                EkoApiKey ekoApiKey = it;
                Intrinsics.checkNotNullExpressionValue((Object)ekoApiKey, (String)"it");
                String string = ekoApiKey.getApiKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.apiKey");
                String string2 = this.$account.getUserId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"account.userId");
                String string3 = this.$account.getDeviceId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"account.deviceId");
                Completable completable = sessionRemoteDataStore.registerDevice(string, string2, this.$displayName, string3, this.$authToken).flatMapCompletable((Function)new Function<RegisterDeviceDto, CompletableSource>(this){
                    final /* synthetic */ registerDevice.1 this$0;

                    public final CompletableSource apply(RegisterDeviceDto it) {
                        this.this$0.$account.setRefreshToken(it.getRefreshToken());
                        this.this$0.$account.setAccessToken(it.getAccessToken());
                        EkoUserListDto ekoUserListDto = new EkoUserListDto();
                        boolean bl = false;
                        boolean bl2 = false;
                        EkoUserListDto $this$apply = ekoUserListDto;
                        boolean bl3 = false;
                        List list = it.getUsers();
                        if (list == null) {
                            list = CollectionsKt.emptyList();
                        }
                        $this$apply.setUsers(list);
                        List list2 = it.getFiles();
                        if (list2 == null) {
                            list2 = CollectionsKt.emptyList();
                        }
                        $this$apply.setFiles(list2);
                        EkoUserListDto users = ekoUserListDto;
                        return (CompletableSource)new SessionLocalDataStore().updateAccount(this.this$0.$account).andThen((CompletableSource)new UserQueryPersister().persist(users));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"SessionRemoteDataStore()\u2026s))\n                    }");
                io.reactivex.Completable completable2 = RxJava3BridgeExtensionsKt.toV2(completable).retryWhen(RetryWhen.retryIf((Predicate)registerDevice.2.INSTANCE).maxRetries(3).exponentialBackoff(1L, 10L, TimeUnit.SECONDS, 1.5).build());
                Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"SessionRemoteDataStore()\u2026d()\n                    )");
                return (CompletableSource)RxJava3BridgeExtensionsKt.toV3(completable2);
            }
            {
                this.$account = ekoAccount;
                this.$displayName = string;
                this.$authToken = string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"SessionLocalDataStore().\u2026    .toV3()\n            }");
        return completable;
    }

    private final void updateDisplayNameIfNeeded(String userId, String displayName) {
        if (displayName != null) {
            new UserRepository().observeUser(userId).firstOrError().flatMapCompletable((Function)new Function<AmityUser, CompletableSource>(displayName, userId){
                final /* synthetic */ String $displayName;
                final /* synthetic */ String $userId;

                public final CompletableSource apply(AmityUser it) {
                    return Intrinsics.areEqual((Object)it.getDisplayName(), (Object)this.$displayName) ? (CompletableSource)Completable.complete() : (CompletableSource)new UserRepository().updateUser(this.$userId, new UserUpdateOption(this.$displayName, null, null, null, null, null, null, 126, null)).ignoreElement();
                }
                {
                    this.$displayName = string;
                    this.$userId = string2;
                }
            }).subscribeOn(Schedulers.io()).doOnError((Consumer)updateDisplayNameIfNeeded.2.INSTANCE).subscribe();
        }
    }

    public static final /* synthetic */ Completable access$refreshToken(SessionRepository $this, EkoAccount account, String displayName, String authToken) {
        return $this.refreshToken(account, displayName, authToken);
    }

    public static final /* synthetic */ void access$updateDisplayNameIfNeeded(SessionRepository $this, String userId, String displayName) {
        $this.updateDisplayNameIfNeeded(userId, displayName);
    }

    public static final /* synthetic */ Completable access$registerDevice(SessionRepository $this, EkoAccount account, String displayName, String authToken) {
        return $this.registerDevice(account, displayName, authToken);
    }
}

