/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoReactorDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoMessageMapper;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectPersister;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageFlagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.model.EkoMessageFlag;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import java.util.List;

class EkoMessageListEventPersister
extends EkoObjectPersister {
    EkoMessageListEventPersister() {
    }

    static void persist(List<EkoMessageDto> dtoList) {
        UserDatabase userDatabase = UserDatabase.get();
        userDatabase.runInTransaction(() -> {
            EkoMessageListEventPersister.persistChanges(dtoList, EkoMessageMapper.MAPPER, userDatabase.messageDao());
            EkoMessageFlagDao flagDao = userDatabase.messageFlagDao();
            EkoReactionDao reactionDao = userDatabase.reactionDao();
            for (EkoMessageDto messageDto : dtoList) {
                EkoReactorDto reactorDto = messageDto.getLatestReaction();
                if (reactorDto != null) {
                    switch (reactorDto.getEventName()) {
                        case "add": {
                            EkoReactionEntity messageReaction = EkoReactionEntity.create(reactorDto.getReactionId(), ReactionReferenceType.MESSAGE, messageDto.getMessageId(), reactorDto.getReactionName(), reactorDto.getUserId(), reactorDto.getUserDisplayName(), reactorDto.getCreatedAt(), reactorDto.getUpdatedAt());
                            reactionDao.insert(messageReaction);
                            break;
                        }
                        case "remove": {
                            reactionDao.deleteByPrimaryKey(ReactionReferenceType.MESSAGE.getValue(), messageDto.getMessageId(), reactorDto.getUserId(), reactorDto.getReactionName());
                            break;
                        }
                    }
                }
                EkoMessageFlag messageFlag = new EkoMessageFlag();
                messageFlag.setMessageId(messageDto.getMessageId());
                messageFlag.setFlag(messageDto.getFlag());
                EkoMessageFlag diskFlag = flagDao.getByIdNow(messageDto.getMessageId());
                if (diskFlag != null) {
                    messageFlag.setLocalFlag(diskFlag.getLocalFlag());
                    flagDao.update(messageFlag);
                    continue;
                }
                flagDao.insert(messageFlag);
            }
        });
    }
}

