/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.core.AmityTags;
import com.ekoapp.ekosdk.EkoCategoryIds;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommunityDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectMapper;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import org.joda.time.ReadableInstant;

public interface EkoCommunityMapper
extends EkoObjectMapper<EkoCommunityDto, CommunityEntity> {
    public static final EkoCommunityMapper MAPPER = dto -> {
        if (dto.getCommunityId() != null && !dto.getCommunityId().isEmpty()) {
            CommunityEntity community = new CommunityEntity();
            community.setCommunityId(dto.getCommunityId());
            community.setChannelId(dto.getChannelId());
            community.setUserId(dto.getUserId());
            community.setDisplayName(dto.getDisplayName());
            community.setDescription(dto.getDescription());
            community.setAvatarFileId(dto.getAvatarFileId());
            community.setOfficial(dto.isOfficial());
            community.setPublic(dto.isPublic());
            community.setOnlyAdminCanPost(dto.getOnlyAdminCanPost());
            community.setTags(dto.getTags() != null ? dto.getTags() : new AmityTags());
            community.setMetadata(dto.getMetadata());
            community.setPostsCount(dto.getPostsCount());
            community.setMembersCount(dto.getMembersCount());
            community.setDeleted(dto.isDeleted());
            community.setCategoryIds(dto.getCategoryIds() != null ? dto.getCategoryIds() : new EkoCategoryIds());
            community.setNeedApprovalOnPostCreation(dto.getNeedApprovalOnPostCreation());
            community.setEditedAt(dto.getEditedAt());
            community.setCreatedAt(dto.getCreatedAt());
            community.setUpdatedAt(dto.getUpdatedAt());
            if (dto.getPath() != null) {
                community.setPath(dto.getPath());
            }
            if (dto.isJoined() != null) {
                community.setJoined(dto.isJoined());
            } else {
                community.setJoined(true);
            }
            return community;
        }
        return null;
    };

    @Override
    default public CommunityEntity update(CommunityEntity objectOnDisk, CommunityEntity objectToSave) {
        if (objectToSave.getUpdatedAt().isAfter((ReadableInstant)objectOnDisk.getUpdatedAt()) || objectToSave.getUpdatedAt().isEqual((ReadableInstant)objectOnDisk.getUpdatedAt())) {
            return objectToSave;
        }
        return objectOnDisk;
    }
}

