/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.paging.DataSource;
import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Query;
import com.amity.socialcloud.sdk.social.feed.AmityCommunityFeedSortOption;
import com.amity.socialcloud.sdk.social.feed.AmityUserFeedSortOption;
import com.ekoapp.ekosdk.internal.PostEntity;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import io.reactivex.Flowable;
import java.util.List;

@Dao
public abstract class PostDao
extends EkoObjectDao<PostEntity> {
    @Override
    @Delete
    public abstract void delete(PostEntity var1);

    @Override
    @Query(value="DELETE from post")
    public abstract void deleteAll();

    @Query(value="DELETE from post where postId = :postId")
    public abstract void deleteById(String var1);

    @Query(value="UPDATE post set commentCount = commentCount + 1 where postId = :postId")
    public abstract void incrementCommentCount(String var1);

    @Query(value="UPDATE post set commentCount = commentCount - 1 where postId = :postId")
    public abstract void decrementCommentCount(String var1);

    @Query(value="UPDATE post set postId = postId where postId = :postId")
    public abstract void updatePost(String var1);

    @Query(value="SELECT * from post where post.postId IN (:postIds)")
    abstract List<PostEntity> getByIdsNowImpl(List<String> var1);

    @Override
    public List<PostEntity> getByIdsNow(List<String> postIds) {
        return this.getByIdsNowImpl(postIds);
    }

    @Query(value="SELECT * from post where post.postId IN (:postIds) LIMIT 1")
    abstract PostEntity getByIdNowImpl(String var1);

    @Override
    public PostEntity getByIdNow(String postId) {
        return this.getByIdNowImpl(postId);
    }

    @Query(value="UPDATE post SET isDeleted = :isDeleted WHERE postId LIKE :postId ")
    abstract void updateDeletedImpl(String var1, boolean var2);

    public void softDeleteById(String postId) {
        this.updateDeletedImpl(postId, true);
    }

    @Query(value="UPDATE post SET feedType = :feedType WHERE postId = :postId ")
    abstract void updateFeedTypeImpl(String var1, String var2);

    public void updateFeedType(String postId, String feedType) {
        this.updateFeedTypeImpl(postId, feedType);
    }

    @Query(value="SELECT * from post where post.postId IN (:postIds) LIMIT 1")
    abstract Flowable<PostEntity> getPostImpl(String var1);

    public Flowable<PostEntity> getPost(String postId) {
        return this.getPostImpl(postId);
    }

    @Query(value="SELECT * from post, community_feed_query_token where post.targetType = 'community' and post.targetId = :communityId  and post.feedType = :feedType and case when :postTypesString = '' then post.parentPostId is null else post.targetId is not null end and post.isDeleted = (case when :isDeleted is null then post.isDeleted else :isDeleted end) and (community_feed_query_token.communityId = :communityId and community_feed_query_token.feedType = :feedType and community_feed_query_token.isDeleted = :deletedStatus and community_feed_query_token.sortBy = :sortBy and community_feed_query_token.postTypes = :postTypesString and community_feed_query_token.ids like '%' || post.postId || '%') order by case when :isSortedAsc = 1 then post.createdAt end asc, case when :isSortedAsc = 0 then post.createdAt end desc")
    abstract PagingSource<Integer, PostEntity> getCommunityFeedPagingSourceImpl(String var1, String var2, Boolean var3, String var4, Boolean var5, String var6, String var7);

    public PagingSource<Integer, PostEntity> getCommunityFeedPagingSource(String communityId, String feedType, Boolean isDeleted, AmityCommunityFeedSortOption sortOption, String postTypesString) {
        String deletedStatus = "";
        if (isDeleted != null) {
            deletedStatus = isDeleted.toString();
        }
        return this.getCommunityFeedPagingSourceImpl(communityId, feedType, isDeleted, deletedStatus, sortOption != AmityCommunityFeedSortOption.LAST_CREATED, sortOption.getApiKey(), postTypesString);
    }

    @Query(value="SELECT * from post, community_feed_query_token where post.targetType = 'community' and post.targetId = :communityId  and post.feedType = :feedType and post.parentPostId is null and post.isDeleted = (case when :isDeleted is null then post.isDeleted else :isDeleted end) and (community_feed_query_token.communityId = :communityId and community_feed_query_token.feedType = :feedType and community_feed_query_token.isDeleted = :deletedStatus and community_feed_query_token.sortBy = :sortBy and community_feed_query_token.pageNumber = 1 and community_feed_query_token.ids like '%' || post.postId || '%') order by case when :isSortedAsc = 1 then post.createdAt end asc, case when :isSortedAsc = 0 then post.createdAt end desc")
    abstract DataSource.Factory<Integer, PostEntity> getCommunityFeedDataSourceImpl(String var1, String var2, Boolean var3, String var4, Boolean var5, String var6);

    public DataSource.Factory<Integer, PostEntity> getCommunityFeedDataSource(String communityId, String feedType, Boolean isDeleted, AmityCommunityFeedSortOption sortOption) {
        String deletedStatus = "";
        if (isDeleted != null) {
            deletedStatus = isDeleted.toString();
        }
        return this.getCommunityFeedDataSourceImpl(communityId, feedType, isDeleted, deletedStatus, sortOption != AmityCommunityFeedSortOption.LAST_CREATED, sortOption.getApiKey());
    }

    @Query(value="SELECT * from post, user_feed_query_token where post.targetType = 'user' and post.targetId = :userId  and case when :postTypesString = '' then post.parentPostId is null else post.targetId is not null end and post.isDeleted = (case when :isDeleted is null then post.isDeleted else :isDeleted end) and (user_feed_query_token.userId = :userId and user_feed_query_token.isDeleted = :deletedStatus and user_feed_query_token.sortBy = :sortBy and user_feed_query_token.postTypes = :postTypesString and user_feed_query_token.ids like '%' || post.postId || '%') order by case when :isSortedAsc = 1 then post.createdAt end asc, case when :isSortedAsc = 0 then post.createdAt end desc")
    abstract PagingSource<Integer, PostEntity> getUserFeedPagingSourceImpl(String var1, Boolean var2, String var3, Boolean var4, String var5, String var6);

    public PagingSource<Integer, PostEntity> getUserFeedPagingSource(String userId, Boolean isDeleted, AmityUserFeedSortOption sortOption, String postTypesString) {
        String deletedStatus = "";
        if (isDeleted != null) {
            deletedStatus = isDeleted.toString();
        }
        return this.getUserFeedPagingSourceImpl(userId, isDeleted, deletedStatus, sortOption == AmityUserFeedSortOption.FIRST_CREATED, sortOption.getApiKey(), postTypesString);
    }

    @Query(value="SELECT * from post, user_feed_query_token where post.targetType = 'user' and post.targetId = :userId  and post.parentPostId is null and post.isDeleted = (case when :isDeleted is null then post.isDeleted else :isDeleted end) and (user_feed_query_token.userId = :userId and user_feed_query_token.isDeleted = :deletedStatus and user_feed_query_token.sortBy = :sortBy and user_feed_query_token.pageNumber = 1 and user_feed_query_token.ids like '%' || post.postId || '%') order by case when :isSortedAsc = 1 then post.createdAt end asc, case when :isSortedAsc = 0 then post.createdAt end desc")
    abstract DataSource.Factory<Integer, PostEntity> getUserFeedDataSourceImpl(String var1, Boolean var2, String var3, Boolean var4, String var5);

    public DataSource.Factory<Integer, PostEntity> getUserFeedDataSource(String userId, Boolean isDeleted, AmityUserFeedSortOption sortOption) {
        String deletedStatus = "";
        if (isDeleted != null) {
            deletedStatus = isDeleted.toString();
        }
        return this.getUserFeedDataSourceImpl(userId, isDeleted, deletedStatus, sortOption == AmityUserFeedSortOption.FIRST_CREATED, sortOption.getApiKey());
    }

    @Query(value="SELECT * from post, global_post where post.isDeleted = 0 and post.postId = global_post.postId")
    abstract DataSource.Factory<Integer, PostEntity> getGlobalPostDataSourceImpl();

    public DataSource.Factory<Integer, PostEntity> getGlobalPostDataSource() {
        return this.getGlobalPostDataSourceImpl();
    }
}

