/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.Nullable;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Transaction;
import androidx.room.Update;
import com.ekoapp.ekosdk.internal.api.dto.EkoInactiveChannelIdsDto;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelExtraDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelMembershipDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.data.model.EkoAccountCache;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import java.util.List;
import timber.log.Timber;

@Dao
public abstract class EkoAccountDao {
    @Query(value="SELECT * from account")
    public abstract Flowable<List<EkoAccount>> getAll();

    @Query(value="SELECT * from account where userId = :userId LIMIT 1")
    public abstract Flowable<EkoAccount> getByIdFlowable(String var1);

    @Query(value="SELECT * from account where userId = :userId LIMIT 1")
    public abstract Maybe<EkoAccount> getByIdMaybe(String var1);

    public Flowable<EkoAccount> getCurrentAccountFlowable() {
        return this.getByIsActiveFlowable(true).distinctUntilChanged(EkoAccount::getAccessToken);
    }

    public Single<EkoAccount> getCurrentAccountSingle() {
        return this.getByIsActiveFlowable(true).firstOrError();
    }

    @Query(value="SELECT * from account where isActive = :isActive LIMIT 1")
    abstract Flowable<EkoAccount> getByIsActiveFlowable(boolean var1);

    public EkoAccount getCurrentAccountNow() {
        return this.getByIsActiveNow(true);
    }

    @Query(value="SELECT * from account where isActive = :isActive LIMIT 1")
    abstract EkoAccount getByIsActiveNow(boolean var1);

    @Insert(onConflict=1)
    abstract void insert(EkoAccount var1);

    @Update(onConflict=1)
    public abstract void update(EkoAccount var1);

    @Transaction
    public EkoAccount activateAccount(String userId) {
        EkoAccount account = this.createAccountIfNeed(userId);
        account.setActive(true);
        this.update(account);
        EkoAccountCache.setMyAccount(userId, account.getDeviceId());
        return account;
    }

    @Transaction
    public EkoAccount deactivateAccount(String userId) {
        EkoAccount account = this.createAccountIfNeed(userId);
        this.setAllIsActive(false);
        return account;
    }

    @Transaction
    public EkoAccount logoutAccount(String userId) {
        EkoAccount account = this.createAccountIfNeed(userId);
        this.clearAllUserData(userId);
        this.setAllIsActive(false);
        return account;
    }

    private EkoAccount createAccountIfNeed(String userId) {
        EkoAccount account = this.getByIdNow(userId);
        if (account == null) {
            account = EkoAccount.create(userId);
            this.insert(account);
        }
        return account;
    }

    @Transaction
    public void pauseAllAccount() {
        this.setAllIsActive(false);
    }

    @Transaction
    public void clearAllUserData(String userId) {
        UserDatabase.get().clearAllTables();
        EkoAccountCache.get().clear();
        this.update(EkoAccount.create(userId));
    }

    @Delete
    public abstract void delete(EkoAccount var1);

    @Nullable
    @Query(value="SELECT * from account where userId = :userId LIMIT 1")
    abstract EkoAccount getByIdNow(String var1);

    @Query(value="UPDATE account SET isActive = :isActive")
    abstract void setAllIsActive(boolean var1);

    @Query(value="UPDATE account set lastInactiveChannelIdsQuery = :lastInactiveChannelIdsQuery where userId = :userId")
    abstract void updateLastInactiveChannelIdsQueryInternal(String var1, String var2);

    @Transaction
    public void updateLastInactiveChannelIdsQuery(EkoInactiveChannelIdsDto inactiveChannelIds) {
        UserDatabase db = UserDatabase.get();
        if (inactiveChannelIds.isExceed()) {
            Timber.i((String)("In-active channels are exceeded since:" + inactiveChannelIds.getSince()), (Object[])new Object[0]);
            this.deleteAllChannelData(db);
        } else {
            EkoChannelDao channelDao = db.channelDao();
            for (String channelId : inactiveChannelIds.getChannelIds()) {
                channelDao.deleteById(channelId);
            }
        }
        this.updateLastInactiveChannelIdsQueryInternal(this.getCurrentAccountNow().getUserId(), inactiveChannelIds.getSince());
    }

    private void deleteAllChannelData(UserDatabase db) {
        EkoChannelDao channelDao = db.channelDao();
        channelDao.deleteAll();
        EkoMessageDao messageDao = db.messageDao();
        messageDao.deleteAll();
        EkoChannelMembershipDao membershipDao = db.channelMembershipDao();
        membershipDao.deleteAll();
        EkoChannelExtraDao extraDao = db.channelExtraDao();
        extraDao.deleteAll();
    }
}

