/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.message;

import androidx.paging.DataSource;
import androidx.paging.PagedList;
import com.amity.socialcloud.sdk.chat.message.AmityMessage;
import com.amity.socialcloud.sdk.core.AmityTags;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.EkoInternalMessage;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.MessageQueryConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.GetMessageRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.MessageDeleteRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.MessageFlagRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.MessageUnflagRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.MessageUpdateDataRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoMessageBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoMessageFlag;
import com.ekoapp.ekosdk.internal.repository.message.MessageRepository$sam$io_reactivex_functions_Function$0;
import com.ekoapp.ekosdk.internal.repository.message.helper.AttachDataToMessageHelper;
import com.ekoapp.ekosdk.internal.repository.message.helper.MapToExternalModelHelper;
import com.ekoapp.ekosdk.internal.repository.message.helper.MessageRepositoryHelper;
import com.google.gson.JsonObject;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u0006JS\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000e0\u000b2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\"\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0016\u00a8\u0006 "}, d2={"Lcom/ekoapp/ekosdk/internal/repository/message/MessageRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "deleteMessage", "Lio/reactivex/Completable;", "messageId", "", "flagMessage", "getDefaultPageSize", "", "getMessage", "Lio/reactivex/Flowable;", "Lcom/amity/socialcloud/sdk/chat/message/AmityMessage;", "getMessageCollection", "Landroidx/paging/PagedList;", "channelId", "stackFromEnd", "", "parentId", "isFilterByParentId", "isDeleted", "includingTags", "Lcom/amity/socialcloud/sdk/core/AmityTags;", "excludingTags", "(Ljava/lang/String;ZLjava/lang/String;ZLjava/lang/Boolean;Lcom/amity/socialcloud/sdk/core/AmityTags;Lcom/amity/socialcloud/sdk/core/AmityTags;)Lio/reactivex/Flowable;", "getMessageFlag", "Lcom/ekoapp/ekosdk/internal/data/model/EkoMessageFlag;", "unflagMessage", "updateMessage", "data", "Lcom/google/gson/JsonObject;", "tags", "amity-sdk_release"})
public final class MessageRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<PagedList<AmityMessage>> getMessageCollection(@NotNull String channelId, boolean stackFromEnd, @Nullable String parentId, boolean isFilterByParentId, @Nullable Boolean isDeleted, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags) {
        DataSource.Factory<Integer, EkoInternalMessage> factory2;
        String[] stringArray;
        Collection thisCollection$iv;
        Collection $this$toTypedArray$iv;
        boolean $i$f$toTypedArray;
        EkoMessageDao ekoMessageDao;
        String string;
        String[] stringArray2;
        Intrinsics.checkParameterIsNotNull((Object)channelId, (String)"channelId");
        Intrinsics.checkParameterIsNotNull((Object)includingTags, (String)"includingTags");
        Intrinsics.checkParameterIsNotNull((Object)excludingTags, (String)"excludingTags");
        UserDatabase userDatabase = UserDatabase.get();
        EkoMessageDao ekoMessageDao2 = userDatabase.messageDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoMessageDao2, (String)"userDatabase.messageDao()");
        EkoMessageDao messageDao = ekoMessageDao2;
        if (includingTags.isEmpty()) {
            if (isFilterByParentId) {
                Collection collection = excludingTags;
                stringArray2 = parentId;
                string = channelId;
                ekoMessageDao = messageDao;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
                if (stringArray3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                stringArray = stringArray3;
                factory2 = ekoMessageDao.getAllByParentId(string, (String)stringArray2, stringArray);
            } else {
                $this$toTypedArray$iv = excludingTags;
                string = channelId;
                ekoMessageDao = messageDao;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray4 = thisCollection$iv.toArray(new String[0]);
                if (stringArray4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                stringArray2 = stringArray4;
                factory2 = ekoMessageDao.getAll(string, stringArray2);
            }
        } else if (isFilterByParentId) {
            $this$toTypedArray$iv = includingTags;
            stringArray2 = parentId;
            string = channelId;
            ekoMessageDao = messageDao;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray5 = thisCollection$iv.toArray(new String[0]);
            if (stringArray5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            stringArray = stringArray5;
            $this$toTypedArray$iv = excludingTags;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray6 = thisCollection$iv.toArray(new String[0]);
            if (stringArray6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] stringArray7 = stringArray6;
            factory2 = ekoMessageDao.getAllByParentIdAndTags(string, (String)stringArray2, stringArray, stringArray7);
        } else {
            $this$toTypedArray$iv = includingTags;
            string = channelId;
            ekoMessageDao = messageDao;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray8 = thisCollection$iv.toArray(new String[0]);
            if (stringArray8 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            stringArray2 = stringArray8;
            $this$toTypedArray$iv = excludingTags;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray9 = thisCollection$iv.toArray(new String[0]);
            if (stringArray9 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            stringArray = stringArray9;
            factory2 = ekoMessageDao.getAllByTags(string, stringArray2, stringArray);
        }
        DataSource.Factory<Integer, EkoInternalMessage> localFactory = factory2;
        DataSource.Factory factory3 = localFactory.map((androidx.arch.core.util.Function)new AttachDataToMessageHelper()).map((androidx.arch.core.util.Function)new MapToExternalModelHelper());
        Intrinsics.checkExpressionValueIsNotNull((Object)factory3, (String)"localFactory\n           \u2026pToExternalModelHelper())");
        DataSource.Factory factory4 = factory3;
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        EkoMessageBoundaryCallback boundaryCallback = new EkoMessageBoundaryCallback(channelId, (String)parentId, isFilterByParentId, isDeleted, includingTags, excludingTags, stackFromEnd, this.getDefaultPageSize(), (Subject<Boolean>)((Subject)delaySubject));
        DataSource.Factory factory5 = factory4.map((androidx.arch.core.util.Function)boundaryCallback);
        Intrinsics.checkExpressionValueIsNotNull((Object)factory5, (String)"factory.map(boundaryCallback)");
        return this.createRxCollectionWithBoundaryCallback(factory5, boundaryCallback, stackFromEnd ? Integer.MAX_VALUE : 0);
    }

    @NotNull
    public final Flowable<AmityMessage> getMessage(@NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        GetMessageRequest request = new GetMessageRequest(messageId);
        EkoMessageDao messageDao = UserDatabase.get().messageDao();
        EkoSocket.call(Call.create(request, new MessageQueryConverter()));
        Function1 function1 = (Function1)new Function1<EkoInternalMessage, EkoInternalMessage>(new MessageRepositoryHelper()){

            @NotNull
            public final EkoInternalMessage invoke(@NotNull EkoInternalMessage p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((MessageRepositoryHelper)this.receiver).attachDataToEkoMessage(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MessageRepositoryHelper.class);
            }

            public final String getName() {
                return "attachDataToEkoMessage";
            }

            public final String getSignature() {
                return "attachDataToEkoMessage(Lcom/ekoapp/ekosdk/internal/EkoInternalMessage;)Lcom/ekoapp/ekosdk/internal/EkoInternalMessage;";
            }
        };
        MessageRepository$sam$io_reactivex_functions_Function$0 messageRepository$sam$io_reactivex_functions_Function$0 = new MessageRepository$sam$io_reactivex_functions_Function$0(function1);
        function1 = (Function1)new Function1<EkoInternalMessage, AmityMessage>(new MessageRepositoryHelper()){

            @NotNull
            public final AmityMessage invoke(@NotNull EkoInternalMessage p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ((MessageRepositoryHelper)this.receiver).mapToExternalModel(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(MessageRepositoryHelper.class);
            }

            public final String getName() {
                return "mapToExternalModel";
            }

            public final String getSignature() {
                return "mapToExternalModel(Lcom/ekoapp/ekosdk/internal/EkoInternalMessage;)Lcom/amity/socialcloud/sdk/chat/message/AmityMessage;";
            }
        };
        Flowable flowable = messageDao.getById(messageId).map((Function)messageRepository$sam$io_reactivex_functions_Function$0).map((Function)new MessageRepository$sam$io_reactivex_functions_Function$0(function1));
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"messageDao.getById(messa\u2026er()::mapToExternalModel)");
        return flowable;
    }

    @NotNull
    public final Completable updateMessage(@NotNull String messageId, @Nullable JsonObject data, @Nullable AmityTags tags) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        MessageUpdateDataRequest request = new MessageUpdateDataRequest(messageId, data, tags);
        Completable completable = EkoSocket.rpc(request).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.rpc(request).ignoreElement()");
        return completable;
    }

    @NotNull
    public final Flowable<EkoMessageFlag> getMessageFlag(@NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        EkoMessageFlagDao flagDao = UserDatabase.get().messageFlagDao();
        Flowable<EkoMessageFlag> flowable = flagDao.getByMessageId(messageId);
        Intrinsics.checkExpressionValueIsNotNull(flowable, (String)"flagDao.getByMessageId(messageId)");
        return flowable;
    }

    @NotNull
    public final Completable flagMessage(@NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        MessageFlagRequest request = new MessageFlagRequest(messageId);
        Completable completable = EkoSocket.call(Call.create(request, new MessageQueryConverter())).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable unflagMessage(@NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        MessageUnflagRequest request = new MessageUnflagRequest(messageId);
        Completable completable = EkoSocket.call(Call.create(request, new MessageQueryConverter())).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable deleteMessage(@NotNull String messageId) {
        Intrinsics.checkParameterIsNotNull((Object)messageId, (String)"messageId");
        UserDatabase userDatabase = UserDatabase.get();
        EkoMessageDao ekoMessageDao = userDatabase.messageDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoMessageDao, (String)"userDatabase.messageDao()");
        EkoMessageDao messageDao = ekoMessageDao;
        Completable completable = messageDao.getById(messageId).firstOrError().subscribeOn(Schedulers.io()).flatMapCompletable((Function)new Function<EkoInternalMessage, CompletableSource>(messageDao, messageId){
            final /* synthetic */ EkoMessageDao $messageDao;
            final /* synthetic */ String $messageId;

            public final CompletableSource apply(@NotNull EkoInternalMessage localMessage) {
                CompletableSource completableSource;
                Intrinsics.checkParameterIsNotNull((Object)localMessage, (String)"localMessage");
                if (Intrinsics.areEqual((Object)localMessage.getSyncState(), (Object)AmityMessage.State.FAILED.getStateName())) {
                    this.$messageDao.delete((EkoObject)localMessage);
                    completableSource = (CompletableSource)Completable.complete();
                } else {
                    MessageDeleteRequest request = new MessageDeleteRequest(this.$messageId);
                    completableSource = (CompletableSource)EkoSocket.rpc(request).ignoreElement();
                }
                return completableSource;
            }
            {
                this.$messageDao = ekoMessageDao;
                this.$messageId = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"messageDao.getById(messa\u2026      }\n                }");
        return completable;
    }
}

