/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.community;

import androidx.arch.core.util.Function;
import androidx.paging.DataSource;
import androidx.paging.PagedList;
import com.amity.socialcloud.sdk.social.community.AmityCommunityMember;
import com.amity.socialcloud.sdk.social.community.AmityCommunityMembershipFilter;
import com.amity.socialcloud.sdk.social.community.AmityCommunityMembershipSortOption;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.socket.call.Call;
import com.ekoapp.ekosdk.internal.api.socket.call.CommunityListQueryConverter;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityAddRoleRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityAddUsersRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityBanUsersRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityRemoveRoleRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityRemoveUsersRequest;
import com.ekoapp.ekosdk.internal.api.socket.request.CommunityUnBanUsersRequest;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.boundarycallback.EkoCommunityMembershipBoundaryCallback;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityMembershipDao;
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity;
import com.ekoapp.ekosdk.internal.repository.community.helper.CommunityMembershipRepositoryHelper;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tJ\u001c\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tJ\u001c\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\tJF\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006J:\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u001d0\u00192\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u001e\u001a\u00020\u000fH\u0002J$\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tJ\u001c\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tJ\u001c\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a8\u0006\""}, d2={"Lcom/ekoapp/ekosdk/internal/repository/community/CommunityMembershipRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "()V", "addRole", "Lio/reactivex/Completable;", "communityId", "", "role", "userIds", "", "addUsers", "banUsers", "users", "getAllCommunityMembership", "Landroidx/paging/DataSource$Factory;", "", "Lcom/ekoapp/ekosdk/internal/entity/CommunityMembershipEntity;", "communityMembershipDao", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoCommunityMembershipDao;", "roles", "filter", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityMembershipFilter;", "sortBy", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityMembershipSortOption;", "getCommunityMembership", "Lio/reactivex/Flowable;", "Lcom/amity/socialcloud/sdk/social/community/AmityCommunityMember;", "userId", "getCommunityMembershipCollection", "Landroidx/paging/PagedList;", "getDefaultPageSize", "removeRole", "removeUsers", "unbanUsers", "amity-sdk_release"})
public final class CommunityMembershipRepository
extends EkoObjectRepository {
    private final int getDefaultPageSize() {
        return 15;
    }

    @NotNull
    public final Flowable<PagedList<AmityCommunityMember>> getCommunityMembershipCollection(@NotNull String communityId, @Nullable List<String> roles, @NotNull AmityCommunityMembershipFilter filter, @NotNull AmityCommunityMembershipSortOption sortBy) {
        EkoCommunityMembershipDao communityMembershipDao;
        Intrinsics.checkParameterIsNotNull((Object)communityId, (String)"communityId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        Intrinsics.checkParameterIsNotNull((Object)((Object)sortBy), (String)"sortBy");
        EkoCommunityMembershipDao ekoCommunityMembershipDao = communityMembershipDao = UserDatabase.get().communityMembershipDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoCommunityMembershipDao, (String)"communityMembershipDao");
        DataSource.Factory factory2 = this.getAllCommunityMembership(ekoCommunityMembershipDao, communityId, roles, filter, sortBy).map(CommunityMembershipRepositoryHelper.INSTANCE.getFactoryMapper());
        Intrinsics.checkExpressionValueIsNotNull((Object)factory2, (String)"getAllCommunityMembershi\u2026toryHelper.factoryMapper)");
        DataSource.Factory factory3 = factory2;
        PublishSubject publishSubject = PublishSubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
        PublishSubject delaySubject = publishSubject;
        EkoCommunityMembershipBoundaryCallback boundaryCallback = new EkoCommunityMembershipBoundaryCallback((Subject<Boolean>)((Subject)delaySubject), communityId, filter.getMemberships(), roles, this.getDefaultPageSize(), sortBy);
        DataSource.Factory factory4 = factory3.map((Function)boundaryCallback);
        Intrinsics.checkExpressionValueIsNotNull((Object)factory4, (String)"factory.map(boundaryCallback)");
        return this.createRxCollectionWithBoundaryCallback(factory4, boundaryCallback);
    }

    @NotNull
    public final Flowable<AmityCommunityMember> getCommunityMembership(@NotNull String communityId, @NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)communityId, (String)"communityId");
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        EkoCommunityMembershipDao communityMembershipDao = UserDatabase.get().communityMembershipDao();
        Flowable flowable = communityMembershipDao.getById(communityId, userId).map(CommunityMembershipRepositoryHelper.INSTANCE.getQueryMapper());
        Intrinsics.checkExpressionValueIsNotNull((Object)flowable, (String)"communityMembershipDao.g\u2026sitoryHelper.queryMapper)");
        return flowable;
    }

    @NotNull
    public final Completable addUsers(@NotNull String communityId, @NotNull List<String> userIds) {
        Intrinsics.checkParameterIsNotNull((Object)communityId, (String)"communityId");
        Intrinsics.checkParameterIsNotNull(userIds, (String)"userIds");
        CommunityAddUsersRequest request = new CommunityAddUsersRequest(communityId, userIds);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.call(Call.crea\u2026erter())).ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable removeUsers(@NotNull String communityId, @NotNull List<String> userIds) {
        Intrinsics.checkParameterIsNotNull((Object)communityId, (String)"communityId");
        Intrinsics.checkParameterIsNotNull(userIds, (String)"userIds");
        CommunityRemoveUsersRequest request = new CommunityRemoveUsersRequest(communityId, userIds);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.call(Call.crea\u2026erter())).ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable addRole(@NotNull String communityId, @NotNull String role, @NotNull List<String> userIds) {
        Intrinsics.checkParameterIsNotNull((Object)communityId, (String)"communityId");
        Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
        Intrinsics.checkParameterIsNotNull(userIds, (String)"userIds");
        CommunityAddRoleRequest request = new CommunityAddRoleRequest(communityId, role, userIds);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable removeRole(@NotNull String communityId, @NotNull String role, @NotNull List<String> userIds) {
        Intrinsics.checkParameterIsNotNull((Object)communityId, (String)"communityId");
        Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
        Intrinsics.checkParameterIsNotNull(userIds, (String)"userIds");
        CommunityRemoveRoleRequest request = new CommunityRemoveRoleRequest(communityId, role, userIds);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable banUsers(@NotNull String communityId, @NotNull List<String> users) {
        Intrinsics.checkParameterIsNotNull((Object)communityId, (String)"communityId");
        Intrinsics.checkParameterIsNotNull(users, (String)"users");
        CommunityBanUsersRequest request = new CommunityBanUsersRequest(communityId, users);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    @NotNull
    public final Completable unbanUsers(@NotNull String communityId, @NotNull List<String> users) {
        Intrinsics.checkParameterIsNotNull((Object)communityId, (String)"communityId");
        Intrinsics.checkParameterIsNotNull(users, (String)"users");
        CommunityUnBanUsersRequest request = new CommunityUnBanUsersRequest(communityId, users);
        Completable completable = EkoSocket.call(Call.create(request, new CommunityListQueryConverter())).ignoreElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"EkoSocket.call(Call.crea\u2026         .ignoreElement()");
        return completable;
    }

    private final DataSource.Factory<Integer, CommunityMembershipEntity> getAllCommunityMembership(EkoCommunityMembershipDao communityMembershipDao, String communityId, List<String> roles, AmityCommunityMembershipFilter filter, AmityCommunityMembershipSortOption sortBy) {
        AmityCommunityMembershipFilter amityCommunityMembershipFilter = filter;
        if (amityCommunityMembershipFilter == null) {
            amityCommunityMembershipFilter = AmityCommunityMembershipFilter.ALL;
        }
        AmityCommunityMembershipFilter membershipFilter = amityCommunityMembershipFilter;
        DataSource.Factory<Integer, CommunityMembershipEntity> factory2 = communityMembershipDao.getAllByCommunityId(communityId, membershipFilter.getMemberships(), sortBy);
        Collection collection = roles;
        boolean bl = false;
        boolean bl2 = false;
        if (!(collection == null || collection.isEmpty())) {
            factory2 = communityMembershipDao.getAllByMembershipWithRole(communityId, roles, membershipFilter.getMemberships(), sortBy);
        }
        DataSource.Factory<Integer, CommunityMembershipEntity> factory3 = factory2;
        Intrinsics.checkExpressionValueIsNotNull(factory3, (String)"factory");
        return factory3;
    }
}

