/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.core.permission.AmityPermissions;
import com.amity.socialcloud.sdk.core.permission.AmityRoles;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.EkoInternalUser;
import com.ekoapp.ekosdk.internal.data.converter.EkoPermissionsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoRolesTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoUserDao;
import com.google.gson.JsonObject;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoUserDao_Impl
extends EkoUserDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfEkoInternalUser;
    private final EkoRolesTypeConverter __ekoRolesTypeConverter = new EkoRolesTypeConverter();
    private final EkoPermissionsTypeConverter __ekoPermissionsTypeConverter = new EkoPermissionsTypeConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfEkoInternalUser;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfEkoInternalUser;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoUserDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoInternalUser = new EntityInsertionAdapter<EkoInternalUser>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `user`(`userId`,`displayName`,`roles`,`permissions`,`flagCount`,`metadata`,`avatarFileId`,`avatarCustomUrl`,`description`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoInternalUser value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getDisplayName());
                }
                String _tmp = EkoUserDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(value.getRoles());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                String _tmp_1 = EkoUserDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(value.getPermissions());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                stmt.bindLong(5, (long)value.getFlagCount());
                String _tmp_2 = EkoUserDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getAvatarFileId());
                }
                if (value.getAvatarCustomUrl() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getAvatarCustomUrl());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getDescription());
                }
                String _tmp_3 = EkoUserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_3);
                }
                String _tmp_4 = EkoUserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_4);
                }
            }
        };
        this.__deletionAdapterOfEkoInternalUser = new EntityDeletionOrUpdateAdapter<EkoInternalUser>(__db){

            public String createQuery() {
                return "DELETE FROM `user` WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoInternalUser value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
            }
        };
        this.__updateAdapterOfEkoInternalUser = new EntityDeletionOrUpdateAdapter<EkoInternalUser>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `user` SET `userId` = ?,`displayName` = ?,`roles` = ?,`permissions` = ?,`flagCount` = ?,`metadata` = ?,`avatarFileId` = ?,`avatarCustomUrl` = ?,`description` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `userId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoInternalUser value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getDisplayName());
                }
                String _tmp = EkoUserDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(value.getRoles());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                String _tmp_1 = EkoUserDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(value.getPermissions());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_1);
                }
                stmt.bindLong(5, (long)value.getFlagCount());
                String _tmp_2 = EkoUserDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getAvatarFileId());
                }
                if (value.getAvatarCustomUrl() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getAvatarCustomUrl());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getDescription());
                }
                String _tmp_3 = EkoUserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_3);
                }
                String _tmp_4 = EkoUserDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_4);
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getUserId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from user";
                return "DELETE from user";
            }
        };
    }

    @Override
    void insertImpl(EkoInternalUser object) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoInternalUser.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<EkoInternalUser> objects) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoInternalUser.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoInternalUser object) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoInternalUser.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<EkoInternalUser> objects) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoInternalUser.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(EkoInternalUser object) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoInternalUser.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoInternalUser object) {
        this.__db.beginTransaction();
        try {
            super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<EkoInternalUser> objects) {
        this.__db.beginTransaction();
        try {
            super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoInternalUser object) {
        this.__db.beginTransaction();
        try {
            super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    Flowable<EkoInternalUser> getByIdImpl(String userId) {
        String _sql = "SELECT user.*, user_flag.userId as flag_userId, user_flag.flag as flag_flag, user_flag.localFlag as flag_localFlag from user, user_flag where user.userId = ? and user.userId = user_flag.userId LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT user.*, user_flag.userId as flag_userId, user_flag.flag as flag_flag, user_flag.localFlag as flag_localFlag from user, user_flag where user.userId = ? and user.userId = user_flag.userId LIMIT 1", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"user", "user_flag"}, (Callable)new Callable<EkoInternalUser>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoInternalUser call() throws Exception {
                try (Cursor _cursor = EkoUserDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    EkoInternalUser _result;
                    int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
                    int _cursorIndexOfDisplayName = _cursor.getColumnIndexOrThrow("displayName");
                    int _cursorIndexOfRoles = _cursor.getColumnIndexOrThrow("roles");
                    int _cursorIndexOfPermissions = _cursor.getColumnIndexOrThrow("permissions");
                    int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
                    int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
                    int _cursorIndexOfAvatarFileId = _cursor.getColumnIndexOrThrow("avatarFileId");
                    int _cursorIndexOfAvatarCustomUrl = _cursor.getColumnIndexOrThrow("avatarCustomUrl");
                    int _cursorIndexOfDescription = _cursor.getColumnIndexOrThrow("description");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoInternalUser();
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
                        _result.setDisplayName(_tmpDisplayName);
                        String _tmp = _cursor.getString(_cursorIndexOfRoles);
                        AmityRoles _tmpRoles = EkoUserDao_Impl.this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
                        _result.setRoles(_tmpRoles);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfPermissions);
                        AmityPermissions _tmpPermissions = EkoUserDao_Impl.this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
                        _result.setPermissions(_tmpPermissions);
                        int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                        _result.setFlagCount(_tmpFlagCount);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoUserDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                        _result.setMetadata(_tmpMetadata);
                        String _tmpAvatarFileId = _cursor.getString(_cursorIndexOfAvatarFileId);
                        _result.setAvatarFileId(_tmpAvatarFileId);
                        String _tmpAvatarCustomUrl = _cursor.getString(_cursorIndexOfAvatarCustomUrl);
                        _result.setAvatarCustomUrl(_tmpAvatarCustomUrl);
                        String _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
                        _result.setDescription(_tmpDescription);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoUserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoUserDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    EkoInternalUser ekoInternalUser = _result;
                    return ekoInternalUser;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EkoInternalUser getByIdNowImpl(String userId) {
        String _sql = "SELECT user.*, user_flag.userId as flag_userId, user_flag.flag as flag_flag, user_flag.localFlag as flag_localFlag from user, user_flag where user.userId = ? and user.userId = user_flag.userId LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT user.*, user_flag.userId as flag_userId, user_flag.flag as flag_flag, user_flag.localFlag as flag_localFlag from user, user_flag where user.userId = ? and user.userId = user_flag.userId LIMIT 1", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            EkoInternalUser _result;
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfDisplayName = _cursor.getColumnIndexOrThrow("displayName");
            int _cursorIndexOfRoles = _cursor.getColumnIndexOrThrow("roles");
            int _cursorIndexOfPermissions = _cursor.getColumnIndexOrThrow("permissions");
            int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfAvatarFileId = _cursor.getColumnIndexOrThrow("avatarFileId");
            int _cursorIndexOfAvatarCustomUrl = _cursor.getColumnIndexOrThrow("avatarCustomUrl");
            int _cursorIndexOfDescription = _cursor.getColumnIndexOrThrow("description");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new EkoInternalUser();
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
                _result.setDisplayName(_tmpDisplayName);
                String _tmp = _cursor.getString(_cursorIndexOfRoles);
                AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
                _result.setRoles(_tmpRoles);
                String _tmp_1 = _cursor.getString(_cursorIndexOfPermissions);
                AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
                _result.setPermissions(_tmpPermissions);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _result.setFlagCount(_tmpFlagCount);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                _result.setMetadata(_tmpMetadata);
                String _tmpAvatarFileId = _cursor.getString(_cursorIndexOfAvatarFileId);
                _result.setAvatarFileId(_tmpAvatarFileId);
                String _tmpAvatarCustomUrl = _cursor.getString(_cursorIndexOfAvatarCustomUrl);
                _result.setAvatarCustomUrl(_tmpAvatarCustomUrl);
                String _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
                _result.setDescription(_tmpDescription);
                String _tmp_3 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_4 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            EkoInternalUser ekoInternalUser = _result;
            return ekoInternalUser;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<EkoInternalUser> getByIdsNowImpl(List<String> userIds) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT user.*, user_flag.userId as flag_userId, user_flag.flag as flag_flag, user_flag.localFlag as flag_localFlag from user, user_flag where user.userId IN (");
        int _inputSize = userIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and user.userId = user_flag.userId");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : userIds) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfDisplayName = _cursor.getColumnIndexOrThrow("displayName");
            int _cursorIndexOfRoles = _cursor.getColumnIndexOrThrow("roles");
            int _cursorIndexOfPermissions = _cursor.getColumnIndexOrThrow("permissions");
            int _cursorIndexOfFlagCount = _cursor.getColumnIndexOrThrow("flagCount");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfAvatarFileId = _cursor.getColumnIndexOrThrow("avatarFileId");
            int _cursorIndexOfAvatarCustomUrl = _cursor.getColumnIndexOrThrow("avatarCustomUrl");
            int _cursorIndexOfDescription = _cursor.getColumnIndexOrThrow("description");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            ArrayList<EkoInternalUser> _result = new ArrayList<EkoInternalUser>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                EkoInternalUser _item_1 = new EkoInternalUser();
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                _item_1.setUserId(_tmpUserId);
                String _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
                _item_1.setDisplayName(_tmpDisplayName);
                String _tmp = _cursor.getString(_cursorIndexOfRoles);
                AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
                _item_1.setRoles(_tmpRoles);
                String _tmp_1 = _cursor.getString(_cursorIndexOfPermissions);
                AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
                _item_1.setPermissions(_tmpPermissions);
                int _tmpFlagCount = _cursor.getInt(_cursorIndexOfFlagCount);
                _item_1.setFlagCount(_tmpFlagCount);
                String _tmp_2 = _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                _item_1.setMetadata(_tmpMetadata);
                String _tmpAvatarFileId = _cursor.getString(_cursorIndexOfAvatarFileId);
                _item_1.setAvatarFileId(_tmpAvatarFileId);
                String _tmpAvatarCustomUrl = _cursor.getString(_cursorIndexOfAvatarCustomUrl);
                _item_1.setAvatarCustomUrl(_tmpAvatarCustomUrl);
                String _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
                _item_1.setDescription(_tmpDescription);
                String _tmp_3 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_4 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item_1);
            }
            ArrayList<EkoInternalUser> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    DataSource.Factory<Integer, EkoInternalUser> getAllImpl(SupportSQLiteQuery query) {
        final SupportSQLiteQuery _internalQuery = query;
        return new DataSource.Factory<Integer, EkoInternalUser>(){

            public LimitOffsetDataSource<EkoInternalUser> create() {
                return new LimitOffsetDataSource<EkoInternalUser>(EkoUserDao_Impl.this.__db, _internalQuery, false, new String[]{"user", "user_flag"}){

                    protected List<EkoInternalUser> convertRows(Cursor cursor) {
                        ArrayList<EkoInternalUser> _res = new ArrayList<EkoInternalUser>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoInternalUser _item = EkoUserDao_Impl.this.__entityCursorConverter_comEkoappEkosdkEkoInternalUser(cursor);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, EkoInternalUser> searchAllImpl(SupportSQLiteQuery query) {
        final SupportSQLiteQuery _internalQuery = query;
        return new DataSource.Factory<Integer, EkoInternalUser>(){

            public LimitOffsetDataSource<EkoInternalUser> create() {
                return new LimitOffsetDataSource<EkoInternalUser>(EkoUserDao_Impl.this.__db, _internalQuery, false, new String[]{"user", "user_flag"}){

                    protected List<EkoInternalUser> convertRows(Cursor cursor) {
                        ArrayList<EkoInternalUser> _res = new ArrayList<EkoInternalUser>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            EkoInternalUser _item = EkoUserDao_Impl.this.__entityCursorConverter_comEkoappEkosdkEkoInternalUser(cursor);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    private EkoInternalUser __entityCursorConverter_comEkoappEkosdkEkoInternalUser(Cursor cursor) {
        int _cursorIndexOfUserId = cursor.getColumnIndex("userId");
        int _cursorIndexOfDisplayName = cursor.getColumnIndex("displayName");
        int _cursorIndexOfRoles = cursor.getColumnIndex("roles");
        int _cursorIndexOfPermissions = cursor.getColumnIndex("permissions");
        int _cursorIndexOfFlagCount = cursor.getColumnIndex("flagCount");
        int _cursorIndexOfMetadata = cursor.getColumnIndex("metadata");
        int _cursorIndexOfAvatarFileId = cursor.getColumnIndex("avatarFileId");
        int _cursorIndexOfAvatarCustomUrl = cursor.getColumnIndex("avatarCustomUrl");
        int _cursorIndexOfDescription = cursor.getColumnIndex("description");
        int _cursorIndexOfCreatedAt = cursor.getColumnIndex("createdAt");
        int _cursorIndexOfUpdatedAt = cursor.getColumnIndex("updatedAt");
        EkoInternalUser _entity = new EkoInternalUser();
        if (_cursorIndexOfUserId != -1) {
            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
            _entity.setUserId(_tmpUserId);
        }
        if (_cursorIndexOfDisplayName != -1) {
            String _tmpDisplayName = cursor.getString(_cursorIndexOfDisplayName);
            _entity.setDisplayName(_tmpDisplayName);
        }
        if (_cursorIndexOfRoles != -1) {
            String _tmp = cursor.getString(_cursorIndexOfRoles);
            AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp);
            _entity.setRoles(_tmpRoles);
        }
        if (_cursorIndexOfPermissions != -1) {
            String _tmp_1 = cursor.getString(_cursorIndexOfPermissions);
            AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_1);
            _entity.setPermissions(_tmpPermissions);
        }
        if (_cursorIndexOfFlagCount != -1) {
            int _tmpFlagCount = cursor.getInt(_cursorIndexOfFlagCount);
            _entity.setFlagCount(_tmpFlagCount);
        }
        if (_cursorIndexOfMetadata != -1) {
            String _tmp_2 = cursor.getString(_cursorIndexOfMetadata);
            JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
            _entity.setMetadata(_tmpMetadata);
        }
        if (_cursorIndexOfAvatarFileId != -1) {
            String _tmpAvatarFileId = cursor.getString(_cursorIndexOfAvatarFileId);
            _entity.setAvatarFileId(_tmpAvatarFileId);
        }
        if (_cursorIndexOfAvatarCustomUrl != -1) {
            String _tmpAvatarCustomUrl = cursor.getString(_cursorIndexOfAvatarCustomUrl);
            _entity.setAvatarCustomUrl(_tmpAvatarCustomUrl);
        }
        if (_cursorIndexOfDescription != -1) {
            String _tmpDescription = cursor.getString(_cursorIndexOfDescription);
            _entity.setDescription(_tmpDescription);
        }
        if (_cursorIndexOfCreatedAt != -1) {
            String _tmp_3 = cursor.getString(_cursorIndexOfCreatedAt);
            DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
            _entity.setCreatedAt(_tmpCreatedAt);
        }
        if (_cursorIndexOfUpdatedAt != -1) {
            String _tmp_4 = cursor.getString(_cursorIndexOfUpdatedAt);
            DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
            _entity.setUpdatedAt(_tmpUpdatedAt);
        }
        return _entity;
    }
}

