/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.EkoPushConfigStateConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoPushConfigDao;
import com.ekoapp.ekosdk.internal.data.model.EkoPushConfig;
import io.reactivex.Flowable;
import java.util.concurrent.Callable;

public final class EkoPushConfigDao_Impl
extends EkoPushConfigDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfEkoPushConfig;
    private final EkoPushConfigStateConverter __ekoPushConfigStateConverter = new EkoPushConfigStateConverter();
    private final SharedSQLiteStatement __preparedStmtOfUnregisterAll;

    public EkoPushConfigDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoPushConfig = new EntityInsertionAdapter<EkoPushConfig>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `push_config`(`userId`,`deviceId`,`state`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoPushConfig value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                if (value.getDeviceId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getDeviceId());
                }
                String _tmp = EkoPushConfigDao_Impl.this.__ekoPushConfigStateConverter.ekoPushConfigStateToString(value.getState());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
            }
        };
        this.__preparedStmtOfUnregisterAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE push_config set state = 'unregistered'";
                return "UPDATE push_config set state = 'unregistered'";
            }
        };
    }

    @Override
    public void insert(EkoPushConfig pushConfig) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoPushConfig.insert((Object)pushConfig);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void unregisterAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUnregisterAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUnregisterAll.release(_stmt);
        }
    }

    @Override
    Flowable<Integer> countRegisteredConfig() {
        String _sql = "SELECT count(*) from push_config where state = 'registered'";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT count(*) from push_config where state = 'registered'", (int)0);
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"push_config"}, (Callable)new Callable<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer call() throws Exception {
                try (Cursor _cursor = EkoPushConfigDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    Integer _result;
                    if (_cursor.moveToFirst()) {
                        Integer _tmp = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0));
                        _result = _tmp;
                    } else {
                        _result = null;
                    }
                    Integer n = _result;
                    return n;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public Flowable<EkoPushConfig> getPushConfig(String userId) {
        String _sql = "SELECT * from push_config where userId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from push_config where userId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"push_config"}, (Callable)new Callable<EkoPushConfig>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoPushConfig call() throws Exception {
                try (Cursor _cursor = EkoPushConfigDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    EkoPushConfig _result;
                    int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
                    int _cursorIndexOfDeviceId = _cursor.getColumnIndexOrThrow("deviceId");
                    int _cursorIndexOfState = _cursor.getColumnIndexOrThrow("state");
                    if (_cursor.moveToFirst()) {
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        String _tmpDeviceId = _cursor.getString(_cursorIndexOfDeviceId);
                        String _tmp = _cursor.getString(_cursorIndexOfState);
                        EkoPushConfig.State _tmpState = EkoPushConfigDao_Impl.this.__ekoPushConfigStateConverter.stringToEkoPushConfigState(_tmp);
                        _result = new EkoPushConfig(_tmpUserId, _tmpDeviceId, _tmpState);
                    } else {
                        _result = null;
                    }
                    EkoPushConfig ekoPushConfig = _result;
                    return ekoPushConfig;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }
}

