/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.core.AmityTags;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.EkoCategoryIds;
import com.ekoapp.ekosdk.internal.data.converter.EkoCategoriesTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoTagsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityDao;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import com.google.gson.JsonObject;
import io.reactivex.Flowable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoCommunityDao_Impl
extends EkoCommunityDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfCommunityEntity;
    private final EkoTagsTypeConverter __ekoTagsTypeConverter = new EkoTagsTypeConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EkoCategoriesTypeConverter __ekoCategoriesTypeConverter = new EkoCategoriesTypeConverter();
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfCommunityEntity;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfCommunityEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByCommunityIdImpl;
    private final SharedSQLiteStatement __preparedStmtOfUpdateIsJoinedImpl;

    public EkoCommunityDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCommunityEntity = new EntityInsertionAdapter<CommunityEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `community`(`communityId`,`channelId`,`userId`,`displayName`,`description`,`avatarFileId`,`isOfficial`,`isPublic`,`onlyAdminCanPost`,`tags`,`metadata`,`postsCount`,`membersCount`,`isJoined`,`isDeleted`,`editedAt`,`categoryIds`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityEntity value) {
                Integer _tmp_6;
                Integer _tmp_5;
                Integer _tmp_2;
                Integer _tmp_1;
                Integer _tmp;
                if (value.getCommunityId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommunityId());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDisplayName());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getDescription());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getAvatarFileId());
                }
                Integer n = value.isOfficial() == null ? null : (_tmp = Integer.valueOf(value.isOfficial() != false ? 1 : 0));
                if (_tmp == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindLong(7, (long)_tmp.intValue());
                }
                Integer n2 = value.isPublic() == null ? null : (_tmp_1 = Integer.valueOf(value.isPublic() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindLong(8, (long)_tmp_1.intValue());
                }
                Integer n3 = value.getOnlyAdminCanPost() == null ? null : (_tmp_2 = Integer.valueOf(value.getOnlyAdminCanPost() != false ? 1 : 0));
                if (_tmp_2 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, (long)_tmp_2.intValue());
                }
                String _tmp_3 = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.getTags());
                if (_tmp_3 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_3);
                }
                String _tmp_4 = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_4 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_4);
                }
                if (value.getPostsCount() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, (long)value.getPostsCount().intValue());
                }
                if (value.getMembersCount() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, (long)value.getMembersCount().intValue());
                }
                Integer n4 = value.isJoined() == null ? null : (_tmp_5 = Integer.valueOf(value.isJoined() != false ? 1 : 0));
                if (_tmp_5 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, (long)_tmp_5.intValue());
                }
                Integer n5 = value.isDeleted() == null ? null : (_tmp_6 = Integer.valueOf(value.isDeleted() != false ? 1 : 0));
                if (_tmp_6 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, (long)_tmp_6.intValue());
                }
                String _tmp_7 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_7);
                }
                String _tmp_8 = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.ekoCategoriesToString(value.getCategoryIds());
                if (_tmp_8 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_8);
                }
                String _tmp_9 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_9);
                }
                String _tmp_10 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_10 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_10);
                }
            }
        };
        this.__deletionAdapterOfCommunityEntity = new EntityDeletionOrUpdateAdapter<CommunityEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `community` WHERE `communityId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityEntity value) {
                if (value.getCommunityId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommunityId());
                }
            }
        };
        this.__updateAdapterOfCommunityEntity = new EntityDeletionOrUpdateAdapter<CommunityEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `community` SET `communityId` = ?,`channelId` = ?,`userId` = ?,`displayName` = ?,`description` = ?,`avatarFileId` = ?,`isOfficial` = ?,`isPublic` = ?,`onlyAdminCanPost` = ?,`tags` = ?,`metadata` = ?,`postsCount` = ?,`membersCount` = ?,`isJoined` = ?,`isDeleted` = ?,`editedAt` = ?,`categoryIds` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `communityId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityEntity value) {
                Integer _tmp_6;
                Integer _tmp_5;
                Integer _tmp_2;
                Integer _tmp_1;
                Integer _tmp;
                if (value.getCommunityId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommunityId());
                }
                if (value.getChannelId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getChannelId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                if (value.getDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getDisplayName());
                }
                if (value.getDescription() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getDescription());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getAvatarFileId());
                }
                Integer n = value.isOfficial() == null ? null : (_tmp = Integer.valueOf(value.isOfficial() != false ? 1 : 0));
                if (_tmp == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindLong(7, (long)_tmp.intValue());
                }
                Integer n2 = value.isPublic() == null ? null : (_tmp_1 = Integer.valueOf(value.isPublic() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindLong(8, (long)_tmp_1.intValue());
                }
                Integer n3 = value.getOnlyAdminCanPost() == null ? null : (_tmp_2 = Integer.valueOf(value.getOnlyAdminCanPost() != false ? 1 : 0));
                if (_tmp_2 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindLong(9, (long)_tmp_2.intValue());
                }
                String _tmp_3 = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(value.getTags());
                if (_tmp_3 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_3);
                }
                String _tmp_4 = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp_4 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_4);
                }
                if (value.getPostsCount() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, (long)value.getPostsCount().intValue());
                }
                if (value.getMembersCount() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindLong(13, (long)value.getMembersCount().intValue());
                }
                Integer n4 = value.isJoined() == null ? null : (_tmp_5 = Integer.valueOf(value.isJoined() != false ? 1 : 0));
                if (_tmp_5 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindLong(14, (long)_tmp_5.intValue());
                }
                Integer n5 = value.isDeleted() == null ? null : (_tmp_6 = Integer.valueOf(value.isDeleted() != false ? 1 : 0));
                if (_tmp_6 == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindLong(15, (long)_tmp_6.intValue());
                }
                String _tmp_7 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getEditedAt());
                if (_tmp_7 == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, _tmp_7);
                }
                String _tmp_8 = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.ekoCategoriesToString(value.getCategoryIds());
                if (_tmp_8 == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindString(17, _tmp_8);
                }
                String _tmp_9 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_9 == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindString(18, _tmp_9);
                }
                String _tmp_10 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_10 == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindString(19, _tmp_10);
                }
                if (value.getCommunityId() == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, value.getCommunityId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from community";
                return "DELETE from community";
            }
        };
        this.__preparedStmtOfDeleteByCommunityIdImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE community set isDeleted = 1 where communityId = ?";
                return "UPDATE community set isDeleted = 1 where communityId = ?";
            }
        };
        this.__preparedStmtOfUpdateIsJoinedImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE community set isJoined = ? where communityId = ?";
                return "UPDATE community set isJoined = ? where communityId = ?";
            }
        };
    }

    @Override
    void insertImpl(CommunityEntity object) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommunityEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<CommunityEntity> objects) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommunityEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(CommunityEntity object) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommunityEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<CommunityEntity> objects) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommunityEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(CommunityEntity object) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCommunityEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteByCommunityId(String communityId) {
        this.__db.beginTransaction();
        try {
            super.deleteByCommunityId(communityId);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(CommunityEntity community) {
        this.__db.beginTransaction();
        try {
            super.insert(community);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<CommunityEntity> communities) {
        this.__db.beginTransaction();
        try {
            super.insert(communities);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(CommunityEntity community) {
        this.__db.beginTransaction();
        try {
            super.update(community);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(List<CommunityEntity> communities) {
        this.__db.beginTransaction();
        try {
            super.update(communities);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deleteByCommunityIdImpl(String communityId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByCommunityIdImpl.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (communityId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, communityId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByCommunityIdImpl.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateIsJoinedImpl(String communityId, Boolean isJoined) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdateIsJoinedImpl.acquire();
        this.__db.beginTransaction();
        try {
            Integer _tmp;
            int _argIndex = 1;
            Integer n = isJoined == null ? null : (_tmp = Integer.valueOf(isJoined != false ? 1 : 0));
            if (_tmp == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindLong(_argIndex, (long)_tmp.intValue());
            }
            _argIndex = 2;
            if (communityId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, communityId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdateIsJoinedImpl.release(_stmt);
        }
    }

    @Override
    Flowable<CommunityEntity> getByCommunityIdImpl(String communityId) {
        String _sql = "SELECT * from community where community.communityId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community where community.communityId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (communityId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, communityId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"community"}, (Callable)new Callable<CommunityEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CommunityEntity call() throws Exception {
                try (Cursor _cursor = EkoCommunityDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    CommunityEntity _result;
                    int _cursorIndexOfCommunityId = _cursor.getColumnIndexOrThrow("communityId");
                    int _cursorIndexOfChannelId = _cursor.getColumnIndexOrThrow("channelId");
                    int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
                    int _cursorIndexOfDisplayName = _cursor.getColumnIndexOrThrow("displayName");
                    int _cursorIndexOfDescription = _cursor.getColumnIndexOrThrow("description");
                    int _cursorIndexOfAvatarFileId = _cursor.getColumnIndexOrThrow("avatarFileId");
                    int _cursorIndexOfIsOfficial = _cursor.getColumnIndexOrThrow("isOfficial");
                    int _cursorIndexOfIsPublic = _cursor.getColumnIndexOrThrow("isPublic");
                    int _cursorIndexOfOnlyAdminCanPost = _cursor.getColumnIndexOrThrow("onlyAdminCanPost");
                    int _cursorIndexOfTags = _cursor.getColumnIndexOrThrow("tags");
                    int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
                    int _cursorIndexOfPostsCount = _cursor.getColumnIndexOrThrow("postsCount");
                    int _cursorIndexOfMembersCount = _cursor.getColumnIndexOrThrow("membersCount");
                    int _cursorIndexOfIsJoined = _cursor.getColumnIndexOrThrow("isJoined");
                    int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
                    int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
                    int _cursorIndexOfCategoryIds = _cursor.getColumnIndexOrThrow("categoryIds");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new CommunityEntity();
                        String _tmpCommunityId = _cursor.getString(_cursorIndexOfCommunityId);
                        _result.setCommunityId(_tmpCommunityId);
                        String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                        _result.setChannelId(_tmpChannelId);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
                        _result.setDisplayName(_tmpDisplayName);
                        String _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
                        _result.setDescription(_tmpDescription);
                        String _tmpAvatarFileId = _cursor.getString(_cursorIndexOfAvatarFileId);
                        _result.setAvatarFileId(_tmpAvatarFileId);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsOfficial));
                        Boolean _tmpIsOfficial = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                        _result.setOfficial(_tmpIsOfficial);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsPublic));
                        Boolean _tmpIsPublic = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                        _result.setPublic(_tmpIsPublic);
                        Integer _tmp_2 = _cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                        Boolean _tmpOnlyAdminCanPost = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                        _result.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfTags);
                        AmityTags _tmpTags = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
                        _result.setTags(_tmpTags);
                        String _tmp_4 = _cursor.getString(_cursorIndexOfMetadata);
                        JsonObject _tmpMetadata = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                        _result.setMetadata(_tmpMetadata);
                        Integer _tmpPostsCount = _cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPostsCount));
                        _result.setPostsCount(_tmpPostsCount);
                        Integer _tmpMembersCount = _cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMembersCount));
                        _result.setMembersCount(_tmpMembersCount);
                        Integer _tmp_5 = _cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsJoined));
                        Boolean _tmpIsJoined = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                        _result.setJoined(_tmpIsJoined);
                        Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                        Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                        _result.setDeleted(_tmpIsDeleted);
                        String _tmp_7 = _cursor.getString(_cursorIndexOfEditedAt);
                        DateTime _tmpEditedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                        _result.setEditedAt(_tmpEditedAt);
                        String _tmp_8 = _cursor.getString(_cursorIndexOfCategoryIds);
                        EkoCategoryIds _tmpCategoryIds = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_8);
                        _result.setCategoryIds(_tmpCategoryIds);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_10 = _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    CommunityEntity communityEntity = _result;
                    return communityEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    DataSource.Factory<Integer, CommunityEntity> getAllByCategoryIdImpl(String keyword, String categoryId, boolean isSortByDisplayName, boolean isSortByCreatedACS, Boolean isDeleted) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from community where community.displayName LIKE ? || '%' COLLATE NOCASE and community.communityId in (SELECT communityId from category where categoryId = ?) and community.isDeleted = (case when ? is null then isDeleted else ? end) and community.isJoined = (case when community.isPublic is 1 then isJoined else 1 end) order by case when ? = 1 then community.displayName end asc, case when ? = 0 and ? = 1 then community.createdAt end asc, case when ? = 0 and ? = 0 then community.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community where community.displayName LIKE ? || '%' COLLATE NOCASE and community.communityId in (SELECT communityId from category where categoryId = ?) and community.isDeleted = (case when ? is null then isDeleted else ? end) and community.isJoined = (case when community.isPublic is 1 then isJoined else 1 end) order by case when ? = 1 then community.displayName end asc, case when ? = 0 and ? = 1 then community.createdAt end asc, case when ? = 0 and ? = 0 then community.createdAt end desc", (int)9);
        int _argIndex = 1;
        if (keyword == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, keyword);
        }
        _argIndex = 2;
        if (categoryId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, categoryId);
        }
        _argIndex = 3;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 4;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 5;
        int _tmp_2 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 6;
        int _tmp_3 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_3);
        _argIndex = 7;
        int _tmp_4 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_4);
        _argIndex = 8;
        int _tmp_5 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_5);
        _argIndex = 9;
        int _tmp_6 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_6);
        return new DataSource.Factory<Integer, CommunityEntity>(){

            public LimitOffsetDataSource<CommunityEntity> create() {
                return new LimitOffsetDataSource<CommunityEntity>(EkoCommunityDao_Impl.this.__db, _statement, false, new String[]{"community", "category"}){

                    protected List<CommunityEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfCommunityId = cursor.getColumnIndexOrThrow("communityId");
                        int _cursorIndexOfChannelId = cursor.getColumnIndexOrThrow("channelId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfDisplayName = cursor.getColumnIndexOrThrow("displayName");
                        int _cursorIndexOfDescription = cursor.getColumnIndexOrThrow("description");
                        int _cursorIndexOfAvatarFileId = cursor.getColumnIndexOrThrow("avatarFileId");
                        int _cursorIndexOfIsOfficial = cursor.getColumnIndexOrThrow("isOfficial");
                        int _cursorIndexOfIsPublic = cursor.getColumnIndexOrThrow("isPublic");
                        int _cursorIndexOfOnlyAdminCanPost = cursor.getColumnIndexOrThrow("onlyAdminCanPost");
                        int _cursorIndexOfTags = cursor.getColumnIndexOrThrow("tags");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfPostsCount = cursor.getColumnIndexOrThrow("postsCount");
                        int _cursorIndexOfMembersCount = cursor.getColumnIndexOrThrow("membersCount");
                        int _cursorIndexOfIsJoined = cursor.getColumnIndexOrThrow("isJoined");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfCategoryIds = cursor.getColumnIndexOrThrow("categoryIds");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<CommunityEntity> _res = new ArrayList<CommunityEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommunityEntity _item = new CommunityEntity();
                            String _tmpCommunityId = cursor.getString(_cursorIndexOfCommunityId);
                            _item.setCommunityId(_tmpCommunityId);
                            String _tmpChannelId = cursor.getString(_cursorIndexOfChannelId);
                            _item.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item.setUserId(_tmpUserId);
                            String _tmpDisplayName = cursor.getString(_cursorIndexOfDisplayName);
                            _item.setDisplayName(_tmpDisplayName);
                            String _tmpDescription = cursor.getString(_cursorIndexOfDescription);
                            _item.setDescription(_tmpDescription);
                            String _tmpAvatarFileId = cursor.getString(_cursorIndexOfAvatarFileId);
                            _item.setAvatarFileId(_tmpAvatarFileId);
                            Integer _tmp_7 = cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsOfficial));
                            Boolean _tmpIsOfficial = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                            _item.setOfficial(_tmpIsOfficial);
                            Integer _tmp_8 = cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsPublic));
                            Boolean _tmpIsPublic = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                            _item.setPublic(_tmpIsPublic);
                            Integer _tmp_9 = cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                            Boolean _tmpOnlyAdminCanPost = _tmp_9 == null ? null : Boolean.valueOf(_tmp_9 != 0);
                            _item.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                            String _tmp_10 = cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_10);
                            _item.setTags(_tmpTags);
                            String _tmp_11 = cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                            _item.setMetadata(_tmpMetadata);
                            Integer _tmpPostsCount = cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfPostsCount));
                            _item.setPostsCount(_tmpPostsCount);
                            Integer _tmpMembersCount = cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfMembersCount));
                            _item.setMembersCount(_tmpMembersCount);
                            Integer _tmp_12 = cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsJoined));
                            Boolean _tmpIsJoined = _tmp_12 == null ? null : Boolean.valueOf(_tmp_12 != 0);
                            _item.setJoined(_tmpIsJoined);
                            Integer _tmp_13 = cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsDeleted));
                            Boolean _tmpIsDeleted = _tmp_13 == null ? null : Boolean.valueOf(_tmp_13 != 0);
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmp_14 = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setEditedAt(_tmpEditedAt);
                            String _tmp_15 = cursor.getString(_cursorIndexOfCategoryIds);
                            EkoCategoryIds _tmpCategoryIds = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_15);
                            _item.setCategoryIds(_tmpCategoryIds);
                            String _tmp_16 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_17 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_17);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, CommunityEntity> getAllByCategoryIdForMemberImpl(String keyword, String categoryId, boolean isSortByDisplayName, boolean isSortByCreatedACS, Boolean isDeleted) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from community where community.displayName LIKE ? || '%' COLLATE NOCASE and community.isJoined = 1 and community.communityId in (SELECT communityId from category where categoryId = ?) and community.isDeleted = (case when ? is null then isDeleted else ? end) order by case when ? = 1 then community.displayName end asc, case when ? = 0 and ? = 1 then community.createdAt end asc, case when ? = 0 and ? = 0 then community.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community where community.displayName LIKE ? || '%' COLLATE NOCASE and community.isJoined = 1 and community.communityId in (SELECT communityId from category where categoryId = ?) and community.isDeleted = (case when ? is null then isDeleted else ? end) order by case when ? = 1 then community.displayName end asc, case when ? = 0 and ? = 1 then community.createdAt end asc, case when ? = 0 and ? = 0 then community.createdAt end desc", (int)9);
        int _argIndex = 1;
        if (keyword == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, keyword);
        }
        _argIndex = 2;
        if (categoryId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, categoryId);
        }
        _argIndex = 3;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 4;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 5;
        int _tmp_2 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 6;
        int _tmp_3 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_3);
        _argIndex = 7;
        int _tmp_4 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_4);
        _argIndex = 8;
        int _tmp_5 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_5);
        _argIndex = 9;
        int _tmp_6 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_6);
        return new DataSource.Factory<Integer, CommunityEntity>(){

            public LimitOffsetDataSource<CommunityEntity> create() {
                return new LimitOffsetDataSource<CommunityEntity>(EkoCommunityDao_Impl.this.__db, _statement, false, new String[]{"community", "category"}){

                    protected List<CommunityEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfCommunityId = cursor.getColumnIndexOrThrow("communityId");
                        int _cursorIndexOfChannelId = cursor.getColumnIndexOrThrow("channelId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfDisplayName = cursor.getColumnIndexOrThrow("displayName");
                        int _cursorIndexOfDescription = cursor.getColumnIndexOrThrow("description");
                        int _cursorIndexOfAvatarFileId = cursor.getColumnIndexOrThrow("avatarFileId");
                        int _cursorIndexOfIsOfficial = cursor.getColumnIndexOrThrow("isOfficial");
                        int _cursorIndexOfIsPublic = cursor.getColumnIndexOrThrow("isPublic");
                        int _cursorIndexOfOnlyAdminCanPost = cursor.getColumnIndexOrThrow("onlyAdminCanPost");
                        int _cursorIndexOfTags = cursor.getColumnIndexOrThrow("tags");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfPostsCount = cursor.getColumnIndexOrThrow("postsCount");
                        int _cursorIndexOfMembersCount = cursor.getColumnIndexOrThrow("membersCount");
                        int _cursorIndexOfIsJoined = cursor.getColumnIndexOrThrow("isJoined");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfCategoryIds = cursor.getColumnIndexOrThrow("categoryIds");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<CommunityEntity> _res = new ArrayList<CommunityEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommunityEntity _item = new CommunityEntity();
                            String _tmpCommunityId = cursor.getString(_cursorIndexOfCommunityId);
                            _item.setCommunityId(_tmpCommunityId);
                            String _tmpChannelId = cursor.getString(_cursorIndexOfChannelId);
                            _item.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item.setUserId(_tmpUserId);
                            String _tmpDisplayName = cursor.getString(_cursorIndexOfDisplayName);
                            _item.setDisplayName(_tmpDisplayName);
                            String _tmpDescription = cursor.getString(_cursorIndexOfDescription);
                            _item.setDescription(_tmpDescription);
                            String _tmpAvatarFileId = cursor.getString(_cursorIndexOfAvatarFileId);
                            _item.setAvatarFileId(_tmpAvatarFileId);
                            Integer _tmp_7 = cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsOfficial));
                            Boolean _tmpIsOfficial = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                            _item.setOfficial(_tmpIsOfficial);
                            Integer _tmp_8 = cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsPublic));
                            Boolean _tmpIsPublic = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                            _item.setPublic(_tmpIsPublic);
                            Integer _tmp_9 = cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                            Boolean _tmpOnlyAdminCanPost = _tmp_9 == null ? null : Boolean.valueOf(_tmp_9 != 0);
                            _item.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                            String _tmp_10 = cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_10);
                            _item.setTags(_tmpTags);
                            String _tmp_11 = cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                            _item.setMetadata(_tmpMetadata);
                            Integer _tmpPostsCount = cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfPostsCount));
                            _item.setPostsCount(_tmpPostsCount);
                            Integer _tmpMembersCount = cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfMembersCount));
                            _item.setMembersCount(_tmpMembersCount);
                            Integer _tmp_12 = cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsJoined));
                            Boolean _tmpIsJoined = _tmp_12 == null ? null : Boolean.valueOf(_tmp_12 != 0);
                            _item.setJoined(_tmpIsJoined);
                            Integer _tmp_13 = cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsDeleted));
                            Boolean _tmpIsDeleted = _tmp_13 == null ? null : Boolean.valueOf(_tmp_13 != 0);
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmp_14 = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setEditedAt(_tmpEditedAt);
                            String _tmp_15 = cursor.getString(_cursorIndexOfCategoryIds);
                            EkoCategoryIds _tmpCategoryIds = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_15);
                            _item.setCategoryIds(_tmpCategoryIds);
                            String _tmp_16 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_17 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_17);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, CommunityEntity> getAllByCategoryIdForNonMemberImpl(String keyword, String categoryId, boolean isSortByDisplayName, boolean isSortByCreatedACS, Boolean isDeleted) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from community where community.displayName LIKE ? || '%' COLLATE NOCASE and community.isJoined = 0 and community.communityId in (SELECT communityId from category where categoryId = ?) and community.isDeleted = (case when ? is null then isDeleted else ? end) order by case when ? = 1 then community.displayName end asc, case when ? = 0 and ? = 1 then community.createdAt end asc, case when ? = 0 and ? = 0 then community.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community where community.displayName LIKE ? || '%' COLLATE NOCASE and community.isJoined = 0 and community.communityId in (SELECT communityId from category where categoryId = ?) and community.isDeleted = (case when ? is null then isDeleted else ? end) order by case when ? = 1 then community.displayName end asc, case when ? = 0 and ? = 1 then community.createdAt end asc, case when ? = 0 and ? = 0 then community.createdAt end desc", (int)9);
        int _argIndex = 1;
        if (keyword == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, keyword);
        }
        _argIndex = 2;
        if (categoryId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, categoryId);
        }
        _argIndex = 3;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 4;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 5;
        int _tmp_2 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 6;
        int _tmp_3 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_3);
        _argIndex = 7;
        int _tmp_4 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_4);
        _argIndex = 8;
        int _tmp_5 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_5);
        _argIndex = 9;
        int _tmp_6 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_6);
        return new DataSource.Factory<Integer, CommunityEntity>(){

            public LimitOffsetDataSource<CommunityEntity> create() {
                return new LimitOffsetDataSource<CommunityEntity>(EkoCommunityDao_Impl.this.__db, _statement, false, new String[]{"community", "category"}){

                    protected List<CommunityEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfCommunityId = cursor.getColumnIndexOrThrow("communityId");
                        int _cursorIndexOfChannelId = cursor.getColumnIndexOrThrow("channelId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfDisplayName = cursor.getColumnIndexOrThrow("displayName");
                        int _cursorIndexOfDescription = cursor.getColumnIndexOrThrow("description");
                        int _cursorIndexOfAvatarFileId = cursor.getColumnIndexOrThrow("avatarFileId");
                        int _cursorIndexOfIsOfficial = cursor.getColumnIndexOrThrow("isOfficial");
                        int _cursorIndexOfIsPublic = cursor.getColumnIndexOrThrow("isPublic");
                        int _cursorIndexOfOnlyAdminCanPost = cursor.getColumnIndexOrThrow("onlyAdminCanPost");
                        int _cursorIndexOfTags = cursor.getColumnIndexOrThrow("tags");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfPostsCount = cursor.getColumnIndexOrThrow("postsCount");
                        int _cursorIndexOfMembersCount = cursor.getColumnIndexOrThrow("membersCount");
                        int _cursorIndexOfIsJoined = cursor.getColumnIndexOrThrow("isJoined");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfCategoryIds = cursor.getColumnIndexOrThrow("categoryIds");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<CommunityEntity> _res = new ArrayList<CommunityEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommunityEntity _item = new CommunityEntity();
                            String _tmpCommunityId = cursor.getString(_cursorIndexOfCommunityId);
                            _item.setCommunityId(_tmpCommunityId);
                            String _tmpChannelId = cursor.getString(_cursorIndexOfChannelId);
                            _item.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item.setUserId(_tmpUserId);
                            String _tmpDisplayName = cursor.getString(_cursorIndexOfDisplayName);
                            _item.setDisplayName(_tmpDisplayName);
                            String _tmpDescription = cursor.getString(_cursorIndexOfDescription);
                            _item.setDescription(_tmpDescription);
                            String _tmpAvatarFileId = cursor.getString(_cursorIndexOfAvatarFileId);
                            _item.setAvatarFileId(_tmpAvatarFileId);
                            Integer _tmp_7 = cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsOfficial));
                            Boolean _tmpIsOfficial = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                            _item.setOfficial(_tmpIsOfficial);
                            Integer _tmp_8 = cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsPublic));
                            Boolean _tmpIsPublic = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                            _item.setPublic(_tmpIsPublic);
                            Integer _tmp_9 = cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                            Boolean _tmpOnlyAdminCanPost = _tmp_9 == null ? null : Boolean.valueOf(_tmp_9 != 0);
                            _item.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                            String _tmp_10 = cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_10);
                            _item.setTags(_tmpTags);
                            String _tmp_11 = cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                            _item.setMetadata(_tmpMetadata);
                            Integer _tmpPostsCount = cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfPostsCount));
                            _item.setPostsCount(_tmpPostsCount);
                            Integer _tmpMembersCount = cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfMembersCount));
                            _item.setMembersCount(_tmpMembersCount);
                            Integer _tmp_12 = cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsJoined));
                            Boolean _tmpIsJoined = _tmp_12 == null ? null : Boolean.valueOf(_tmp_12 != 0);
                            _item.setJoined(_tmpIsJoined);
                            Integer _tmp_13 = cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsDeleted));
                            Boolean _tmpIsDeleted = _tmp_13 == null ? null : Boolean.valueOf(_tmp_13 != 0);
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmp_14 = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setEditedAt(_tmpEditedAt);
                            String _tmp_15 = cursor.getString(_cursorIndexOfCategoryIds);
                            EkoCategoryIds _tmpCategoryIds = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_15);
                            _item.setCategoryIds(_tmpCategoryIds);
                            String _tmp_16 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_17 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_17);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, CommunityEntity> getAllByKeywordImpl(String keyword, boolean isSortByDisplayName, boolean isSortByCreatedACS, Boolean isDeleted) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from community where community.displayName LIKE ? || '%' COLLATE NOCASE and community.isDeleted = (case when ? is null then isDeleted else ? end) and community.isJoined = (case when community.isPublic is 1 then isJoined else 1 end) order by case when ? = 1 then community.displayName end asc, case when ? = 0 and ? = 1 then community.createdAt end asc, case when ? = 0 and ? = 0 then community.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community where community.displayName LIKE ? || '%' COLLATE NOCASE and community.isDeleted = (case when ? is null then isDeleted else ? end) and community.isJoined = (case when community.isPublic is 1 then isJoined else 1 end) order by case when ? = 1 then community.displayName end asc, case when ? = 0 and ? = 1 then community.createdAt end asc, case when ? = 0 and ? = 0 then community.createdAt end desc", (int)8);
        int _argIndex = 1;
        if (keyword == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, keyword);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        int _tmp_2 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 5;
        int _tmp_3 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_3);
        _argIndex = 6;
        int _tmp_4 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_4);
        _argIndex = 7;
        int _tmp_5 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_5);
        _argIndex = 8;
        int _tmp_6 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_6);
        return new DataSource.Factory<Integer, CommunityEntity>(){

            public LimitOffsetDataSource<CommunityEntity> create() {
                return new LimitOffsetDataSource<CommunityEntity>(EkoCommunityDao_Impl.this.__db, _statement, false, new String[]{"community"}){

                    protected List<CommunityEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfCommunityId = cursor.getColumnIndexOrThrow("communityId");
                        int _cursorIndexOfChannelId = cursor.getColumnIndexOrThrow("channelId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfDisplayName = cursor.getColumnIndexOrThrow("displayName");
                        int _cursorIndexOfDescription = cursor.getColumnIndexOrThrow("description");
                        int _cursorIndexOfAvatarFileId = cursor.getColumnIndexOrThrow("avatarFileId");
                        int _cursorIndexOfIsOfficial = cursor.getColumnIndexOrThrow("isOfficial");
                        int _cursorIndexOfIsPublic = cursor.getColumnIndexOrThrow("isPublic");
                        int _cursorIndexOfOnlyAdminCanPost = cursor.getColumnIndexOrThrow("onlyAdminCanPost");
                        int _cursorIndexOfTags = cursor.getColumnIndexOrThrow("tags");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfPostsCount = cursor.getColumnIndexOrThrow("postsCount");
                        int _cursorIndexOfMembersCount = cursor.getColumnIndexOrThrow("membersCount");
                        int _cursorIndexOfIsJoined = cursor.getColumnIndexOrThrow("isJoined");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfCategoryIds = cursor.getColumnIndexOrThrow("categoryIds");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<CommunityEntity> _res = new ArrayList<CommunityEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommunityEntity _item = new CommunityEntity();
                            String _tmpCommunityId = cursor.getString(_cursorIndexOfCommunityId);
                            _item.setCommunityId(_tmpCommunityId);
                            String _tmpChannelId = cursor.getString(_cursorIndexOfChannelId);
                            _item.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item.setUserId(_tmpUserId);
                            String _tmpDisplayName = cursor.getString(_cursorIndexOfDisplayName);
                            _item.setDisplayName(_tmpDisplayName);
                            String _tmpDescription = cursor.getString(_cursorIndexOfDescription);
                            _item.setDescription(_tmpDescription);
                            String _tmpAvatarFileId = cursor.getString(_cursorIndexOfAvatarFileId);
                            _item.setAvatarFileId(_tmpAvatarFileId);
                            Integer _tmp_7 = cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsOfficial));
                            Boolean _tmpIsOfficial = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                            _item.setOfficial(_tmpIsOfficial);
                            Integer _tmp_8 = cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsPublic));
                            Boolean _tmpIsPublic = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                            _item.setPublic(_tmpIsPublic);
                            Integer _tmp_9 = cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                            Boolean _tmpOnlyAdminCanPost = _tmp_9 == null ? null : Boolean.valueOf(_tmp_9 != 0);
                            _item.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                            String _tmp_10 = cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_10);
                            _item.setTags(_tmpTags);
                            String _tmp_11 = cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                            _item.setMetadata(_tmpMetadata);
                            Integer _tmpPostsCount = cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfPostsCount));
                            _item.setPostsCount(_tmpPostsCount);
                            Integer _tmpMembersCount = cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfMembersCount));
                            _item.setMembersCount(_tmpMembersCount);
                            Integer _tmp_12 = cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsJoined));
                            Boolean _tmpIsJoined = _tmp_12 == null ? null : Boolean.valueOf(_tmp_12 != 0);
                            _item.setJoined(_tmpIsJoined);
                            Integer _tmp_13 = cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsDeleted));
                            Boolean _tmpIsDeleted = _tmp_13 == null ? null : Boolean.valueOf(_tmp_13 != 0);
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmp_14 = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setEditedAt(_tmpEditedAt);
                            String _tmp_15 = cursor.getString(_cursorIndexOfCategoryIds);
                            EkoCategoryIds _tmpCategoryIds = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_15);
                            _item.setCategoryIds(_tmpCategoryIds);
                            String _tmp_16 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_17 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_17);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, CommunityEntity> getAllByKeywordForMemberImpl(String keyword, boolean isSortByDisplayName, boolean isSortByCreatedACS, Boolean isDeleted) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from community where community.displayName LIKE ? || '%' COLLATE NOCASE and community.isJoined = 1 and community.isDeleted = (case when ? is null then isDeleted else ? end) order by case when ? = 1 then community.displayName end asc, case when ? = 0 and ? = 1 then community.createdAt end asc, case when ? = 0 and ? = 0 then community.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community where community.displayName LIKE ? || '%' COLLATE NOCASE and community.isJoined = 1 and community.isDeleted = (case when ? is null then isDeleted else ? end) order by case when ? = 1 then community.displayName end asc, case when ? = 0 and ? = 1 then community.createdAt end asc, case when ? = 0 and ? = 0 then community.createdAt end desc", (int)8);
        int _argIndex = 1;
        if (keyword == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, keyword);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        int _tmp_2 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 5;
        int _tmp_3 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_3);
        _argIndex = 6;
        int _tmp_4 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_4);
        _argIndex = 7;
        int _tmp_5 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_5);
        _argIndex = 8;
        int _tmp_6 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_6);
        return new DataSource.Factory<Integer, CommunityEntity>(){

            public LimitOffsetDataSource<CommunityEntity> create() {
                return new LimitOffsetDataSource<CommunityEntity>(EkoCommunityDao_Impl.this.__db, _statement, false, new String[]{"community"}){

                    protected List<CommunityEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfCommunityId = cursor.getColumnIndexOrThrow("communityId");
                        int _cursorIndexOfChannelId = cursor.getColumnIndexOrThrow("channelId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfDisplayName = cursor.getColumnIndexOrThrow("displayName");
                        int _cursorIndexOfDescription = cursor.getColumnIndexOrThrow("description");
                        int _cursorIndexOfAvatarFileId = cursor.getColumnIndexOrThrow("avatarFileId");
                        int _cursorIndexOfIsOfficial = cursor.getColumnIndexOrThrow("isOfficial");
                        int _cursorIndexOfIsPublic = cursor.getColumnIndexOrThrow("isPublic");
                        int _cursorIndexOfOnlyAdminCanPost = cursor.getColumnIndexOrThrow("onlyAdminCanPost");
                        int _cursorIndexOfTags = cursor.getColumnIndexOrThrow("tags");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfPostsCount = cursor.getColumnIndexOrThrow("postsCount");
                        int _cursorIndexOfMembersCount = cursor.getColumnIndexOrThrow("membersCount");
                        int _cursorIndexOfIsJoined = cursor.getColumnIndexOrThrow("isJoined");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfCategoryIds = cursor.getColumnIndexOrThrow("categoryIds");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<CommunityEntity> _res = new ArrayList<CommunityEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommunityEntity _item = new CommunityEntity();
                            String _tmpCommunityId = cursor.getString(_cursorIndexOfCommunityId);
                            _item.setCommunityId(_tmpCommunityId);
                            String _tmpChannelId = cursor.getString(_cursorIndexOfChannelId);
                            _item.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item.setUserId(_tmpUserId);
                            String _tmpDisplayName = cursor.getString(_cursorIndexOfDisplayName);
                            _item.setDisplayName(_tmpDisplayName);
                            String _tmpDescription = cursor.getString(_cursorIndexOfDescription);
                            _item.setDescription(_tmpDescription);
                            String _tmpAvatarFileId = cursor.getString(_cursorIndexOfAvatarFileId);
                            _item.setAvatarFileId(_tmpAvatarFileId);
                            Integer _tmp_7 = cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsOfficial));
                            Boolean _tmpIsOfficial = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                            _item.setOfficial(_tmpIsOfficial);
                            Integer _tmp_8 = cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsPublic));
                            Boolean _tmpIsPublic = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                            _item.setPublic(_tmpIsPublic);
                            Integer _tmp_9 = cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                            Boolean _tmpOnlyAdminCanPost = _tmp_9 == null ? null : Boolean.valueOf(_tmp_9 != 0);
                            _item.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                            String _tmp_10 = cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_10);
                            _item.setTags(_tmpTags);
                            String _tmp_11 = cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                            _item.setMetadata(_tmpMetadata);
                            Integer _tmpPostsCount = cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfPostsCount));
                            _item.setPostsCount(_tmpPostsCount);
                            Integer _tmpMembersCount = cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfMembersCount));
                            _item.setMembersCount(_tmpMembersCount);
                            Integer _tmp_12 = cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsJoined));
                            Boolean _tmpIsJoined = _tmp_12 == null ? null : Boolean.valueOf(_tmp_12 != 0);
                            _item.setJoined(_tmpIsJoined);
                            Integer _tmp_13 = cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsDeleted));
                            Boolean _tmpIsDeleted = _tmp_13 == null ? null : Boolean.valueOf(_tmp_13 != 0);
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmp_14 = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setEditedAt(_tmpEditedAt);
                            String _tmp_15 = cursor.getString(_cursorIndexOfCategoryIds);
                            EkoCategoryIds _tmpCategoryIds = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_15);
                            _item.setCategoryIds(_tmpCategoryIds);
                            String _tmp_16 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_17 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_17);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, CommunityEntity> getAllByKeywordForNonMemberImpl(String keyword, boolean isSortByDisplayName, boolean isSortByCreatedACS, Boolean isDeleted) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from community where community.displayName LIKE ? || '%' COLLATE NOCASE and community.isJoined = 0 and community.isDeleted = (case when ? is null then isDeleted else ? end) order by case when ? = 1 then community.displayName end asc, case when ? = 0 and ? = 1 then community.createdAt end asc, case when ? = 0 and ? = 0 then community.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community where community.displayName LIKE ? || '%' COLLATE NOCASE and community.isJoined = 0 and community.isDeleted = (case when ? is null then isDeleted else ? end) order by case when ? = 1 then community.displayName end asc, case when ? = 0 and ? = 1 then community.createdAt end asc, case when ? = 0 and ? = 0 then community.createdAt end desc", (int)8);
        int _argIndex = 1;
        if (keyword == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, keyword);
        }
        _argIndex = 2;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 3;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 4;
        int _tmp_2 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 5;
        int _tmp_3 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_3);
        _argIndex = 6;
        int _tmp_4 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_4);
        _argIndex = 7;
        int _tmp_5 = isSortByDisplayName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_5);
        _argIndex = 8;
        int _tmp_6 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_6);
        return new DataSource.Factory<Integer, CommunityEntity>(){

            public LimitOffsetDataSource<CommunityEntity> create() {
                return new LimitOffsetDataSource<CommunityEntity>(EkoCommunityDao_Impl.this.__db, _statement, false, new String[]{"community"}){

                    protected List<CommunityEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfCommunityId = cursor.getColumnIndexOrThrow("communityId");
                        int _cursorIndexOfChannelId = cursor.getColumnIndexOrThrow("channelId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfDisplayName = cursor.getColumnIndexOrThrow("displayName");
                        int _cursorIndexOfDescription = cursor.getColumnIndexOrThrow("description");
                        int _cursorIndexOfAvatarFileId = cursor.getColumnIndexOrThrow("avatarFileId");
                        int _cursorIndexOfIsOfficial = cursor.getColumnIndexOrThrow("isOfficial");
                        int _cursorIndexOfIsPublic = cursor.getColumnIndexOrThrow("isPublic");
                        int _cursorIndexOfOnlyAdminCanPost = cursor.getColumnIndexOrThrow("onlyAdminCanPost");
                        int _cursorIndexOfTags = cursor.getColumnIndexOrThrow("tags");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfPostsCount = cursor.getColumnIndexOrThrow("postsCount");
                        int _cursorIndexOfMembersCount = cursor.getColumnIndexOrThrow("membersCount");
                        int _cursorIndexOfIsJoined = cursor.getColumnIndexOrThrow("isJoined");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfCategoryIds = cursor.getColumnIndexOrThrow("categoryIds");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<CommunityEntity> _res = new ArrayList<CommunityEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommunityEntity _item = new CommunityEntity();
                            String _tmpCommunityId = cursor.getString(_cursorIndexOfCommunityId);
                            _item.setCommunityId(_tmpCommunityId);
                            String _tmpChannelId = cursor.getString(_cursorIndexOfChannelId);
                            _item.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item.setUserId(_tmpUserId);
                            String _tmpDisplayName = cursor.getString(_cursorIndexOfDisplayName);
                            _item.setDisplayName(_tmpDisplayName);
                            String _tmpDescription = cursor.getString(_cursorIndexOfDescription);
                            _item.setDescription(_tmpDescription);
                            String _tmpAvatarFileId = cursor.getString(_cursorIndexOfAvatarFileId);
                            _item.setAvatarFileId(_tmpAvatarFileId);
                            Integer _tmp_7 = cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsOfficial));
                            Boolean _tmpIsOfficial = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                            _item.setOfficial(_tmpIsOfficial);
                            Integer _tmp_8 = cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsPublic));
                            Boolean _tmpIsPublic = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                            _item.setPublic(_tmpIsPublic);
                            Integer _tmp_9 = cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                            Boolean _tmpOnlyAdminCanPost = _tmp_9 == null ? null : Boolean.valueOf(_tmp_9 != 0);
                            _item.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                            String _tmp_10 = cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_10);
                            _item.setTags(_tmpTags);
                            String _tmp_11 = cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                            _item.setMetadata(_tmpMetadata);
                            Integer _tmpPostsCount = cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfPostsCount));
                            _item.setPostsCount(_tmpPostsCount);
                            Integer _tmpMembersCount = cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfMembersCount));
                            _item.setMembersCount(_tmpMembersCount);
                            Integer _tmp_12 = cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsJoined));
                            Boolean _tmpIsJoined = _tmp_12 == null ? null : Boolean.valueOf(_tmp_12 != 0);
                            _item.setJoined(_tmpIsJoined);
                            Integer _tmp_13 = cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsDeleted));
                            Boolean _tmpIsDeleted = _tmp_13 == null ? null : Boolean.valueOf(_tmp_13 != 0);
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmp_14 = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                            _item.setEditedAt(_tmpEditedAt);
                            String _tmp_15 = cursor.getString(_cursorIndexOfCategoryIds);
                            EkoCategoryIds _tmpCategoryIds = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_15);
                            _item.setCategoryIds(_tmpCategoryIds);
                            String _tmp_16 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_17 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_17);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    CommunityEntity getByIdNowImpl(String id) {
        String _sql = "SELECT * from community where communityId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community where communityId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            CommunityEntity _result;
            int _cursorIndexOfCommunityId = _cursor.getColumnIndexOrThrow("communityId");
            int _cursorIndexOfChannelId = _cursor.getColumnIndexOrThrow("channelId");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfDisplayName = _cursor.getColumnIndexOrThrow("displayName");
            int _cursorIndexOfDescription = _cursor.getColumnIndexOrThrow("description");
            int _cursorIndexOfAvatarFileId = _cursor.getColumnIndexOrThrow("avatarFileId");
            int _cursorIndexOfIsOfficial = _cursor.getColumnIndexOrThrow("isOfficial");
            int _cursorIndexOfIsPublic = _cursor.getColumnIndexOrThrow("isPublic");
            int _cursorIndexOfOnlyAdminCanPost = _cursor.getColumnIndexOrThrow("onlyAdminCanPost");
            int _cursorIndexOfTags = _cursor.getColumnIndexOrThrow("tags");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfPostsCount = _cursor.getColumnIndexOrThrow("postsCount");
            int _cursorIndexOfMembersCount = _cursor.getColumnIndexOrThrow("membersCount");
            int _cursorIndexOfIsJoined = _cursor.getColumnIndexOrThrow("isJoined");
            int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
            int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
            int _cursorIndexOfCategoryIds = _cursor.getColumnIndexOrThrow("categoryIds");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new CommunityEntity();
                String _tmpCommunityId = _cursor.getString(_cursorIndexOfCommunityId);
                _result.setCommunityId(_tmpCommunityId);
                String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                _result.setChannelId(_tmpChannelId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
                _result.setDisplayName(_tmpDisplayName);
                String _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
                _result.setDescription(_tmpDescription);
                String _tmpAvatarFileId = _cursor.getString(_cursorIndexOfAvatarFileId);
                _result.setAvatarFileId(_tmpAvatarFileId);
                Integer _tmp = _cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsOfficial));
                Boolean _tmpIsOfficial = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                _result.setOfficial(_tmpIsOfficial);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsPublic));
                Boolean _tmpIsPublic = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                _result.setPublic(_tmpIsPublic);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                Boolean _tmpOnlyAdminCanPost = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                _result.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                String _tmp_3 = _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
                _result.setTags(_tmpTags);
                String _tmp_4 = _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _result.setMetadata(_tmpMetadata);
                Integer _tmpPostsCount = _cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPostsCount));
                _result.setPostsCount(_tmpPostsCount);
                Integer _tmpMembersCount = _cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMembersCount));
                _result.setMembersCount(_tmpMembersCount);
                Integer _tmp_5 = _cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsJoined));
                Boolean _tmpIsJoined = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                _result.setJoined(_tmpIsJoined);
                Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                _result.setDeleted(_tmpIsDeleted);
                String _tmp_7 = _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _result.setEditedAt(_tmpEditedAt);
                String _tmp_8 = _cursor.getString(_cursorIndexOfCategoryIds);
                EkoCategoryIds _tmpCategoryIds = this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_8);
                _result.setCategoryIds(_tmpCategoryIds);
                String _tmp_9 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_10 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            CommunityEntity communityEntity = _result;
            return communityEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<CommunityEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from community where community.communityId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfCommunityId = _cursor.getColumnIndexOrThrow("communityId");
            int _cursorIndexOfChannelId = _cursor.getColumnIndexOrThrow("channelId");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfDisplayName = _cursor.getColumnIndexOrThrow("displayName");
            int _cursorIndexOfDescription = _cursor.getColumnIndexOrThrow("description");
            int _cursorIndexOfAvatarFileId = _cursor.getColumnIndexOrThrow("avatarFileId");
            int _cursorIndexOfIsOfficial = _cursor.getColumnIndexOrThrow("isOfficial");
            int _cursorIndexOfIsPublic = _cursor.getColumnIndexOrThrow("isPublic");
            int _cursorIndexOfOnlyAdminCanPost = _cursor.getColumnIndexOrThrow("onlyAdminCanPost");
            int _cursorIndexOfTags = _cursor.getColumnIndexOrThrow("tags");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfPostsCount = _cursor.getColumnIndexOrThrow("postsCount");
            int _cursorIndexOfMembersCount = _cursor.getColumnIndexOrThrow("membersCount");
            int _cursorIndexOfIsJoined = _cursor.getColumnIndexOrThrow("isJoined");
            int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
            int _cursorIndexOfEditedAt = _cursor.getColumnIndexOrThrow("editedAt");
            int _cursorIndexOfCategoryIds = _cursor.getColumnIndexOrThrow("categoryIds");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            ArrayList<CommunityEntity> _result = new ArrayList<CommunityEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CommunityEntity _item_1 = new CommunityEntity();
                String _tmpCommunityId = _cursor.getString(_cursorIndexOfCommunityId);
                _item_1.setCommunityId(_tmpCommunityId);
                String _tmpChannelId = _cursor.getString(_cursorIndexOfChannelId);
                _item_1.setChannelId(_tmpChannelId);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                _item_1.setUserId(_tmpUserId);
                String _tmpDisplayName = _cursor.getString(_cursorIndexOfDisplayName);
                _item_1.setDisplayName(_tmpDisplayName);
                String _tmpDescription = _cursor.getString(_cursorIndexOfDescription);
                _item_1.setDescription(_tmpDescription);
                String _tmpAvatarFileId = _cursor.getString(_cursorIndexOfAvatarFileId);
                _item_1.setAvatarFileId(_tmpAvatarFileId);
                Integer _tmp = _cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsOfficial));
                Boolean _tmpIsOfficial = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                _item_1.setOfficial(_tmpIsOfficial);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsPublic));
                Boolean _tmpIsPublic = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                _item_1.setPublic(_tmpIsPublic);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                Boolean _tmpOnlyAdminCanPost = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                _item_1.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                String _tmp_3 = _cursor.getString(_cursorIndexOfTags);
                AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
                _item_1.setTags(_tmpTags);
                String _tmp_4 = _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                _item_1.setMetadata(_tmpMetadata);
                Integer _tmpPostsCount = _cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfPostsCount));
                _item_1.setPostsCount(_tmpPostsCount);
                Integer _tmpMembersCount = _cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMembersCount));
                _item_1.setMembersCount(_tmpMembersCount);
                Integer _tmp_5 = _cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsJoined));
                Boolean _tmpIsJoined = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                _item_1.setJoined(_tmpIsJoined);
                Integer _tmp_6 = _cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfIsDeleted));
                Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                _item_1.setDeleted(_tmpIsDeleted);
                String _tmp_7 = _cursor.getString(_cursorIndexOfEditedAt);
                DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                _item_1.setEditedAt(_tmpEditedAt);
                String _tmp_8 = _cursor.getString(_cursorIndexOfCategoryIds);
                EkoCategoryIds _tmpCategoryIds = this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_8);
                _item_1.setCategoryIds(_tmpCategoryIds);
                String _tmp_9 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_10 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item_1);
            }
            ArrayList<CommunityEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    DataSource.Factory<Integer, CommunityEntity> getTrendingCommunityCollectionImpl() {
        String _sql = "SELECT community.*, trending_community.* from community, trending_community where community.communityId = trending_community.communityId order by trending_community.createdAt ASC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT community.*, trending_community.* from community, trending_community where community.communityId = trending_community.communityId order by trending_community.createdAt ASC", (int)0);
        return new DataSource.Factory<Integer, CommunityEntity>(){

            public LimitOffsetDataSource<CommunityEntity> create() {
                return new LimitOffsetDataSource<CommunityEntity>(EkoCommunityDao_Impl.this.__db, _statement, true, new String[]{"community", "trending_community"}){

                    protected List<CommunityEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfCommunityId = cursor.getColumnIndexOrThrow("communityId");
                        int _cursorIndexOfChannelId = cursor.getColumnIndexOrThrow("channelId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfDisplayName = cursor.getColumnIndexOrThrow("displayName");
                        int _cursorIndexOfDescription = cursor.getColumnIndexOrThrow("description");
                        int _cursorIndexOfAvatarFileId = cursor.getColumnIndexOrThrow("avatarFileId");
                        int _cursorIndexOfIsOfficial = cursor.getColumnIndexOrThrow("isOfficial");
                        int _cursorIndexOfIsPublic = cursor.getColumnIndexOrThrow("isPublic");
                        int _cursorIndexOfOnlyAdminCanPost = cursor.getColumnIndexOrThrow("onlyAdminCanPost");
                        int _cursorIndexOfTags = cursor.getColumnIndexOrThrow("tags");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfPostsCount = cursor.getColumnIndexOrThrow("postsCount");
                        int _cursorIndexOfMembersCount = cursor.getColumnIndexOrThrow("membersCount");
                        int _cursorIndexOfIsJoined = cursor.getColumnIndexOrThrow("isJoined");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfCategoryIds = cursor.getColumnIndexOrThrow("categoryIds");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        int _cursorIndexOfCommunityId_1 = cursor.getColumnIndexOrThrow("communityId");
                        int _cursorIndexOfCreatedAt_1 = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt_1 = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<CommunityEntity> _res = new ArrayList<CommunityEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommunityEntity _item = new CommunityEntity();
                            String _tmpCommunityId = cursor.getString(_cursorIndexOfCommunityId);
                            _item.setCommunityId(_tmpCommunityId);
                            String _tmpChannelId = cursor.getString(_cursorIndexOfChannelId);
                            _item.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item.setUserId(_tmpUserId);
                            String _tmpDisplayName = cursor.getString(_cursorIndexOfDisplayName);
                            _item.setDisplayName(_tmpDisplayName);
                            String _tmpDescription = cursor.getString(_cursorIndexOfDescription);
                            _item.setDescription(_tmpDescription);
                            String _tmpAvatarFileId = cursor.getString(_cursorIndexOfAvatarFileId);
                            _item.setAvatarFileId(_tmpAvatarFileId);
                            Integer _tmp = cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsOfficial));
                            Boolean _tmpIsOfficial = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                            _item.setOfficial(_tmpIsOfficial);
                            Integer _tmp_1 = cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsPublic));
                            Boolean _tmpIsPublic = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                            _item.setPublic(_tmpIsPublic);
                            Integer _tmp_2 = cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                            Boolean _tmpOnlyAdminCanPost = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                            _item.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                            String _tmp_3 = cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
                            _item.setTags(_tmpTags);
                            String _tmp_4 = cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item.setMetadata(_tmpMetadata);
                            Integer _tmpPostsCount = cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfPostsCount));
                            _item.setPostsCount(_tmpPostsCount);
                            Integer _tmpMembersCount = cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfMembersCount));
                            _item.setMembersCount(_tmpMembersCount);
                            Integer _tmp_5 = cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsJoined));
                            Boolean _tmpIsJoined = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                            _item.setJoined(_tmpIsJoined);
                            Integer _tmp_6 = cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsDeleted));
                            Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmp_7 = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                            _item.setEditedAt(_tmpEditedAt);
                            String _tmp_8 = cursor.getString(_cursorIndexOfCategoryIds);
                            EkoCategoryIds _tmpCategoryIds = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_8);
                            _item.setCategoryIds(_tmpCategoryIds);
                            String _tmp_9 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_10 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            String _tmpCommunityId_1 = cursor.getString(_cursorIndexOfCommunityId_1);
                            _item.setCommunityId(_tmpCommunityId_1);
                            String _tmp_11 = cursor.getString(_cursorIndexOfCreatedAt_1);
                            DateTime _tmpCreatedAt_1 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                            _item.setCreatedAt(_tmpCreatedAt_1);
                            String _tmp_12 = cursor.getString(_cursorIndexOfUpdatedAt_1);
                            DateTime _tmpUpdatedAt_1 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                            _item.setUpdatedAt(_tmpUpdatedAt_1);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, CommunityEntity> getRecommendedCommunityCollectionImpl() {
        String _sql = "SELECT community.*, recommended_community.* from community, recommended_community where community.communityId = recommended_community.communityId order by recommended_community.createdAt ASC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT community.*, recommended_community.* from community, recommended_community where community.communityId = recommended_community.communityId order by recommended_community.createdAt ASC", (int)0);
        return new DataSource.Factory<Integer, CommunityEntity>(){

            public LimitOffsetDataSource<CommunityEntity> create() {
                return new LimitOffsetDataSource<CommunityEntity>(EkoCommunityDao_Impl.this.__db, _statement, true, new String[]{"community", "recommended_community"}){

                    protected List<CommunityEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfCommunityId = cursor.getColumnIndexOrThrow("communityId");
                        int _cursorIndexOfChannelId = cursor.getColumnIndexOrThrow("channelId");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfDisplayName = cursor.getColumnIndexOrThrow("displayName");
                        int _cursorIndexOfDescription = cursor.getColumnIndexOrThrow("description");
                        int _cursorIndexOfAvatarFileId = cursor.getColumnIndexOrThrow("avatarFileId");
                        int _cursorIndexOfIsOfficial = cursor.getColumnIndexOrThrow("isOfficial");
                        int _cursorIndexOfIsPublic = cursor.getColumnIndexOrThrow("isPublic");
                        int _cursorIndexOfOnlyAdminCanPost = cursor.getColumnIndexOrThrow("onlyAdminCanPost");
                        int _cursorIndexOfTags = cursor.getColumnIndexOrThrow("tags");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfPostsCount = cursor.getColumnIndexOrThrow("postsCount");
                        int _cursorIndexOfMembersCount = cursor.getColumnIndexOrThrow("membersCount");
                        int _cursorIndexOfIsJoined = cursor.getColumnIndexOrThrow("isJoined");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfEditedAt = cursor.getColumnIndexOrThrow("editedAt");
                        int _cursorIndexOfCategoryIds = cursor.getColumnIndexOrThrow("categoryIds");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        int _cursorIndexOfCommunityId_1 = cursor.getColumnIndexOrThrow("communityId");
                        int _cursorIndexOfCreatedAt_1 = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt_1 = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<CommunityEntity> _res = new ArrayList<CommunityEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommunityEntity _item = new CommunityEntity();
                            String _tmpCommunityId = cursor.getString(_cursorIndexOfCommunityId);
                            _item.setCommunityId(_tmpCommunityId);
                            String _tmpChannelId = cursor.getString(_cursorIndexOfChannelId);
                            _item.setChannelId(_tmpChannelId);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            _item.setUserId(_tmpUserId);
                            String _tmpDisplayName = cursor.getString(_cursorIndexOfDisplayName);
                            _item.setDisplayName(_tmpDisplayName);
                            String _tmpDescription = cursor.getString(_cursorIndexOfDescription);
                            _item.setDescription(_tmpDescription);
                            String _tmpAvatarFileId = cursor.getString(_cursorIndexOfAvatarFileId);
                            _item.setAvatarFileId(_tmpAvatarFileId);
                            Integer _tmp = cursor.isNull(_cursorIndexOfIsOfficial) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsOfficial));
                            Boolean _tmpIsOfficial = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                            _item.setOfficial(_tmpIsOfficial);
                            Integer _tmp_1 = cursor.isNull(_cursorIndexOfIsPublic) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsPublic));
                            Boolean _tmpIsPublic = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                            _item.setPublic(_tmpIsPublic);
                            Integer _tmp_2 = cursor.isNull(_cursorIndexOfOnlyAdminCanPost) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfOnlyAdminCanPost));
                            Boolean _tmpOnlyAdminCanPost = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                            _item.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                            String _tmp_3 = cursor.getString(_cursorIndexOfTags);
                            AmityTags _tmpTags = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
                            _item.setTags(_tmpTags);
                            String _tmp_4 = cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                            _item.setMetadata(_tmpMetadata);
                            Integer _tmpPostsCount = cursor.isNull(_cursorIndexOfPostsCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfPostsCount));
                            _item.setPostsCount(_tmpPostsCount);
                            Integer _tmpMembersCount = cursor.isNull(_cursorIndexOfMembersCount) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfMembersCount));
                            _item.setMembersCount(_tmpMembersCount);
                            Integer _tmp_5 = cursor.isNull(_cursorIndexOfIsJoined) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsJoined));
                            Boolean _tmpIsJoined = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                            _item.setJoined(_tmpIsJoined);
                            Integer _tmp_6 = cursor.isNull(_cursorIndexOfIsDeleted) ? null : Integer.valueOf(cursor.getInt(_cursorIndexOfIsDeleted));
                            Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmp_7 = cursor.getString(_cursorIndexOfEditedAt);
                            DateTime _tmpEditedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                            _item.setEditedAt(_tmpEditedAt);
                            String _tmp_8 = cursor.getString(_cursorIndexOfCategoryIds);
                            EkoCategoryIds _tmpCategoryIds = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_8);
                            _item.setCategoryIds(_tmpCategoryIds);
                            String _tmp_9 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_10 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            String _tmpCommunityId_1 = cursor.getString(_cursorIndexOfCommunityId_1);
                            _item.setCommunityId(_tmpCommunityId_1);
                            String _tmp_11 = cursor.getString(_cursorIndexOfCreatedAt_1);
                            DateTime _tmpCreatedAt_1 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                            _item.setCreatedAt(_tmpCreatedAt_1);
                            String _tmp_12 = cursor.getString(_cursorIndexOfUpdatedAt_1);
                            DateTime _tmpUpdatedAt_1 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                            _item.setUpdatedAt(_tmpUpdatedAt_1);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }
}

