/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.community.category.CommunityCategoryEntity;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityCategoryDao;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public final class EkoCommunityCategoryDao_Impl
extends EkoCommunityCategoryDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfCommunityCategoryEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfCommunityCategoryEntity;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfCommunityCategoryEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoCommunityCategoryDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfCommunityCategoryEntity = new EntityInsertionAdapter<CommunityCategoryEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `community_category`(`categoryId`,`name`,`avatarFileId`,`metadata`,`isDeleted`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityCategoryEntity value) {
                if (value.getCategoryId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCategoryId());
                }
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAvatarFileId());
                }
                String _tmp = EkoCommunityCategoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                int _tmp_1 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                String _tmp_2 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                String _tmp_3 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
            }
        };
        this.__deletionAdapterOfCommunityCategoryEntity = new EntityDeletionOrUpdateAdapter<CommunityCategoryEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `community_category` WHERE `categoryId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityCategoryEntity value) {
                if (value.getCategoryId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCategoryId());
                }
            }
        };
        this.__updateAdapterOfCommunityCategoryEntity = new EntityDeletionOrUpdateAdapter<CommunityCategoryEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `community_category` SET `categoryId` = ?,`name` = ?,`avatarFileId` = ?,`metadata` = ?,`isDeleted` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `categoryId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, CommunityCategoryEntity value) {
                if (value.getCategoryId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCategoryId());
                }
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                if (value.getAvatarFileId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getAvatarFileId());
                }
                String _tmp = EkoCommunityCategoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(value.getMetadata());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                int _tmp_1 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                String _tmp_2 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                String _tmp_3 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_3);
                }
                if (value.getCategoryId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getCategoryId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from community_category";
                return "DELETE from community_category";
            }
        };
    }

    @Override
    void insertImpl(CommunityCategoryEntity object) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommunityCategoryEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<CommunityCategoryEntity> objects) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfCommunityCategoryEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<CommunityCategoryEntity> objects) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommunityCategoryEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(CommunityCategoryEntity category) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfCommunityCategoryEntity.handle((Object)category);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(CommunityCategoryEntity object) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfCommunityCategoryEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(CommunityCategoryEntity object) {
        this.__db.beginTransaction();
        try {
            super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<CommunityCategoryEntity> objects) {
        this.__db.beginTransaction();
        try {
            super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(CommunityCategoryEntity object) {
        this.__db.beginTransaction();
        try {
            super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    DataSource.Factory<Integer, CommunityCategoryEntity> getAllImpl(boolean isSortByName, boolean isSortByCreatedACS, Boolean isDeleted) {
        Integer _tmp_1;
        Integer _tmp;
        String _sql = "SELECT * from community_category where community_category.isDeleted = (case when ? is null then isDeleted else ? end) order by case when ? = 1 then community_category.name end asc, case when ? = 0 and ? = 1 then community_category.createdAt end asc, case when ? = 0 and ? = 0 then community_category.createdAt end desc";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from community_category where community_category.isDeleted = (case when ? is null then isDeleted else ? end) order by case when ? = 1 then community_category.name end asc, case when ? = 0 and ? = 1 then community_category.createdAt end asc, case when ? = 0 and ? = 0 then community_category.createdAt end desc", (int)7);
        int _argIndex = 1;
        Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        _argIndex = 3;
        int _tmp_2 = isSortByName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_2);
        _argIndex = 4;
        int _tmp_3 = isSortByName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_3);
        _argIndex = 5;
        int _tmp_4 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_4);
        _argIndex = 6;
        int _tmp_5 = isSortByName ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_5);
        _argIndex = 7;
        int _tmp_6 = isSortByCreatedACS ? 1 : 0;
        _statement.bindLong(_argIndex, (long)_tmp_6);
        return new DataSource.Factory<Integer, CommunityCategoryEntity>(){

            public LimitOffsetDataSource<CommunityCategoryEntity> create() {
                return new LimitOffsetDataSource<CommunityCategoryEntity>(EkoCommunityCategoryDao_Impl.this.__db, _statement, false, new String[]{"community_category"}){

                    protected List<CommunityCategoryEntity> convertRows(Cursor cursor) {
                        int _cursorIndexOfCategoryId = cursor.getColumnIndexOrThrow("categoryId");
                        int _cursorIndexOfName = cursor.getColumnIndexOrThrow("name");
                        int _cursorIndexOfAvatarFileId = cursor.getColumnIndexOrThrow("avatarFileId");
                        int _cursorIndexOfMetadata = cursor.getColumnIndexOrThrow("metadata");
                        int _cursorIndexOfIsDeleted = cursor.getColumnIndexOrThrow("isDeleted");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<CommunityCategoryEntity> _res = new ArrayList<CommunityCategoryEntity>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            CommunityCategoryEntity _item = new CommunityCategoryEntity();
                            String _tmpCategoryId = cursor.getString(_cursorIndexOfCategoryId);
                            _item.setCategoryId(_tmpCategoryId);
                            String _tmpName = cursor.getString(_cursorIndexOfName);
                            _item.setName(_tmpName);
                            String _tmpAvatarFileId = cursor.getString(_cursorIndexOfAvatarFileId);
                            _item.setAvatarFileId(_tmpAvatarFileId);
                            String _tmp_7 = cursor.getString(_cursorIndexOfMetadata);
                            JsonObject _tmpMetadata = EkoCommunityCategoryDao_Impl.this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                            _item.setMetadata(_tmpMetadata);
                            int _tmp_8 = cursor.getInt(_cursorIndexOfIsDeleted);
                            boolean _tmpIsDeleted = _tmp_8 != 0;
                            _item.setDeleted(_tmpIsDeleted);
                            String _tmp_9 = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_10 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<CommunityCategoryEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("SELECT * from community_category where community_category.categoryId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        int _argCount = 0 + _inputSize;
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)_sql, (int)_argCount);
        int _argIndex = 1;
        for (String _item : ids) {
            if (_item == null) {
                _statement.bindNull(_argIndex);
            } else {
                _statement.bindString(_argIndex, _item);
            }
            ++_argIndex;
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfCategoryId = _cursor.getColumnIndexOrThrow("categoryId");
            int _cursorIndexOfName = _cursor.getColumnIndexOrThrow("name");
            int _cursorIndexOfAvatarFileId = _cursor.getColumnIndexOrThrow("avatarFileId");
            int _cursorIndexOfMetadata = _cursor.getColumnIndexOrThrow("metadata");
            int _cursorIndexOfIsDeleted = _cursor.getColumnIndexOrThrow("isDeleted");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            ArrayList<CommunityCategoryEntity> _result = new ArrayList<CommunityCategoryEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                CommunityCategoryEntity _item_1 = new CommunityCategoryEntity();
                String _tmpCategoryId = _cursor.getString(_cursorIndexOfCategoryId);
                _item_1.setCategoryId(_tmpCategoryId);
                String _tmpName = _cursor.getString(_cursorIndexOfName);
                _item_1.setName(_tmpName);
                String _tmpAvatarFileId = _cursor.getString(_cursorIndexOfAvatarFileId);
                _item_1.setAvatarFileId(_tmpAvatarFileId);
                String _tmp = _cursor.getString(_cursorIndexOfMetadata);
                JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                _item_1.setMetadata(_tmpMetadata);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_1 != 0;
                _item_1.setDeleted(_tmpIsDeleted);
                String _tmp_2 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _item_1.setCreatedAt(_tmpCreatedAt);
                String _tmp_3 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _item_1.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item_1);
            }
            ArrayList<CommunityCategoryEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

