/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoMessageMapper;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectPersister;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoInternalReactionDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoInternalReaction;
import com.ekoapp.ekosdk.internal.data.model.EkoMessageFlag;
import com.google.common.collect.FluentIterable;
import java.util.Collections;
import java.util.List;

class EkoMessageListPersister
extends EkoObjectPersister {
    EkoMessageListPersister() {
    }

    static void persist(final List<EkoMessageDto> dtoList) {
        final UserDatabase userDatabase = UserDatabase.get();
        userDatabase.runInTransaction(new Runnable(){

            @Override
            public void run() {
                EkoObjectPersister.persistChanges(dtoList, EkoMessageMapper.MAPPER, userDatabase.messageDao());
                EkoMessageFlagDao flagDao = userDatabase.messageFlagDao();
                EkoInternalReactionDao reactionDao = userDatabase.reactionDao();
                for (EkoMessageDto messageDto : dtoList) {
                    reactionDao.deleteByReferenceIdAndUserId(messageDto.getMessageId(), ReactionReferenceType.MESSAGE.getValue(), AmityCoreClient.INSTANCE.getUserId());
                    reactionDao.insert(FluentIterable.from(messageDto.getMyReactions() == null ? Collections.emptyList() : messageDto.getMyReactions()).transform(reactionName -> EkoInternalReaction.createFromPrimaryKeys(ReactionReferenceType.MESSAGE, messageDto.getMessageId(), reactionName, AmityCoreClient.INSTANCE.getUserId())).toList());
                    EkoMessageFlag messageFlag = new EkoMessageFlag();
                    messageFlag.setMessageId(messageDto.getMessageId());
                    messageFlag.setFlag(messageDto.getFlag());
                    EkoMessageFlag diskFlag = flagDao.getByIdNow(messageDto.getMessageId());
                    if (diskFlag != null) {
                        messageFlag.setLocalFlag(diskFlag.getLocalFlag());
                        flagDao.update(messageFlag);
                        continue;
                    }
                    flagDao.insert(messageFlag);
                }
            }
        });
    }
}

