/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionAndUserListDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoReactorDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectMapper;
import com.ekoapp.ekosdk.internal.data.model.EkoInternalReaction;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public interface EkoInternalReactionMapper
extends EkoObjectMapper<EkoReactionAndUserListDto, List<EkoInternalReaction>> {
    public static final EkoInternalReactionMapper MAPPER = dto -> {
        List<EkoUserDto> userDtoList = dto.getUsers();
        HashMap userMap = Maps.newHashMap();
        for (EkoUserDto userDto : userDtoList) {
            userMap.put(userDto.getUserId(), userDto.getDisplayName());
        }
        ArrayList<EkoInternalReaction> reactionList = new ArrayList<EkoInternalReaction>();
        for (EkoReactionDto reactionDto : dto.getReactions()) {
            for (EkoReactorDto reactorDto : reactionDto.getReactors()) {
                EkoInternalReaction reaction = EkoInternalReaction.create(ReactionReferenceType.valueOf(reactionDto.getReferenceType().toUpperCase()), reactorDto.getReactionId(), reactorDto.getReactionName(), reactorDto.getUserId(), reactionDto.getReferenceId(), (String)userMap.get(reactorDto.getUserId()), reactorDto.getCreatedAt());
                reactionList.add(reaction);
            }
        }
        return reactionList;
    };
}

