/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.repository.user.helper;

import com.ekoapp.ekosdk.internal.api.EkoApi;
import com.ekoapp.ekosdk.internal.api.EkoSocket;
import com.ekoapp.ekosdk.internal.api.SocketConnectionEvent;
import com.ekoapp.ekosdk.internal.api.dto.EkoUserQueryDto;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceRequest;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceResponse;
import com.ekoapp.ekosdk.internal.api.mapper.EkoUserSingleMapper;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoAccountDao;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.ekoapp.ekosdk.internal.repository.user.helper.RegisterDeviceManager;
import com.github.davidmoten.rx2.RetryWhen;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Single;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0003J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/ekoapp/ekosdk/internal/repository/user/helper/RegisterDeviceManager;", "", "userId", "", "displayName", "authToken", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "connect", "Lio/reactivex/Maybe;", "Lcom/ekoapp/ekosdk/internal/api/SocketConnectionEvent;", "disconnect", "register", "Lio/reactivex/Single;", "Lcom/ekoapp/ekosdk/internal/api/http/request/RegisterDeviceResponse;", "apiKey", "restart", "insertOrUpdate", "", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "response", "amity-sdk_release"})
public final class RegisterDeviceManager {
    private final String userId;
    private final String displayName;
    private final String authToken;

    @NotNull
    public final Single<RegisterDeviceResponse> register(@NotNull String apiKey) {
        EkoAccount ekoAccount;
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        EkoAccountDao accountDao = EkoDatabase.get().accountDao();
        EkoAccount ekoAccount2 = ekoAccount = accountDao.activateAccount(this.userId, this.displayName);
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoAccount2, (String)"ekoAccount");
        RegisterDeviceRequest request = RegisterDeviceRequest.create(this.userId, this.displayName, ekoAccount2.getDeviceId(), this.authToken);
        Single single = EkoApi.INSTANCE.auth().registerDevice(apiKey, request).retryWhen(RetryWhen.maxRetries((int)5).exponentialBackoff(1L, 10L, TimeUnit.SECONDS, 1.5).build()).doOnSuccess((Consumer)new Consumer<RegisterDeviceResponse>(this, ekoAccount){
            final /* synthetic */ RegisterDeviceManager this$0;
            final /* synthetic */ EkoAccount $ekoAccount;

            public final void accept(RegisterDeviceResponse it) {
                EkoAccount ekoAccount = this.$ekoAccount;
                Intrinsics.checkExpressionValueIsNotNull((Object)ekoAccount, (String)"ekoAccount");
                RegisterDeviceResponse registerDeviceResponse = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)registerDeviceResponse, (String)"it");
                RegisterDeviceManager.access$insertOrUpdate(this.this$0, ekoAccount, registerDeviceResponse);
            }
            {
                this.this$0 = registerDeviceManager;
                this.$ekoAccount = ekoAccount;
            }
        }).doOnError((Consumer)register.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"EkoApi.auth()\n          \u2026ames()} ${it.message}\") }");
        return single;
    }

    private final void insertOrUpdate(@NotNull EkoAccount $this$insertOrUpdate, RegisterDeviceResponse response) {
        $this$insertOrUpdate.setRefreshToken(response.getRefreshToken());
        $this$insertOrUpdate.setAccessToken(response.getAccessToken());
        EkoUserQueryDto dto = new EkoUserQueryDto();
        dto.setUsers(response.getUsers());
        dto.setFiles(response.getFiles());
        EkoUserSingleMapper.MAPPER.map(dto);
        EkoDatabase.get().accountDao().update($this$insertOrUpdate);
    }

    @NotNull
    public final Maybe<SocketConnectionEvent> restart() {
        Maybe maybe = this.disconnect().flatMap(new Function<T, MaybeSource<? extends R>>(this){
            final /* synthetic */ RegisterDeviceManager this$0;

            @NotNull
            public final Maybe<SocketConnectionEvent> apply(@NotNull SocketConnectionEvent it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return RegisterDeviceManager.access$connect(this.this$0);
            }
            {
                this.this$0 = registerDeviceManager;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)maybe, (String)"disconnect().flatMap { connect() }");
        return maybe;
    }

    private final Maybe<SocketConnectionEvent> disconnect() {
        Maybe maybe = EkoSocket.connectionEvent().filter((Predicate)disconnect.1.INSTANCE).firstElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)maybe, (String)"EkoSocket.connectionEven\u2026          .firstElement()");
        return maybe;
    }

    private final Maybe<SocketConnectionEvent> connect() {
        Maybe maybe = EkoSocket.connectionEvent().filter((Predicate)connect.1.INSTANCE).firstElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)maybe, (String)"EkoSocket.connectionEven\u2026          .firstElement()");
        return maybe;
    }

    public RegisterDeviceManager(@NotNull String userId, @Nullable String displayName, @Nullable String authToken) {
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        this.userId = userId;
        this.displayName = displayName;
        this.authToken = authToken;
    }

    public static final /* synthetic */ void access$insertOrUpdate(RegisterDeviceManager $this, EkoAccount $this$access_u24insertOrUpdate, RegisterDeviceResponse response) {
        $this.insertOrUpdate($this$access_u24insertOrUpdate, response);
    }

    public static final /* synthetic */ Maybe access$connect(RegisterDeviceManager $this) {
        return $this.connect();
    }
}

