/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.paging.DataSource;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetDataSource;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoInternalReactionDao;
import com.ekoapp.ekosdk.internal.data.model.EkoInternalReaction;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoInternalReactionDao_Impl
extends EkoInternalReactionDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfEkoInternalReaction;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfEkoInternalReaction;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfEkoInternalReaction;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByPrimaryKeyImpl;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByReferenceIdAndUserIdImpl;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByReferenceIdImpl;

    public EkoInternalReactionDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoInternalReaction = new EntityInsertionAdapter<EkoInternalReaction>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `reaction`(`reactionId`,`reactionName`,`userId`,`userDisplayName`,`referenceId`,`referenceType`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoInternalReaction value) {
                if (value.getReactionId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getReactionId());
                }
                if (value.getReactionName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getReactionName());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                if (value.getUserDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getUserDisplayName());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getReferenceId());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getReferenceType());
                }
                String _tmp = EkoInternalReactionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp);
                }
                String _tmp_1 = EkoInternalReactionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_1);
                }
            }
        };
        this.__deletionAdapterOfEkoInternalReaction = new EntityDeletionOrUpdateAdapter<EkoInternalReaction>(__db){

            public String createQuery() {
                return "DELETE FROM `reaction` WHERE `userId` = ? AND `reactionName` = ? AND `referenceType` = ? AND `referenceId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoInternalReaction value) {
                if (value.getUserId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getUserId());
                }
                if (value.getReactionName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getReactionName());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getReferenceType());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getReferenceId());
                }
            }
        };
        this.__updateAdapterOfEkoInternalReaction = new EntityDeletionOrUpdateAdapter<EkoInternalReaction>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `reaction` SET `reactionId` = ?,`reactionName` = ?,`userId` = ?,`userDisplayName` = ?,`referenceId` = ?,`referenceType` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `userId` = ? AND `reactionName` = ? AND `referenceType` = ? AND `referenceId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoInternalReaction value) {
                if (value.getReactionId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getReactionId());
                }
                if (value.getReactionName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getReactionName());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getUserId());
                }
                if (value.getUserDisplayName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getUserDisplayName());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getReferenceId());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getReferenceType());
                }
                String _tmp = EkoInternalReactionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp);
                }
                String _tmp_1 = EkoInternalReactionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, _tmp_1);
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getUserId());
                }
                if (value.getReactionName() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getReactionName());
                }
                if (value.getReferenceType() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, value.getReferenceType());
                }
                if (value.getReferenceId() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getReferenceId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from reaction";
                return "DELETE from reaction";
            }
        };
        this.__preparedStmtOfDeleteByPrimaryKeyImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from reaction where referenceId = ? and userId = ? and reactionName = ? and referenceType = ?";
                return "DELETE from reaction where referenceId = ? and userId = ? and reactionName = ? and referenceType = ?";
            }
        };
        this.__preparedStmtOfDeleteByReferenceIdAndUserIdImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from reaction where referenceId = ? and userId = ? and referenceType = ?";
                return "DELETE from reaction where referenceId = ? and userId = ? and referenceType = ?";
            }
        };
        this.__preparedStmtOfDeleteByReferenceIdImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from reaction where referenceId = ? and referenceType = ?";
                return "DELETE from reaction where referenceId = ? and referenceType = ?";
            }
        };
    }

    @Override
    void insertImpl(EkoInternalReaction object) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoInternalReaction.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<EkoInternalReaction> objects) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoInternalReaction.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<EkoInternalReaction> objects) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoInternalReaction.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoInternalReaction reaction) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoInternalReaction.handle((Object)reaction);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(EkoInternalReaction object) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoInternalReaction.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoInternalReaction object) {
        this.__db.beginTransaction();
        try {
            super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<EkoInternalReaction> objects) {
        this.__db.beginTransaction();
        try {
            super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoInternalReaction object) {
        this.__db.beginTransaction();
        try {
            super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deleteByPrimaryKeyImpl(String referenceId, String referenceType, String userId, String reactionName) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByPrimaryKeyImpl.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (referenceId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, referenceId);
            }
            _argIndex = 2;
            if (userId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, userId);
            }
            _argIndex = 3;
            if (reactionName == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, reactionName);
            }
            _argIndex = 4;
            if (referenceType == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, referenceType);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByPrimaryKeyImpl.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deleteByReferenceIdAndUserIdImpl(String referenceId, String referenceType, String userId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByReferenceIdAndUserIdImpl.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (referenceId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, referenceId);
            }
            _argIndex = 2;
            if (userId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, userId);
            }
            _argIndex = 3;
            if (referenceType == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, referenceType);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByReferenceIdAndUserIdImpl.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deleteByReferenceIdImpl(String referenceId, String referenceType) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByReferenceIdImpl.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (referenceId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, referenceId);
            }
            _argIndex = 2;
            if (referenceType == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, referenceType);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByReferenceIdImpl.release(_stmt);
        }
    }

    @Override
    DataSource.Factory<Integer, EkoInternalReaction> getAllByReferenceIdImpl(String referenceId, String referenceType) {
        String _sql = "SELECT * from reaction where reaction.referenceId = ? and reaction.referenceType = ? order by reaction.createdAt DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.referenceId = ? and reaction.referenceType = ? order by reaction.createdAt DESC", (int)2);
        int _argIndex = 1;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 2;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        return new DataSource.Factory<Integer, EkoInternalReaction>(){

            public LimitOffsetDataSource<EkoInternalReaction> create() {
                return new LimitOffsetDataSource<EkoInternalReaction>(EkoInternalReactionDao_Impl.this.__db, _statement, false, new String[]{"reaction"}){

                    protected List<EkoInternalReaction> convertRows(Cursor cursor) {
                        int _cursorIndexOfReactionId = cursor.getColumnIndexOrThrow("reactionId");
                        int _cursorIndexOfReactionName = cursor.getColumnIndexOrThrow("reactionName");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfUserDisplayName = cursor.getColumnIndexOrThrow("userDisplayName");
                        int _cursorIndexOfReferenceId = cursor.getColumnIndexOrThrow("referenceId");
                        int _cursorIndexOfReferenceType = cursor.getColumnIndexOrThrow("referenceType");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<EkoInternalReaction> _res = new ArrayList<EkoInternalReaction>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            String _tmpReactionId = cursor.getString(_cursorIndexOfReactionId);
                            String _tmpReactionName = cursor.getString(_cursorIndexOfReactionName);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            String _tmpUserDisplayName = cursor.getString(_cursorIndexOfUserDisplayName);
                            String _tmpReferenceId = cursor.getString(_cursorIndexOfReferenceId);
                            EkoInternalReaction _item = new EkoInternalReaction(_tmpReactionId, _tmpReactionName, _tmpUserId, _tmpReferenceId, _tmpUserDisplayName);
                            String _tmpReferenceType = cursor.getString(_cursorIndexOfReferenceType);
                            _item.setReferenceType(_tmpReferenceType);
                            String _tmp = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoInternalReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_1 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoInternalReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    DataSource.Factory<Integer, EkoInternalReaction> getAllByReferenceIdAndReactionNameImpl(String referenceId, String referenceType, String reactionName) {
        String _sql = "SELECT * from reaction where reaction.referenceId = ? and reaction.reactionName = ? and reaction.referenceType = ? order by reaction.createdAt DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.referenceId = ? and reaction.reactionName = ? and reaction.referenceType = ? order by reaction.createdAt DESC", (int)3);
        int _argIndex = 1;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 2;
        if (reactionName == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, reactionName);
        }
        _argIndex = 3;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        return new DataSource.Factory<Integer, EkoInternalReaction>(){

            public LimitOffsetDataSource<EkoInternalReaction> create() {
                return new LimitOffsetDataSource<EkoInternalReaction>(EkoInternalReactionDao_Impl.this.__db, _statement, false, new String[]{"reaction"}){

                    protected List<EkoInternalReaction> convertRows(Cursor cursor) {
                        int _cursorIndexOfReactionId = cursor.getColumnIndexOrThrow("reactionId");
                        int _cursorIndexOfReactionName = cursor.getColumnIndexOrThrow("reactionName");
                        int _cursorIndexOfUserId = cursor.getColumnIndexOrThrow("userId");
                        int _cursorIndexOfUserDisplayName = cursor.getColumnIndexOrThrow("userDisplayName");
                        int _cursorIndexOfReferenceId = cursor.getColumnIndexOrThrow("referenceId");
                        int _cursorIndexOfReferenceType = cursor.getColumnIndexOrThrow("referenceType");
                        int _cursorIndexOfCreatedAt = cursor.getColumnIndexOrThrow("createdAt");
                        int _cursorIndexOfUpdatedAt = cursor.getColumnIndexOrThrow("updatedAt");
                        ArrayList<EkoInternalReaction> _res = new ArrayList<EkoInternalReaction>(cursor.getCount());
                        while (cursor.moveToNext()) {
                            String _tmpReactionId = cursor.getString(_cursorIndexOfReactionId);
                            String _tmpReactionName = cursor.getString(_cursorIndexOfReactionName);
                            String _tmpUserId = cursor.getString(_cursorIndexOfUserId);
                            String _tmpUserDisplayName = cursor.getString(_cursorIndexOfUserDisplayName);
                            String _tmpReferenceId = cursor.getString(_cursorIndexOfReferenceId);
                            EkoInternalReaction _item = new EkoInternalReaction(_tmpReactionId, _tmpReactionName, _tmpUserId, _tmpReferenceId, _tmpUserDisplayName);
                            String _tmpReferenceType = cursor.getString(_cursorIndexOfReferenceType);
                            _item.setReferenceType(_tmpReferenceType);
                            String _tmp = cursor.getString(_cursorIndexOfCreatedAt);
                            DateTime _tmpCreatedAt = EkoInternalReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                            _item.setCreatedAt(_tmpCreatedAt);
                            String _tmp_1 = cursor.getString(_cursorIndexOfUpdatedAt);
                            DateTime _tmpUpdatedAt = EkoInternalReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                            _item.setUpdatedAt(_tmpUpdatedAt);
                            _res.add(_item);
                        }
                        return _res;
                    }
                };
            }
        };
    }

    @Override
    Maybe<EkoInternalReaction> getMyReactionByReferenceIdAndReactionNameImpl(String referenceId, String referenceType, String reactionName, String userId) {
        String _sql = "SELECT * from reaction where reaction.referenceId = ? and reaction.reactionName = ? and reaction.userId = ? and reaction.referenceType = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.referenceId = ? and reaction.reactionName = ? and reaction.userId = ? and reaction.referenceType = ? LIMIT 1", (int)4);
        int _argIndex = 1;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 2;
        if (reactionName == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, reactionName);
        }
        _argIndex = 3;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        _argIndex = 4;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        return Maybe.fromCallable((Callable)new Callable<EkoInternalReaction>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoInternalReaction call() throws Exception {
                try (Cursor _cursor = EkoInternalReactionDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    EkoInternalReaction _result;
                    int _cursorIndexOfReactionId = _cursor.getColumnIndexOrThrow("reactionId");
                    int _cursorIndexOfReactionName = _cursor.getColumnIndexOrThrow("reactionName");
                    int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
                    int _cursorIndexOfUserDisplayName = _cursor.getColumnIndexOrThrow("userDisplayName");
                    int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
                    int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
                    if (_cursor.moveToFirst()) {
                        String _tmpReactionId = _cursor.getString(_cursorIndexOfReactionId);
                        String _tmpReactionName = _cursor.getString(_cursorIndexOfReactionName);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        String _tmpUserDisplayName = _cursor.getString(_cursorIndexOfUserDisplayName);
                        String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                        _result = new EkoInternalReaction(_tmpReactionId, _tmpReactionName, _tmpUserId, _tmpReferenceId, _tmpUserDisplayName);
                        String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                        _result.setReferenceType(_tmpReferenceType);
                        String _tmp = _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoInternalReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoInternalReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    EkoInternalReaction ekoInternalReaction = _result;
                    return ekoInternalReaction;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    Flowable<List<EkoInternalReaction>> getAllMyReactionsByReferenceTypeAndReferenceIdImpl(String referenceType, String referenceId, String userId) {
        String _sql = "SELECT * from reaction where reaction.referenceType = ? and reaction.referenceId = ? and reaction.userId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.referenceType = ? and reaction.referenceId = ? and reaction.userId = ?", (int)3);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 3;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"reaction"}, (Callable)new Callable<List<EkoInternalReaction>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<EkoInternalReaction> call() throws Exception {
                try (Cursor _cursor = EkoInternalReactionDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    int _cursorIndexOfReactionId = _cursor.getColumnIndexOrThrow("reactionId");
                    int _cursorIndexOfReactionName = _cursor.getColumnIndexOrThrow("reactionName");
                    int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
                    int _cursorIndexOfUserDisplayName = _cursor.getColumnIndexOrThrow("userDisplayName");
                    int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
                    int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
                    ArrayList<EkoInternalReaction> _result = new ArrayList<EkoInternalReaction>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpReactionId = _cursor.getString(_cursorIndexOfReactionId);
                        String _tmpReactionName = _cursor.getString(_cursorIndexOfReactionName);
                        String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                        String _tmpUserDisplayName = _cursor.getString(_cursorIndexOfUserDisplayName);
                        String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                        EkoInternalReaction _item = new EkoInternalReaction(_tmpReactionId, _tmpReactionName, _tmpUserId, _tmpReferenceId, _tmpUserDisplayName);
                        String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                        _item.setReferenceType(_tmpReferenceType);
                        String _tmp = _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoInternalReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                        _item.setCreatedAt(_tmpCreatedAt);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoInternalReactionDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _item.setUpdatedAt(_tmpUpdatedAt);
                        _result.add(_item);
                    }
                    ArrayList<EkoInternalReaction> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<EkoInternalReaction> getAllMyReactionsByReferenceTypeAndReferenceIdNowImpl(String referenceType, String referenceId, String userId) {
        String _sql = "SELECT * from reaction where reaction.referenceType = ? and reaction.referenceId = ? and reaction.userId = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.referenceType = ? and reaction.referenceId = ? and reaction.userId = ?", (int)3);
        int _argIndex = 1;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        _argIndex = 2;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 3;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfReactionId = _cursor.getColumnIndexOrThrow("reactionId");
            int _cursorIndexOfReactionName = _cursor.getColumnIndexOrThrow("reactionName");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfUserDisplayName = _cursor.getColumnIndexOrThrow("userDisplayName");
            int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
            int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            ArrayList<EkoInternalReaction> _result = new ArrayList<EkoInternalReaction>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpReactionId = _cursor.getString(_cursorIndexOfReactionId);
                String _tmpReactionName = _cursor.getString(_cursorIndexOfReactionName);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                String _tmpUserDisplayName = _cursor.getString(_cursorIndexOfUserDisplayName);
                String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                EkoInternalReaction _item = new EkoInternalReaction(_tmpReactionId, _tmpReactionName, _tmpUserId, _tmpReferenceId, _tmpUserDisplayName);
                String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                _item.setReferenceType(_tmpReferenceType);
                String _tmp = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item);
            }
            ArrayList<EkoInternalReaction> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EkoInternalReaction> getAllByReferenceTypeAndReferenceId(String referenceType, String referenceId) {
        String _sql = "SELECT * from reaction where reaction.referenceId = ? and reaction.referenceType = ? order by reaction.createdAt DESC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.referenceId = ? and reaction.referenceType = ? order by reaction.createdAt DESC", (int)2);
        int _argIndex = 1;
        if (referenceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceId);
        }
        _argIndex = 2;
        if (referenceType == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, referenceType);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfReactionId = _cursor.getColumnIndexOrThrow("reactionId");
            int _cursorIndexOfReactionName = _cursor.getColumnIndexOrThrow("reactionName");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfUserDisplayName = _cursor.getColumnIndexOrThrow("userDisplayName");
            int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
            int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            ArrayList<EkoInternalReaction> _result = new ArrayList<EkoInternalReaction>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpReactionId = _cursor.getString(_cursorIndexOfReactionId);
                String _tmpReactionName = _cursor.getString(_cursorIndexOfReactionName);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                String _tmpUserDisplayName = _cursor.getString(_cursorIndexOfUserDisplayName);
                String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                EkoInternalReaction _item = new EkoInternalReaction(_tmpReactionId, _tmpReactionName, _tmpUserId, _tmpReferenceId, _tmpUserDisplayName);
                String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                _item.setReferenceType(_tmpReferenceType);
                String _tmp = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item);
            }
            ArrayList<EkoInternalReaction> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EkoInternalReaction> getAllAfterReactionId(String reactionId) {
        String _sql = "SELECT * from reaction where reaction.reactionId >= ? order by reaction.createdAt DESC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.reactionId >= ? order by reaction.createdAt DESC", (int)1);
        int _argIndex = 1;
        if (reactionId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, reactionId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfReactionId = _cursor.getColumnIndexOrThrow("reactionId");
            int _cursorIndexOfReactionName = _cursor.getColumnIndexOrThrow("reactionName");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfUserDisplayName = _cursor.getColumnIndexOrThrow("userDisplayName");
            int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
            int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            ArrayList<EkoInternalReaction> _result = new ArrayList<EkoInternalReaction>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpReactionId = _cursor.getString(_cursorIndexOfReactionId);
                String _tmpReactionName = _cursor.getString(_cursorIndexOfReactionName);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                String _tmpUserDisplayName = _cursor.getString(_cursorIndexOfUserDisplayName);
                String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                EkoInternalReaction _item = new EkoInternalReaction(_tmpReactionId, _tmpReactionName, _tmpUserId, _tmpReferenceId, _tmpUserDisplayName);
                String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                _item.setReferenceType(_tmpReferenceType);
                String _tmp = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item);
            }
            ArrayList<EkoInternalReaction> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EkoInternalReaction> getAllBeforeReactionId(String reactionId) {
        String _sql = "SELECT * from reaction where reaction.reactionId < ? order by reaction.createdAt DESC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.reactionId < ? order by reaction.createdAt DESC", (int)1);
        int _argIndex = 1;
        if (reactionId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, reactionId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfReactionId = _cursor.getColumnIndexOrThrow("reactionId");
            int _cursorIndexOfReactionName = _cursor.getColumnIndexOrThrow("reactionName");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfUserDisplayName = _cursor.getColumnIndexOrThrow("userDisplayName");
            int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
            int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            ArrayList<EkoInternalReaction> _result = new ArrayList<EkoInternalReaction>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpReactionId = _cursor.getString(_cursorIndexOfReactionId);
                String _tmpReactionName = _cursor.getString(_cursorIndexOfReactionName);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                String _tmpUserDisplayName = _cursor.getString(_cursorIndexOfUserDisplayName);
                String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                EkoInternalReaction _item = new EkoInternalReaction(_tmpReactionId, _tmpReactionName, _tmpUserId, _tmpReferenceId, _tmpUserDisplayName);
                String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                _item.setReferenceType(_tmpReferenceType);
                String _tmp = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item);
            }
            ArrayList<EkoInternalReaction> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EkoInternalReaction> getAllBetweenReactionId(String fromReactionId, String tillReactionId) {
        String _sql = "SELECT * from reaction where reaction.reactionId BETWEEN ? and ? and reaction.reactionId != ? order by reaction.createdAt DESC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from reaction where reaction.reactionId BETWEEN ? and ? and reaction.reactionId != ? order by reaction.createdAt DESC", (int)3);
        int _argIndex = 1;
        if (fromReactionId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, fromReactionId);
        }
        _argIndex = 2;
        if (tillReactionId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, tillReactionId);
        }
        _argIndex = 3;
        if (tillReactionId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, tillReactionId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfReactionId = _cursor.getColumnIndexOrThrow("reactionId");
            int _cursorIndexOfReactionName = _cursor.getColumnIndexOrThrow("reactionName");
            int _cursorIndexOfUserId = _cursor.getColumnIndexOrThrow("userId");
            int _cursorIndexOfUserDisplayName = _cursor.getColumnIndexOrThrow("userDisplayName");
            int _cursorIndexOfReferenceId = _cursor.getColumnIndexOrThrow("referenceId");
            int _cursorIndexOfReferenceType = _cursor.getColumnIndexOrThrow("referenceType");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            ArrayList<EkoInternalReaction> _result = new ArrayList<EkoInternalReaction>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpReactionId = _cursor.getString(_cursorIndexOfReactionId);
                String _tmpReactionName = _cursor.getString(_cursorIndexOfReactionName);
                String _tmpUserId = _cursor.getString(_cursorIndexOfUserId);
                String _tmpUserDisplayName = _cursor.getString(_cursorIndexOfUserDisplayName);
                String _tmpReferenceId = _cursor.getString(_cursorIndexOfReferenceId);
                EkoInternalReaction _item = new EkoInternalReaction(_tmpReactionId, _tmpReactionName, _tmpUserId, _tmpReferenceId, _tmpUserDisplayName);
                String _tmpReferenceType = _cursor.getString(_cursorIndexOfReferenceType);
                _item.setReferenceType(_tmpReferenceType);
                String _tmp = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _item.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _item.setUpdatedAt(_tmpUpdatedAt);
                _result.add(_item);
            }
            ArrayList<EkoInternalReaction> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

