/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoGlobalPostDao;
import com.ekoapp.ekosdk.internal.data.model.GlobalPostEntity;
import java.util.List;
import org.joda.time.DateTime;

public final class EkoGlobalPostDao_Impl
extends EkoGlobalPostDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfGlobalPostEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfGlobalPostEntity;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfGlobalPostEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeleteByPostIdImpl;
    private final SharedSQLiteStatement __preparedStmtOfUpdatePost;

    public EkoGlobalPostDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfGlobalPostEntity = new EntityInsertionAdapter<GlobalPostEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `global_post`(`postId`,`createdAt`,`updatedAt`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, GlobalPostEntity value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
                String _tmp = EkoGlobalPostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = EkoGlobalPostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
            }
        };
        this.__deletionAdapterOfGlobalPostEntity = new EntityDeletionOrUpdateAdapter<GlobalPostEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `global_post` WHERE `postId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, GlobalPostEntity value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
            }
        };
        this.__updateAdapterOfGlobalPostEntity = new EntityDeletionOrUpdateAdapter<GlobalPostEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `global_post` SET `postId` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `postId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, GlobalPostEntity value) {
                if (value.getPostId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPostId());
                }
                String _tmp = EkoGlobalPostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = EkoGlobalPostDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                if (value.getPostId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getPostId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from global_post";
                return "DELETE from global_post";
            }
        };
        this.__preparedStmtOfDeleteByPostIdImpl = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from global_post where postId = ?";
                return "DELETE from global_post where postId = ?";
            }
        };
        this.__preparedStmtOfUpdatePost = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE global_post set postId = postId where postId = ?";
                return "UPDATE global_post set postId = postId where postId = ?";
            }
        };
    }

    @Override
    void insertImpl(GlobalPostEntity object) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfGlobalPostEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<GlobalPostEntity> objects) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfGlobalPostEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(GlobalPostEntity object) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfGlobalPostEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<GlobalPostEntity> objects) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfGlobalPostEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(GlobalPostEntity object) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfGlobalPostEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(GlobalPostEntity object) {
        this.__db.beginTransaction();
        try {
            super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<GlobalPostEntity> objects) {
        this.__db.beginTransaction();
        try {
            super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(GlobalPostEntity object) {
        this.__db.beginTransaction();
        try {
            super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deleteByPostIdImpl(String postId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteByPostIdImpl.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (postId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, postId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteByPostIdImpl.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePost(String postId) {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfUpdatePost.acquire();
        this.__db.beginTransaction();
        try {
            int _argIndex = 1;
            if (postId == null) {
                _stmt.bindNull(_argIndex);
            } else {
                _stmt.bindString(_argIndex, postId);
            }
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfUpdatePost.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    GlobalPostEntity getByIdNowImpl(String postId) {
        String _sql = "SELECT * from global_post where postId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from global_post where postId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (postId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, postId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            GlobalPostEntity _result;
            int _cursorIndexOfPostId = _cursor.getColumnIndexOrThrow("postId");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new GlobalPostEntity();
                String _tmpPostId = _cursor.getString(_cursorIndexOfPostId);
                _result.setPostId(_tmpPostId);
                String _tmp = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            GlobalPostEntity globalPostEntity = _result;
            return globalPostEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalPostEntity getFirstGlobalPostRanking() {
        String _sql = "SELECT * from global_post order by createdAt ASC LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from global_post order by createdAt ASC LIMIT 1", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            GlobalPostEntity _result;
            int _cursorIndexOfPostId = _cursor.getColumnIndexOrThrow("postId");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new GlobalPostEntity();
                String _tmpPostId = _cursor.getString(_cursorIndexOfPostId);
                _result.setPostId(_tmpPostId);
                String _tmp = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_1 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            GlobalPostEntity globalPostEntity = _result;
            return globalPostEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

