/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.socket.util.DateTimeTypeConverter;
import com.ekoapp.ekosdk.EkoFlag;
import com.ekoapp.ekosdk.internal.EkoLocalFlag;
import com.ekoapp.ekosdk.internal.data.converter.EkoFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoLocalFlagTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoCommentFlagEntity;
import io.reactivex.Flowable;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class EkoCommentFlagDao_Impl
extends EkoCommentFlagDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfEkoCommentFlagEntity;
    private final EkoFlagTypeConverter __ekoFlagTypeConverter = new EkoFlagTypeConverter();
    private final EkoLocalFlagTypeConverter __ekoLocalFlagTypeConverter = new EkoLocalFlagTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfEkoCommentFlagEntity;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfEkoCommentFlagEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EkoCommentFlagDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEkoCommentFlagEntity = new EntityInsertionAdapter<EkoCommentFlagEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `comment_flag`(`commentId`,`flag`,`localFlag`,`createdAt`,`updatedAt`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, EkoCommentFlagEntity value) {
                if (value.getCommentId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommentId());
                }
                String _tmp = EkoCommentFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(value.getFlag());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = EkoCommentFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(value.getLocalFlag());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
            }
        };
        this.__deletionAdapterOfEkoCommentFlagEntity = new EntityDeletionOrUpdateAdapter<EkoCommentFlagEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `comment_flag` WHERE `commentId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoCommentFlagEntity value) {
                if (value.getCommentId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommentId());
                }
            }
        };
        this.__updateAdapterOfEkoCommentFlagEntity = new EntityDeletionOrUpdateAdapter<EkoCommentFlagEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `comment_flag` SET `commentId` = ?,`flag` = ?,`localFlag` = ?,`createdAt` = ?,`updatedAt` = ? WHERE `commentId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, EkoCommentFlagEntity value) {
                if (value.getCommentId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCommentId());
                }
                String _tmp = EkoCommentFlagDao_Impl.this.__ekoFlagTypeConverter.ekoFlagToString(value.getFlag());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = EkoCommentFlagDao_Impl.this.__ekoLocalFlagTypeConverter.ekoLocalFlagToString(value.getLocalFlag());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                String _tmp_3 = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_3 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_3);
                }
                if (value.getCommentId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getCommentId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from comment_flag";
                return "DELETE from comment_flag";
            }
        };
    }

    @Override
    void insertImpl(EkoCommentFlagEntity object) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoCommentFlagEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void insertImpl(List<EkoCommentFlagEntity> objects) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEkoCommentFlagEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(EkoCommentFlagEntity object) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoCommentFlagEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<EkoCommentFlagEntity> objects) {
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEkoCommentFlagEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    void updateImpl(EkoCommentFlagEntity object) {
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfEkoCommentFlagEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(EkoCommentFlagEntity object) {
        this.__db.beginTransaction();
        try {
            super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<EkoCommentFlagEntity> objects) {
        this.__db.beginTransaction();
        try {
            super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(EkoCommentFlagEntity object) {
        this.__db.beginTransaction();
        try {
            super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    EkoCommentFlagEntity getByIdNowImpl(String commentId) {
        String _sql = "SELECT * from comment_flag where commentId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from comment_flag where commentId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (commentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, commentId);
        }
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            EkoCommentFlagEntity _result;
            int _cursorIndexOfCommentId = _cursor.getColumnIndexOrThrow("commentId");
            int _cursorIndexOfFlag = _cursor.getColumnIndexOrThrow("flag");
            int _cursorIndexOfLocalFlag = _cursor.getColumnIndexOrThrow("localFlag");
            int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
            int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
            if (_cursor.moveToFirst()) {
                _result = new EkoCommentFlagEntity();
                String _tmpCommentId = _cursor.getString(_cursorIndexOfCommentId);
                _result.setCommentId(_tmpCommentId);
                String _tmp = _cursor.getString(_cursorIndexOfFlag);
                EkoFlag _tmpFlag = this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                _result.setFlag(_tmpFlag);
                String _tmp_1 = _cursor.getString(_cursorIndexOfLocalFlag);
                EkoLocalFlag _tmpLocalFlag = this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                _result.setLocalFlag(_tmpLocalFlag);
                String _tmp_2 = _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_3 = _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                _result.setUpdatedAt(_tmpUpdatedAt);
            } else {
                _result = null;
            }
            EkoCommentFlagEntity ekoCommentFlagEntity = _result;
            return ekoCommentFlagEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    Flowable<EkoCommentFlagEntity> getByCommentIdImpl(String commentId) {
        String _sql = "SELECT * from comment_flag where comment_flag.commentId = ? LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from comment_flag where comment_flag.commentId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (commentId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, commentId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (String[])new String[]{"comment_flag"}, (Callable)new Callable<EkoCommentFlagEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public EkoCommentFlagEntity call() throws Exception {
                try (Cursor _cursor = EkoCommentFlagDao_Impl.this.__db.query((SupportSQLiteQuery)_statement);){
                    EkoCommentFlagEntity _result;
                    int _cursorIndexOfCommentId = _cursor.getColumnIndexOrThrow("commentId");
                    int _cursorIndexOfFlag = _cursor.getColumnIndexOrThrow("flag");
                    int _cursorIndexOfLocalFlag = _cursor.getColumnIndexOrThrow("localFlag");
                    int _cursorIndexOfCreatedAt = _cursor.getColumnIndexOrThrow("createdAt");
                    int _cursorIndexOfUpdatedAt = _cursor.getColumnIndexOrThrow("updatedAt");
                    if (_cursor.moveToFirst()) {
                        _result = new EkoCommentFlagEntity();
                        String _tmpCommentId = _cursor.getString(_cursorIndexOfCommentId);
                        _result.setCommentId(_tmpCommentId);
                        String _tmp = _cursor.getString(_cursorIndexOfFlag);
                        EkoFlag _tmpFlag = EkoCommentFlagDao_Impl.this.__ekoFlagTypeConverter.stringToEkoFlag(_tmp);
                        _result.setFlag(_tmpFlag);
                        String _tmp_1 = _cursor.getString(_cursorIndexOfLocalFlag);
                        EkoLocalFlag _tmpLocalFlag = EkoCommentFlagDao_Impl.this.__ekoLocalFlagTypeConverter.stringToEkoLocalFlag(_tmp_1);
                        _result.setLocalFlag(_tmpLocalFlag);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = EkoCommentFlagDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                    } else {
                        _result = null;
                    }
                    EkoCommentFlagEntity ekoCommentFlagEntity = _result;
                    return ekoCommentFlagEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }
}

