/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.socket.call;

import com.amity.socialcloud.sdk.socket.model.SocketResponse;
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionAndUserListDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoReactionQueryResultDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectMapper;
import com.ekoapp.ekosdk.internal.api.socket.call.ResponseConverter;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoInternalReactionDao;
import com.ekoapp.ekosdk.internal.data.model.EkoInternalReaction;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

abstract class ReactionQueryConverter
implements ResponseConverter<EkoReactionQueryResultDto> {
    private final EkoInternalReactionDao reactionDao = UserDatabase.get().reactionDao();
    final String referenceId;
    final String referenceType;
    final String lastMapReactionId;

    public ReactionQueryConverter(String referenceId, String referenceType, String lastMapReactionId) {
        this.referenceId = referenceId;
        this.referenceType = referenceType;
        this.lastMapReactionId = lastMapReactionId;
    }

    abstract EkoObjectMapper<EkoReactionAndUserListDto, List<EkoInternalReaction>> getMapper();

    private PERSIST_PAGE_TYPE getPersistPageType(boolean hasNextToken, boolean hasPrevToken, boolean hasItem) {
        PERSIST_PAGE_TYPE pageType = PERSIST_PAGE_TYPE.NO_DATA;
        for (PERSIST_PAGE_TYPE value : PERSIST_PAGE_TYPE.values()) {
            if (value.hasNextToken != hasNextToken || value.hasPrevToken != hasPrevToken || value.hasItem != hasItem) continue;
            pageType = value;
            break;
        }
        return pageType;
    }

    @Override
    public EkoReactionQueryResultDto convert(SocketResponse response) {
        EkoReactionQueryResultDto dto = (EkoReactionQueryResultDto)response.getData(EkoReactionQueryResultDto.class);
        String next = dto.getToken().getNext();
        String previous = dto.getToken().getPrevious();
        List<EkoInternalReaction> remoteReactionList = this.getMapper().map(dto.getResults());
        PERSIST_PAGE_TYPE pageType = this.getPersistPageType(!StringUtils.isEmpty((CharSequence)next), !StringUtils.isEmpty((CharSequence)previous), !CollectionUtils.isEmpty(remoteReactionList));
        if (pageType == PERSIST_PAGE_TYPE.NO_DATA) {
            this.removeAllReactions(this.referenceId, this.referenceType);
        } else {
            this.persistReactionByPageType(pageType, remoteReactionList);
        }
        return dto;
    }

    private void persistReactionByPageType(PERSIST_PAGE_TYPE pageType, List<EkoInternalReaction> remoteList) {
        List<EkoInternalReaction> onDiskList = new ArrayList<EkoInternalReaction>();
        switch (pageType) {
            case NO_DATA: 
            case ONE_PAGE: {
                onDiskList = this.reactionDao.getAllByReferenceTypeAndReferenceId(this.referenceType, this.referenceId);
                break;
            }
            case FIRST_PAGE: {
                String lastReactionIdFromRemote = remoteList.get(remoteList.size() - 1).getReactionId();
                onDiskList = this.reactionDao.getAllAfterReactionId(lastReactionIdFromRemote);
                break;
            }
            case REGULAR_PAGE: {
                String lastReactionIdFromRemote = remoteList.get(remoteList.size() - 1).getReactionId();
                onDiskList = this.reactionDao.getAllBetweenReactionId(lastReactionIdFromRemote, this.lastMapReactionId);
                break;
            }
            case EMPTY_LAST_PAGE: 
            case LAST_PAGE: {
                onDiskList = this.reactionDao.getAllBeforeReactionId(this.lastMapReactionId);
                break;
            }
        }
        this.persistReaction(onDiskList, remoteList);
    }

    private void persistReaction(List<EkoInternalReaction> onDiskList, List<EkoInternalReaction> remoteList) {
        HashMap remoteMap = Maps.newHashMap();
        for (EkoInternalReaction reaction : remoteList) {
            EkoInternalReaction internalReaction = new EkoInternalReaction(reaction.getReactionId(), reaction.getReactionName(), reaction.getUserId(), reaction.getReferenceId(), reaction.getUserDisplayName());
            internalReaction.setReferenceType(this.referenceType);
            internalReaction.setCreatedAt(reaction.getCreatedAt());
            internalReaction.setUpdatedAt(reaction.getUpdatedAt());
            remoteMap.put(reaction.getId(), internalReaction);
        }
        ArrayList updateList = new ArrayList();
        ArrayList<EkoInternalReaction> deleteList = new ArrayList<EkoInternalReaction>();
        for (EkoInternalReaction onDiskReaction : onDiskList) {
            String onDiskId = onDiskReaction.getId();
            if (remoteMap.containsKey(onDiskId)) {
                updateList.add(remoteMap.get(onDiskId));
                remoteMap.remove(onDiskId);
                continue;
            }
            deleteList.add(onDiskReaction);
        }
        ArrayList insertList = new ArrayList(remoteMap.values());
        UserDatabase.get().runInTransaction(() -> {
            this.deleteReactions(deleteList);
            this.updateReactions(updateList);
            this.insertReactions(insertList);
        });
    }

    private void insertReactions(List<EkoInternalReaction> reactionList) {
        this.reactionDao.insert(reactionList);
    }

    private void updateReactions(List<EkoInternalReaction> reactionList) {
        this.reactionDao.update(reactionList);
    }

    private void deleteReactions(List<EkoInternalReaction> reactionList) {
        this.reactionDao.delete(reactionList);
    }

    private void removeAllReactions(String referenceId, String referenceType) {
        this.reactionDao.deleteByReferenceId(referenceId, referenceType);
    }

    public static enum PERSIST_PAGE_TYPE {
        NO_DATA(false, false, false),
        ONE_PAGE(false, false, true),
        FIRST_PAGE(true, false, true),
        REGULAR_PAGE(true, true, true),
        LAST_PAGE(false, true, true),
        EMPTY_LAST_PAGE(false, true, false);

        boolean hasNextToken;
        boolean hasPrevToken;
        boolean hasItem;

        private PERSIST_PAGE_TYPE(boolean hasNextToken, boolean hasPrevToken, boolean hasItem) {
            this.hasNextToken = hasNextToken;
            this.hasPrevToken = hasPrevToken;
            this.hasItem = hasItem;
        }
    }
}

