/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.socket.call;

import com.amity.socialcloud.sdk.socket.model.SocketResponse;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoPostAndUserMapper;
import com.ekoapp.ekosdk.internal.api.socket.call.ResponseConverter;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoGlobalPostDao;
import com.ekoapp.ekosdk.internal.data.model.EkoPostQueryToken;
import com.ekoapp.ekosdk.internal.data.model.GlobalPostEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/ekoapp/ekosdk/internal/api/socket/call/GlobalRankedPostQueryConverter;", "Lcom/ekoapp/ekosdk/internal/api/socket/call/ResponseConverter;", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoPostQueryDto;", "()V", "globalPostDao", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoGlobalPostDao;", "assignGlobalRankedPosts", "", "postDtoList", "", "Lcom/ekoapp/ekosdk/internal/api/dto/EkoPostDto;", "convert", "response", "Lcom/amity/socialcloud/sdk/socket/model/SocketResponse;", "persistPost", "dto", "resetGlobalRankedPosts", "amity-sdk_release"})
public final class GlobalRankedPostQueryConverter
implements ResponseConverter<EkoPostQueryDto> {
    private final EkoGlobalPostDao globalPostDao;

    @Override
    @NotNull
    public EkoPostQueryDto convert(@NotNull SocketResponse response) {
        EkoPostQueryDto dto;
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        EkoPostQueryDto ekoPostQueryDto = dto = (EkoPostQueryDto)response.getData(EkoPostQueryDto.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoPostQueryDto, (String)"dto");
        this.persistPost(ekoPostQueryDto);
        return dto;
    }

    private final void persistPost(EkoPostQueryDto dto) {
        this.resetGlobalRankedPosts(dto);
        List<EkoPostDto> list = dto.getPosts();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"dto.posts");
        this.assignGlobalRankedPosts(list);
        EkoPostAndUserMapper.MAPPER.map(dto);
    }

    private final void resetGlobalRankedPosts(EkoPostQueryDto dto) {
        EkoPostQueryToken ekoPostQueryToken = dto.getToken();
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoPostQueryToken, (String)"dto.token");
        String previousToken = ekoPostQueryToken.getPrevious();
        Object object = previousToken;
        boolean bl = false;
        boolean bl2 = false;
        if (object == null || object.length() == 0) {
            List<EkoPostDto> list = dto.getPosts();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"dto.posts");
            object = list;
            bl = false;
            if (!object.isEmpty()) {
                this.globalPostDao.deleteAll();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assignGlobalRankedPosts(List<? extends EkoPostDto> postDtoList) {
        void $this$mapTo$iv$iv;
        if (postDtoList.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = postDtoList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            EkoPostDto ekoPostDto = (EkoPostDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getPostId();
            collection.add(string);
        }
        List ids = (List)destination$iv$iv;
        $i$f$map = false;
        List globalPosts = new ArrayList();
        for (String id : ids) {
            GlobalPostEntity entity = new GlobalPostEntity();
            entity.setPostId(id);
            globalPosts.add(entity);
        }
        this.globalPostDao.insert(globalPosts);
    }

    public GlobalRankedPostQueryConverter() {
        EkoGlobalPostDao ekoGlobalPostDao = UserDatabase.get().globalPostDao();
        Intrinsics.checkExpressionValueIsNotNull((Object)ekoGlobalPostDao, (String)"UserDatabase.get().globalPostDao()");
        this.globalPostDao = ekoGlobalPostDao;
    }
}

