/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectPersister;
import com.ekoapp.ekosdk.internal.api.mapper.EkoUserMapper;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoUserFlagDao;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFlag;
import java.util.List;

class EkoUserListPersister
extends EkoObjectPersister {
    EkoUserListPersister() {
    }

    static void persist(final List<EkoUserDto> userDtoList) {
        final UserDatabase userDatabase = UserDatabase.get();
        userDatabase.runInTransaction(new Runnable(){

            @Override
            public void run() {
                EkoObjectPersister.persistChanges(userDtoList, EkoUserMapper.MAPPER, userDatabase.userDao());
                EkoUserFlagDao flagDao = userDatabase.userFlagDao();
                for (EkoUserDto userDto : userDtoList) {
                    EkoUserFlag userFlag = new EkoUserFlag();
                    userFlag.setUserId(userDto.getUserId());
                    userFlag.setFlag(userDto.getFlag());
                    EkoUserFlag diskFlag = flagDao.getByIdNow(userDto.getUserId());
                    if (diskFlag != null) {
                        userFlag.setLocalFlag(diskFlag.getLocalFlag());
                        flagDao.update(userFlag);
                        continue;
                    }
                    flagDao.insert(userFlag);
                }
            }
        });
    }
}

