/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.mapper;

import com.amity.socialcloud.sdk.AmityCoreClient;
import com.amity.socialcloud.sdk.core.reaction.ReactionReferenceType;
import com.ekoapp.ekosdk.internal.api.dto.EkoCommentDto;
import com.ekoapp.ekosdk.internal.api.mapper.EkoCommentMapper;
import com.ekoapp.ekosdk.internal.api.mapper.EkoObjectPersister;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommentFlagDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoInternalReactionDao;
import com.ekoapp.ekosdk.internal.data.model.EkoCommentFlagEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoInternalReaction;
import com.google.common.collect.FluentIterable;
import java.util.Collections;
import java.util.List;

class EkoCommentListPersister
extends EkoObjectPersister {
    EkoCommentListPersister() {
    }

    static void persist(List<EkoCommentDto> dtoList) {
        UserDatabase userDatabase = UserDatabase.get();
        userDatabase.runInTransaction(() -> {
            EkoCommentListPersister.persistChanges(dtoList, EkoCommentMapper.MAPPER, userDatabase.commentDao());
            EkoCommentFlagDao flagDao = userDatabase.commentFlagDao();
            for (EkoCommentDto commentDto : dtoList) {
                EkoInternalReactionDao reactionDao = userDatabase.reactionDao();
                reactionDao.deleteByReferenceIdAndUserId(commentDto.getCommentId(), ReactionReferenceType.COMMENT.getValue(), AmityCoreClient.INSTANCE.getUserId());
                reactionDao.insert(FluentIterable.from(commentDto.getMyReactions() == null ? Collections.emptyList() : commentDto.getMyReactions()).transform(reactionName -> EkoInternalReaction.createFromPrimaryKeys(ReactionReferenceType.COMMENT, commentDto.getCommentId(), reactionName, AmityCoreClient.INSTANCE.getUserId())).toList());
                EkoCommentFlagEntity commentFlag = new EkoCommentFlagEntity();
                commentFlag.setCommentId(commentDto.getCommentId());
                commentFlag.setFlag(commentDto.getFlag());
                EkoCommentFlagEntity diskFlag = flagDao.getByIdNow(commentDto.getCommentId());
                if (diskFlag != null) {
                    commentFlag.setLocalFlag(diskFlag.getLocalFlag());
                    flagDao.update(commentFlag);
                    continue;
                }
                flagDao.insert(commentFlag);
            }
        });
    }
}

